/*
 * Decompiled with CFR 0.152.
 */
package net.outer_planes.jso;

import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import net.outer_planes.jso.AbstractBuilder;
import org.jabberstudio.jso.NSI;
import org.jabberstudio.jso.StreamElement;
import org.jabberstudio.jso.StreamNode;
import org.jabberstudio.jso.io.StreamBuilder;
import org.jabberstudio.jso.io.StreamParseState;

public class ElementBuilder
extends AbstractBuilder {
    private StreamElement _Base;
    private List _Elems = new LinkedList();

    public ElementBuilder(StreamElement base) {
        this.setBaseElement(base);
    }

    public StreamElement getBaseElement() {
        return this._Base;
    }

    protected void setBaseElement(StreamElement base) throws IllegalArgumentException {
        if (base == null) {
            throw new IllegalArgumentException("StreamElement cannot be null");
        }
        this._Base = base;
    }

    protected int getDepth() {
        return this._Elems.size();
    }

    protected StreamElement getTop() {
        return !this._Elems.isEmpty() ? this._Elems.get(0) : null;
    }

    protected StreamElement popElement() {
        StreamElement e = this.getTop();
        if (e != null) {
            this._Elems.remove(0);
        }
        return e;
    }

    protected void pushElement(StreamElement e) {
        this._Elems.add(0, e);
    }

    public void addExtendedData(StreamNode node) throws IllegalStateException {
        this.getBaseElement().add(node);
    }

    public StreamBuilder buildExtendedData() throws IllegalStateException {
        return null;
    }

    protected void setExtendedData(StreamBuilder b) {
    }

    public StreamNode getNode() throws IllegalStateException {
        return this.getBaseElement();
    }

    public void reset() {
        this.getBaseElement().reset();
        this.setStatus(StreamBuilder.READY);
    }

    public StreamBuilder.Status processElementStart(StreamParseState s) {
        StreamElement elem;
        StreamElement ctx = s.getContext();
        NSI name = s.getName();
        Set nss = s.getNamespacePrefixes(s.getDepth());
        Set attrs = s.getAttributeNames();
        if (this.getDepth() == 0) {
            elem = this.getBaseElement();
            this.pushElement(elem);
        } else {
            elem = this.createElementNode(s);
            this.pushElement(elem);
        }
        Iterator itr = nss.iterator();
        while (itr.hasNext()) {
            String prefix = (String)itr.next();
            String uri = s.getNamespaceURI(prefix);
            elem.addNamespace(prefix, uri);
        }
        itr = attrs.iterator();
        while (itr.hasNext()) {
            NSI attrName = (NSI)itr.next();
            String attrVal = s.getAttributeValue(attrName);
            elem.setAttributeValue(attrName, attrVal);
        }
        this.setStatus(PROCESSING);
        return this.getStatus();
    }

    public StreamBuilder.Status processElementEnd(StreamParseState s) {
        StreamElement elem = this.popElement();
        if (this.getDepth() > 0) {
            StreamElement parent = this.getTop();
            parent.add(elem);
            this.setStatus(PROCESSING);
        } else {
            this.setStatus(COMPLETE);
        }
        return this.getStatus();
    }

    public StreamBuilder.Status processText(StreamParseState s) {
        StreamElement ctx = s.getContext();
        String txt = s.getText();
        StreamElement elem = this.getTop();
        elem.add(ctx.getDataFactory().createText(txt));
        this.setStatus(PROCESSING);
        return this.getStatus();
    }

    protected StreamElement createElementNode(StreamParseState s) {
        StreamElement ctx = s.getContext();
        NSI name = s.getName();
        return ctx.getDataFactory().createElementNode(name, null);
    }
}

