/*
 * Decompiled with CFR 0.152.
 */
package net.outer_planes.jso;

import java.nio.charset.Charset;
import java.nio.charset.IllegalCharsetNameException;
import java.nio.charset.UnsupportedCharsetException;
import net.outer_planes.jso.ContextBuilder;
import net.outer_planes.jso.ElementNode;
import org.jabberstudio.jso.JID;
import org.jabberstudio.jso.NSI;
import org.jabberstudio.jso.PacketRouter;
import org.jabberstudio.jso.Stream;
import org.jabberstudio.jso.StreamContext;
import org.jabberstudio.jso.StreamDataFactory;
import org.jabberstudio.jso.StreamElement;
import org.jabberstudio.jso.StreamObject;
import org.jabberstudio.jso.io.StreamBuilder;
import org.jabberstudio.jso.util.Utilities;

public class BasicStreamContext
extends ElementNode
implements StreamContext {
    public static final NSI NAME = new NSI("stream", "http://etherx.jabber.org/streams");
    public static final NSI ATTRIBUTE_ID = new NSI("id", null);
    public static final NSI ATTRIBUTE_FROM = new NSI("from", null);
    public static final NSI ATTRIBUTE_TO = new NSI("to", null);
    public static final NSI ATTRNAME_VERSION = new NSI("version", null);
    private StreamDataFactory _SDF;
    private Charset _CS;

    public BasicStreamContext() {
        this(NAME, "stream");
    }

    public BasicStreamContext(NSI name) {
        this(name, "");
    }

    public BasicStreamContext(NSI name, String prefix) {
        super(null, name);
        this.addNamespace(prefix, this.getNamespaceURI());
    }

    protected BasicStreamContext(BasicStreamContext base) {
        super(null, base);
    }

    public StreamBuilder createBuilder() {
        return new ContextBuilder(this);
    }

    public void setParent(StreamElement p) throws IllegalStateException {
        if (p != null) {
            throw new IllegalStateException("Parent cannot be set for StreamContext");
        }
    }

    public StreamContext getContext() {
        return this;
    }

    public JID getFrom() {
        Object val = this.getAttributeObject(ATTRIBUTE_FROM);
        JID jid = null;
        if (val instanceof JID) {
            jid = (JID)val;
        } else if (val != null) {
            try {
                jid = JID.valueOf(val);
                this.setAttributeObject(ATTRIBUTE_FROM, (Object)jid);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return jid;
    }

    public void setFrom(JID from) {
        this.setAttributeObject(ATTRIBUTE_FROM, (Object)from);
    }

    public JID getTo() {
        Object val = this.getAttributeObject(ATTRIBUTE_TO);
        JID jid = null;
        if (val instanceof JID) {
            jid = (JID)val;
        } else if (val != null) {
            try {
                jid = JID.valueOf(val);
                this.setAttributeObject(ATTRIBUTE_TO, (Object)jid);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return jid;
    }

    public void setTo(JID to) {
        this.setAttributeObject(ATTRIBUTE_TO, (Object)to);
    }

    public String getVersion() {
        String ver = this.getAttributeValue(ATTRNAME_VERSION);
        return ver != null ? ver : "";
    }

    public void setVersion(String ver) {
        this.setAttributeValue(ATTRNAME_VERSION, Utilities.isValidString(ver) ? ver : null);
    }

    public boolean isInbound() {
        return false;
    }

    public boolean isOutbound() {
        return false;
    }

    public StreamObject copy(StreamElement p) {
        return new BasicStreamContext(this);
    }

    public PacketRouter getRouter() {
        return null;
    }

    public Stream.Status getCurrentStatus() {
        return Stream.DISCONNECTED;
    }

    public String getCharsetName() {
        return this._CS != null ? this._CS.name() : "";
    }

    public void setCharsetName(String name) throws IllegalArgumentException {
        if (!Utilities.isValidString(name)) {
            throw new IllegalArgumentException("name cannot be null or \"\"");
        }
        try {
            this._CS = Charset.forName(name);
        }
        catch (IllegalCharsetNameException icne) {
            throw new IllegalArgumentException("charset named " + name + " is not valid");
        }
        catch (UnsupportedCharsetException uce) {
            throw new IllegalArgumentException("charset named " + name + " is not supported");
        }
    }

    public Charset obtainCharset() {
        if (this._CS == null) {
            this._CS = Charset.forName("UTF-8");
        }
        return this._CS;
    }

    protected void checkReset(StreamElement check) throws IllegalArgumentException {
        if (NSI.STRICT_COMPARATOR.compare(this.getNSI(), check.getNSI()) != 0) {
            throw new IllegalArgumentException("NSI must be equal");
        }
    }
}

