/*
 * Decompiled with CFR 0.152.
 */
package net.outer_planes.jso;

import java.util.Iterator;
import net.outer_planes.jso.AbstractPacket;
import net.outer_planes.jso.BasicPacketBuilder;
import org.jabberstudio.jso.NSI;
import org.jabberstudio.jso.PacketError;
import org.jabberstudio.jso.StreamDataFactory;
import org.jabberstudio.jso.StreamElement;
import org.jabberstudio.jso.StreamNode;
import org.jabberstudio.jso.StreamObject;
import org.jabberstudio.jso.io.StreamBuilder;
import org.jabberstudio.jso.util.Utilities;

public class BasicPacketNode
extends AbstractPacket {
    public BasicPacketNode(StreamDataFactory sdf, NSI name) {
        super(sdf, name);
    }

    public BasicPacketNode(StreamElement parent, BasicPacketNode base) {
        super(parent, base);
    }

    public PacketError getError() {
        Iterator itr = this.listElements("error", this.getNamespaceURI()).iterator();
        return itr.hasNext() ? itr.next() : null;
    }

    public void setError(PacketError err) {
        Iterator itr = this.listElements("error", this.getNamespaceURI()).iterator();
        while (itr.hasNext()) {
            ((StreamElement)itr.next()).detach();
        }
        this.configurePacketError(err);
        super.add(err);
    }

    public StreamBuilder createBuilder() {
        return new BasicPacketBuilder(this);
    }

    public void add(StreamNode node) throws UnsupportedOperationException {
        if (node != null) {
            if (node instanceof PacketError) {
                this.configurePacketError((PacketError)node);
            }
            super.add(node);
        }
    }

    public void insert(int idx, StreamNode node) throws UnsupportedOperationException {
        if (node == null) {
            return;
        }
        if (node instanceof StreamElement) {
            if (node instanceof PacketError) {
                this.configurePacketError((PacketError)node);
            }
            super.insert(idx, node);
        }
    }

    public void remove(StreamNode node) throws UnsupportedOperationException {
        if (node == null) {
            return;
        }
        if (node instanceof StreamElement) {
            if (node instanceof PacketError) {
                this.configurePacketError(null);
            }
            super.remove(node);
        }
    }

    public StreamObject copy(StreamElement parent) {
        return new BasicPacketNode(parent, this);
    }

    public void checkNSI(NSI check) throws IllegalArgumentException {
        super.checkNSI(check);
        if (!Utilities.equateStrings(this.getLocalName(), check.getLocalName())) {
            throw new IllegalArgumentException("local name must be equal");
        }
    }

    public void checkElement(StreamElement check) throws IllegalArgumentException {
    }

    protected void configurePacketError(PacketError err) {
        if (err == null) {
            this.setType(null);
        } else {
            String msg = err.normalizeTrimText();
            String txt = err.getText();
            this.setType(ERROR);
            this.configureIETF(err);
            this.configureLegacy(err);
            if (!Utilities.isValidString(txt)) {
                err.setText(msg);
            }
            if (Utilities.isValidString(msg)) {
                err.clearText();
            }
        }
    }

    protected void configureLegacy(PacketError err) {
        PacketError.Type type = err.getType();
        String cond = err.getDefinedCondition();
        Integer codeObj = null;
        int codeVal = 0;
        try {
            codeObj = Integer.valueOf(err.getAttributeValue("code"));
        }
        catch (NumberFormatException nfe) {
            // empty catch block
        }
        if (codeObj == null) {
            codeVal = Utilities.equateStrings(cond, "bad-request") && type == PacketError.MODIFY ? 400 : (Utilities.equateStrings(cond, "conflict") && type == PacketError.CANCEL ? 409 : (Utilities.equateStrings(cond, "feature-not-implemented") && type == PacketError.CANCEL ? 501 : (Utilities.equateStrings(cond, "forbidden") && type == PacketError.AUTH ? 403 : (Utilities.equateStrings(cond, "gone") && type == PacketError.MODIFY ? 302 : (Utilities.equateStrings(cond, "internal-server-error") && type == PacketError.WAIT ? 500 : (Utilities.equateStrings(cond, "item-not-found") && type == PacketError.CANCEL ? 404 : (Utilities.equateStrings(cond, "jid-malformed") && type == PacketError.MODIFY ? 400 : (Utilities.equateStrings(cond, "not-acceptable") && type == PacketError.CANCEL ? 406 : (Utilities.equateStrings(cond, "not-allowed") && type == PacketError.CANCEL ? 405 : (Utilities.equateStrings(cond, "recipient-unavailable") && type == PacketError.WAIT ? 404 : (Utilities.equateStrings(cond, "redirect") && type == PacketError.MODIFY ? 302 : (Utilities.equateStrings(cond, "registration-required") && type == PacketError.AUTH ? 407 : (Utilities.equateStrings(cond, "remote-server-not-found") && type == PacketError.CANCEL ? 404 : (Utilities.equateStrings(cond, "remote-server-timeout") && type == PacketError.WAIT ? 504 : (Utilities.equateStrings(cond, "resource-constraint") && type == PacketError.WAIT ? 500 : (Utilities.equateStrings(cond, "service-unavailable") && type == PacketError.CANCEL ? 503 : (Utilities.equateStrings(cond, "subscription-required") && type == PacketError.AUTH ? 407 : (Utilities.equateStrings(cond, "unexpected-request") && type == PacketError.WAIT ? 400 : 500))))))))))))))))));
            err.setAttributeValue("code", Integer.toString(codeVal));
        }
    }

    protected void configureIETF(PacketError err) {
        PacketError.Type type = err.getType();
        String cond = err.getDefinedCondition();
        String msg = err.normalizeTrimText();
        if (!Utilities.isValidString(cond)) {
            try {
                switch (Integer.parseInt(err.getAttributeValue("code"))) {
                    case 302: {
                        cond = "redirect";
                        type = PacketError.MODIFY;
                        break;
                    }
                    case 400: {
                        cond = "bad-request";
                        type = PacketError.MODIFY;
                        break;
                    }
                    case 401: {
                        cond = "not-allowed";
                        type = PacketError.AUTH;
                        break;
                    }
                    case 402: {
                        cond = "payment-required";
                        type = PacketError.AUTH;
                        break;
                    }
                    case 403: {
                        cond = "forbidden";
                        type = PacketError.AUTH;
                        break;
                    }
                    case 404: {
                        cond = "item-not-found";
                        type = PacketError.CANCEL;
                        break;
                    }
                    case 405: {
                        cond = "not-allowed";
                        type = PacketError.CANCEL;
                        break;
                    }
                    case 406: {
                        cond = "not-acceptable";
                        type = PacketError.MODIFY;
                        break;
                    }
                    case 407: {
                        cond = "registration-required";
                        type = PacketError.AUTH;
                        break;
                    }
                    case 408: {
                        cond = "remote-server-timeout";
                        type = PacketError.WAIT;
                        break;
                    }
                    case 409: {
                        cond = "conflict";
                        type = PacketError.CANCEL;
                        break;
                    }
                    case 500: {
                        cond = "internal-server-error";
                        type = PacketError.WAIT;
                        break;
                    }
                    case 501: {
                        cond = "feature-not-implemented";
                        type = PacketError.CANCEL;
                        break;
                    }
                    case 502: {
                        cond = "service-unavailable";
                        type = PacketError.WAIT;
                    }
                    case 503: {
                        cond = "service-unavailable";
                        type = PacketError.CANCEL;
                        break;
                    }
                    case 504: {
                        cond = "remote-server-timeout";
                        type = PacketError.WAIT;
                        break;
                    }
                    case 510: {
                        cond = "service-unavailable";
                        type = PacketError.CANCEL;
                        break;
                    }
                    default: {
                        cond = "undefined-condition";
                        type = PacketError.CANCEL;
                    }
                }
                err.setType(type);
                err.setDefinedCondition(cond);
            }
            catch (NumberFormatException nfe) {
                // empty catch block
            }
        }
    }
}

