/*
 * Decompiled with CFR 0.152.
 */
package net.outer_planes.jso;

import java.util.Iterator;
import java.util.Set;
import net.outer_planes.jso.AbstractBuilder;
import net.outer_planes.jso.AbstractPacket;
import org.jabberstudio.jso.Extension;
import org.jabberstudio.jso.NSI;
import org.jabberstudio.jso.StreamDataFactory;
import org.jabberstudio.jso.StreamElement;
import org.jabberstudio.jso.StreamNode;
import org.jabberstudio.jso.io.StreamBuilder;
import org.jabberstudio.jso.io.StreamParseState;
import org.jabberstudio.jso.util.Utilities;

public class AbstractPacketBuilder
extends AbstractBuilder {
    private AbstractPacket _Packet;
    private StreamBuilder _Extended;

    public AbstractPacketBuilder(AbstractPacket packet) {
        this.setPacket(packet);
    }

    protected AbstractPacket getPacket() {
        return this._Packet;
    }

    private void setPacket(AbstractPacket pkt) throws IllegalArgumentException {
        if (pkt == null) {
            throw new IllegalArgumentException("Packet cannot be null");
        }
        this._Packet = pkt;
    }

    public NSI getName() {
        return this.getPacket().getNSI();
    }

    public void reset() {
        AbstractPacket p = this.getPacket();
        Iterator itr = p.listExtensions().iterator();
        this.setStatus(READY);
        p.setFrom(null);
        p.setTo(null);
        p.setID(null);
        while (itr.hasNext()) {
            p.removeExtension((Extension)itr.next());
        }
    }

    public StreamNode getNode() throws IllegalStateException {
        if (this.getStatus() != COMPLETE) {
            throw new IllegalStateException("Not ready to get the node!");
        }
        return this.getPacket();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public StreamBuilder.Status processElementStart(StreamParseState s) {
        StreamElement ctx = s.getContext();
        NSI name = s.getName();
        NSI.Comparator cmpr = NSI.STRICT_COMPARATOR;
        StreamDataFactory sdf = ctx.getDataFactory();
        AbstractPacket p = this.getPacket();
        Set attrs = s.getAttributeNames();
        Set nss = s.getNamespacePrefixes(s.getDepth());
        StreamBuilder.Status status = INVALID;
        try {
            if (NSI.NS_LOOSE_COMPARATOR.compare(name, this.getName()) == 0) {
                Iterator attrItr = attrs.iterator();
                Iterator nssItr = nss.iterator();
                while (attrItr.hasNext()) {
                    NSI attrName = (NSI)attrItr.next();
                    String val = s.getAttributeValue(attrName);
                    p.setAttributeValue(attrName, val);
                }
                while (nssItr.hasNext()) {
                    String nsPre = (String)nssItr.next();
                    String nsURI = s.getNamespaceURI(nsPre);
                    p.addNamespace(nsPre, nsURI);
                }
                status = PROCESSING;
            } else {
                status = this.processNestedElementStart(s);
            }
        }
        finally {
            this.setStatus(status);
        }
        return this.getStatus();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public StreamBuilder.Status processElementEnd(StreamParseState s) {
        NSI name = s.getName();
        AbstractPacket p = this.getPacket();
        StreamBuilder.Status status = INVALID;
        try {
            if (NSI.NS_LOOSE_COMPARATOR.compare(name, this.getName()) == 0) {
                status = COMPLETE;
            }
        }
        finally {
            this.setStatus(status);
        }
        return this.getStatus();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public StreamBuilder.Status processText(StreamParseState s) {
        block5: {
            StreamElement ctx = s.getContext();
            String txt = s.getText();
            AbstractPacket elem = this.getPacket();
            StreamBuilder.Status status = INVALID;
            try {
                if (elem == null) break block5;
                try {
                    elem.add(ctx.getDataFactory().createText(txt));
                }
                catch (UnsupportedOperationException uoe) {
                    // empty catch block
                }
                status = PROCESSING;
            }
            finally {
                this.setStatus(status);
            }
        }
        return this.getStatus();
    }

    protected StreamBuilder.Status processNestedElementStart(StreamParseState s) {
        StreamElement ctx = s.getContext();
        NSI.Comparator cmpr = NSI.NS_LOOSE_COMPARATOR;
        NSI name = s.getName();
        String uri = name.getNamespaceURI();
        String ln = name.getLocalName();
        StreamDataFactory sdf = ctx.getDataFactory();
        StreamBuilder.Status status = INVALID;
        if (Utilities.isValidString(uri) && !Utilities.equateStrings(this.getName().getNamespaceURI(), uri)) {
            this.setExtendedData(sdf.createExtensionBuilder(name));
            status = EXTENDED_DATA;
        } else {
            this.setExtendedData(sdf.createElementBuilder(name));
            status = EXTENDED_DATA;
        }
        return status;
    }

    public StreamBuilder buildExtendedData() throws IllegalStateException {
        return this._Extended;
    }

    protected void setExtendedData(StreamBuilder b) {
        this._Extended = b;
    }

    public void addExtendedData(StreamNode node) throws IllegalStateException {
        if (node instanceof Extension) {
            this.getPacket().addExtension((Extension)node);
        } else {
            this.getPacket().add(node);
        }
        this.setExtendedData(null);
    }
}

