/*
 * Decompiled with CFR 0.152.
 */
package net.outer_planes.jso;

import java.util.List;
import net.outer_planes.jso.ElementNode;
import org.jabberstudio.jso.Extension;
import org.jabberstudio.jso.JID;
import org.jabberstudio.jso.NSI;
import org.jabberstudio.jso.Packet;
import org.jabberstudio.jso.PacketError;
import org.jabberstudio.jso.StreamDataFactory;
import org.jabberstudio.jso.StreamElement;
import org.jabberstudio.jso.io.StreamBuilder;
import org.jabberstudio.jso.util.Utilities;

public abstract class AbstractPacket
extends ElementNode
implements Packet {
    public static final NSI ATTRIBUTE_TYPE = new NSI("type", "");
    public static final NSI ATTRIBUTE_ID = new NSI("id", "");
    public static final NSI ATTRIBUTE_FROM = new NSI("from", "");
    public static final NSI ATTRIBUTE_TO = new NSI("to", "");

    public AbstractPacket(StreamDataFactory sdf, NSI name) {
        super(sdf, name);
    }

    protected AbstractPacket(StreamElement parent, AbstractPacket base) {
        super(parent, base);
    }

    public StreamBuilder createBuilder() {
        throw new IllegalStateException("Cannot create StreamBuilder");
    }

    public Packet.Type getType() {
        Object typeObj = this.getAttributeObject(ATTRIBUTE_TYPE);
        Packet.Type typeVal = null;
        if (typeObj instanceof Packet.Type) {
            typeVal = (Packet.Type)typeObj;
        } else if (typeObj != null) {
            typeVal = this.determineType(typeObj.toString());
        }
        return typeVal;
    }

    public void setType(Packet.Type type) throws IllegalArgumentException {
        this.setAttributeObject(ATTRIBUTE_TYPE, (Object)type);
    }

    protected Packet.Type determineType(String name) {
        Packet.Type type = null;
        if (Utilities.equateStrings(ERROR.toString(), name)) {
            type = ERROR;
        } else {
            this.setError(null);
        }
        return type;
    }

    public JID getFrom() {
        Object fromObj = this.getAttributeObject(ATTRIBUTE_FROM);
        JID fromVal = null;
        if (fromObj instanceof JID) {
            fromVal = (JID)fromObj;
        } else if (fromObj != null) {
            try {
                fromVal = JID.valueOf(fromObj);
                this.setAttributeObject(ATTRIBUTE_FROM, (Object)fromVal);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
        }
        return fromVal;
    }

    public void setFrom(JID from) {
        this.setAttributeObject(ATTRIBUTE_FROM, (Object)from);
    }

    public JID getTo() {
        Object toObj = this.getAttributeObject(ATTRIBUTE_TO);
        JID toVal = null;
        if (toObj instanceof JID) {
            toVal = (JID)toObj;
        } else if (toObj != null) {
            try {
                toVal = JID.valueOf(toObj);
                this.setAttributeObject(ATTRIBUTE_TO, (Object)toVal);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
        }
        return toVal;
    }

    public void setTo(JID to) {
        this.setAttributeObject(ATTRIBUTE_TO, (Object)to);
    }

    public List listExtensions() {
        return this.listExtensions(null, null);
    }

    public List listExtensions(Class iface) {
        return this.listExtensions(null, iface);
    }

    public List listExtensions(String ns) {
        return this.listElements(new NSI(null, ns), Extension.class);
    }

    public List listExtensions(String ns, Class iface) {
        if (iface == null) {
            iface = Extension.class;
        }
        if (!Extension.class.isAssignableFrom(iface)) {
            throw new IllegalArgumentException(iface + " does not implement Extension");
        }
        return this.listElements(new NSI(null, ns), iface);
    }

    public Extension getExtension() {
        return this.getExtension(null, null);
    }

    public Extension getExtension(Class iface) {
        return this.getExtension(null, iface);
    }

    public Extension getExtension(String ns) {
        return (Extension)this.getFirstElement(new NSI(null, ns), Extension.class);
    }

    public Extension getExtension(String ns, Class iface) {
        if (iface != null && !Extension.class.isAssignableFrom(iface)) {
            throw new IllegalArgumentException(iface + " does not implement Extension");
        }
        return (Extension)this.getFirstElement(new NSI(null, ns), iface);
    }

    public void addExtension(Extension x) {
        this.add(x);
    }

    public void removeExtension(Extension x) {
        this.remove(x);
    }

    public PacketError setError(int code) {
        return this.setError(code, null);
    }

    public PacketError setError(int code, String msg) {
        PacketError err = this.getDataFactory().createError(code, msg);
        this.setError(err);
        return err;
    }

    public PacketError setError(PacketError.Type type, String cond) throws IllegalArgumentException {
        PacketError err = this.getDataFactory().createPacketError(type, cond);
        this.setError(err);
        return err;
    }
}

