/*
 * Decompiled with CFR 0.152.
 */
package com.sun.im.service.xmpp;

import com.sun.im.service.CollaborationException;
import com.sun.im.service.ContentStream;
import com.sun.im.service.ContentStreamListener;
import com.sun.im.service.ReceiverStreamingProfile;
import com.sun.im.service.SenderFileStreamingProfile;
import com.sun.im.service.SenderStreamingProfile;
import com.sun.im.service.ServiceUnavailableException;
import com.sun.im.service.StreamingService;
import com.sun.im.service.StreamingServiceListener;
import com.sun.im.service.util.StringUtility;
import com.sun.im.service.xmpp.XMPPContentStream;
import com.sun.im.service.xmpp.XMPPReceiverFileStreamingProfile;
import com.sun.im.service.xmpp.XMPPSession;
import com.sun.im.service.xmpp.XMPPSessionProvider;
import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Timer;
import java.util.TimerTask;
import org.jabberstudio.jso.InfoQuery;
import org.jabberstudio.jso.JID;
import org.jabberstudio.jso.Packet;
import org.jabberstudio.jso.PacketError;
import org.jabberstudio.jso.StreamDataFactory;
import org.jabberstudio.jso.StreamException;
import org.jabberstudio.jso.x.disco.DiscoInfoQuery;
import org.jabberstudio.jso.x.info.OutOfBandExtension;
import org.jabberstudio.jso.x.si.SIQuery;
import org.jabberstudio.jso.x.sift.FileTransferProfile;

public class XMPPStreamingService
implements StreamingService {
    List _streamingServiceListeners = Collections.synchronizedList(new ArrayList());
    XMPPSession __session;
    StreamDataFactory _sdf;
    Hashtable _activeStreams = new Hashtable();
    String[] _availableMethods;
    public static long CLEANUP_PERIOD = 120000L;

    public XMPPStreamingService(XMPPSession session) {
        this.__session = session;
        this._sdf = this.__session.getDataFactory();
        Timer timer = new Timer(true);
        timer.schedule(new TimerTask(){

            public void run() {
                XMPPStreamingService.this.cleanup();
            }
        }, 0L, CLEANUP_PERIOD);
    }

    public void initialize(StreamingServiceListener listener) throws CollaborationException {
        this.addStreamingServiceListener(listener);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public ContentStream open(String rcpt, String[] methods, SenderStreamingProfile profile, ContentStreamListener listener) throws CollaborationException {
        String sid;
        Set features;
        if (!(profile instanceof SenderFileStreamingProfile)) throw new CollaborationException("Not Implemented");
        SenderFileStreamingProfile fileProfile = (SenderFileStreamingProfile)profile;
        File file = fileProfile.getFile();
        JID recipient = new JID(rcpt);
        try {
            DiscoInfoQuery diq = this.__session.sendInfoQuery(recipient, null);
            features = diq.getFeatures();
        }
        catch (CollaborationException e) {
            features = null;
        }
        boolean useOOBOnly = false;
        if (features == null || !features.contains("http://jabber.org/protocol/si")) {
            if (!StringUtility.contains(methods, "jabber:iq:oob")) throw new ServiceUnavailableException("Recipient does not support streaming");
            useOOBOnly = true;
            sid = this.__session.nextID("oob");
        } else {
            InfoQuery iq = (InfoQuery)this._sdf.createPacketNode(XMPPSession.IQ_NAME);
            SIQuery si = (SIQuery)this._sdf.createElementNode(SIQuery.NAME);
            si.setMimeType(fileProfile.getMimeType());
            sid = this.__session.nextID("sid");
            si.setID(sid);
            FileTransferProfile ftp = (FileTransferProfile)this._sdf.createElementNode(FileTransferProfile.NAME);
            ftp.setName(file.getName());
            ftp.setSize(file.length());
            ftp.setDescription(fileProfile.getDescription());
            ftp.setHash(fileProfile.getHash());
            si.setProfile(ftp);
            for (int i = 0; i < methods.length; ++i) {
                si.addSupportedStreamMethod(methods[i]);
            }
            iq.add(si);
            iq.setID(sid);
            iq.setTo(recipient);
            iq.setType(InfoQuery.SET);
            try {
                this.__session.getConnection().send(iq);
            }
            catch (StreamException se) {
                XMPPSessionProvider.error(se.toString(), se);
                throw new CollaborationException(se);
            }
            this._availableMethods = methods;
        }
        try {
            XMPPContentStream cs = new XMPPContentStream(this.__session, listener);
            cs.setSessionID(sid);
            cs.setTo(recipient);
            cs.setFile(file);
            this._activeStreams.put(sid, cs);
            if (!useOOBOnly) return cs;
            cs.start("jabber:iq:oob");
            return cs;
        }
        catch (Exception e) {
            XMPPSessionProvider.error(e.toString(), e);
            throw new CollaborationException(e);
        }
    }

    public void processSIPackets(InfoQuery iq) {
        try {
            XMPPContentStream cs = (XMPPContentStream)this._activeStreams.get(iq.getID());
            if (cs != null) {
                if (Packet.ERROR.equals(iq.getType())) {
                    PacketError error = iq.getError();
                    if (error == null) {
                        cs.notifyClosed(2, "Unknown reason");
                    } else if (error.getType() == PacketError.CANCEL) {
                        if (StringUtility.contains(this._availableMethods, "jabber:iq:oob")) {
                            cs.start("jabber:iq:oob");
                        } else if (error.listElements(XMPPContentStream.BAD_PROFILE).size() > 0) {
                            cs.notifyClosed(1, "bad-profile");
                        } else if (error.listElements(XMPPContentStream.INVALID_STREAM).size() > 0) {
                            cs.notifyClosed(1, "no-valid-streams");
                        } else if ("forbidden".equals(error.getDefinedCondition())) {
                            cs.notifyClosed(1, error.getText());
                        } else {
                            cs.notifyClosed(1, "Stream Rejected. Unknown reason");
                        }
                    }
                } else if (InfoQuery.RESULT.equals(iq.getType())) {
                    List elements = iq.listElements(SIQuery.NAME);
                    if (elements.size() == 0) {
                        cs.notifyClosed(2, "Unknown reason");
                        return;
                    }
                    SIQuery si = (SIQuery)elements.get(0);
                    cs.start(si.getPreferredStreamMethod());
                }
            } else {
                String sid;
                cs = new XMPPContentStream(this.__session, iq);
                JID sender = iq.getFrom();
                List elements = iq.listElements(SIQuery.NAME);
                if (elements.size() == 0) {
                    if (iq.listElements(OutOfBandExtension.IQ_NAME).size() == 0) {
                        cs.notifyClosed(2, "Unknown reason");
                        return;
                    }
                    sid = iq.getID();
                } else {
                    SIQuery si = (SIQuery)elements.get(0);
                    sid = si.getID();
                }
                this._activeStreams.put(sid, cs);
                XMPPReceiverFileStreamingProfile profile = new XMPPReceiverFileStreamingProfile(cs, iq);
                this._fireStreamingServiceListeners(sender == null ? null : sender.toBareJID().toString(), profile, cs);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public XMPPContentStream getContentStream(String sid) {
        if (sid == null) {
            return null;
        }
        return (XMPPContentStream)this._activeStreams.get(sid);
    }

    public XMPPContentStream removeContentStream(String sid) {
        if (sid == null) {
            return null;
        }
        return (XMPPContentStream)this._activeStreams.remove(sid);
    }

    public boolean isStreamingPacket(Packet packet) {
        if (packet.listElements(SIQuery.NAME).size() > 0) {
            return true;
        }
        return packet.getType() == Packet.ERROR && this._activeStreams.containsKey(packet.getID());
    }

    public void cleanup() {
        Iterator itr = this._activeStreams.entrySet().iterator();
        while (itr.hasNext()) {
            Map.Entry entry = itr.next();
            XMPPContentStream cs = (XMPPContentStream)entry.getValue();
            if (!cs.isTimedOut()) continue;
            String sid = (String)entry.getKey();
            XMPPSessionProvider.debug("Removing timedout content stream sid - " + sid);
            this._activeStreams.remove(sid);
            cs.timeout();
        }
    }

    private void _fireStreamingServiceListeners(String sender, ReceiverStreamingProfile profile, ContentStream stream) {
        this.__session.addWorkerRunnable(new StreamingServiceNotifier(sender, profile, stream));
    }

    public void addStreamingServiceListener(StreamingServiceListener listener) {
        if (!this._streamingServiceListeners.contains(listener)) {
            this._streamingServiceListeners.add(listener);
        }
    }

    public void removeStreamingServiceListener(StreamingServiceListener listener) {
        this._streamingServiceListeners.remove(listener);
    }

    private class StreamingServiceNotifier
    implements Runnable {
        String sender;
        ReceiverStreamingProfile profile;
        ContentStream stream;

        StreamingServiceNotifier(String sender, ReceiverStreamingProfile profile, ContentStream stream) {
            this.sender = sender;
            this.profile = profile;
            this.stream = stream;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            List list = XMPPStreamingService.this._streamingServiceListeners;
            synchronized (list) {
                Iterator itr = XMPPStreamingService.this._streamingServiceListeners.iterator();
                while (itr.hasNext()) {
                    try {
                        StreamingServiceListener l = (StreamingServiceListener)itr.next();
                        if (l == null) continue;
                        l.onContentStream(this.sender, this.profile, this.stream);
                    }
                    catch (Exception e) {
                        XMPPSessionProvider.error(e.toString(), e);
                    }
                }
            }
        }
    }
}

