/*
 * Decompiled with CFR 0.152.
 */
package com.sun.im.service.xmpp;

import com.sun.im.service.ApplicationInfo;
import com.sun.im.service.CollaborationException;
import com.sun.im.service.CollaborationSession;
import com.sun.im.service.CollaborationSessionListener;
import com.sun.im.service.CollaborationSessionProvider;
import com.sun.im.service.RegistrationListener;
import com.sun.im.service.jso.x.message_event.MessageEventFactory;
import com.sun.im.service.jso.x.muc.MUCFactory;
import com.sun.im.service.jso.x.pubsub.PubSubExtensionFactory;
import com.sun.im.service.util.BufferedByteChannel;
import com.sun.im.service.util.NioSelectWorker;
import com.sun.im.service.xmpp.StreamSourceCreator;
import com.sun.im.service.xmpp.XMPPRegistrationListenerWrapper;
import com.sun.im.service.xmpp.XMPPSession;
import java.io.IOException;
import java.net.InetAddress;
import java.nio.channels.SocketChannel;
import java.security.Principal;
import java.util.Hashtable;
import java.util.Iterator;
import org.apache.log4j.LogManager;
import org.apache.log4j.Logger;
import org.jabberstudio.jso.JID;
import org.jabberstudio.jso.JSOImplementation;
import org.jabberstudio.jso.StreamDataFactory;

public class XMPPSessionProvider
implements CollaborationSessionProvider {
    Hashtable _sessions = new Hashtable();
    private ApplicationInfo _appinfo;
    public static final int LOGINTYPE_PRIMARY = 1;
    public static final int LOGINTYPE_SECONDARY = 2;
    boolean keepGoing = true;
    NioSelectWorker channelManager;
    public static final String logPropertyName = "com.sun.im.service.xmpp.log";
    public static final String JVMID_PROP = "com.iplanet.im.jvmid";
    private static Logger logger = LogManager.getLogger("com.sun.im.service.xmpp");
    protected static String processId;
    private KeepAliveThread _keepAliveThread = null;

    public XMPPSessionProvider() {
        try {
            this.channelManager = new NioSelectWorker(1, 10);
            new Thread(this.channelManager).start();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public Object register(SocketChannel sch, Runnable callback) throws IOException {
        return this.channelManager.register(sch, callback);
    }

    public Object register(SocketChannel sch, Runnable callback, BufferedByteChannel writes) throws IOException {
        return null;
    }

    public void cancel(Object key) {
        this.channelManager.cancel(key);
    }

    public void close() {
        if (this._keepAliveThread != null) {
            this._keepAliveThread.close();
        }
        this.channelManager.close();
    }

    public CollaborationSession getSession(String str, CollaborationSessionListener collaborationSessionListener) throws CollaborationException {
        throw new CollaborationException("Not implemented");
    }

    public CollaborationSession getSession(Principal principal, CollaborationSessionListener collaborationSessionListener) throws CollaborationException {
        throw new CollaborationException("Not implemented");
    }

    public CollaborationSession getSession(String serviceUrl, String loginName, String password, CollaborationSessionListener collaborationSessionListener) throws CollaborationException {
        return this.getSession(serviceUrl, loginName, password, 1, collaborationSessionListener);
    }

    public CollaborationSession getSession(String serviceUrl, String loginName, String password, int loginType, CollaborationSessionListener collaborationSessionListener) throws CollaborationException {
        String sid = loginName + "[" + serviceUrl + "]";
        try {
            XMPPSession s = (XMPPSession)this._sessions.get(sid);
            if (s == null) {
                s = this.createSession(serviceUrl, loginName, password, loginType, collaborationSessionListener);
                this._sessions.put(sid, s);
                s.setProviderSessionIdentifier(sid);
            } else {
                s.setSessionListener(collaborationSessionListener);
            }
            return s;
        }
        catch (CollaborationException e) {
            this._sessions.remove(sid);
            throw e;
        }
    }

    public void register(String serviceURL, RegistrationListener listener) throws CollaborationException {
        XMPPSession s = this.createSession(serviceURL, null, null, 1, this.getCollaborationSessionListerForRegistration(listener));
        XMPPRegistrationListenerWrapper regisListener = new XMPPRegistrationListenerWrapper(listener);
        regisListener.setRequestType(XMPPRegistrationListenerWrapper.USER_REGISTRATION);
        s.register(serviceURL, regisListener);
    }

    void cleanupSession(XMPPSession session) {
        String sid = session.getProviderSessionIdentifier();
        if (sid != null) {
            this._sessions.remove(session.getProviderSessionIdentifier());
        }
    }

    public static void debug(String msg) {
        logger.debug(msg);
    }

    public static void debug(String msg, Throwable t) {
        logger.debug(msg, t);
    }

    public static void error(String msg) {
        logger.error(msg);
    }

    public static void error(String msg, Throwable t) {
        logger.error(msg, t);
    }

    public static void fatal(String msg) {
        logger.fatal(msg);
    }

    public static void fatal(String msg, Throwable t) {
        logger.fatal(msg, t);
    }

    public static void warning(String msg) {
        logger.warn(msg);
    }

    public static void warning(String msg, Throwable t) {
        logger.warn(msg, t);
    }

    public static void info(String msg) {
        logger.info(msg);
    }

    public static void info(String msg, Throwable t) {
        logger.info(msg, t);
    }

    protected XMPPSession createSession(String serviceUrl, String loginName, String password, int loginType, CollaborationSessionListener collaborationSessionListener) throws CollaborationException {
        return new XMPPSession(this, serviceUrl, loginName, password, loginType, collaborationSessionListener, new StreamSourceCreator(collaborationSessionListener));
    }

    protected CollaborationSessionListener getCollaborationSessionListerForRegistration(RegistrationListener listener) {
        return null;
    }

    public void setApplicationInfo(ApplicationInfo appinfo) throws CollaborationException {
        this._appinfo = appinfo;
    }

    public ApplicationInfo getApplicationInfo() throws CollaborationException {
        return this._appinfo;
    }

    synchronized void startKeepAlive(long period) {
        if (this._keepAliveThread == null) {
            this._keepAliveThread = new KeepAliveThread(period);
            this._keepAliveThread.start();
        } else if (period < this._keepAliveThread.getPeriod()) {
            this._keepAliveThread.setPeriod(period);
        }
    }

    static {
        try {
            try {
                processId = InetAddress.getLocalHost().getHostAddress() + "." + System.getProperty(JVMID_PROP, "jvm");
            }
            catch (Exception e) {
                processId = "ip." + System.getProperty(JVMID_PROP, "pid");
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        StreamDataFactory _sdf = JSOImplementation.getInstance().getDataFactory();
        _sdf.registerElementFactory(new MUCFactory());
        _sdf.registerElementFactory(new PubSubExtensionFactory());
        _sdf.registerElementFactory(new MessageEventFactory());
        Class clazz = JID.class;
    }

    class KeepAliveThread
    extends Thread {
        boolean running = true;
        long period;

        KeepAliveThread(long period) {
            this.period = period;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public synchronized void close() {
            Hashtable hashtable = XMPPSessionProvider.this._sessions;
            synchronized (hashtable) {
                this.running = false;
                XMPPSessionProvider.this._sessions.notify();
            }
        }

        public void setPeriod(long period) {
            this.period = period;
        }

        public long getPeriod() {
            return this.period;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            while (this.running) {
                Hashtable hashtable = XMPPSessionProvider.this._sessions;
                synchronized (hashtable) {
                    try {
                        XMPPSessionProvider.this._sessions.wait(this.period);
                    }
                    catch (Exception e) {
                        // empty catch block
                    }
                    if (!this.running) {
                        return;
                    }
                    Iterator i = XMPPSessionProvider.this._sessions.values().iterator();
                    while (i.hasNext()) {
                        XMPPSession s = (XMPPSession)i.next();
                        s.sendKeepAlive();
                    }
                }
            }
        }
    }
}

