/*
 * Decompiled with CFR 0.152.
 */
package com.sun.im.service.xmpp;

import com.sun.im.service.CollaborationException;
import com.sun.im.service.CollaborationPrincipal;
import com.sun.im.service.CollaborationSession;
import com.sun.im.service.CollaborationSessionListener;
import com.sun.im.service.ConferenceService;
import com.sun.im.service.NewsService;
import com.sun.im.service.NotificationService;
import com.sun.im.service.PersonalStoreService;
import com.sun.im.service.Presence;
import com.sun.im.service.PresenceHelper;
import com.sun.im.service.PresenceInfoListener;
import com.sun.im.service.PresenceService;
import com.sun.im.service.PresenceServiceListener;
import com.sun.im.service.PresenceSession;
import com.sun.im.service.PresenceSessionListener;
import com.sun.im.service.PresenceSubscription;
import com.sun.im.service.PresenceTuple;
import com.sun.im.service.PrivacyList;
import com.sun.im.service.RegistrationListener;
import com.sun.im.service.StreamingService;
import com.sun.im.service.xmpp.XMPPPresenceService;
import com.sun.im.service.xmpp.XMPPPresenceSubscription;
import com.sun.im.service.xmpp.XMPPSession;
import com.sun.im.service.xmpp.XMPPSessionProvider;
import java.util.Date;
import java.util.Iterator;
import java.util.List;

public class XMPPPresenceSession
extends XMPPPresenceService
implements PresenceSession,
PresenceServiceListener {
    private PresenceSessionListener _sessionListener;

    public XMPPPresenceSession(XMPPSession session) throws CollaborationException {
        super(session);
        this.initialize(this);
    }

    public String fetch(String presentity) throws CollaborationException {
        Presence p = this.fetchPresence(presentity);
        PresenceHelper ph = new PresenceHelper(p);
        return ph.toString();
    }

    public String[] fetch(String[] presentity) throws CollaborationException {
        String[] ret = new String[presentity.length];
        for (int i = 0; i < presentity.length; ++i) {
            ret[i] = this.fetch(presentity[i]);
        }
        return ret;
    }

    public void fetch(String[] presentity, PresenceInfoListener listener) throws CollaborationException {
        for (int i = 0; i < presentity.length; ++i) {
            this.fetch(presentity[i], listener);
        }
    }

    public void fetch(String presentity, PresenceInfoListener listener) throws CollaborationException {
        Presence p = this.fetchPresence(presentity);
        PresenceHelper ph = new PresenceHelper(p);
        listener.onPresenceInfo(ph.toString());
    }

    public void publish(String str) throws CollaborationException {
        PresenceHelper ph = new PresenceHelper(str);
        this.publish(ph.getPresence());
    }

    public PresenceSubscription subscribe(String str, PresenceInfoListener presenceInfoListener) throws CollaborationException {
        this.subscribe(str);
        String[] presentities = new String[]{str};
        return new XMPPPresenceSubscription(this, presentities);
    }

    public PresenceSubscription subscribe(String[] str, PresenceInfoListener presenceInfoListener) throws CollaborationException {
        this.subscribe(str);
        return new XMPPPresenceSubscription(this, str);
    }

    public PresenceSubscription subscribe(String[] str, PresenceInfoListener presenceInfoListener, Date date) throws CollaborationException {
        return this.subscribe(str, presenceInfoListener);
    }

    public PresenceSubscription subscribe(String str, PresenceInfoListener presenceInfoListener, Date date) throws CollaborationException {
        return this.subscribe(str, presenceInfoListener);
    }

    public CollaborationSession accessService(String service) throws CollaborationException {
        return this.__session.accessService(service);
    }

    public CollaborationPrincipal createPrincipal(String uid) throws CollaborationException {
        return this.__session.createPrincipal(uid);
    }

    public CollaborationPrincipal createPrincipal(String uid, String displayName) throws CollaborationException {
        return this.__session.createPrincipal(uid, displayName);
    }

    public CollaborationPrincipal getPrincipal() throws CollaborationException {
        return this.__session.getPrincipal();
    }

    public void logout() {
        this.__session.logout();
    }

    public void changePassword(String password, RegistrationListener listener) throws CollaborationException {
        this.__session.changePassword(password, listener);
    }

    public void setSessionListener(CollaborationSessionListener listener) {
        if (!(listener instanceof PresenceSessionListener)) {
            return;
        }
        XMPPSessionProvider.debug("Setting presence listener");
        this._sessionListener = (PresenceSessionListener)listener;
    }

    public void unregister(RegistrationListener listener) throws CollaborationException {
        this.__session.unregister(listener);
    }

    public NotificationService getNotificationService() throws CollaborationException {
        return this.__session.getNotificationService();
    }

    public ConferenceService getConferenceService() throws CollaborationException {
        return this.__session.getConferenceService();
    }

    public NewsService getNewsService() throws CollaborationException {
        return this.__session.getNewsService();
    }

    public PersonalStoreService getPersonalStoreService() throws CollaborationException {
        return this.__session.getPersonalStoreService();
    }

    public PresenceService getPresenceService() throws CollaborationException {
        return this.__session.getPresenceService();
    }

    public StreamingService getStreamingService() throws CollaborationException {
        return this.__session.getStreamingService();
    }

    public void setDefaultPrivacyListName(String name) throws CollaborationException {
        this.__session.setDefaultPrivacyListName(name);
    }

    public void setActivePrivacyListName(String name) throws CollaborationException {
        this.__session.setActivePrivacyListName(name);
    }

    public void removePrivacyList(String name) throws CollaborationException {
        this.__session.removePrivacyList(name);
    }

    public List listPrivacyLists() throws CollaborationException {
        return this.__session.listPrivacyLists();
    }

    public PrivacyList getPrivacyList(String name) throws CollaborationException {
        return this.__session.getPrivacyList(name);
    }

    public String getDefaultPrivacyListName() throws CollaborationException {
        return this.__session.getDefaultPrivacyListName();
    }

    public String getActivePrivacyListName() throws CollaborationException {
        return this.__session.getActivePrivacyListName();
    }

    public PrivacyList createPrivacyList(String name) throws CollaborationException {
        return this.__session.createPrivacyList(name);
    }

    public void addPrivacyList(PrivacyList list) throws CollaborationException {
        this.__session.addPrivacyList(list);
    }

    public void onPresence(Presence p) {
        PresenceTuple pt;
        Iterator it;
        if (this._sessionListener != null && (it = p.getTuples().iterator()).hasNext() && !"PENDING".equals((pt = (PresenceTuple)it.next()).getStatus())) {
            this._sessionListener.onPresenceNotify(p.url, p.toString(), null);
        }
    }

    public void onSubscribeRequest(Presence p) {
    }

    public void onSubscribed(Presence p) {
    }

    public void onUnsubscribe(Presence p) {
    }

    public void onUnsubscribed(Presence p) {
    }

    public void addSessionListener(CollaborationSessionListener listener) {
        throw new UnsupportedOperationException();
    }

    public void removeSessionListener(CollaborationSessionListener listener) {
        throw new UnsupportedOperationException();
    }
}

