/*
 * Decompiled with CFR 0.152.
 */
package com.sun.im.service.xmpp;

import com.sun.im.service.CollaborationException;
import com.sun.im.service.CollaborationPrincipal;
import com.sun.im.service.Conference;
import com.sun.im.service.PersonalConference;
import com.sun.im.service.PersonalContact;
import com.sun.im.service.PersonalGateway;
import com.sun.im.service.PersonalGroup;
import com.sun.im.service.PersonalProfile;
import com.sun.im.service.PersonalStoreEntry;
import com.sun.im.service.PersonalStoreEvent;
import com.sun.im.service.PersonalStoreFolder;
import com.sun.im.service.PersonalStoreService;
import com.sun.im.service.PersonalStoreServiceListener;
import com.sun.im.service.Presence;
import com.sun.im.service.ServiceUnavailableException;
import com.sun.im.service.Watcher;
import com.sun.im.service.util.StringUtility;
import com.sun.im.service.xmpp.JIDUtil;
import com.sun.im.service.xmpp.XMPPConference;
import com.sun.im.service.xmpp.XMPPConferenceService;
import com.sun.im.service.xmpp.XMPPGroup;
import com.sun.im.service.xmpp.XMPPPersonalConference;
import com.sun.im.service.xmpp.XMPPPersonalContact;
import com.sun.im.service.xmpp.XMPPPersonalFolder;
import com.sun.im.service.xmpp.XMPPPersonalGateway;
import com.sun.im.service.xmpp.XMPPPersonalGroup;
import com.sun.im.service.xmpp.XMPPPersonalProfile;
import com.sun.im.service.xmpp.XMPPPersonalStoreEntry;
import com.sun.im.service.xmpp.XMPPPresenceService;
import com.sun.im.service.xmpp.XMPPPrincipal;
import com.sun.im.service.xmpp.XMPPSession;
import com.sun.im.service.xmpp.XMPPSessionProvider;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import org.jabberstudio.jso.Extension;
import org.jabberstudio.jso.InfoQuery;
import org.jabberstudio.jso.JID;
import org.jabberstudio.jso.NSI;
import org.jabberstudio.jso.StreamDataFactory;
import org.jabberstudio.jso.StreamElement;
import org.jabberstudio.jso.StreamException;
import org.jabberstudio.jso.util.PacketMonitor;
import org.jabberstudio.jso.x.core.RosterItem;
import org.jabberstudio.jso.x.core.RosterQuery;
import org.jabberstudio.jso.x.disco.DiscoIdentity;
import org.jabberstudio.jso.x.disco.DiscoInfoQuery;
import org.jabberstudio.jso.x.disco.DiscoItem;
import org.jabberstudio.jso.x.disco.DiscoItemsQuery;

public class XMPPPersonalStoreService
implements PersonalStoreService {
    private List _personalStoreServiceListeners = Collections.synchronizedList(new ArrayList());
    XMPPSession __session;
    private XMPPPersonalProfile _personalProfile = null;
    private Hashtable _profiles = new Hashtable();
    private HashMap _folders = new HashMap();
    private Map _subscribedConferenceItems = new HashMap();
    private Map _watchers = new HashMap();
    private Map _gateWays = new HashMap();
    private Map _personalGroups = new HashMap();
    private JID _pstoreService;
    private HashSet _remoteServices = new HashSet();
    private boolean _asyncRosterProcessed;
    private Exception _asyncRosterException;
    private boolean _asyncBookmarkProcessed;
    private Exception _asyncBookmarkException;
    private Object _bookmarkLock = new Object();
    private boolean _asyncLDAPGroupProcessed;
    private Exception _asyncLDAPGroupException;

    public XMPPPersonalStoreService(XMPPSession session) {
        this.__session = session;
    }

    public PersonalStoreEntry getEntry(String entryType, String entryId) throws CollaborationException {
        if (entryId == null) {
            return null;
        }
        if ("abook".equals(entryType) || "book".equals(entryType)) {
            return (PersonalStoreEntry)this._getFolders().get(entryId);
        }
        if ("contact".equals(entryType) || "gateway".equals(entryType)) {
            Iterator i = this._getFolders().values().iterator();
            while (i.hasNext()) {
                PersonalStoreFolder f = (PersonalStoreFolder)i.next();
                PersonalStoreEntry e = f.getEntry(entryId);
                if (e == null || !e.getType().equals(entryType)) continue;
                return e;
            }
            return null;
        }
        if ("group".equals(entryType)) {
            Iterator i = this._getFolders().values().iterator();
            while (i.hasNext()) {
                PersonalStoreFolder f = (PersonalStoreFolder)i.next();
                PersonalStoreEntry e = f.getEntry(JIDUtil.encodedJID(entryId).toString());
                if (e != null && e.getType().equals(entryType)) {
                    return e;
                }
                e = f.getEntry(entryId);
                if (e != null && e.getType().equals(entryType)) {
                    return e;
                }
                e = f.getEntry(JIDUtil.decodedJID(entryId));
                if (e == null || !e.getType().equals(entryType)) continue;
                return e;
            }
            return null;
        }
        if ("conference".equals(entryType)) {
            return (PersonalConference)this._getSubscribedConferenceItems().get(JIDUtil.encodedJID(entryId).toString());
        }
        if ("watcher".equals(entryType)) {
            return (Watcher)this._watchers.get(entryId);
        }
        return null;
    }

    public PersonalStoreEntry getEntry(CollaborationPrincipal collaborationPrincipal, String entryType, String entryId) throws CollaborationException {
        if (collaborationPrincipal == null) {
            return this.getEntry(entryType, entryId);
        }
        throw new CollaborationException("Not Implemented");
    }

    public Collection getEntries(String entryType) throws CollaborationException {
        if ("abook".equals(entryType) || "book".equals(entryType)) {
            return this._getFolders().values();
        }
        if ("contact".equals(entryType)) {
            ArrayList contacts = new ArrayList();
            Iterator i = this._getFolders().values().iterator();
            while (i.hasNext()) {
                PersonalStoreFolder f = (PersonalStoreFolder)i.next();
                contacts.addAll(f.getEntries("contact"));
            }
            return contacts;
        }
        if ("group".equals(entryType)) {
            ArrayList groups = new ArrayList();
            Iterator i = this._getFolders().values().iterator();
            while (i.hasNext()) {
                PersonalStoreFolder f = (PersonalStoreFolder)i.next();
                groups.addAll(f.getEntries("group"));
            }
            return groups;
        }
        if ("conference".equals(entryType)) {
            return this._getSubscribedConferenceItems().values();
        }
        if ("gateway".equals(entryType)) {
            ArrayList gateways = new ArrayList();
            Iterator i = this._getFolders().values().iterator();
            while (i.hasNext()) {
                PersonalStoreFolder f = (PersonalStoreFolder)i.next();
                gateways.addAll(f.getEntries("gateway"));
            }
            return gateways;
        }
        if ("watcher".equals(entryType)) {
            return this._watchers.values();
        }
        throw new CollaborationException("Not Implemented");
    }

    public Collection getFolders(String entryType) throws CollaborationException {
        return this._getFolders().values();
    }

    public Collection getFolders(CollaborationPrincipal collaborationPrincipal, String entryType) throws CollaborationException {
        if (collaborationPrincipal == null) {
            return this.getFolders(entryType);
        }
        throw new CollaborationException("Not Implemented");
    }

    public PersonalStoreEntry createEntry(String entryType, String displayName) throws CollaborationException {
        return this.createEntry(entryType, displayName, null);
    }

    public PersonalStoreEntry createEntry(CollaborationPrincipal collaborationPrincipal, String entryType, String displayName) throws CollaborationException {
        if (collaborationPrincipal == null) {
            return this.createEntry(entryType, displayName);
        }
        return this.createEntry(entryType, displayName, collaborationPrincipal.getUID());
    }

    private PersonalStoreEntry createEntry(String entryType, String displayName, String jid) throws CollaborationException {
        PersonalStoreEntry e = this.getEntry(entryType, jid);
        if (e != null) {
            return e;
        }
        if ("contact".equals(entryType)) {
            return new XMPPPersonalContact(this.__session, displayName, jid);
        }
        if ("group".equals(entryType)) {
            if (jid == null) {
                return new XMPPPersonalGroup(this.__session, displayName, jid);
            }
            return new XMPPPersonalGroup(this.__session, displayName, JIDUtil.encodedJID(jid).toString());
        }
        if ("abook".equals(entryType) || "book".equals(entryType)) {
            Map map = this._getFolders();
            if (map.get(displayName) != null) {
                throw new CollaborationException("Folder name " + displayName + " already present!");
            }
            XMPPPersonalFolder folder = new XMPPPersonalFolder(this.__session, displayName);
            map.put(displayName, folder);
            return folder;
        }
        if ("conference".equals(entryType)) {
            return new XMPPPersonalConference(this.__session, displayName, jid);
        }
        if (entryType.equals("gateway")) {
            throw new CollaborationException("PersonalStoreEntry of type PersonalStoreEntry.GATEWAY  cannot be created");
        }
        if (entryType.equals("watcher")) {
            throw new CollaborationException("PersonalStoreEntry of type PersonalStoreEntry.WATCHER  cannot be created");
        }
        throw new CollaborationException("Unsupported entry type: " + entryType);
    }

    public CollaborationPrincipal[] searchPrincipals(int searchType, String pattern) throws CollaborationException {
        if (searchType == 0) {
            return this.searchPrincipals(searchType, pattern, 2);
        }
        return this.searchPrincipals(searchType, pattern, 1);
    }

    public CollaborationPrincipal[] searchPrincipals(int searchType, String pattern, int attribute) throws CollaborationException {
        String searchField;
        if ((attribute == 2 || attribute == 4) && searchType != 0) {
            throw new CollaborationException("Not Supported");
        }
        String wildcard = pattern;
        ArrayList<XMPPPrincipal> p = new ArrayList<XMPPPrincipal>();
        String domain = null;
        JID judJID = this.getService();
        switch (attribute) {
            case 2: {
                searchField = "nick";
                domain = StringUtility.getDomainFromAddress(pattern, null);
                judJID = this.getService(domain);
                if (judJID != null) break;
                throw new ServiceUnavailableException("No search service for " + domain);
            }
            case 4: {
                searchField = "email";
                break;
            }
            default: {
                searchField = "first";
            }
        }
        wildcard = XMPPPersonalStoreService.getWildCard(searchType, pattern);
        StreamDataFactory sdf = this.__session.getDataFactory();
        InfoQuery iqSearch = (InfoQuery)sdf.createPacketNode(XMPPSession.IQ_NAME, InfoQuery.class);
        iqSearch.setType(InfoQuery.SET);
        XMPPPrincipal client = (XMPPPrincipal)this.__session.getPrincipal();
        iqSearch.setFrom(client.getJID());
        iqSearch.setTo(judJID);
        iqSearch.setID(this.__session.nextID("search"));
        StreamElement sq = sdf.createElementNode(XMPPSession.SEARCH_QUERY_NAME, null);
        sq.addElement(new NSI(searchField, null)).addText(wildcard);
        iqSearch.add(sq);
        try {
            iqSearch = (InfoQuery)PacketMonitor.sendAndWatch(this.__session.getConnection(), iqSearch, XMPPSession.REQUEST_TIMEOUT);
        }
        catch (StreamException se) {
            throw new CollaborationException(se);
        }
        if (iqSearch == null || iqSearch.getType() != InfoQuery.RESULT) {
            throw new CollaborationException("Error while doing the search");
        }
        sq = (StreamElement)iqSearch.listExtensions("jabber:iq:search").get(0);
        Iterator itr = sq.listElements().iterator();
        while (itr.hasNext()) {
            StreamElement n = (StreamElement)itr.next();
            JID jid = new JID(n.getAttributeValue("jid"));
            String displayName = XMPPSession.getItemValue(n, "first");
            XMPPPrincipal principal = "".equals(jid.getNode()) ? new XMPPGroup(jid, displayName) : new XMPPPrincipal(jid, displayName);
            StreamElement x = n.getFirstElement(XMPPSession.SUN_PRIVATE_NAME);
            if (x != null) {
                Iterator i = x.listElements("property").iterator();
                while (i.hasNext()) {
                    StreamElement prop = (StreamElement)i.next();
                    String name = prop.getAttributeValue("name");
                    StreamElement val = prop.getFirstElement("value");
                    if (val == null) continue;
                    principal.setProperty(name, val.normalizeTrimText());
                }
            }
            p.add(principal);
        }
        if (p.size() > 0) {
            CollaborationPrincipal[] result = new XMPPPrincipal[p.size()];
            for (int i = 0; i < p.size(); ++i) {
                result[i] = (XMPPPrincipal)p.get(i);
            }
            return result;
        }
        return null;
    }

    public PersonalStoreEntry[] search(int searchType, String pattern, String entryType) throws CollaborationException {
        if (searchType == 0) {
            return this.search(searchType, pattern, entryType, 2);
        }
        return this.search(searchType, pattern, entryType, 1);
    }

    public PersonalStoreEntry[] search(int searchType, String pattern, String entryType, int attribute) throws CollaborationException {
        if ("conference".equals(entryType)) {
            Conference[] r = this.searchConference(searchType, pattern);
            if (r == null) {
                return null;
            }
            PersonalStoreEntry[] c = new XMPPPersonalConference[r.length];
            for (int i = 0; i < r.length; ++i) {
                c[i] = new XMPPPersonalConference(this.__session, ((XMPPConference)r[i]).getName(), ((XMPPConference)r[i]).getDestination());
            }
            return c;
        }
        if (entryType.equals("contact") || entryType.equals("group")) {
            CollaborationPrincipal[] p = this.searchPrincipals(searchType, pattern, attribute);
            if (p == null) {
                return null;
            }
            PersonalStoreEntry[] pse = new PersonalStoreEntry[p.length];
            for (int i = 0; i < p.length; ++i) {
                JID jid = ((XMPPPrincipal)p[i]).getJID();
                pse[i] = p[i] instanceof XMPPGroup ? new XMPPPersonalGroup(this.__session, p[i].getDisplayName(), ((XMPPPrincipal)p[i]).getJid()) : new XMPPPersonalContact(this.__session, p[i].getDisplayName(), p[i].getUID());
            }
            return pse;
        }
        if (entryType.equals("gateway")) {
            return this.searchGateways(searchType, pattern);
        }
        return null;
    }

    public PersonalProfile getProfile() throws CollaborationException {
        if (this._personalProfile != null) {
            return this._personalProfile;
        }
        this._personalProfile = this.getPrivateQuery(null);
        this._profiles.put(this.__session.getPrincipal().getUID(), this._personalProfile);
        return this._personalProfile;
    }

    public PersonalProfile getProfile(CollaborationPrincipal collaborationPrincipal) throws CollaborationException {
        if (collaborationPrincipal == null) {
            return this.getProfile();
        }
        PersonalProfile profile = null;
        profile = (PersonalProfile)this._profiles.get(collaborationPrincipal.getUID());
        if (profile == null) {
            profile = this.getPrivateQuery(((XMPPPrincipal)collaborationPrincipal).getJID());
            this._profiles.put(collaborationPrincipal.getUID(), profile);
        }
        return profile;
    }

    public void save() throws CollaborationException {
        Iterator i = this._getFolders().values().iterator();
        while (i.hasNext()) {
            PersonalStoreFolder f = (PersonalStoreFolder)i.next();
            XMPPPersonalStoreService.saveFolder(f);
        }
        this.saveProfile();
    }

    public void initialize(PersonalStoreServiceListener listener) throws CollaborationException {
        this.addPersonalStoreServiceListener(listener);
        this.sendLDAPGroupRequest();
        this.sendRosterRequest();
        this.sendBookmarkRequest();
        try {
            this.__session.loadJabberServices();
        }
        catch (CollaborationException collaborationException) {
            // empty catch block
        }
    }

    protected Collection expandGroup(PersonalGroup group) {
        Hashtable<JID, CollaborationPrincipal> p = new Hashtable<JID, CollaborationPrincipal>();
        try {
            DiscoItemsQuery dq = this.__session.sendItemsQuery(this.getService(), group.getEntryId());
            Iterator itr = dq.listItems().iterator();
            while (itr.hasNext()) {
                DiscoItem item = (DiscoItem)itr.next();
                p.put(item.getJID(), new XMPPPrincipal(item.getJID(), item.getName()));
            }
            Collection c = this.getEntries("contact");
            itr = c.iterator();
            while (itr.hasNext()) {
                PersonalContact pc = (PersonalContact)itr.next();
                JID jid = new JID(pc.getEntryId());
                if (!p.containsKey(jid)) continue;
                p.put(jid, pc.getPrincipal());
            }
        }
        catch (Exception e) {
            // empty catch block
        }
        return p.values();
    }

    protected void saveEntry(PersonalStoreEntry entry) throws CollaborationException {
        this.setRosterQuery(entry);
    }

    protected void removeEntry(PersonalStoreEntry entry) throws CollaborationException {
        this.removeRosterQuery(entry);
    }

    protected static void saveFolder(PersonalStoreFolder folder) throws CollaborationException {
        Collection entries = folder.getEntries();
        Iterator i = entries.iterator();
        while (i.hasNext()) {
            PersonalStoreEntry pse = (PersonalStoreEntry)i.next();
            pse.save();
        }
    }

    protected void removeFolder(PersonalStoreFolder folder) throws CollaborationException {
        Collection entries = folder.getEntries();
        Iterator i = entries.iterator();
        while (i.hasNext()) {
            PersonalStoreEntry pse = (PersonalStoreEntry)i.next();
            pse.removeFromFolder(folder);
            pse.save();
        }
        this._getFolders().remove(folder.getDisplayName());
        XMPPSessionProvider.debug("removeFolder folders: " + this._folders.values());
    }

    protected void removeProfile() throws CollaborationException {
        if (this._personalProfile == null) {
            return;
        }
        this._personalProfile.clear(true);
        this._personalProfile.save();
    }

    protected void setRosterQuery(PersonalStoreEntry entry) throws CollaborationException {
        StreamDataFactory sdf = this.__session.getDataFactory();
        InfoQuery iqRoster = (InfoQuery)sdf.createPacketNode(XMPPSession.IQ_NAME, InfoQuery.class);
        iqRoster.setType(InfoQuery.SET);
        iqRoster.setID(this.__session.nextID("roster"));
        RosterQuery rq = (RosterQuery)sdf.createExtensionNode(RosterQuery.NAME, RosterQuery.class);
        iqRoster.add(rq);
        XMPPSessionProvider.info("Saving Roster Entry : " + entry.getEntryId());
        JID jid = new JID(entry.getEntryId());
        RosterItem item = rq.createItem(jid);
        item.setDisplayName(entry.getDisplayName());
        Collection groups = ((XMPPPersonalStoreEntry)entry).getFolders();
        Iterator i = groups.iterator();
        while (i.hasNext()) {
            String group = ((PersonalStoreFolder)i.next()).getDisplayName();
            item.addGroup(group);
        }
        rq.add(item);
        try {
            iqRoster = (InfoQuery)PacketMonitor.sendAndWatch(this.__session.getConnection(), iqRoster, XMPPSession.REQUEST_TIMEOUT);
        }
        catch (StreamException se) {
            throw new CollaborationException(se);
        }
    }

    protected void removeRosterQuery(PersonalStoreEntry entry) throws CollaborationException {
        StreamDataFactory sdf = this.__session.getDataFactory();
        InfoQuery iqRoster = (InfoQuery)sdf.createPacketNode(XMPPSession.IQ_NAME, InfoQuery.class);
        iqRoster.setType(InfoQuery.SET);
        iqRoster.setID(this.__session.nextID("roster"));
        RosterQuery rq = (RosterQuery)sdf.createExtensionNode(RosterQuery.NAME, RosterQuery.class);
        iqRoster.add(rq);
        RosterItem item = rq.createItem(new JID(entry.getEntryId()));
        item.setSubscription(RosterItem.REMOVE);
        rq.add(item);
        if (entry instanceof Watcher) {
            this._watchers.remove(entry.getEntryId());
        }
        try {
            this.__session.getConnection().send(iqRoster);
        }
        catch (StreamException se) {
            throw new CollaborationException(se);
        }
    }

    protected void setPrivateStorage(PersonalStoreEntry entry) throws CollaborationException {
        if (entry instanceof PersonalConference) {
            String entryId = entry.getEntryId();
            JID jid = JIDUtil.encodedJID(entryId);
            XMPPSessionProvider.info("Saving Conference Bookmark Storage Entry : " + entryId);
            XMPPConference c = this.__session.getConference(jid.toString());
            if (c == null) {
                c = new XMPPConference(this.__session, StringUtility.getLocalPartFromAddress(entryId), jid);
            }
            this.__session.addConference(c);
            this._subscribedConferenceItems.put(jid.toString(), entry);
            this.setConferenceBookmarkQuery();
        } else if (entry instanceof PersonalGroup) {
            XMPPSessionProvider.info("Saving LDAP Group Storage Entry : " + entry.getEntryId());
            JID jid = new JID(entry.getEntryId());
            this._personalGroups.put(entry.getEntryId(), entry);
            this.setLDAPGroupQuery();
            this._firePersonalStoreServiceListeners(new PersonalStoreEvent(1, entry));
        }
    }

    protected void removePrivateStorage(PersonalStoreEntry entry) throws CollaborationException {
        if (entry instanceof PersonalConference) {
            String encodedEntryId = JIDUtil.encodedJID(entry.getEntryId()).toString();
            XMPPSessionProvider.info("Deleting Conference Bookmark Entry : " + encodedEntryId);
            this.__session.removeConference(encodedEntryId);
            this._subscribedConferenceItems.remove(encodedEntryId);
            this.setConferenceBookmarkQuery();
        } else if (entry instanceof PersonalGroup) {
            XMPPSessionProvider.info("Deleting LDAP Group Storage Entry : " + entry.getEntryId());
            this._personalGroups.remove(entry.getEntryId());
            this.setLDAPGroupQuery();
            this._firePersonalStoreServiceListeners(new PersonalStoreEvent(4, entry));
        }
    }

    Conference[] searchConference(int searchType, String pattern) throws CollaborationException {
        pattern = StringUtility.getDomainFromAddress(pattern, null) != null ? JIDUtil.encodedJID(pattern).toString() : JIDUtil.encodedString(pattern);
        String wildcard = pattern;
        ArrayList<XMPPConference> p = new ArrayList<XMPPConference>();
        wildcard = XMPPPersonalStoreService.getWildCard(searchType, pattern);
        XMPPConferenceService cs = (XMPPConferenceService)this.__session.getConferenceService();
        DiscoItemsQuery sq = this.__session.sendItemsQuery(cs.getService(), wildcard);
        Iterator itr = sq.listItems().iterator();
        while (itr.hasNext()) {
            DiscoItem item = (DiscoItem)itr.next();
            p.add(new XMPPConference(this.__session, JIDUtil.decodedString(item.getName()), item.getJID()));
        }
        Iterator iter = cs.getRemoteServices().iterator();
        while (iter.hasNext()) {
            JID serviceJID = (JID)iter.next();
            try {
                sq = this.__session.sendItemsQuery(serviceJID, wildcard);
                Iterator itr2 = sq.listItems().iterator();
                while (itr2.hasNext()) {
                    DiscoItem item = (DiscoItem)itr2.next();
                    p.add(new XMPPConference(this.__session, JIDUtil.decodedString(item.getName()), item.getJID()));
                }
            }
            catch (CollaborationException e) {
            }
        }
        if (p.size() > 0) {
            Conference[] result = new XMPPConference[p.size()];
            for (int i = 0; i < p.size(); ++i) {
                result[i] = (XMPPConference)p.get(i);
            }
            return result;
        }
        return null;
    }

    void getRosterQuery() throws CollaborationException {
        StreamDataFactory sdf = this.__session.getDataFactory();
        InfoQuery iqRoster = (InfoQuery)sdf.createPacketNode(XMPPSession.IQ_NAME, InfoQuery.class);
        iqRoster.setType(InfoQuery.GET);
        iqRoster.setID(this.__session.nextID("roster"));
        RosterQuery rq = (RosterQuery)sdf.createExtensionNode(RosterQuery.NAME, RosterQuery.class);
        iqRoster.add(rq);
        try {
            iqRoster = (InfoQuery)PacketMonitor.sendAndWatch(this.__session.getConnection(), iqRoster, XMPPSession.REQUEST_TIMEOUT);
        }
        catch (StreamException se) {
            XMPPSessionProvider.error(se.toString(), se);
        }
        if (iqRoster == null || iqRoster.getType() != InfoQuery.RESULT) {
            throw new CollaborationException("Failed to get roster " + iqRoster);
        }
        List rqList = iqRoster.listExtensions("jabber:iq:roster");
        if (rqList.size() > 0) {
            this.processRosterQuery((RosterQuery)rqList.get(0));
        }
    }

    void sendRosterRequest() throws CollaborationException {
        StreamDataFactory sdf = this.__session.getDataFactory();
        InfoQuery iqRoster = (InfoQuery)sdf.createPacketNode(XMPPSession.IQ_NAME, InfoQuery.class);
        iqRoster.setType(InfoQuery.GET);
        iqRoster.setID(this.__session.nextID("roster"));
        RosterQuery rq = (RosterQuery)sdf.createExtensionNode(RosterQuery.NAME, RosterQuery.class);
        iqRoster.add(rq);
        try {
            this.__session._connection.send(iqRoster);
        }
        catch (StreamException se) {
            XMPPSessionProvider.error(se.toString(), se);
            throw new CollaborationException(se);
        }
    }

    void processRosterQuery(RosterQuery rosterQuery) throws CollaborationException {
        Iterator itr = rosterQuery.listElements().iterator();
        while (itr.hasNext()) {
            int eventType;
            RosterItem item = (RosterItem)itr.next();
            XMPPSessionProvider.debug("processRosterQuery called subscription: " + item.getSubscription());
            XMPPSessionProvider.debug("processRosterQuery item: " + item);
            List groups = item.listGroups();
            JID jid = item.getJID();
            String displayName = item.getDisplayName();
            if (displayName == null || displayName.trim().length() == 0) {
                displayName = jid.toString();
            }
            String uid = jid.getNode();
            String host = jid.getDomain();
            String resource = jid.getResource();
            boolean remove = false;
            if (item.getSubscription() != null && RosterItem.REMOVE.equals(item.getSubscription())) {
                remove = true;
            } else if (groups.size() == 0) {
                groups.add("");
            }
            if (uid.equals("")) {
                int eventType2;
                if (!this.isGatewayEntry(jid)) continue;
                XMPPSessionProvider.debug("Got a gateway entry " + jid);
                XMPPPersonalGateway gtw = null;
                if (this._asyncRosterProcessed) {
                    gtw = (XMPPPersonalGateway)this.getEntry("gateway", jid.toString());
                }
                if (gtw == null) {
                    gtw = new XMPPPersonalGateway(this.__session, displayName, jid.toString());
                    eventType2 = 1;
                } else {
                    eventType2 = 2;
                }
                if (remove) {
                    this.removeContactsFromFolders(gtw);
                    eventType2 = 4;
                } else {
                    gtw.setDisplayName(displayName);
                    Collection c = gtw.getFolders();
                    Iterator ltr = c.iterator();
                    while (ltr.hasNext()) {
                        XMPPPersonalFolder fol = (XMPPPersonalFolder)ltr.next();
                        fol.removeEntry(gtw);
                    }
                    gtw.clearFolders();
                    this.addContactsToFolders(gtw, groups);
                }
                if (!this._asyncRosterProcessed) continue;
                this._firePersonalStoreServiceListeners(new PersonalStoreEvent(eventType2, gtw));
                continue;
            }
            XMPPPersonalContact entry = null;
            XMPPPresenceService ps = (XMPPPresenceService)this.__session.getPresenceService();
            if (this._asyncRosterProcessed) {
                entry = (XMPPPersonalContact)this.getEntry("contact", jid.toString());
            }
            if (entry == null) {
                entry = new XMPPPersonalContact(this.__session, displayName, jid.toString());
                eventType = 1;
            } else {
                eventType = 2;
            }
            if (remove) {
                this.removeContactsFromFolders(entry);
                ps.removeSubscriptions(jid);
                eventType = 4;
            } else {
                RosterItem.SubscriptionType subsType = item.getSubscription();
                if (subsType.isSubscribedFrom()) {
                    entry.setOutboundSubscriptionStatus(1);
                } else {
                    entry.setOutboundSubscriptionStatus(0);
                }
                if (subsType.isSubscribedTo()) {
                    entry.setInboundSubscriptionStatus(1);
                } else {
                    entry.setInboundSubscriptionStatus(0);
                }
                entry.setDisplayName(displayName);
                Collection c = entry.getFolders();
                Iterator ltr = c.iterator();
                while (ltr.hasNext()) {
                    XMPPPersonalFolder fol = (XMPPPersonalFolder)ltr.next();
                    fol.removeEntry(entry);
                }
                entry.clearFolders();
                this.addContactsToFolders(entry, groups);
                if (item.isAskSubscribe()) {
                    entry.setInboundSubscriptionStatus(2);
                    Presence p = ps.createPresence(jid.toString(), "PENDING", "", 0.0f);
                    ps.addSubscriptions(jid, p);
                }
            }
            if (!this._asyncRosterProcessed) continue;
            this._firePersonalStoreServiceListeners(new PersonalStoreEvent(eventType, entry));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    void processAsyncRosterQuery(RosterQuery rosterQuery) {
        XMPPPersonalStoreService xMPPPersonalStoreService;
        try {
            try {
                this.processRosterQuery(rosterQuery);
            }
            catch (Exception e) {
                this._asyncRosterException = e;
                Object var4_3 = null;
                XMPPPersonalStoreService xMPPPersonalStoreService3 = this;
                synchronized (xMPPPersonalStoreService3) {
                    this._asyncRosterProcessed = true;
                    this.notifyAll();
                    return;
                }
            }
            Object var4_2 = null;
            xMPPPersonalStoreService = this;
        }
        catch (Throwable throwable) {
            Object var4_4 = null;
            XMPPPersonalStoreService xMPPPersonalStoreService2 = this;
            synchronized (xMPPPersonalStoreService2) {
                this._asyncRosterProcessed = true;
                this.notifyAll();
                throw throwable;
            }
        }
        synchronized (xMPPPersonalStoreService) {
            this._asyncRosterProcessed = true;
            this.notifyAll();
            return;
        }
    }

    void sendBookmarkRequest() throws CollaborationException {
        StreamDataFactory sdf = this.__session.getDataFactory();
        InfoQuery iqPrivate = (InfoQuery)sdf.createPacketNode(XMPPSession.IQ_NAME, InfoQuery.class);
        iqPrivate.setType(InfoQuery.GET);
        iqPrivate.setID(this.__session.nextID("private"));
        StreamElement pq = sdf.createElementNode(new NSI("query", "jabber:iq:private"), null);
        Extension n = sdf.createExtensionNode(XMPPSession.STORAGE_BOOKMARK_NAME);
        pq.add(n);
        iqPrivate.add(pq);
        try {
            this.__session._connection.send(iqPrivate);
        }
        catch (StreamException se) {
            XMPPSessionProvider.error(se.toString(), se);
            throw new CollaborationException(se);
        }
    }

    void processBookmarkQuery(StreamElement bookmarks) throws CollaborationException {
        List confs = bookmarks.listElements("conference");
        Iterator i = confs.iterator();
        while (i.hasNext()) {
            StreamElement conf = (StreamElement)i.next();
            String name = conf.getAttributeValue("name");
            String jid = conf.getAttributeValue("jid");
            String nick = null;
            StreamElement nickElem = conf.getFirstElement("nick");
            if (nickElem != null) {
                nick = nickElem.normalizeTrimText();
            }
            XMPPPersonalConference entry = new XMPPPersonalConference(this.__session, name, jid);
            XMPPConference c = this.__session.getConference(jid);
            if (c == null) {
                c = new XMPPConference(this.__session, name, new JID(jid));
            }
            this._subscribedConferenceItems.put(jid, entry);
            this.__session.addConference(c);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    void processAsyncBookmarkQuery(StreamElement bookmarks) {
        Object object;
        try {
            try {
                this.processBookmarkQuery(bookmarks);
            }
            catch (Exception e) {
                this._asyncBookmarkException = e;
                Object var4_3 = null;
                Object object3 = this._bookmarkLock;
                synchronized (object3) {
                    this._asyncBookmarkProcessed = true;
                    this._bookmarkLock.notifyAll();
                    return;
                }
            }
            Object var4_2 = null;
            object = this._bookmarkLock;
        }
        catch (Throwable throwable) {
            Object var4_4 = null;
            Object object2 = this._bookmarkLock;
            synchronized (object2) {
                this._asyncBookmarkProcessed = true;
                this._bookmarkLock.notifyAll();
                throw throwable;
            }
        }
        synchronized (object) {
            this._asyncBookmarkProcessed = true;
            this._bookmarkLock.notifyAll();
            return;
        }
    }

    void sendLDAPGroupRequest() throws CollaborationException {
        StreamDataFactory sdf = this.__session.getDataFactory();
        InfoQuery iqPrivate = (InfoQuery)sdf.createPacketNode(XMPPSession.IQ_NAME, InfoQuery.class);
        iqPrivate.setType(InfoQuery.GET);
        iqPrivate.setID(this.__session.nextID("private"));
        StreamElement pq = sdf.createElementNode(new NSI("query", "jabber:iq:private"), null);
        Extension n = sdf.createExtensionNode(XMPPSession.SUN_PRIVATE_LDAPGROUP_NAME);
        pq.add(n);
        iqPrivate.add(pq);
        try {
            this.__session._connection.send(iqPrivate);
        }
        catch (StreamException se) {
            XMPPSessionProvider.error(se.toString(), se);
            throw new CollaborationException(se);
        }
    }

    void processLDAPGroupQuery(StreamElement ldapGroups) throws CollaborationException {
        List groups = ldapGroups.listElements("ldapgroup");
        Iterator i = groups.iterator();
        while (i.hasNext()) {
            StreamElement group = (StreamElement)i.next();
            String name = group.getAttributeValue("name");
            String jid = group.getAttributeValue("jid");
            XMPPPersonalGroup contact = new XMPPPersonalGroup(this.__session, name, jid);
            List g = group.listElements("group");
            Iterator itr = g.iterator();
            while (itr.hasNext()) {
                StreamElement elem = (StreamElement)itr.next();
                String folderName = elem.normalizeTrimText();
                XMPPPersonalFolder folder = null;
                if (!this._folders.containsKey(folderName)) {
                    folder = new XMPPPersonalFolder(this.__session, folderName);
                    this._folders.put(folderName, folder);
                } else {
                    folder = (XMPPPersonalFolder)this._folders.get(folderName);
                }
                contact.addToFolder(folder);
            }
            this._personalGroups.put(jid, contact);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    void processAsyncLDAPGroupQuery(StreamElement bookmarks) {
        XMPPPersonalStoreService xMPPPersonalStoreService;
        try {
            try {
                this.processLDAPGroupQuery(bookmarks);
            }
            catch (Exception e) {
                this._asyncLDAPGroupException = e;
                Object var4_3 = null;
                XMPPPersonalStoreService xMPPPersonalStoreService3 = this;
                synchronized (xMPPPersonalStoreService3) {
                    this._asyncLDAPGroupProcessed = true;
                    this.notifyAll();
                    return;
                }
            }
            Object var4_2 = null;
            xMPPPersonalStoreService = this;
        }
        catch (Throwable throwable) {
            Object var4_4 = null;
            XMPPPersonalStoreService xMPPPersonalStoreService2 = this;
            synchronized (xMPPPersonalStoreService2) {
                this._asyncLDAPGroupProcessed = true;
                this.notifyAll();
                throw throwable;
            }
        }
        synchronized (xMPPPersonalStoreService) {
            this._asyncLDAPGroupProcessed = true;
            this.notifyAll();
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void setService(JID jid) {
        this._pstoreService = jid;
        XMPPPersonalStoreService xMPPPersonalStoreService = this;
        synchronized (xMPPPersonalStoreService) {
            this.notifyAll();
        }
    }

    public boolean isServiceInitialized() {
        return this._pstoreService != null;
    }

    JID getService() throws CollaborationException {
        if (this._pstoreService == null) {
            this.__session.waitForServiceInitialization(this);
        }
        if (this._pstoreService == null) {
            throw new ServiceUnavailableException("personal store service was not initialized successfully");
        }
        return this._pstoreService;
    }

    JID getService(String domain) throws CollaborationException {
        if (domain == null || this.__session.getCurrentUserJID().getDomain().equalsIgnoreCase(domain)) {
            return this.getService();
        }
        if (domain != null && domain.trim().length() > 0) {
            domain = domain.toLowerCase();
            Iterator iter = this._remoteServices.iterator();
            while (iter.hasNext()) {
                JID rsjid = (JID)iter.next();
                if (rsjid.getDomain().toLowerCase().indexOf(domain) < 0) continue;
                return rsjid;
            }
        }
        return null;
    }

    void addRemoteService(JID jid) {
        this._remoteServices.add(jid);
    }

    Set getRemoteServices() {
        return this._remoteServices;
    }

    void addGatewayEntries(String jid, PersonalStoreEntry pse) throws CollaborationException {
        this._gateWays.put(jid, pse);
    }

    PersonalGateway getGatewayEntry(String jid) throws CollaborationException {
        return (PersonalGateway)this._gateWays.get(jid);
    }

    void saveProfile() throws CollaborationException {
        this.setPrivateQuery(this._personalProfile);
    }

    void saveProfile(XMPPPersonalProfile pp) throws CollaborationException {
        this.setPrivateQuery(pp);
    }

    private String getEntryType(JID jid) {
        try {
            this.__session.loadJabberServices();
            JID judJID = this.getService(jid.getDomain());
            if (judJID == null) {
                return null;
            }
            DiscoInfoQuery dq = this.__session.sendInfoQuery(judJID, jid.toString());
            Iterator iter = dq.listIdentities().iterator();
            while (iter.hasNext()) {
                DiscoIdentity discoIdentity = (DiscoIdentity)iter.next();
                String type = discoIdentity.getType();
                if ("contact".equals(type)) {
                    return "contact";
                }
                if (!"group".equals(type)) continue;
                return "group";
            }
        }
        catch (Exception e) {
            return null;
        }
        return null;
    }

    private void checkAsyncRequest() throws CollaborationException {
        if (this._asyncRosterProcessed && this._asyncLDAPGroupProcessed) {
            if (this._asyncRosterException == null && this._asyncLDAPGroupException == null) {
                return;
            }
            throw new CollaborationException(this._asyncRosterException);
        }
        XMPPPersonalStoreService xMPPPersonalStoreService = this;
        synchronized (xMPPPersonalStoreService) {
            int waitTime = 5000;
            while (!this._asyncRosterProcessed || !this._asyncLDAPGroupProcessed) {
                long start = System.currentTimeMillis();
                try {
                    this.wait(waitTime);
                }
                catch (InterruptedException e) {
                    throw new CollaborationException("Wait for RosterQuery and LDAPGroup retreival interrupted");
                }
                if (this._asyncRosterProcessed && this._asyncLDAPGroupProcessed) continue;
                int slept = (int)(System.currentTimeMillis() - start);
                if (slept >= waitTime) {
                    throw new CollaborationException("Wait for RosterQuery and LDAPGroup retreival timed out");
                }
                waitTime -= slept;
            }
            if (this._asyncRosterException == null && this._asyncLDAPGroupException == null) {
                return;
            }
            throw new CollaborationException(this._asyncRosterException);
        }
    }

    private void checkAsyncBookmarkRequest() throws CollaborationException {
        if (this._asyncBookmarkProcessed) {
            if (this._asyncBookmarkException == null) {
                return;
            }
            throw new CollaborationException(this._asyncBookmarkException);
        }
        Object object = this._bookmarkLock;
        synchronized (object) {
            int waitTime = 5000;
            while (!this._asyncBookmarkProcessed) {
                long start = System.currentTimeMillis();
                try {
                    this._bookmarkLock.wait(waitTime);
                }
                catch (InterruptedException e) {
                    throw new CollaborationException("Wait for BookmarkQuery retreival interrupted");
                }
                if (this._asyncBookmarkProcessed) continue;
                int slept = (int)(System.currentTimeMillis() - start);
                if (slept >= waitTime) {
                    throw new CollaborationException("Wait for BookmarkQuery retreival timed out");
                }
                waitTime -= slept;
            }
            if (this._asyncBookmarkException == null) {
                return;
            }
            throw new CollaborationException(this._asyncBookmarkException);
        }
    }

    private Map _getFolders() throws CollaborationException {
        this.checkAsyncRequest();
        return this._folders;
    }

    private Map _getSubscribedConferenceItems() throws CollaborationException {
        this.checkAsyncBookmarkRequest();
        return this._subscribedConferenceItems;
    }

    private Properties getUserAttributes(String uid) {
        try {
            String localUid = StringUtility.getLocalPartFromAddress(uid);
            CollaborationPrincipal[] searchResults = this.searchPrincipals(0, localUid);
            if (searchResults == null) {
                return null;
            }
            boolean found = false;
            CollaborationPrincipal cp = null;
            for (int i = 0; i < searchResults.length; ++i) {
                cp = searchResults[i];
                if (!cp.getUID().equalsIgnoreCase(uid)) continue;
                found = true;
                break;
            }
            if (found) {
                return ((XMPPPrincipal)cp).getAttributes();
            }
        }
        catch (CollaborationException e) {
            XMPPSessionProvider.error(e.toString(), e);
        }
        return null;
    }

    private XMPPPersonalProfile getPrivateQuery(JID jid) throws CollaborationException {
        boolean forOther = false;
        Properties privateSettings = this.sendPrivateGetQuery(jid, XMPPSession.SUN_PRIVATE_SUNMSGR_NAME);
        Properties ISServicePolicyAttrs = null;
        if (jid == null) {
            ISServicePolicyAttrs = this.sendPrivateGetQuery(jid, XMPPSession.SUN_PRIVATE_POLICY_NAME);
        }
        String displayName = null;
        if (jid == null) {
            XMPPPrincipal client = (XMPPPrincipal)this.__session.getPrincipal();
            Properties a = this.getUserAttributes(client.getUID());
            if (a != null) {
                displayName = a.getProperty("cn");
            }
            this._personalProfile = new XMPPPersonalProfile(this.__session, client.getUID(), displayName, privateSettings, a, ISServicePolicyAttrs);
            return this._personalProfile;
        }
        Properties a = this.getUserAttributes(jid.toBareJID().toString());
        if (a != null) {
            displayName = a.getProperty("cn");
        }
        XMPPPersonalProfile xp = new XMPPPersonalProfile(this.__session, jid.toString(), displayName, privateSettings, a, ISServicePolicyAttrs);
        return xp;
    }

    private Properties sendPrivateGetQuery(JID jid, NSI privateExt) throws CollaborationException {
        StreamDataFactory sdf = this.__session.getDataFactory();
        InfoQuery iqPrivate = (InfoQuery)sdf.createPacketNode(XMPPSession.IQ_NAME, InfoQuery.class);
        iqPrivate.setType(InfoQuery.GET);
        iqPrivate.setID(this.__session.nextID("private"));
        if (jid != null) {
            iqPrivate.setFrom(jid);
        }
        StreamElement pq = sdf.createElementNode(new NSI("query", "jabber:iq:private"), null);
        Extension n = sdf.createExtensionNode(privateExt);
        pq.add(n);
        iqPrivate.add(pq);
        try {
            iqPrivate = (InfoQuery)PacketMonitor.sendAndWatch(this.__session.getConnection(), iqPrivate, XMPPSession.REQUEST_TIMEOUT);
        }
        catch (StreamException se) {
            throw new CollaborationException(se);
        }
        if (iqPrivate == null || iqPrivate.getType() != InfoQuery.RESULT) {
            throw new CollaborationException("Could not get private data from server!");
        }
        Properties p = new Properties();
        List privateNodes = iqPrivate.listElements("query");
        pq = (StreamElement)privateNodes.get(0);
        StreamElement properties = (StreamElement)pq.listElements().get(0);
        Iterator i = properties.listElements().iterator();
        while (i.hasNext()) {
            StreamElement e = (StreamElement)i.next();
            String propName = e.getAttributeValue("name");
            String val = null;
            List valueList = e.listElements();
            if (valueList.size() == 0) {
                val = "";
                p.put(propName, val);
                continue;
            }
            if (valueList.size() == 1) {
                val = ((StreamElement)valueList.get(0)).normalizeTrimText();
                p.put(propName, val);
                continue;
            }
            HashSet<String> valueSet = new HashSet<String>();
            Iterator j = valueList.iterator();
            while (j.hasNext()) {
                val = ((StreamElement)j.next()).normalizeTrimText();
                valueSet.add(val);
            }
            p.put(propName, valueSet);
        }
        return p;
    }

    private void setPrivateQuery(XMPPPersonalProfile p) throws CollaborationException {
        StreamDataFactory sdf = this.__session.getDataFactory();
        InfoQuery iqPrivate = (InfoQuery)sdf.createPacketNode(XMPPSession.IQ_NAME, InfoQuery.class);
        iqPrivate.setType(InfoQuery.SET);
        iqPrivate.setID(this.__session.nextID("private"));
        StreamElement pq = sdf.createElementNode(new NSI("query", "jabber:iq:private"), null);
        Extension n = sdf.createExtensionNode(XMPPSession.SUN_PRIVATE_SUNMSGR_NAME);
        Map m = p.getProperties(false);
        if (m instanceof Hashtable) {
            m = (Map)((Hashtable)m).clone();
        } else if (m instanceof HashMap) {
            m = (Map)((HashMap)m).clone();
        }
        Set propNames = m.keySet();
        Iterator i = propNames.iterator();
        while (i.hasNext()) {
            String prop = (String)i.next();
            String val = p.getProperty(prop, "");
            StreamElement e = sdf.createElementNode(new NSI("property", null), null);
            e.setAttributeValue("name", prop);
            e.addElement("value").addText(val);
            n.add(e);
        }
        pq.add(n);
        iqPrivate.add(pq);
        try {
            iqPrivate = (InfoQuery)PacketMonitor.sendAndWatch(this.__session.getConnection(), iqPrivate, XMPPSession.REQUEST_TIMEOUT);
        }
        catch (StreamException se) {
            throw new CollaborationException(se);
        }
        if (iqPrivate == null || iqPrivate.getType() != InfoQuery.RESULT) {
            throw new CollaborationException("Could not set the private data to the server!");
        }
    }

    private void setConferenceBookmarkQuery() throws CollaborationException {
        StreamDataFactory sdf = this.__session.getDataFactory();
        InfoQuery iqPrivate = (InfoQuery)sdf.createPacketNode(XMPPSession.IQ_NAME, InfoQuery.class);
        iqPrivate.setType(InfoQuery.SET);
        iqPrivate.setID(this.__session.nextID("private"));
        StreamElement pq = sdf.createElementNode(new NSI("query", "jabber:iq:private"), null);
        Extension n = sdf.createExtensionNode(XMPPSession.STORAGE_BOOKMARK_NAME);
        Collection confs = this._subscribedConferenceItems.values();
        Iterator i = confs.iterator();
        while (i.hasNext()) {
            PersonalStoreEntry entry = (PersonalStoreEntry)i.next();
            String entryId = entry.getEntryId();
            JID encodedJID = JIDUtil.encodedJID(entryId);
            XMPPConference c = this.__session.getConference(encodedJID.toString());
            if (c == null) {
                c = new XMPPConference(this.__session, StringUtility.getLocalPartFromAddress(entryId), encodedJID);
            }
            StreamElement e = sdf.createElementNode(new NSI("conference", null), null);
            String name = c.getName() == null ? c.getNode().toString() : c.getName();
            e.setAttributeValue("name", name);
            e.setAttributeValue("jid", c.getNode().toString());
            XMPPPrincipal client = (XMPPPrincipal)this.__session.getPrincipal();
            e.addElement("nick").addText(client.getName());
            n.add(e);
        }
        pq.add(n);
        iqPrivate.add(pq);
        try {
            iqPrivate = (InfoQuery)PacketMonitor.sendAndWatch(this.__session.getConnection(), iqPrivate, XMPPSession.REQUEST_TIMEOUT);
        }
        catch (StreamException se) {
            throw new CollaborationException(se);
        }
        if (iqPrivate == null || iqPrivate.getType() != InfoQuery.RESULT) {
            throw new CollaborationException("Could not save conference subscription to the server!");
        }
    }

    private void setLDAPGroupQuery() throws CollaborationException {
        StreamDataFactory sdf = this.__session.getDataFactory();
        InfoQuery iqPrivate = (InfoQuery)sdf.createPacketNode(XMPPSession.IQ_NAME, InfoQuery.class);
        iqPrivate.setType(InfoQuery.SET);
        iqPrivate.setID(this.__session.nextID("private"));
        StreamElement pq = sdf.createElementNode(new NSI("query", "jabber:iq:private"), null);
        Extension n = sdf.createExtensionNode(XMPPSession.SUN_PRIVATE_LDAPGROUP_NAME);
        Collection ldapGroups = this._personalGroups.values();
        Iterator i = ldapGroups.iterator();
        while (i.hasNext()) {
            PersonalStoreEntry entry = (PersonalStoreEntry)i.next();
            StreamElement e = sdf.createElementNode(new NSI("ldapgroup", null), null);
            e.setAttributeValue("name", entry.getDisplayName());
            e.setAttributeValue("jid", entry.getEntryId());
            Collection groups = ((XMPPPersonalStoreEntry)entry).getFolders();
            Iterator itr = groups.iterator();
            while (itr.hasNext()) {
                String group = ((PersonalStoreFolder)itr.next()).getDisplayName();
                e.addElement("group").addText(group);
            }
            n.add(e);
        }
        pq.add(n);
        iqPrivate.add(pq);
        try {
            iqPrivate = (InfoQuery)PacketMonitor.sendAndWatch(this.__session.getConnection(), iqPrivate, XMPPSession.REQUEST_TIMEOUT);
        }
        catch (StreamException se) {
            throw new CollaborationException(se);
        }
        if (iqPrivate == null || iqPrivate.getType() != InfoQuery.RESULT) {
            throw new CollaborationException("Could not set ldap group to the server!");
        }
    }

    private void addContactsToFolders(PersonalStoreEntry contact, List groups) throws CollaborationException {
        Iterator i = groups.iterator();
        while (i.hasNext()) {
            String folderName = (String)i.next();
            XMPPPersonalFolder folder = null;
            if (!this._folders.containsKey(folderName)) {
                folder = new XMPPPersonalFolder(this.__session, folderName);
                this._folders.put(folderName, folder);
            } else {
                folder = (XMPPPersonalFolder)this._folders.get(folderName);
            }
            contact.addToFolder(folder);
        }
    }

    private void removeContactsFromFolders(PersonalStoreEntry contact) throws CollaborationException {
        if (this._folders != null && !this._folders.isEmpty()) {
            Iterator i = this._folders.values().iterator();
            while (i.hasNext()) {
                XMPPPersonalFolder folder = (XMPPPersonalFolder)i.next();
                contact.removeFromFolder(folder);
            }
        }
    }

    private static String getWildCard(int searchType, String pattern) {
        String wildcard = pattern;
        switch (searchType) {
            case 0: {
                wildcard = pattern;
                break;
            }
            case 1: {
                wildcard = "*" + pattern + "*";
                break;
            }
            case 3: {
                wildcard = "*" + pattern;
                break;
            }
            case 2: {
                wildcard = pattern + "*";
            }
        }
        return wildcard;
    }

    private PersonalStoreEntry[] searchGateways(int searchType, String pattern) throws CollaborationException {
        this.__session.loadJabberServices();
        if (searchType == 0) {
            PersonalStoreEntry gw = (PersonalStoreEntry)this._gateWays.get(pattern);
            if (gw == null) {
                return null;
            }
            return new PersonalStoreEntry[]{gw};
        }
        PersonalStoreEntry[] pse = new PersonalStoreEntry[this._gateWays.size()];
        int i = 0;
        Iterator iter = this._gateWays.values().iterator();
        while (iter.hasNext()) {
            pse[i++] = (PersonalStoreEntry)iter.next();
        }
        return pse;
    }

    boolean isGatewayEntry(JID jid) throws CollaborationException {
        this.__session.loadJabberServices();
        return this._gateWays.get(jid.toString()) != null;
    }

    protected void renameFolder(XMPPPersonalFolder folder, String newName) {
        String oldName = folder.getDisplayName();
        if (oldName.length() <= 0) {
            return;
        }
        if (this._folders.containsKey(newName)) {
            return;
        }
        folder.setDisplayName(newName);
        this._folders.put(newName, folder);
        this._folders.remove(oldName);
    }

    private void _firePersonalStoreServiceListeners(PersonalStoreEvent event) {
        this.__session.addWorkerRunnable(new PersonalStoreServiceNotifier(event));
    }

    public void addPersonalStoreServiceListener(PersonalStoreServiceListener listener) {
        if (!this._personalStoreServiceListeners.contains(listener)) {
            this._personalStoreServiceListeners.add(listener);
        }
    }

    public void removePersonalStoreServiceListener(PersonalStoreServiceListener listener) {
        this._personalStoreServiceListeners.remove(listener);
    }

    private class PersonalStoreServiceNotifier
    implements Runnable {
        PersonalStoreEvent event;

        PersonalStoreServiceNotifier(PersonalStoreEvent e) {
            this.event = e;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            List list = XMPPPersonalStoreService.this._personalStoreServiceListeners;
            synchronized (list) {
                Iterator itr = XMPPPersonalStoreService.this._personalStoreServiceListeners.iterator();
                while (itr.hasNext()) {
                    try {
                        PersonalStoreServiceListener l = (PersonalStoreServiceListener)itr.next();
                        if (l == null) continue;
                        l.onEvent(this.event);
                    }
                    catch (Exception e) {
                        XMPPSessionProvider.error(e.toString(), e);
                    }
                }
            }
        }
    }
}

