/*
 * Decompiled with CFR 0.152.
 */
package com.sun.im.service.xmpp;

import com.sun.im.service.CollaborationException;
import com.sun.im.service.jso.x.pubsub.PubSubQueryNode;
import com.sun.im.service.xmpp.JIDUtil;
import com.sun.im.service.xmpp.XMPPMessage;
import com.sun.im.service.xmpp.XMPPNewsService;
import com.sun.im.service.xmpp.XMPPNewsSession;
import com.sun.im.service.xmpp.XMPPSession;
import java.util.List;
import org.jabberstudio.jso.InfoQuery;
import org.jabberstudio.jso.JID;
import org.jabberstudio.jso.Message;
import org.jabberstudio.jso.Packet;
import org.jabberstudio.jso.StreamDataFactory;
import org.jabberstudio.jso.StreamElement;
import org.jabberstudio.jso.x.pubsub.PubSubElement;
import org.jabberstudio.jso.x.pubsub.PubSubEvent;
import org.jabberstudio.jso.x.pubsub.PubSubItems;
import org.jabberstudio.jso.x.pubsub.PubSubQuery;

public class XMPPNewsMessage
extends XMPPMessage {
    public XMPPNewsMessage() {
    }

    public XMPPNewsMessage(XMPPSession s, String node, JID originator) throws CollaborationException {
        this._session = s;
        this._sdf = s.getDataFactory();
        XMPPNewsService newsService = (XMPPNewsService)s.getNewsService();
        InfoQuery iq = (InfoQuery)this._sdf.createPacketNode(XMPPSession.IQ_NAME, InfoQuery.class);
        iq.setID(s.nextID("http://jabber.org/protocol/pubsub"));
        iq.setType(InfoQuery.SET);
        iq.setTo(newsService.getService());
        PubSubQuery pubsubquery = (PubSubQuery)this._sdf.createExtensionNode(PubSubQuery.NAME, PubSubQueryNode.class);
        PubSubElement publishElement = pubsubquery.createPublishElement(XMPPNewsSession.encode(node, newsService.getService().toString()));
        pubsubquery.add(publishElement);
        iq.addExtension(pubsubquery);
        this._xmppMessage = iq;
        this.setOriginator(originator.toString());
    }

    public XMPPNewsMessage(XMPPSession s, String node, JID recipient, JID originator) throws CollaborationException {
        this(s, node, originator);
        this.addRecipient(recipient.toString());
    }

    public XMPPNewsMessage(XMPPSession s, Packet message) throws CollaborationException {
        super(s, message);
    }

    public XMPPNewsMessage(StreamDataFactory sdf, InfoQuery iq) throws CollaborationException {
        this._sdf = sdf;
        this._xmppMessage = iq;
    }

    public String getMessageId() {
        String messageId = null;
        if (this._xmppMessage instanceof Message) {
            PubSubEvent event = (PubSubEvent)this._xmppMessage.getExtension("http://jabber.org/protocol/pubsub#event");
            PubSubItems items = event.getPubSubItemsElement();
            StreamElement item = null;
            item = items.hasPubSubRetractItem() ? items.getPubSubRetractItem() : (StreamElement)items.listPubSubItems().get(0);
            messageId = item.getID();
        } else {
            PubSubQuery query = (PubSubQuery)this._xmppMessage.getExtension("http://jabber.org/protocol/pubsub");
            if (query != null) {
                PubSubElement publishElem = query.getPublishElement();
                PubSubQueryNode.PubSubItemElement item = (PubSubQueryNode.PubSubItemElement)publishElem.getFirstElement(PubSubQueryNode.PubSubItemElement.NAME, PubSubQueryNode.PubSubItemElement.class);
                messageId = item.getID();
            }
        }
        return messageId;
    }

    public void setContent(String content) {
        List l = this._xmppMessage.listElements(PubSubQuery.NAME, PubSubQuery.class);
        if (l.iterator().hasNext()) {
            StreamElement elem = (StreamElement)l.iterator().next();
            l = elem.listElements(PubSubQueryNode.PubSubPublishElement.NAME, PubSubQueryNode.PubSubPublishElement.class);
        }
        PubSubQueryNode.PubSubPublishElement publishElem = null;
        if (l.iterator().hasNext()) {
            publishElem = (PubSubQueryNode.PubSubPublishElement)l.iterator().next();
        }
        publishElem.addPubSubItem(PubSubQuery.NAME.getLocalName() + "-" + XMPPNewsMessage.getUniqueMessageID(), content);
    }

    public String getContent() {
        if (this._xmppMessage instanceof Message) {
            PubSubEvent event = (PubSubEvent)this._xmppMessage.getExtension("http://jabber.org/protocol/pubsub#event");
            PubSubItems items = event.getPubSubItemsElement();
            StreamElement item = (StreamElement)items.listPubSubItems().get(0);
            return item.normalizeTrimText();
        }
        PubSubQuery query = (PubSubQuery)this._xmppMessage.getExtension("http://jabber.org/protocol/pubsub");
        if (query != null) {
            PubSubElement publishElem = query.getPublishElement();
            PubSubQueryNode.PubSubItemElement item = (PubSubQueryNode.PubSubItemElement)publishElem.getFirstElement(PubSubQueryNode.PubSubItemElement.NAME, PubSubQueryNode.PubSubItemElement.class);
            return item.getContent();
        }
        return null;
    }

    public void setContentType(String type) {
    }

    public String getContentType() {
        return null;
    }

    public String getOriginator() {
        return JIDUtil.decodedJID(this._xmppMessage.getFrom());
    }

    public String toString() {
        return this._xmppMessage.toString();
    }
}

