/*
 * Decompiled with CFR 0.152.
 */
package com.sun.im.service.xmpp;

import com.sun.im.service.CollaborationException;
import com.sun.im.service.ConflictException;
import com.sun.im.service.Message;
import com.sun.im.service.NewsChannel;
import com.sun.im.service.NewsChannelListener;
import com.sun.im.service.ServiceUnavailableException;
import com.sun.im.service.TimeoutException;
import com.sun.im.service.jso.x.pubsub.PubSubQueryNode;
import com.sun.im.service.util.StringUtility;
import com.sun.im.service.xmpp.JIDUtil;
import com.sun.im.service.xmpp.XMPPConference;
import com.sun.im.service.xmpp.XMPPMessage;
import com.sun.im.service.xmpp.XMPPNewsMessage;
import com.sun.im.service.xmpp.XMPPNewsService;
import com.sun.im.service.xmpp.XMPPNewsSession;
import com.sun.im.service.xmpp.XMPPPrincipal;
import com.sun.im.service.xmpp.XMPPSession;
import com.sun.im.service.xmpp.XMPPSessionProvider;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.jabberstudio.jso.InfoQuery;
import org.jabberstudio.jso.JID;
import org.jabberstudio.jso.NSI;
import org.jabberstudio.jso.PacketError;
import org.jabberstudio.jso.Stream;
import org.jabberstudio.jso.StreamDataFactory;
import org.jabberstudio.jso.StreamElement;
import org.jabberstudio.jso.StreamException;
import org.jabberstudio.jso.util.PacketMonitor;
import org.jabberstudio.jso.x.pubsub.EntityContainer;
import org.jabberstudio.jso.x.pubsub.PubSubElement;
import org.jabberstudio.jso.x.pubsub.PubSubEntityElement;
import org.jabberstudio.jso.x.pubsub.PubSubQuery;
import org.jabberstudio.jso.x.xdata.XDataField;
import org.jabberstudio.jso.x.xdata.XDataForm;

public class XMPPNewsChannel
extends XMPPConference
implements NewsChannel {
    private NewsChannelListener _listener;
    private XMPPNewsService _newsService;

    public XMPPNewsChannel() {
    }

    public XMPPNewsChannel(XMPPSession s, String node) throws CollaborationException {
        super(s);
        this.init(s, node, null);
    }

    public XMPPNewsChannel(XMPPSession s, String destination, NewsChannelListener listener) throws CollaborationException {
        super(s);
        this.init(s, destination, listener);
        if (listener != null) {
            this.subscribe(listener);
        }
    }

    public XMPPNewsChannel(XMPPSession s, String destination, NewsChannelListener listener, int defaultAccess) throws CollaborationException {
        super(s);
        XMPPSessionProvider.debug("Creating the new newschannel ");
        this.init(s, destination, listener);
        this.createNewChannel(s, destination);
        this.setDefaultPrivilege(defaultAccess);
        this.subscribe(listener);
    }

    private void init(XMPPSession s, String destination, NewsChannelListener listener) throws CollaborationException {
        this._listener = listener;
        this._newsService = (XMPPNewsService)s.getNewsService();
        String fqDest = null;
        destination = fqDest = StringUtility.appendDomainToAddress(destination, this._newsService.getService().toString());
        this._node = JIDUtil.encodedJID(destination);
    }

    private void createNewChannel(XMPPSession s, String destination) throws CollaborationException {
        PacketError error;
        StreamDataFactory sdf = this._session.getDataFactory();
        Stream connection = this._session.getConnection();
        InfoQuery iq = (InfoQuery)sdf.createPacketNode(XMPPSession.IQ_NAME, InfoQuery.class);
        PubSubQuery pubsubquery = (PubSubQuery)sdf.createExtensionNode(PubSubQuery.NAME, PubSubQuery.class);
        PubSubElement createElem = pubsubquery.createCreateElement(JIDUtil.encodedString(destination));
        pubsubquery.add(createElem);
        iq.addExtension(pubsubquery);
        iq.setType(InfoQuery.SET);
        iq.setTo(this._newsService.getService());
        iq.setFrom(((XMPPPrincipal)this._session.getPrincipal()).getJID());
        iq.setID(this._session.nextID("pubsub"));
        try {
            iq = (InfoQuery)PacketMonitor.sendAndWatch(connection, iq, XMPPSession.SHORT_REQUEST_TIMEOUT);
        }
        catch (StreamException se) {
            throw new CollaborationException(se.toString());
        }
        if (iq == null) {
            throw new TimeoutException("Request timed out");
        }
        if (iq.getType() == InfoQuery.RESULT) {
            return;
        }
        if (iq.getType() == InfoQuery.ERROR && (error = iq.getError()) != null) {
            String errorCond = error.getDefinedCondition();
            if ("feature-not-implemented".equals(errorCond) || "service-unavailable".equals(errorCond)) {
                throw new ServiceUnavailableException(error.getText());
            }
            if ("conflict".equals(errorCond)) {
                throw new ConflictException(error.getText());
            }
            if ("registration-required".equals(errorCond)) {
                throw new CollaborationException(error.getText());
            }
            throw new CollaborationException(error.getText());
        }
    }

    public Message createMessage() {
        try {
            return new XMPPNewsMessage(this._session, this._node.toString(), ((XMPPPrincipal)this._session.getPrincipal()).getJID());
        }
        catch (CollaborationException ce) {
            return null;
        }
    }

    public void addMessage(Message message) throws CollaborationException {
        PacketError error;
        InfoQuery iq = (InfoQuery)((XMPPMessage)message).getXMPPMessage();
        Stream connection = this._session.getConnection();
        try {
            iq = (InfoQuery)PacketMonitor.sendAndWatch(connection, iq, XMPPSession.REQUEST_TIMEOUT);
        }
        catch (StreamException se) {
            throw new CollaborationException(se.getMessage());
        }
        if (iq == null) {
            throw new TimeoutException("Request timed out");
        }
        if (iq.getType() == InfoQuery.RESULT) {
            return;
        }
        if (iq.getType() == InfoQuery.ERROR && (error = iq.getError()) != null) {
            String errorCond = error.getDefinedCondition();
            if ("feature-not-implemented".equals(errorCond) || "service-unavailable".equals(errorCond)) {
                throw new ServiceUnavailableException(error.getText());
            }
            if ("conflict".equals(errorCond)) {
                throw new ConflictException(error.getText());
            }
            if ("registration-required".equals(errorCond)) {
                throw new CollaborationException(error.getText());
            }
            throw new CollaborationException(error.getText());
        }
    }

    public void modifyMessage(String msgId, Message message) throws CollaborationException {
        InfoQuery xmppMessage = (InfoQuery)((XMPPMessage)message).getXMPPMessage();
        List l = xmppMessage.listElements(PubSubQuery.NAME, PubSubQuery.class);
        try {
            if (l.iterator().hasNext()) {
                StreamElement elem = (StreamElement)l.iterator().next();
                l = elem.listElements(PubSubQueryNode.PubSubPublishElement.NAME, PubSubQueryNode.PubSubPublishElement.class);
            }
            PubSubQueryNode.PubSubPublishElement publishElem = null;
            if (l.iterator().hasNext()) {
                publishElem = (PubSubQueryNode.PubSubPublishElement)l.iterator().next();
            }
            PubSubQueryNode.PubSubItemElement item = (PubSubQueryNode.PubSubItemElement)publishElem.getFirstElement(PubSubQueryNode.PubSubItemElement.NAME, PubSubQueryNode.PubSubItemElement.class);
            item.setID(msgId);
            this._session.getConnection().send(xmppMessage);
        }
        catch (Exception e) {
            // empty catch block
        }
    }

    public void removeMessage(String msgId) throws CollaborationException {
        try {
            StreamDataFactory sdf = this._session.getDataFactory();
            Stream connection = this._session.getConnection();
            InfoQuery iq = (InfoQuery)sdf.createPacketNode(XMPPSession.IQ_NAME, InfoQuery.class);
            PubSubQuery pubsubquery = (PubSubQuery)sdf.createExtensionNode(PubSubQuery.NAME, PubSubQuery.class);
            PubSubElement retractElem = pubsubquery.createRetractElement(this._node.getNode(), msgId);
            pubsubquery.add(retractElem);
            iq.addExtension(pubsubquery);
            iq.setType(InfoQuery.SET);
            iq.setTo(this._newsService.getService());
            iq.setFrom(((XMPPPrincipal)this._session.getPrincipal()).getJID());
            iq.setID(this._session.nextID("pubsub"));
            connection.send(iq);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void subscribe(NewsChannelListener newsChannelListener) throws CollaborationException {
        this._listener = newsChannelListener;
        if (this._listener != null) {
            PacketError error;
            StreamDataFactory sdf = this._session.getDataFactory();
            Stream connection = this._session.getConnection();
            InfoQuery iq = (InfoQuery)sdf.createPacketNode(XMPPSession.IQ_NAME, InfoQuery.class);
            PubSubQuery pubsubquery = (PubSubQuery)sdf.createExtensionNode(PubSubQuery.NAME, PubSubQuery.class);
            PubSubElement subElem = pubsubquery.createSubscribeElement(XMPPNewsSession.encode(this._node.toString(), this._newsService.getService().toString()), ((XMPPPrincipal)this._session.getPrincipal()).getJID().toBareJID());
            pubsubquery.add(subElem);
            iq.add(pubsubquery);
            iq.setType(InfoQuery.SET);
            iq.setTo(this._newsService.getService());
            iq.setFrom(((XMPPPrincipal)this._session.getPrincipal()).getJID());
            iq.setID(this._session.nextID("pubsub"));
            try {
                iq = (InfoQuery)PacketMonitor.sendAndWatch(connection, iq, XMPPSession.SHORT_REQUEST_TIMEOUT);
            }
            catch (StreamException se) {
                throw new CollaborationException(se.getMessage());
            }
            if (iq == null) {
                throw new TimeoutException("Request timed out");
            }
            if (iq.getType() == InfoQuery.RESULT) {
                return;
            }
            if (iq.getType() == InfoQuery.ERROR && (error = iq.getError()) != null) {
                String errorCond = error.getDefinedCondition();
                if ("feature-not-implemented".equals(errorCond) || "service-unavailable".equals(errorCond)) {
                    throw new ServiceUnavailableException(error.getText());
                }
                if ("conflict".equals(errorCond)) {
                    throw new ConflictException(error.getText());
                }
                if ("registration-required".equals(errorCond)) {
                    throw new CollaborationException(error.getText());
                }
                throw new CollaborationException(error.getText());
            }
            this._session.addNewsChannel(this);
        }
    }

    public StreamElement getConfiguration() throws CollaborationException {
        XMPPSessionProvider.debug("Getting configuration .......");
        StreamDataFactory sdf = this._session.getDataFactory();
        Stream connection = this._session.getConnection();
        InfoQuery iq = (InfoQuery)sdf.createPacketNode(XMPPSession.IQ_NAME, InfoQuery.class);
        PubSubQuery pubsubquery = (PubSubQuery)sdf.createExtensionNode(new NSI("pubsub", "http://jabber.org/protocol/pubsub#owner"));
        PubSubElement configureElem = pubsubquery.createConfigureElement(XMPPNewsSession.encode(this._node.toString(), this._newsService.getService().toString()));
        pubsubquery.add(configureElem);
        iq.add(pubsubquery);
        iq.setType(InfoQuery.GET);
        iq.setTo(this._newsService.getService());
        iq.setFrom(((XMPPPrincipal)this._session.getPrincipal()).getJID());
        iq.setID(this._session.nextID("pubsub"));
        try {
            iq = (InfoQuery)PacketMonitor.sendAndWatch(connection, iq, 1000L);
            if (iq == null || iq.getType() != InfoQuery.RESULT) {
                throw new CollaborationException("NewsChannel " + this._node.toString() + " does not exist");
            }
        }
        catch (StreamException se) {
            se.printStackTrace();
            throw new CollaborationException(se.toString());
        }
        pubsubquery = (PubSubQuery)iq.getExtension("http://jabber.org/protocol/pubsub#owner");
        configureElem = (PubSubElement)pubsubquery.getFirstElement("configure");
        return configureElem;
    }

    public void leave() {
        try {
            StreamDataFactory sdf = this._session.getDataFactory();
            Stream connection = this._session.getConnection();
            InfoQuery iq = (InfoQuery)sdf.createPacketNode(XMPPSession.IQ_NAME, InfoQuery.class);
            PubSubQuery pubsubquery = (PubSubQuery)sdf.createExtensionNode(PubSubQuery.NAME, PubSubQueryNode.class);
            PubSubElement unsubElem = pubsubquery.createUnSubscribeElement(XMPPNewsSession.encode(this._node.toString(), this._newsService.getService().toString()), ((XMPPPrincipal)this._session.getPrincipal()).getJID().toBareJID());
            pubsubquery.add(unsubElem);
            iq.setType(InfoQuery.SET);
            iq.setTo(this._newsService.getService());
            iq.setFrom(((XMPPPrincipal)this._session.getPrincipal()).getJID());
            iq.setID(this._session.nextID("pubsub"));
            iq.addExtension(pubsubquery);
            connection.send(iq);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void close() throws CollaborationException {
        StreamDataFactory sdf = this._session.getDataFactory();
        Stream connection = this._session.getConnection();
        try {
            InfoQuery iq = (InfoQuery)sdf.createPacketNode(XMPPSession.IQ_NAME, InfoQuery.class);
            PubSubQuery pubsubquery = (PubSubQuery)sdf.createExtensionNode(PubSubQuery.NAME, PubSubQueryNode.class);
            PubSubElement deleteElem = pubsubquery.createDeleteElement(XMPPNewsSession.encode(this._node.toString(), this._newsService.getService().toString()));
            pubsubquery.add(deleteElem);
            iq.addExtension(pubsubquery);
            iq.setType(InfoQuery.SET);
            iq.setTo(this._newsService.getService());
            iq.setFrom(((XMPPPrincipal)this._session.getPrincipal()).getJID());
            iq.setID(this._session.nextID("pubsub"));
            connection.send(iq);
        }
        catch (StreamException se) {
            throw new CollaborationException(se.toString());
        }
        this._session.removeNewsChannel(this);
    }

    public void setDefaultPrivilege(int accesslevel) throws CollaborationException {
        StreamDataFactory sdf = this._session.getDataFactory();
        Stream connection = this._session.getConnection();
        try {
            InfoQuery iq = (InfoQuery)sdf.createPacketNode(XMPPSession.IQ_NAME, InfoQuery.class);
            PubSubQuery pubsubquery = (PubSubQuery)sdf.createExtensionNode(PubSubQuery.NAME_OWNER);
            StreamElement config = this.getConfiguration();
            XDataForm xform = (XDataForm)config.getFirstElement(XDataForm.NAME);
            xform.setType(XDataForm.SUBMIT);
            XDataField pubField = xform.getField("publish_model");
            XDataField subField = xform.getField("subscription_model");
            PubSubModel pubsubModel = this.defaultAccess2PubSubModel(accesslevel);
            subField.setValue(pubsubModel.subscriptionModel);
            pubField.setValue(pubsubModel.publishModel);
            subField.clearOptions();
            pubField.clearOptions();
            pubsubquery.add(config);
            iq.addExtension(pubsubquery);
            iq.setType(InfoQuery.SET);
            iq.setTo(this._newsService.getService());
            iq.setFrom(((XMPPPrincipal)this._session.getPrincipal()).getJID());
            iq.setID(this._session.nextID("pubsub"));
            connection.send(iq);
        }
        catch (StreamException se) {
            se.printStackTrace();
            throw new CollaborationException(se.toString());
        }
    }

    public int getPrivilege() throws CollaborationException {
        XMPPPrincipal principal = (XMPPPrincipal)this._newsService.__session.getPrincipal();
        return this.getPrivilege(principal.getUID());
    }

    public int getPrivilege(String uid) throws CollaborationException {
        Map m = this.listPrivileges();
        Integer accessInteger = (Integer)m.get(uid);
        int access = -1;
        access = accessInteger != null ? accessInteger.intValue() : this.getDefaultPrivilege();
        return access;
    }

    public void setPrivilege(String uid, int accesslevel) throws CollaborationException {
        HashMap<String, Integer> m = new HashMap<String, Integer>();
        m.put(uid, new Integer(accesslevel));
        this.setPrivileges(m);
    }

    public boolean hasPrivilege(int accessLevel) throws CollaborationException {
        int currentAccessLevel = this.getPrivilege();
        switch (accessLevel) {
            case 30: {
                switch (currentAccessLevel) {
                    case 30: {
                        return true;
                    }
                }
                return false;
            }
            case 4: 
            case 14: {
                switch (currentAccessLevel) {
                    case 4: 
                    case 14: 
                    case 30: {
                        return true;
                    }
                }
                return false;
            }
            case 2: {
                switch (currentAccessLevel) {
                    case 2: 
                    case 4: 
                    case 14: 
                    case 30: {
                        return true;
                    }
                }
                return false;
            }
            case 1: {
                return true;
            }
        }
        return false;
    }

    public int getDefaultPrivilege() throws CollaborationException {
        StreamElement config = this.getConfiguration();
        XDataForm xform = (XDataForm)config.getFirstElement(XDataForm.NAME);
        XDataField pubField = xform.getField("publish_model");
        XDataField subField = xform.getField("subscription_model");
        String publishModel = null;
        String subscriptionModel = null;
        if (pubField != null) {
            publishModel = pubField.getValue();
        }
        if (subField != null) {
            subscriptionModel = subField.getValue();
        }
        return this.pubSubModel2DefaultAccess(publishModel, subscriptionModel);
    }

    public Map listPrivileges() throws CollaborationException {
        EntityContainer entitiesElem;
        HashMap<String, Integer> user2Priv = new HashMap<String, Integer>();
        try {
            entitiesElem = this.getEntitiesElementResponse();
        }
        catch (StreamException se) {
            throw new CollaborationException(se.toString());
        }
        Iterator i = entitiesElem.listPubSubEntities().iterator();
        while (i.hasNext()) {
            PubSubEntityElement entityElem = (PubSubEntityElement)i.next();
            if (!this._newsService.isIncludedInACL(entityElem)) continue;
            String affiliation = entityElem.getAffiliation().toString();
            int access = XMPPSession.affiliation2Access(affiliation);
            String userID = entityElem.getSubscriberJID().toString();
            user2Priv.put(userID, new Integer(access));
        }
        return user2Priv;
    }

    private Map listUserSubscriptionStatus() throws CollaborationException {
        HashMap<String, PubSubEntityElement.SubscriptionStatus> user2Status = new HashMap<String, PubSubEntityElement.SubscriptionStatus>();
        EntityContainer entitiesElem = null;
        try {
            entitiesElem = this.getEntitiesElementResponse();
        }
        catch (StreamException se) {
            throw new CollaborationException(se.toString());
        }
        Iterator i = entitiesElem.listPubSubEntities().iterator();
        while (i.hasNext()) {
            PubSubEntityElement entityElem = (PubSubEntityElement)i.next();
            String userID = entityElem.getSubscriberJID().toString();
            user2Status.put(userID, entityElem.getSubscriptionStatus());
        }
        return user2Status;
    }

    private EntityContainer getEntitiesElementResponse() throws StreamException, CollaborationException {
        StreamDataFactory sdf = this._session.getDataFactory();
        Stream connection = this._session.getConnection();
        InfoQuery iq = (InfoQuery)sdf.createPacketNode(XMPPSession.IQ_NAME, InfoQuery.class);
        PubSubQuery pubsubquery = (PubSubQuery)sdf.createExtensionNode(PubSubQuery.NAME, PubSubQuery.class);
        EntityContainer entitiesElem = pubsubquery.createEntitiesElement(XMPPNewsSession.encode(this._node.toString(), this._newsService.getService().toString()));
        pubsubquery.add(entitiesElem);
        iq.addExtension(pubsubquery);
        iq.setType(InfoQuery.GET);
        iq.setTo(this._newsService.getService());
        iq.setFrom(((XMPPPrincipal)this._session.getPrincipal()).getJID());
        iq.setID(this._session.nextID("pubsub"));
        iq = (InfoQuery)PacketMonitor.sendAndWatch(connection, iq, XMPPSession.SHORT_REQUEST_TIMEOUT);
        if (iq == null || iq.getType() != InfoQuery.RESULT) {
            throw new CollaborationException("Could not get affiliations of the newschannel");
        }
        pubsubquery = (PubSubQuery)iq.getExtension("http://jabber.org/protocol/pubsub");
        entitiesElem = (EntityContainer)pubsubquery.getFirstElement("entities");
        return entitiesElem;
    }

    public void setPrivileges(Map map) throws CollaborationException {
        StreamDataFactory sdf = this._session.getDataFactory();
        Stream connection = this._session.getConnection();
        try {
            EntityContainer entitiesElement = this.getEntitiesElementResponse();
            HashMap<String, PubSubEntityElement> user2Entity = new HashMap<String, PubSubEntityElement>();
            Iterator i = entitiesElement.listPubSubEntities().iterator();
            while (i.hasNext()) {
                PubSubEntityElement entityElem = (PubSubEntityElement)i.next();
                String userID = entityElem.getSubscriberJID().toString();
                user2Entity.put(userID, entityElem);
            }
            InfoQuery iq = (InfoQuery)sdf.createPacketNode(XMPPSession.IQ_NAME, InfoQuery.class);
            PubSubQuery pubsubquery = (PubSubQuery)sdf.createExtensionNode(PubSubQuery.NAME, PubSubQuery.class);
            EntityContainer entitiesElem = pubsubquery.createEntitiesElement(XMPPNewsSession.encode(this._node.toString(), this._node.getDomain()));
            pubsubquery.add(entitiesElem);
            iq.addExtension(pubsubquery);
            Iterator i2 = map.keySet().iterator();
            while (i2.hasNext()) {
                String subscriptionStatus;
                String userID = (String)i2.next();
                Integer access = (Integer)map.get(userID);
                String affiliation = XMPPSession.access2Affiliation(access);
                PubSubEntityElement entityElement = (PubSubEntityElement)user2Entity.get(userID);
                if (entityElement != null) {
                    PubSubEntityElement.SubscriptionStatus subStatus = entityElement.getSubscriptionStatus();
                    subscriptionStatus = subStatus != null ? subStatus.toString() : PubSubEntityElement.NONE.toString();
                    entitiesElem.addPubSubEntity(entityElement);
                    continue;
                }
                subscriptionStatus = PubSubEntityElement.NONE.toString();
                PubSubEntityElement entityElem = pubsubquery.createEntityElement(null, new JID(userID), affiliation, subscriptionStatus);
                entitiesElem.addPubSubEntity(entityElem);
            }
            iq.setType(InfoQuery.SET);
            iq.setTo(this._newsService.getService());
            iq.setFrom(((XMPPPrincipal)this._session.getPrincipal()).getJID());
            iq.setID(this._session.nextID("pubsub"));
            connection.send(iq);
        }
        catch (StreamException se) {
            throw new CollaborationException(se.toString());
        }
    }

    public void messageAdded(XMPPNewsMessage message) {
        if (this._listener != null) {
            this._listener.onMessageAdded(message);
        }
    }

    public void messageRemoved(XMPPNewsMessage message) {
        if (this._listener != null) {
            this._listener.onMessageRemoved(message.getMessageId());
        }
    }

    private PubSubModel defaultAccess2PubSubModel(int accesslevel) {
        PubSubModel pubsubModel = new PubSubModel();
        if (accesslevel == 1) {
            pubsubModel.publishModel = "publishers";
            pubsubModel.subscriptionModel = "whitelist";
        } else if (accesslevel == 2) {
            pubsubModel.publishModel = "publishers";
            pubsubModel.subscriptionModel = "open";
        } else if (accesslevel == 4) {
            pubsubModel.publishModel = "open";
            pubsubModel.subscriptionModel = "open";
        } else if (accesslevel == 30) {
            pubsubModel.publishModel = "open";
            pubsubModel.subscriptionModel = "open";
        }
        return pubsubModel;
    }

    private int pubSubModel2DefaultAccess(String publishModel, String subscriptionModel) {
        int defaultAccess = 1;
        if (publishModel.equalsIgnoreCase("open")) {
            defaultAccess = 4;
            return defaultAccess;
        }
        if (publishModel.equalsIgnoreCase("subscribers") && subscriptionModel.equalsIgnoreCase("open")) {
            defaultAccess = 2;
        }
        if (publishModel.equalsIgnoreCase("publishers") && subscriptionModel.equalsIgnoreCase("open")) {
            defaultAccess = 2;
        }
        if (publishModel.equalsIgnoreCase("publishers") && subscriptionModel.equalsIgnoreCase("whitelist")) {
            defaultAccess = 1;
        }
        if (publishModel.equalsIgnoreCase("publishers") && subscriptionModel.equalsIgnoreCase("authorize")) {
            defaultAccess = 1;
        }
        return defaultAccess;
    }

    public boolean equals(Object o) {
        return o != null && o instanceof NewsChannel && ((NewsChannel)o).getDestination().equals(this.getDestination());
    }

    public void setListener(NewsChannelListener listener) throws CollaborationException {
        this._listener = listener;
        this._session.addNewsChannel(this);
    }

    public void getMessages() throws CollaborationException {
    }

    private class PubSubModel {
        String publishModel;
        String subscriptionModel;

        private PubSubModel() {
        }
    }
}

