/*
 * Decompiled with CFR 0.152.
 */
package com.sun.im.service.xmpp;

import com.sun.im.service.CollaborationException;
import com.sun.im.service.InviteMessage;
import com.sun.im.service.Message;
import com.sun.im.service.MessagePart;
import com.sun.im.service.PollResponse;
import com.sun.im.service.ReadOnlyMessage;
import com.sun.im.service.ReadOnlyMessagePart;
import com.sun.im.service.ServiceUnavailableException;
import com.sun.im.service.util.StringUtility;
import com.sun.im.service.xmpp.XMPPConference;
import com.sun.im.service.xmpp.XMPPConferenceService;
import com.sun.im.service.xmpp.XMPPMessagePart;
import com.sun.im.service.xmpp.XMPPSession;
import com.sun.im.service.xmpp.XMPPSessionProvider;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.Date;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jabberstudio.jso.Extension;
import org.jabberstudio.jso.JID;
import org.jabberstudio.jso.JIDFormatException;
import org.jabberstudio.jso.NSI;
import org.jabberstudio.jso.Packet;
import org.jabberstudio.jso.StreamContext;
import org.jabberstudio.jso.StreamDataFactory;
import org.jabberstudio.jso.StreamElement;
import org.jabberstudio.jso.StreamException;
import org.jabberstudio.jso.format.DateTimeProfileFormat;
import org.jabberstudio.jso.io.XMLImporter;
import org.jabberstudio.jso.x.message_event.MessageEventExtension;
import org.jabberstudio.jso.x.muc.Decline;
import org.jabberstudio.jso.x.muc.Invite;
import org.jabberstudio.jso.x.muc.MUCUserQuery;
import org.jabberstudio.jso.x.xdata.XDataForm;

public class XMPPMessage
extends XMPPMessagePart
implements InviteMessage,
ReadOnlyMessage {
    Set _recipients = new HashSet();
    String _contentType;
    String _originator;
    private JID _associatedConferenceJID;
    private static DateTimeProfileFormat _dateFormat = DateTimeProfileFormat.getInstance(3);
    static long lastTime = 0L;
    static int lastTimeIndex = 0;
    static Object timeLock = new Object();
    public static final String CONTENT_TYPE = "content-type";
    public static final String CONTENT_NAME = "content-name";
    public static final String CONTENT_ENCODING = "content-encoding";
    public static final String SID_LIST = "sid_list";
    public static final String SUBJECT = "subject";
    public static final String POLL_TYPE = "application/x-iim-poll";
    public static final String POLL_REPLY_TYPE = "application/x-iim-poll-reply";
    public static final String DEFAULT_CONTENT_TYPE = "text/plain";
    public static final String BINARY_CONTENT_TYPE = "application/octet-stream";
    public static final String XML_CONTENT_TYPE = "text/xml";
    public static final String SOAP_CONTENT_TYPE = "application/soap+xml";
    public static final String XHTML_TYPE = "text/html";
    public static final String XHTML_NAMESPACE = "http://jabber.org/protocol/xhtml-im";
    public static final NSI NSI_XHTML = new NSI("html", "http://jabber.org/protocol/xhtml-im");
    public static final NSI NSI_XHTML_BODY = new NSI("body", "http://www.w3.org/1999/xhtml");
    XMPPSession _session;
    StreamDataFactory _sdf;
    Packet _xmppMessage;
    List _parts = new ArrayList();
    boolean isNewMsg = true;
    Hashtable _headers = new Hashtable();

    public XMPPMessage() {
    }

    public XMPPMessage(InputStream in) {
    }

    public XMPPMessage(XMPPSession s, JID originator) throws CollaborationException {
        this._session = s;
        this._sdf = s.getDataFactory();
        this._xmppMessage = (org.jabberstudio.jso.Message)this._sdf.createPacketNode(XMPPSession.MESSAGE_NAME, org.jabberstudio.jso.Message.class);
        this.setOriginator(originator.toString());
        String uniqueID = s.nextID("message");
        this._xmppMessage.setID(uniqueID);
        this._xmppMessage.setType(org.jabberstudio.jso.Message.NORMAL);
        ((org.jabberstudio.jso.Message)this._xmppMessage).setThread(uniqueID);
    }

    public XMPPMessage(XMPPSession s, String originator) throws CollaborationException {
        this(s, JID.valueOf(originator));
    }

    public XMPPMessage(XMPPSession s, JID recipient, JID originator) throws CollaborationException {
        this(s, originator);
        if (recipient != null) {
            this.addRecipient(recipient.toString());
        }
    }

    public XMPPMessage(XMPPSession s, String recipient, String originator) throws CollaborationException {
        this(s, JID.valueOf(recipient), JID.valueOf(originator));
    }

    public XMPPMessage(XMPPSession s, Packet m) throws CollaborationException {
        this(s.getDataFactory(), s, m);
    }

    public XMPPMessage(StreamDataFactory sdf, Packet m) throws CollaborationException {
        this(sdf, null, m);
    }

    XMPPMessage(StreamDataFactory sdf, XMPPSession s, Packet m) throws CollaborationException {
        this._session = s;
        this._sdf = sdf;
        this._xmppMessage = m;
        JID from = m.getFrom();
        JID to = m.getTo();
        if (from != null) {
            this.setOriginator(from.toString());
        }
        if (to != null) {
            this.addRecipient(m.getTo().toString());
        }
        this.isNewMsg = false;
    }

    public XMPPMessage copy() throws CollaborationException {
        XMPPMessage m = new XMPPMessage(this._sdf, this._session, (Packet)this._xmppMessage.copy());
        m.setHeaders((Hashtable)this._headers.clone());
        m.setPartList(new ArrayList(this._parts));
        m.setRecipientSet(new HashSet(this._recipients));
        return m;
    }

    public void addPart(MessagePart messagePart) throws CollaborationException {
        if (this._parts.size() == 0 && this.isNewMsg) {
            this.setContent(messagePart.getContent());
            this.setContentType(messagePart.getContentType());
            Hashtable ht = ((XMPPMessagePart)messagePart).getContents();
            Enumeration e = ht.keys();
            while (e.hasMoreElements()) {
                String type = (String)e.nextElement();
                this.setContent((String)ht.get(type), type);
            }
            this.isNewMsg = false;
        } else {
            this._parts.add(messagePart);
        }
    }

    public void addRecipient(String recipient) throws CollaborationException {
        String fqid = recipient;
        if (this._session != null) {
            fqid = StringUtility.appendDomainToAddress(recipient, this._session.getPrincipal().getDomainName());
        }
        this._xmppMessage.setTo(this._sdf.createJID(fqid));
        this._recipients.add(fqid);
    }

    public Date getExpirationDate() {
        return null;
    }

    public String getHeader(String header) {
        if (header.equalsIgnoreCase(SUBJECT) && this._xmppMessage instanceof org.jabberstudio.jso.Message) {
            return ((org.jabberstudio.jso.Message)this._xmppMessage).getSubject();
        }
        if (header.equalsIgnoreCase(CONTENT_TYPE)) {
            return this.getContentType();
        }
        return (String)this._headers.get(header);
    }

    private boolean isXMLMessage(Packet packet) {
        Iterator i = this._xmppMessage.listElements().iterator();
        while (i.hasNext()) {
            StreamElement child = (StreamElement)i.next();
            String ns = child.getNamespaceURI();
            if (ns == null || ns.indexOf("http://schemas.xmlsoap.org/") <= 0 && ns.indexOf("http://www.w3.org/") <= 0) continue;
            return true;
        }
        return false;
    }

    public String getContentType() {
        if (this._contentType != null) {
            return this._contentType;
        }
        this._contentType = (String)this._headers.get(CONTENT_TYPE);
        if (this._contentType != null) {
            return this._contentType;
        }
        if (this._xmppMessage.getExtension(XHTML_NAMESPACE) != null) {
            XMPPSessionProvider.debug("Found html namespace");
            this.setContentType(XHTML_TYPE);
        } else if (this._xmppMessage.getExtension("jabber:x:data") != null) {
            XMPPSessionProvider.debug("Found xdata namespace");
            Extension e = this._xmppMessage.getExtension("jabber:x:data");
            XDataForm.Type type = ((XDataForm)e).getType();
            if (type != null && type.equals(XDataForm.SUBMIT)) {
                this.setContentType(POLL_REPLY_TYPE);
            } else if (type != null && type.equals(XDataForm.FORM)) {
                this.setContentType(POLL_TYPE);
            }
        } else if (this._xmppMessage.getExtension("http://jabber.org/protocol/ibb") != null) {
            XMPPSessionProvider.debug("Found ibb namespace");
            this.setContentType(BINARY_CONTENT_TYPE);
        } else if (this.isXMLMessage(this._xmppMessage)) {
            XMPPSessionProvider.debug("Found xml namespace");
            this.setContentType(XML_CONTENT_TYPE);
        }
        return this._contentType != null ? this._contentType : DEFAULT_CONTENT_TYPE;
    }

    public String getMessageId() {
        return this._xmppMessage.getID();
    }

    public String getOriginator() {
        JID from = null;
        MUCUserQuery user = (MUCUserQuery)this._xmppMessage.getExtension("http://jabber.org/protocol/muc#user");
        if (user != null) {
            Iterator itr = user.listElements().iterator();
            while (itr.hasNext()) {
                Object o = itr.next();
                if (!(o instanceof Invite)) continue;
                from = ((Invite)o).getFrom();
                break;
            }
            return from.toString();
        }
        JID jid = this._xmppMessage.getFrom();
        return jid != null ? jid.toString() : null;
    }

    public MessagePart[] getParts() {
        MessagePart[] mparts = new MessagePart[this._parts.size() + 1];
        mparts[0] = this;
        for (int i = 0; i < this._parts.size(); ++i) {
            mparts[i + 1] = (MessagePart)this._parts.get(i);
        }
        return mparts;
    }

    public String[] getRecipients() throws CollaborationException {
        if (this._recipients.size() == 0 && this._xmppMessage.getTo() != null) {
            this._recipients.add(this._xmppMessage.getTo().toString());
        }
        String[] recipients = new String[this._recipients.size()];
        int j = 0;
        Iterator i = this._recipients.iterator();
        while (i.hasNext()) {
            recipients[j++] = (String)i.next();
        }
        return recipients;
    }

    public MessagePart newPart() throws CollaborationException {
        return new XMPPMessagePart();
    }

    public void removePart(MessagePart messagePart) throws CollaborationException {
        if (this._parts.get(0).equals(messagePart)) {
            throw new CollaborationException("Cannot remove first message part");
        }
        this._parts.remove(messagePart);
    }

    public void removeRecipient(String str) throws CollaborationException {
        String fqid = str;
        if (this._session != null) {
            fqid = StringUtility.appendDomainToAddress(str, this._session.getPrincipal().getDomainName());
        }
        this._recipients.remove(fqid);
    }

    public void sendReply(Message message) throws CollaborationException {
        try {
            org.jabberstudio.jso.Message m = (org.jabberstudio.jso.Message)((XMPPMessage)message).getXMPPMessage();
            String threadId = ((org.jabberstudio.jso.Message)this._xmppMessage).getThread();
            m.setThread(threadId);
            if (this.getContentType() != null && this.getContentType().equalsIgnoreCase(POLL_REPLY_TYPE) || this.getContentType().equalsIgnoreCase(POLL_TYPE)) {
                String content = message.getContent();
                m.setBody(null);
                try {
                    PollResponse p = new PollResponse(content);
                    XDataForm xdf = p.getXDataForm();
                    m.add(xdf);
                }
                catch (Exception e) {
                    // empty catch block
                }
            }
            this._session.getConnection().send(m);
        }
        catch (StreamException se) {
            se.printStackTrace();
            throw new CollaborationException(se.toString());
        }
    }

    public void sendStatus(int msgStatus) throws CollaborationException {
        if (this._xmppMessage.getType() == org.jabberstudio.jso.Message.CHAT) {
            XMPPConference c;
            String thread = null;
            XMPPConferenceService confService = (XMPPConferenceService)this._session.getConferenceService();
            if (confService != null) {
                thread = confService.getConversationThread((org.jabberstudio.jso.Message)this._xmppMessage);
            }
            if ((c = this._session.getConference(thread)) == null) {
                XMPPSessionProvider.debug("Conference room not found " + thread);
                return;
            }
            if (!c.sendStatus(msgStatus)) {
                this._xmppMessage.add(this.getMessageExtension(msgStatus));
                try {
                    if (this._xmppMessage.getTo() != null) {
                        this._session.getConnection().send(this._xmppMessage);
                    }
                }
                catch (StreamException se) {
                    throw new CollaborationException(se.toString());
                }
                this._xmppMessage.setTo(this._xmppMessage.getFrom());
                this._session.processMessage(this._xmppMessage);
            }
        } else if (this._xmppMessage.getType() == org.jabberstudio.jso.Message.GROUPCHAT) {
            String id = this._xmppMessage.getTo().toString();
            XMPPConference c = this._session.getConference(id);
            if (c == null) {
                XMPPSessionProvider.debug("Conference room not found " + id);
                return;
            }
            if (!c.sendStatus(msgStatus)) {
                this._xmppMessage.add(this.getMessageExtension(msgStatus));
                try {
                    this._session.getConnection().send(this._xmppMessage);
                }
                catch (StreamException se) {
                    throw new CollaborationException(se.toString());
                }
            }
        } else {
            this.sendNormalMessageEvent(msgStatus);
        }
    }

    private void sendNormalMessageEvent(int msgStatus) throws CollaborationException {
        String[] rcpts = this.getRecipients();
        String recipient = null;
        if (!(rcpts != null & rcpts.length > 0)) {
            throw new CollaborationException(this + "message does not have any recipient");
        }
        recipient = rcpts[0];
        try {
            org.jabberstudio.jso.Message xmppMessage = (org.jabberstudio.jso.Message)this._sdf.createPacketNode(XMPPSession.MESSAGE_NAME, org.jabberstudio.jso.Message.class);
            xmppMessage.setFrom(JID.valueOf(recipient));
            xmppMessage.setTo(JID.valueOf(this.getOriginator()));
            xmppMessage.setType(this._xmppMessage.getType());
            xmppMessage.setThread(((org.jabberstudio.jso.Message)this._xmppMessage).getThread());
            xmppMessage.add(this.getMessageExtension(msgStatus));
            this._session.getConnection().send(xmppMessage);
        }
        catch (JIDFormatException jfe) {
            throw new CollaborationException(jfe.toString());
        }
        catch (StreamException se) {
            throw new CollaborationException(se.toString());
        }
    }

    private StreamElement getMessageExtension(int msgStatus) {
        MessageEventExtension x = (MessageEventExtension)this._sdf.createExtensionNode(MessageEventExtension.NAME);
        MessageEventExtension.EventType type = this.getJabberStatus(msgStatus);
        if (type != null) {
            x.addEvent(type);
        }
        x.setMessageID(this.getMessageId());
        return x;
    }

    public void setHeader(String header, String value) throws CollaborationException {
        if (header == null || value == null) {
            return;
        }
        if (this._xmppMessage instanceof org.jabberstudio.jso.Message && header.equalsIgnoreCase(SUBJECT)) {
            ((org.jabberstudio.jso.Message)this._xmppMessage).setSubject(value);
            return;
        }
        if (header.equalsIgnoreCase(CONTENT_TYPE) && (value.equalsIgnoreCase(XHTML_TYPE) || value.equalsIgnoreCase(POLL_TYPE) || value.equalsIgnoreCase(DEFAULT_CONTENT_TYPE) || value.equalsIgnoreCase(BINARY_CONTENT_TYPE) || value.equalsIgnoreCase(POLL_REPLY_TYPE))) {
            return;
        }
        this._headers.put(header, value);
    }

    public void setOriginator(String sender) throws CollaborationException {
        this._originator = sender;
        if (this._session != null) {
            this._originator = StringUtility.appendDomainToAddress(sender, this._session.getPrincipal().getDomainName());
        }
        this._xmppMessage.setFrom(this._sdf.createJID(this._originator));
    }

    public void setContent(String content) throws CollaborationException {
        ((org.jabberstudio.jso.Message)this._xmppMessage).setBody(content);
    }

    public void setContent(String content, String contentType) throws CollaborationException {
        if (contentType.equals(XHTML_TYPE)) {
            StreamElement htmlElement = this._sdf.createElementNode(NSI_XHTML);
            StreamContext _outCtx = this._session.getConnection().getOutboundContext();
            XMLImporter importer = this._session.getConnection().getJSO().createXMLImporter(_outCtx);
            StringBuffer str = new StringBuffer();
            str.append("<body xmlns='http://www.w3.org/1999/xhtml'>");
            String temp = this._addImageEndTag(content);
            temp = this._substituteBrTag(temp, "<br[\t\n\r ]*>", "<br/>");
            str.append(temp);
            str.append("</body>");
            StreamElement bodyElement = importer.read(str.toString());
            htmlElement.add(bodyElement);
            this._xmppMessage.add(htmlElement);
            this.setContentType(contentType);
        } else if (this.isXMLContentType(contentType)) {
            StreamContext _outCtx = this._session.getConnection().getOutboundContext();
            XMLImporter importer = this._session.getConnection().getJSO().createXMLImporter(_outCtx);
            StreamElement xmlElement = importer.read(content);
            this._xmppMessage.add(xmlElement);
            this.setContentType(contentType);
        } else {
            ((org.jabberstudio.jso.Message)this._xmppMessage).setBody(content);
        }
    }

    public void setContent(InputStream is, String enc) throws CollaborationException {
        try {
            this.setHeader(CONTENT_ENCODING, enc);
            InputStreamReader isr = new InputStreamReader(is, enc);
            StringBuffer buf = new StringBuffer();
            char[] c = new char[1024];
            while (isr.ready()) {
                int len = isr.read(c, 0, c.length);
                buf.append(c, 0, len);
            }
            ((org.jabberstudio.jso.Message)this._xmppMessage).setBody(buf.toString());
            isr.close();
        }
        catch (Exception e) {
            throw new CollaborationException(e.toString());
        }
    }

    public ReadOnlyMessagePart[] getReadOnlyParts() {
        ReadOnlyMessagePart[] mparts = new MessagePart[this._parts.size() + 1];
        mparts[0] = this;
        for (int i = 0; i < this._parts.size(); ++i) {
            mparts[i + 1] = (ReadOnlyMessagePart)this._parts.get(i);
        }
        return mparts;
    }

    public void setContentType(String contentType) {
        this._contentType = contentType;
        try {
            this.setHeader(CONTENT_TYPE, contentType);
        }
        catch (CollaborationException e) {
            e.printStackTrace();
        }
    }

    private boolean isXMLContentType(String ct) {
        return (ct = ct.toLowerCase()).equals(XML_CONTENT_TYPE) || ct.indexOf("/") < ct.indexOf("+xml");
    }

    public String getContent() {
        String type = this.getContentType();
        if (type != null && (type.equalsIgnoreCase(POLL_TYPE) || type.equalsIgnoreCase(POLL_REPLY_TYPE))) {
            Extension ext = ((org.jabberstudio.jso.Message)this._xmppMessage).getExtension("jabber:x:data");
            if (ext == null) {
                return ((org.jabberstudio.jso.Message)this._xmppMessage).getBody();
            }
            return ext.toString();
        }
        if (type != null && this.isXMLContentType(type)) {
            Iterator i = this._xmppMessage.listElements().iterator();
            while (i.hasNext()) {
                StreamElement child = (StreamElement)i.next();
                if (child.getNamespaceURI().equals("sun:xmpp:properties") || child.getLocalName().equals(SUBJECT) || child.getLocalName().equals("body") || child.getLocalName().equals("error") || child.getLocalName().equals("event") || child.getLocalName().equals("thread")) continue;
                return child.toString();
            }
        } else {
            return ((org.jabberstudio.jso.Message)this._xmppMessage).getBody();
        }
        return null;
    }

    public String getContent(String contentType) {
        StreamElement bodyElement;
        StreamElement htmlElement;
        if (contentType != null && (contentType.equalsIgnoreCase(POLL_TYPE) || contentType.equalsIgnoreCase(POLL_REPLY_TYPE))) {
            Extension ext = ((org.jabberstudio.jso.Message)this._xmppMessage).getExtension("jabber:x:data");
            if (ext == null) {
                return ((org.jabberstudio.jso.Message)this._xmppMessage).getBody();
            }
            return ext.toString();
        }
        if (contentType.equals(XHTML_TYPE) && (htmlElement = this._xmppMessage.getFirstElement(NSI_XHTML)) != null && (bodyElement = htmlElement.getFirstElement(NSI_XHTML_BODY)) != null) {
            List list = bodyElement.listElements();
            String temp = this._removeImageEndTag(bodyElement.toString());
            temp = this._substituteBrTag(temp, "<br[\t\n\r ]*/>", "<br>");
            return this._substituteBrTag(temp, "</br[\t\n\r ]*>", "");
        }
        return null;
    }

    public Packet getXMPPMessage() {
        return this._xmppMessage;
    }

    public InputStream getInputStream() throws CollaborationException {
        String content = this.getContent();
        if (content != null) {
            return new ByteArrayInputStream(content.getBytes());
        }
        return null;
    }

    private MessageEventExtension.EventType getJabberStatus(int icapiStatus) {
        switch (icapiStatus) {
            case 7: {
                return MessageEventExtension.DISPLAYED;
            }
            case 1: {
                return MessageEventExtension.DELIVERED;
            }
            case 8: {
                return MessageEventExtension.COMPOSING;
            }
        }
        return null;
    }

    public void rsvp(boolean param) throws CollaborationException {
        this.rsvp(null, param);
    }

    public void rsvp(Message message, boolean param) throws CollaborationException {
        try {
            MessagePart[] parts;
            if (this._xmppMessage.getType() == org.jabberstudio.jso.Message.CHAT) {
                String thread = null;
                XMPPConferenceService confService = (XMPPConferenceService)this._session.getConferenceService();
                if (confService != null) {
                    thread = confService.getConversationThread((org.jabberstudio.jso.Message)this._xmppMessage);
                }
                XMPPConference c = this._session.getConference(thread);
                c.sendChatInviteReply(message, param);
                return;
            }
            org.jabberstudio.jso.Message m = (org.jabberstudio.jso.Message)this._sdf.createPacketNode(XMPPSession.MESSAGE_NAME, org.jabberstudio.jso.Message.class);
            JID from = null;
            MUCUserQuery user = (MUCUserQuery)this._xmppMessage.getExtension("http://jabber.org/protocol/muc#user");
            if (user == null) {
                return;
            }
            Iterator itr = user.listElements().iterator();
            while (itr.hasNext()) {
                Object o = itr.next();
                if (!(o instanceof Invite)) continue;
                XMPPSessionProvider.debug("Found invite");
                from = ((Invite)o).getFrom();
                break;
            }
            m.setFrom(this._xmppMessage.getTo());
            m.setTo(this._associatedConferenceJID);
            user = (MUCUserQuery)this._sdf.createElementNode(MUCUserQuery.NAME, MUCUserQuery.class);
            String reason = null;
            if (message != null && (parts = message.getParts()) != null) {
                reason = parts[0].getContent();
            }
            if (param) {
                Invite invite = (Invite)this._sdf.createElementNode(Invite.NAME, Invite.class);
                if (reason != null) {
                    invite.setReason(reason);
                }
                invite.setTo(from);
                user.add(invite);
            } else {
                Decline decline = (Decline)this._sdf.createElementNode(Decline.NAME, Decline.class);
                if (reason != null) {
                    decline.setReason(reason);
                }
                decline.setTo(new JID(this.getOriginator()));
                user.add(decline);
            }
            m.add(user);
            this._session.getConnection().send(m);
        }
        catch (StreamException e) {
            e.printStackTrace();
        }
    }

    protected void setHeaders(Hashtable ht) {
        this._headers = ht == null ? new Hashtable() : ht;
    }

    protected Hashtable getHeaders() {
        return this._headers;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static String getUniqueMessageID() {
        long t = System.currentTimeMillis();
        int index = 0;
        Object object = timeLock;
        synchronized (object) {
            if (lastTime == t) {
                index = ++lastTimeIndex;
            } else {
                lastTime = t;
                lastTimeIndex = 0;
            }
        }
        String msgid = "iim." + XMPPSessionProvider.processId + "." + Long.toString(t) + "." + index;
        return msgid;
    }

    private String _addImageEndTag(String content) {
        Pattern p = Pattern.compile("(<img[\t\n\r ][^>]*)>", 2);
        Matcher m = p.matcher(content);
        StringBuffer sb = new StringBuffer();
        int prev = 0;
        while (m.find()) {
            sb.append(content.substring(prev, m.start()));
            sb.append(m.group(1) + "/>");
            prev = m.end();
        }
        sb.append(content.substring(prev));
        return sb.toString();
    }

    private String _substituteBrTag(String content, String pattern, String replacement) {
        Pattern p = Pattern.compile(pattern, 2);
        Matcher m = p.matcher(content);
        StringBuffer out = new StringBuffer();
        int prev = 0;
        while (m.find()) {
            out.append(content.substring(prev, m.start()));
            out.append(replacement);
            prev = m.end();
        }
        out.append(content.substring(prev));
        return out.toString();
    }

    private String _removeImageEndTag(String content) {
        Pattern p = Pattern.compile("(<img[\t\n\r ][^>]*)(?<=/)>", 2);
        Matcher m = p.matcher(content);
        StringBuffer ret = new StringBuffer();
        int prev = 0;
        while (m.find()) {
            ret.append(content.substring(prev, m.start()));
            ret.append(m.group(1));
            ret.setCharAt(ret.length() - 1, '>');
            prev = m.end();
        }
        ret.append(content.substring(prev));
        p = Pattern.compile("</img[\t\n\r ]*>", 2);
        content = ret.toString();
        m = p.matcher(content);
        ret.delete(0, ret.length());
        prev = 0;
        while (m.find()) {
            ret.append(content.substring(prev, m.start()));
            prev = m.end();
        }
        ret.append(content.substring(prev));
        return ret.toString();
    }

    public void setRecipientSet(Set s) {
        if (s != null) {
            this._recipients = s;
        }
    }

    public void setPartList(List l) {
        if (l != null) {
            this._parts = l;
        }
    }

    public void setAssociatedConferenceJID(JID jid) {
        this._associatedConferenceJID = jid;
    }

    public void setExpirationDate(Date expireAt) throws CollaborationException {
        this._session._initFeaturesSupported();
        if (!(this._session.ampSupported && this._session.ampCondExpireAtSupported && this._session.ampActionDropSupported)) {
            throw new ServiceUnavailableException("Advanced Message processing is not supportedor Expireat condition or drop action is not supported");
        }
        StreamDataFactory sdf = this._session.getDataFactory();
        Extension amp = sdf.createExtensionNode(new NSI("amp", "http://jabber.org/protocol/amp"));
        StreamElement rule = sdf.createElementNode(new NSI("rule", null));
        rule.setAttributeValue("condition", "expire-at");
        rule.setAttributeValue("value", _dateFormat.format(expireAt));
        amp.add(rule);
        this._xmppMessage.add(amp);
    }

    public String toString() {
        return this._xmppMessage.toString();
    }
}

