/*
 * Decompiled with CFR 0.152.
 */
package com.sun.im.service.util;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.InetAddress;
import java.net.Socket;
import java.net.SocketAddress;
import java.net.SocketException;
import java.net.SocketTimeoutException;
import java.nio.ByteBuffer;
import java.nio.channels.SocketChannel;

public class StreamChannelSocketAdaptor
extends Socket {
    private Socket _channelSocket = null;
    private OutStream _outStream = new OutStream();
    private InStream _inStream = new InStream();

    public StreamChannelSocketAdaptor(Socket channelSocket) {
        this._channelSocket = channelSocket;
    }

    public OutputStream getOutputStream() throws IOException {
        return this._outStream;
    }

    public InputStream getInputStream() throws IOException {
        return this._inStream;
    }

    public void bind(SocketAddress socketaddress_1) throws IOException {
        this._channelSocket.bind(socketaddress_1);
    }

    public synchronized void close() throws IOException {
        this._channelSocket.close();
    }

    public void connect(SocketAddress socketaddress_1) throws IOException {
        this._channelSocket.connect(socketaddress_1);
    }

    public void connect(SocketAddress socketaddress_1, int int_1) throws IOException {
        this._channelSocket.connect(socketaddress_1, int_1);
    }

    public SocketChannel getChannel() {
        return this._channelSocket.getChannel();
    }

    public InetAddress getInetAddress() {
        return this._channelSocket.getInetAddress();
    }

    public boolean getKeepAlive() throws SocketException {
        return this._channelSocket.getKeepAlive();
    }

    public InetAddress getLocalAddress() {
        return this._channelSocket.getLocalAddress();
    }

    public int getLocalPort() {
        return this._channelSocket.getLocalPort();
    }

    public SocketAddress getLocalSocketAddress() {
        return this._channelSocket.getLocalSocketAddress();
    }

    public boolean getOOBInline() throws SocketException {
        return this._channelSocket.getOOBInline();
    }

    public int getPort() {
        return this._channelSocket.getPort();
    }

    public synchronized int getReceiveBufferSize() throws SocketException {
        return this._channelSocket.getReceiveBufferSize();
    }

    public SocketAddress getRemoteSocketAddress() {
        return this._channelSocket.getRemoteSocketAddress();
    }

    public boolean getReuseAddress() throws SocketException {
        return this._channelSocket.getReuseAddress();
    }

    public synchronized int getSendBufferSize() throws SocketException {
        return this._channelSocket.getSendBufferSize();
    }

    public int getSoLinger() throws SocketException {
        return this._channelSocket.getSoLinger();
    }

    public synchronized int getSoTimeout() throws SocketException {
        return this._channelSocket.getSoTimeout();
    }

    public boolean getTcpNoDelay() throws SocketException {
        return this._channelSocket.getTcpNoDelay();
    }

    public int getTrafficClass() throws SocketException {
        return this._channelSocket.getTrafficClass();
    }

    public boolean isBound() {
        return this._channelSocket.isBound();
    }

    public boolean isClosed() {
        return this._channelSocket.isClosed();
    }

    public boolean isConnected() {
        return this._channelSocket.isConnected();
    }

    public boolean isInputShutdown() {
        return this._channelSocket.isInputShutdown();
    }

    public boolean isOutputShutdown() {
        return this._channelSocket.isOutputShutdown();
    }

    public void sendUrgentData(int int_1) throws IOException {
        this._channelSocket.sendUrgentData(int_1);
    }

    public void setKeepAlive(boolean boolean_1) throws SocketException {
        this._channelSocket.setKeepAlive(boolean_1);
    }

    public void setOOBInline(boolean boolean_1) throws SocketException {
        this._channelSocket.setOOBInline(boolean_1);
    }

    public synchronized void setReceiveBufferSize(int int_1) throws SocketException {
        this._channelSocket.setReceiveBufferSize(int_1);
    }

    public void setReuseAddress(boolean boolean_1) throws SocketException {
        this._channelSocket.setReuseAddress(boolean_1);
    }

    public synchronized void setSendBufferSize(int int_1) throws SocketException {
        this._channelSocket.setSendBufferSize(int_1);
    }

    public void setSoLinger(boolean boolean_1, int int_1) throws SocketException {
        this._channelSocket.setSoLinger(boolean_1, int_1);
    }

    public synchronized void setSoTimeout(int int_1) throws SocketException {
        this._channelSocket.setSoTimeout(int_1);
    }

    public void setTcpNoDelay(boolean boolean_1) throws SocketException {
        this._channelSocket.setTcpNoDelay(boolean_1);
    }

    public void setTrafficClass(int int_1) throws SocketException {
        this._channelSocket.setTrafficClass(int_1);
    }

    public void shutdownInput() throws IOException {
        this._channelSocket.shutdownInput();
    }

    public void shutdownOutput() throws IOException {
        this._channelSocket.shutdownOutput();
    }

    private class InStream
    extends InputStream {
        private InStream() {
        }

        public int read() throws IOException {
            return this.read(new byte[1], 0, 1);
        }

        public void close() throws IOException {
            StreamChannelSocketAdaptor.this._channelSocket.getChannel().close();
        }

        public int read(byte[] data, int offset, int len) throws IOException {
            int read = StreamChannelSocketAdaptor.this._channelSocket.getChannel().read(ByteBuffer.wrap(data, offset, len));
            if (read == 0 && StreamChannelSocketAdaptor.this._channelSocket.getSoTimeout() != 0) {
                throw new SocketTimeoutException();
            }
            return read;
        }
    }

    private class OutStream
    extends OutputStream {
        private OutStream() {
        }

        public void write(int b) throws IOException {
            this.write(new byte[]{(byte)b}, 0, 1);
        }

        public void write(byte[] b, int off, int len) throws IOException {
            int written = 0;
            if (len != 0) {
                ByteBuffer byteBuffer = ByteBuffer.wrap(b, off, len);
                int waitTime = 10;
                int lastCount = 0;
                SocketChannel byteChannel = StreamChannelSocketAdaptor.this._channelSocket.getChannel();
                while ((written += byteChannel.write(byteBuffer)) < len) {
                    if (lastCount != written) {
                        waitTime = 10;
                    }
                    lastCount = written;
                    try {
                        Thread.sleep(waitTime);
                        waitTime += waitTime;
                    }
                    catch (Exception e) {}
                }
            }
        }

        public void close() throws IOException {
            StreamChannelSocketAdaptor.this._channelSocket.getChannel().close();
        }
    }
}

