/*
 * Decompiled with CFR 0.152.
 */
package com.sun.im.service.util;

import java.io.IOException;
import java.net.Socket;
import java.nio.ByteBuffer;
import java.nio.channels.ByteChannel;

public class SocketByteChannel
implements ByteChannel {
    private Socket _socket = null;

    public SocketByteChannel(Socket s) {
        this._socket = s;
    }

    public int write(ByteBuffer src) throws IOException {
        int len = src.remaining();
        this._socket.getOutputStream().write(src.array(), src.position(), len);
        try {
            src.position(src.position() + len);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        return len;
    }

    public int read(ByteBuffer dst) throws IOException {
        int len = this._socket.getInputStream().read(dst.array(), dst.position(), dst.remaining());
        try {
            dst.position(dst.position() + len);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        return len;
    }

    public void close() throws IOException {
        this._socket.close();
    }

    public boolean isOpen() {
        return this._socket.isConnected();
    }
}

