/*
 * Decompiled with CFR 0.152.
 */
package com.sun.im.service.util;

import com.sun.im.service.util.ImageDictionary;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.StringReader;
import java.net.URL;
import java.net.URLConnection;
import java.util.StringTokenizer;
import javax.swing.text.BadLocationException;
import javax.swing.text.ChangedCharSetException;
import javax.swing.text.Element;
import javax.swing.text.StyleConstants;
import javax.swing.text.html.HTML;
import javax.swing.text.html.HTMLDocument;
import javax.swing.text.html.HTMLEditorKit;

public class HTMLDocumentLoader {
    public static ImageDictionary _dic = new ImageDictionary();
    static final String IMAGE_CACHE_PROPERTY = "imageCache";
    protected static HTMLEditorKit kit = new HTMLEditorKit();
    protected static HTMLEditorKit.Parser parser;

    public HTMLDocument loadDocument(HTMLDocument doc, URL url, String charSet) throws IOException {
        doc.putProperty("stream", url);
        InputStream in = null;
        boolean ignoreCharSet = false;
        while (true) {
            try {
                doc.remove(0, doc.getLength());
                URLConnection urlc = url.openConnection();
                in = urlc.getInputStream();
                InputStreamReader reader = charSet == null ? new InputStreamReader(in) : new InputStreamReader(in, charSet);
                HTMLEditorKit.Parser parser = this.getParser();
                HTMLEditorKit.ParserCallback htmlReader = this.getParserCallback(doc);
                parser.parse(reader, htmlReader, ignoreCharSet);
                htmlReader.flush();
                in.close();
            }
            catch (BadLocationException ex) {
                throw new IOException(ex.getMessage());
            }
            catch (ChangedCharSetException e) {
                charSet = this.getNewCharSet(e);
                ignoreCharSet = true;
                in.close();
                continue;
            }
            break;
        }
        return doc;
    }

    public void setImageCache(ImageDictionary d) {
        _dic = d;
    }

    public HTMLDocument loadDocument(URL url, String charSet) throws IOException {
        return this.loadDocument((HTMLDocument)kit.createDefaultDocument(), url, charSet);
    }

    public HTMLDocument loadDocument(URL url) throws IOException {
        return this.loadDocument(url, null);
    }

    public HTMLDocument loadDocument(String text) throws IOException {
        return this.loadDocument((HTMLDocument)kit.createDefaultDocument(), text, true);
    }

    public HTMLDocument loadDocument(HTMLDocument doc, String text, boolean use_cache) throws IOException {
        if (use_cache && _dic != null) {
            doc.putProperty(IMAGE_CACHE_PROPERTY, _dic);
        }
        boolean ignoreCharSet = false;
        while (true) {
            try {
                StringReader in = new StringReader(text);
                BufferedReader bufin = new BufferedReader(in);
                HTMLEditorKit.Parser parser = this.getParser();
                HTMLEditorKit.ParserCallback htmlReader = this.getParserCallback(doc);
                parser.parse(bufin, htmlReader, ignoreCharSet);
                htmlReader.flush();
                bufin.close();
                in.close();
            }
            catch (BadLocationException ex) {
                throw new IOException(ex.getMessage());
            }
            catch (ChangedCharSetException e) {
                System.out.println("loadDocument:" + e);
                ignoreCharSet = true;
                continue;
            }
            break;
        }
        return doc;
    }

    public void insertHTML(HTMLDocument doc, Element parent, int offset, String html, HTML.Tag insertTag) throws BadLocationException, IOException {
        if (parent != null && html != null) {
            HTML.Tag name = insertTag != null ? insertTag : parent.getAttributes().getAttribute(StyleConstants.NameAttribute);
            HTMLEditorKit.Parser parser = this.getParser();
            if (parser != null && name != null && name instanceof HTML.Tag) {
                int lastOffset = Math.max(0, offset - 1);
                Element charElement = doc.getCharacterElement(lastOffset);
                Element commonParent = parent;
                int pop = 0;
                int push = 0;
                if (parent.getStartOffset() > lastOffset) {
                    while (commonParent != null && commonParent.getStartOffset() > lastOffset) {
                        commonParent = commonParent.getParentElement();
                        ++push;
                    }
                    if (commonParent == null) {
                        throw new BadLocationException("No common parent", offset);
                    }
                }
                while (charElement != null && charElement != commonParent) {
                    ++pop;
                    charElement = charElement.getParentElement();
                }
                if (charElement != null) {
                    HTMLEditorKit.ParserCallback callback = doc.getReader(offset, pop - 1, push, name);
                    parser.parse(new StringReader(html), callback, true);
                    callback.flush();
                }
            }
        }
    }

    public synchronized HTMLEditorKit.Parser getParser() {
        if (parser == null) {
            try {
                Class<?> c = Class.forName("javax.swing.text.html.parser.ParserDelegator");
                parser = (HTMLEditorKit.Parser)c.newInstance();
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        return parser;
    }

    public synchronized HTMLEditorKit.ParserCallback getParserCallback(HTMLDocument doc) {
        return doc.getReader(0);
    }

    protected String getNewCharSet(ChangedCharSetException e) {
        String spec = e.getCharSetSpec();
        if (e.keyEqualsCharSet()) {
            return spec;
        }
        int index = spec.indexOf(";");
        if (index != -1) {
            spec = spec.substring(index + 1);
        }
        spec = spec.toLowerCase();
        StringTokenizer st = new StringTokenizer(spec, " \t=", true);
        boolean foundCharSet = false;
        boolean foundEquals = false;
        while (st.hasMoreTokens()) {
            String token = st.nextToken();
            if (token.equals(" ") || token.equals("\t")) continue;
            if (!foundCharSet && !foundEquals && token.equals("charset")) {
                foundCharSet = true;
                continue;
            }
            if (!foundEquals && token.equals("=")) {
                foundEquals = true;
                continue;
            }
            if (foundEquals && foundCharSet) {
                return token;
            }
            foundCharSet = false;
            foundEquals = false;
        }
        return "8859_1";
    }
}

