/*
 * Decompiled with CFR 0.152.
 */
package com.sun.im.service.util;

import com.sun.im.service.util.SelectWorker;
import java.io.EOFException;
import java.io.IOException;
import java.io.PrintStream;
import java.nio.ByteBuffer;
import java.nio.channels.ByteChannel;

public class BufferedByteChannel
implements ByteChannel {
    private ByteBuffer _OutBuffer;
    private ByteChannel sc;
    private SelectWorker _selector;
    private Object _selection = null;
    private PrintStream debugOut;

    public BufferedByteChannel(ByteChannel sc, SelectWorker selector, PrintStream out) {
        this(sc, selector);
        this.debugOut = out;
    }

    public BufferedByteChannel(ByteChannel sc, SelectWorker selector) {
        this(sc, selector, 16386);
    }

    public BufferedByteChannel(ByteChannel sc, SelectWorker selector, int capacity) {
        this.sc = sc;
        this._selector = selector;
        this._OutBuffer = ByteBuffer.allocate(capacity);
    }

    protected void setSelectionKey(Object key) {
        this._selection = key;
    }

    public int read(ByteBuffer dst) throws IOException {
        if (!this.sc.isOpen()) {
            throw new EOFException("Channel already closed");
        }
        int len = this.sc.read(dst);
        if (this.debugOut != null) {
            this.debugOut.println("BufferedByteChannel: read bytes=" + len);
        }
        this._selector.interestOps(this._selection, 1);
        return len;
    }

    public void close() throws IOException {
        this._selector.cancel(this._selection);
    }

    public boolean isOpen() {
        return this.sc.isOpen();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int write(ByteBuffer src) throws IOException {
        if (!this.sc.isOpen()) {
            throw new EOFException("Channel already closed");
        }
        int len = 0;
        BufferedByteChannel bufferedByteChannel = this;
        synchronized (bufferedByteChannel) {
            this._OutBuffer.limit(this._OutBuffer.capacity());
            len = src.remaining();
            if (len > this._OutBuffer.remaining()) {
                System.out.println("BufferedByteChannel: OVERFLOW: remaining=" + this._OutBuffer.remaining() + " requested=" + len + " position=" + this._OutBuffer.remaining() + " limit=" + this._OutBuffer.limit());
                len = this._OutBuffer.remaining();
                this._OutBuffer.put(src.array(), src.position(), len);
                src.position(src.position() + len);
            } else {
                this._OutBuffer.put(src);
            }
        }
        if (this.writeNow() > 0) {
            this._selector.interestOps(this._selection, 4);
        }
        return len;
    }

    public synchronized int writeNow() throws IOException {
        if (this._OutBuffer.position() == 0) {
            return 0;
        }
        this._OutBuffer.flip();
        int amt = this.sc.write(this._OutBuffer);
        this._OutBuffer.compact();
        return this._OutBuffer.position();
    }
}

