/*
 * Decompiled with CFR 0.152.
 */
package com.sun.im.service.shells;

import com.sun.im.service.ApplicationInfo;
import com.sun.im.service.CollaborationException;
import com.sun.im.service.CollaborationPrincipal;
import com.sun.im.service.CollaborationSession;
import com.sun.im.service.CollaborationSessionFactory;
import com.sun.im.service.CollaborationSessionProvider;
import com.sun.im.service.Conference;
import com.sun.im.service.ConferenceService;
import com.sun.im.service.ConferenceServiceListener;
import com.sun.im.service.ConferenceSession;
import com.sun.im.service.ConferenceSessionListener;
import com.sun.im.service.ContentStream;
import com.sun.im.service.InviteMessage;
import com.sun.im.service.InviteMessageStatusListener;
import com.sun.im.service.Message;
import com.sun.im.service.MessagePart;
import com.sun.im.service.MessageStatusListener;
import com.sun.im.service.NewsChannel;
import com.sun.im.service.NewsService;
import com.sun.im.service.NewsSession;
import com.sun.im.service.NotificationService;
import com.sun.im.service.NotificationServiceListener;
import com.sun.im.service.NotificationSession;
import com.sun.im.service.NotificationSessionListener;
import com.sun.im.service.PersonalConference;
import com.sun.im.service.PersonalContact;
import com.sun.im.service.PersonalGateway;
import com.sun.im.service.PersonalGroup;
import com.sun.im.service.PersonalProfile;
import com.sun.im.service.PersonalStoreEntry;
import com.sun.im.service.PersonalStoreFolder;
import com.sun.im.service.PersonalStoreService;
import com.sun.im.service.PersonalStoreSession;
import com.sun.im.service.Poll;
import com.sun.im.service.PollHelper;
import com.sun.im.service.PollResponse;
import com.sun.im.service.Presence;
import com.sun.im.service.PresenceAccessRule;
import com.sun.im.service.PresenceHelper;
import com.sun.im.service.PresenceInfoListener;
import com.sun.im.service.PresenceService;
import com.sun.im.service.PresenceServiceListener;
import com.sun.im.service.PresenceSession;
import com.sun.im.service.PresenceTuple;
import com.sun.im.service.PrivacyItem;
import com.sun.im.service.PrivacyList;
import com.sun.im.service.ReceiverFileStreamingProfile;
import com.sun.im.service.ReceiverStreamingProfile;
import com.sun.im.service.SecureSessionListener;
import com.sun.im.service.SenderFileStreamingProfile;
import com.sun.im.service.StreamingService;
import com.sun.im.service.StreamingServiceListener;
import com.sun.im.service.shells.ContentStreamListenerImpl;
import com.sun.im.service.shells.ShellConference;
import com.sun.im.service.shells.ShellNewsChannel;
import com.sun.im.service.shells.ShellRegistrationListener;
import com.sun.im.service.util.HTMLConverter;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.InetAddress;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.Vector;
import org.apache.log4j.ConsoleAppender;
import org.apache.log4j.Layout;
import org.apache.log4j.Level;
import org.apache.log4j.LogManager;
import org.apache.log4j.Logger;
import org.apache.log4j.PatternLayout;

public class Shell
implements NotificationSessionListener,
ConferenceSessionListener,
PresenceInfoListener,
MessageStatusListener,
InviteMessageStatusListener,
SecureSessionListener,
PresenceServiceListener,
NotificationServiceListener,
ConferenceServiceListener,
StreamingServiceListener {
    CollaborationSession _session;
    PresenceService _presenceService;
    NewsService _newsService;
    ConferenceService _conferenceService;
    NotificationService _messageService;
    PersonalStoreService _personalStoreService;
    StreamingService _streamingService;
    static String _defaultDomain;
    Vector _receivedMessages;
    CollaborationSessionFactory _factory;
    CollaborationSessionFactory _compFactory;
    BufferedReader _reader;
    boolean interactive;
    static boolean _serviceModel;
    Hashtable _conferences = new Hashtable();
    Hashtable _confnames = new Hashtable();
    Hashtable _polls = new Hashtable();
    CollaborationPrincipal _principal;
    boolean running;
    boolean waiting;
    boolean inTestingMode = false;
    final int testModeWaitMsec = 500;
    String sessionId;
    public static boolean _usesso;
    private static String imServer;
    String server = null;
    String user = System.getProperty("user.name");
    String password = "iplanet";
    private static final HTMLConverter htmlConverter;
    AsyncReader _asyncReader = new AsyncReader();
    private String _instanceID = null;
    static String _inputFileName;

    public Shell() throws Exception {
        this.init(true, null);
    }

    public Shell(BufferedReader br, boolean multiShells) throws Exception {
        this.inTestingMode = multiShells;
        this.init(false, br);
    }

    private void init(boolean interactive, BufferedReader br) throws Exception {
        this.interactive = interactive;
        this._reader = br != null ? br : new BufferedReader(new InputStreamReader(System.in));
        this._factory = new CollaborationSessionFactory();
        this._receivedMessages = new Vector();
    }

    protected String getCanonicalConferenceName(Conference conf) {
        return conf.getDestination();
    }

    protected void assignLocalName(String name, String confDest) {
        this._confnames.put(name, confDest);
    }

    protected void assignLocalNameIfSameDomain(String confDest) {
        if (confDest.endsWith("@" + this._principal.getDomainName())) {
            this._confnames.put(Shell.getLocalPartFromAddress(confDest), confDest);
        }
    }

    public void start() {
        block3: while (true) {
            try {
                while (true) {
                    if (this.interactive) {
                        System.out.print("\nimp> ");
                    }
                    String s = this._reader.readLine();
                    if (this._asyncReader.isActive()) {
                        this._asyncReader.write(s);
                        continue;
                    }
                    if (s == null) break block3;
                    if ((s = s.trim()).equals("")) continue;
                    this.running = true;
                    StringTokenizer st = new StringTokenizer(s);
                    String cmd = st.nextToken();
                    String[] args = new String[st.countTokens()];
                    int i = 0;
                    while (st.hasMoreTokens()) {
                        args[i++] = st.nextToken();
                    }
                    if (cmd.equals("amc") || cmd.equalsIgnoreCase("AddMessageConference")) {
                        this.addConferenceMessage(args);
                    } else if (cmd.equals("amnc") || cmd.equalsIgnoreCase("AddMessageNewsChannel")) {
                        this.addNewsMessage(args);
                    } else if (cmd.equals("send")) {
                        this.sendMessage(args);
                    } else if (cmd.equals("pause")) {
                        Thread.sleep(1000L);
                    } else if (cmd.equals("cnc")) {
                        this.addNewsChannel(args);
                    } else if (cmd.equals("snc")) {
                        this.subscribeNewsChannel(args);
                    } else if (cmd.equals("unc")) {
                        this.unSubscribeNewsChannel(args);
                    } else if (cmd.equals("rnc")) {
                        this.delNewsChannel(args);
                    } else if (cmd.equals("ac")) {
                        this.addConference(args);
                    } else if (cmd.equals("apc")) {
                        this.addPublicConference(args);
                    } else if (cmd.equals("jpc")) {
                        this.joinPublicConference(args);
                    } else if (cmd.equals("spc")) {
                        this.subscribePublicConference(args);
                    } else if (cmd.equals("lpc")) {
                        this.listSubscribedPublicConference(args);
                    } else if (cmd.equals("upc")) {
                        this.unsubscribePublicConference(args);
                    } else if (cmd.equals("rc")) {
                        this.delRoom(args);
                    } else if (cmd.equals("mc")) {
                        this.moderateRoom(args);
                    } else if (cmd.equals("lmc")) {
                        this.listMembersInRoom(args);
                    } else if (cmd.equals("ammc")) {
                        this.addModeratedMessage(args);
                    } else if (cmd.equals("login")) {
                        this.login(args);
                    } else if (cmd.equals("loginc")) {
                        this.loginComponent(args);
                    } else if (cmd.equals("ru")) {
                        this.registerUser(args);
                    } else if (cmd.equals("uru")) {
                        this.unregisterUser(args);
                    } else if (cmd.equals("cup")) {
                        this.changeUserPassword(args);
                    } else if (cmd.equals("rgw")) {
                        this.registerGateway(args);
                    } else if (cmd.equals("urgw")) {
                        System.out.println("It is unregister gateway");
                        this.unregisterGateway(args);
                    } else if (cmd.equals("lsgw")) {
                        this.listGateways(args);
                    } else if (cmd.equals("lsrgw")) {
                        this.listRegisteredGateways(args);
                    } else if (cmd.equals("dmnc")) {
                        this.delNewsMessage(args);
                    } else if (cmd.equals("lmnc")) {
                        this.listMessages(args);
                    } else if (cmd.equals("lsnc")) {
                        this.listNewsChannels(args);
                    } else if (cmd.equals("lsmnc")) {
                        this.listManagedNewsChannels(args);
                    } else if (cmd.equals("gsnc")) {
                        this.getSubscribedNewsChannels(args);
                    } else if (cmd.equals("lsnp")) {
                        this.listNewsPrivileges(args);
                    } else if (cmd.equals("snp")) {
                        this.setNewsPrivileges(args);
                    } else if (cmd.equals("gnc")) {
                        this.getNewsConfiguration(args);
                    } else if (cmd.equals("sunp")) {
                        this.setNewsPrivilege(args);
                    } else if (cmd.equals("gunp")) {
                        this.getNewsPrivilege(args);
                    } else if (cmd.equals("gndp")) {
                        this.getDefaultNewsPrivilege(args);
                    } else if (cmd.equals("sndp")) {
                        this.setDefaultNewsPrivilege(args);
                    } else if (!cmd.equals("lq")) {
                        if (cmd.equals("lsc")) {
                            this.listPublicConferences(args);
                        } else if (!cmd.equals("lu") && !cmd.equals("lg")) {
                            if (cmd.equals("lc")) {
                                this.quitRoom(args);
                            } else if (cmd.equals("cacl")) {
                                this.editConferenceAcl(args);
                            } else if (cmd.equals("dcacl")) {
                                this.displayConferenceAcl(args);
                            } else if (cmd.equals("status")) {
                                this.sendMessageStatus(args);
                            } else if (cmd.equals("reply")) {
                                this.sendMessageReply(args);
                            } else if (cmd.equals("getdp")) {
                                this.getDestinationProperty(args);
                            } else if (cmd.equals("setdp")) {
                                this.setDestinationProperty(args);
                            } else if (cmd.equals("rmdp")) {
                                this.removeDestinationProperty(args);
                            } else if (!cmd.equals("s")) {
                                if (cmd.equals("ss")) {
                                    this.startStream(args);
                                } else if (cmd.equals("h") || cmd.equals("help")) {
                                    this.help();
                                } else if (cmd.equals("logout")) {
                                    this.logout();
                                } else {
                                    if (cmd.equals("e") || cmd.equals("exit") || cmd.equals("quit")) {
                                        this.logout();
                                        this.running = false;
                                        break block3;
                                    }
                                    if (cmd.equals("iuc")) {
                                        this.invite(args);
                                    } else if (!(cmd.equals("checkacl") || cmd.equals("ls") || cmd.equals("ss"))) {
                                        if (cmd.equals("ppi")) {
                                            this.publishPresenceInfo(args);
                                        } else if (cmd.equals("fpi")) {
                                            this.fetchPresenceInfo(args);
                                        } else if (cmd.equals("fp")) {
                                            this.fetchPresence(args);
                                        } else if (cmd.equals("spi")) {
                                            this.subscribePresenceInfo(args);
                                        } else if (cmd.equals("uspi")) {
                                            this.unsubscribePresenceInfo(args);
                                        } else if (cmd.equals("pacl")) {
                                            this.editPresenceAcl(args);
                                        } else if (cmd.equals("sacl")) {
                                            this.showPresenceAcl(args);
                                        } else if (cmd.equals("poll")) {
                                            this.sendPollMessage(args);
                                        } else if (cmd.equals("pollr")) {
                                            this.sendPollResponse(args);
                                        } else if (cmd.equals("acon")) {
                                            this.addContact(args);
                                        } else if (cmd.equals("alcon")) {
                                            this.addLegacyContact(args);
                                        } else if (cmd.equals("rcon")) {
                                            this.removeContact(args);
                                        } else if (cmd.equals("rlcon")) {
                                            this.removeLegacyContact(args);
                                        } else if (cmd.equals("search")) {
                                            this.searchEntries(args);
                                        } else if (cmd.equals("agrp")) {
                                            this.addContactGroup(args);
                                        } else if (cmd.equals("rgrp")) {
                                            this.removeContactGroup(args);
                                        } else if (cmd.equals("afol")) {
                                            this.addContactFolder(args);
                                        } else if (cmd.equals("rfol")) {
                                            this.removeContactFolder(args);
                                        } else if (cmd.equals("nfol")) {
                                            this.renameContactFolder(args);
                                        } else if (cmd.equals("lcon")) {
                                            this.listContacts(args);
                                        } else if (cmd.equals("egrp")) {
                                            this.expandContactGroup(args);
                                        } else if (cmd.equals("lpro")) {
                                            this.listProfile(args);
                                        } else if (cmd.equals("gpro")) {
                                            this.getProfile(args);
                                        } else if (cmd.equals("cpro")) {
                                            this.changeProfile(args);
                                        } else if (cmd.equals("rpro")) {
                                            this.removeProfile(args);
                                        } else if (cmd.equals("asub")) {
                                            this.addSubscription(args);
                                        } else if (cmd.equals("rsub")) {
                                            this.removeSubscription(args);
                                        } else if (cmd.equals("lsub")) {
                                            this.listSubscriptions(args);
                                        } else if (cmd.equals("lpl")) {
                                            this.listPrivacyList(args);
                                        } else if (cmd.equals("gpl")) {
                                            this.getPrivacyList(args);
                                        } else if (cmd.equals("spl")) {
                                            this.setPrivacyList(args);
                                        } else if (cmd.equals("rpl")) {
                                            this.removePrivacyList(args);
                                        } else if (cmd.equals("?")) {
                                            this.help();
                                        } else if (cmd.equalsIgnoreCase("y") || cmd.equalsIgnoreCase("n") || cmd.equalsIgnoreCase("no") || cmd.equalsIgnoreCase("yes")) {
                                            this._asyncReader.write(cmd);
                                        } else {
                                            System.out.println("error: unknown command : " + cmd);
                                            if (this.interactive) {
                                                this.help();
                                            }
                                        }
                                    }
                                }
                            }
                        }
                    }
                    this.running = false;
                }
            }
            catch (IOException ioe) {
                ioe.printStackTrace();
            }
            catch (Exception e) {
                this.running = false;
                System.out.println("Error " + e.toString());
                e.printStackTrace();
                continue;
            }
            break;
        }
        this._factory.close();
        if (this._compFactory != null) {
            this._compFactory.close();
        }
    }

    void help() {
        System.out.println("");
        System.out.println("login = start a session with presence, conference,");
        System.out.println("        message, and news channel services");
        System.out.println("");
        System.out.println("logout = logout of the current session");
        System.out.println();
        System.out.println(" --- PRESENCE --- ");
        System.out.println("ppi  = publish availability      fpi  = fetch availability");
        System.out.println("spi  = subcribe to availability  uspi = unsubcribe to availability");
        System.out.println("sacl = show presence rule acl    pacl = edit presence rule acl");
        System.out.println("");
        System.out.println(" --- CONFERENCE ---");
        System.out.println("amc  = add or send a message     iuc = invite user");
        System.out.println("ac   = setup conference          rc  = remove conference");
        System.out.println("jpc  = join public conference    lc  = leave conference");
        System.out.println("lsc  = list public conferences   apc = add public conference");
        System.out.println("spc  = subs public conferences   upc = unsu public conference");
        System.out.println("lpc  = list subscribed public conferences");
        System.out.println("cacl = edit conference access rules dcacl = display conference acls");
        System.out.println("mc   = moderate conference room  ammc = add moderated message to room");
        System.out.println("lmc  = list members in a public conference room");
        System.out.println("");
        System.out.println(" --- NEWS --- ");
        System.out.println("cnc  = create news channel       rnc = remove news channel");
        System.out.println("snc  = subscribe news channel    unc = unsubscribe news channel");
        System.out.println("lsnc = list news channels        amnc = post a message");
        System.out.println("lmnc = list messages             dmnc = delete message");
        System.out.println("lsmnc = list managed News channels      gsnc = get subscribed news channels");
        System.out.println("snp = set News access control list      lsnp = get news access control list");
        System.out.println("sndp = set default access level of newschannel gndp = get default acess level of newschannel");
        System.out.println("sunp = set Privilege of current user   gunp = get privilege of current user");
        System.out.println("");
        System.out.println(" --- NOTIFICATION --- ");
        System.out.println("send = send a message to users");
        System.out.println("status = send message status     reply reply last message");
        System.out.println("poll = send poll message         pollr send poll response");
        System.out.println("");
        System.out.println(" --- PERSONAL STORE --- ");
        System.out.println("lcon = list contacts\t\t");
        System.out.println("rcon = remove contact            acon = add contact");
        System.out.println("rlcon = remove legacy contact    alcon = add legacy contact");
        System.out.println("rgrp = remove contact group      agrp = add contact group");
        System.out.println("rfol = remove contact folder     afol = add contact folder");
        System.out.println("nfol = rename contact folder");
        System.out.println("search = search entries");
        System.out.println("lpro = list profile info         rpro = remove profile info");
        System.out.println("gpro = get profile info          cpro = change profile info");
        System.out.println("asub = subscribe to destination  rsub = unsubscribe");
        System.out.println("lsub = list subscriptions");
        System.out.println();
        System.out.println(" --- ARCHIVE TEST --- ");
        System.out.println("rat = run archive tests\t\t");
        System.out.println();
        System.out.println(" --- Privacy List --- ");
        System.out.println("lpl = List Privacy Lists\t\t");
        System.out.println("gpl = Get Privacy List\t\t");
        System.out.println("spl = Set Privacy List\t\t");
        System.out.println("rpl = Remove Privacy List\t\t");
        System.out.println();
        System.out.println("---- Gateway--------");
        System.out.println("rgw = register with gateway      urgw = unregister gateway");
        System.out.println("lsgw = list all available gateways");
        System.out.println();
        System.out.println("---- Streaming Service--------");
        System.out.println("ss = start the stream");
        System.out.println();
        System.out.println("e = exit");
        System.out.println("h = print this help");
        System.out.println("for help on a command type \"command ?\"");
    }

    boolean getYesOrNo(String ask, boolean async) throws Exception {
        String s = this.prompt(ask, false, async);
        if (s.equals("y") || s.equalsIgnoreCase("yes")) {
            return true;
        }
        if (s.equals("n") || s.equalsIgnoreCase("no")) {
            return false;
        }
        System.out.println("Please answer yes or no.");
        throw new Exception("Please answer yes or no.");
    }

    public boolean isRunning() {
        return this.running;
    }

    public boolean isWaiting() {
        return this.waiting;
    }

    protected String prompt(String ask, boolean newline) {
        return this.prompt(ask, newline, "", false);
    }

    protected String prompt(String ask, boolean newline, boolean async) {
        return this.prompt(ask, newline, "", async);
    }

    protected String prompt(String ask, boolean newline, String defaultValue) {
        return this.prompt(ask, newline, defaultValue, false);
    }

    protected String prompt(String ask, boolean newline, String defaultValue, boolean async) {
        String ret = defaultValue;
        this.waiting = true;
        if (async) {
            ret = this._asyncReader.read(ask);
        } else {
            if (newline) {
                System.out.println(ask);
            } else {
                System.out.print(ask);
            }
            try {
                ret = this._reader.readLine();
            }
            catch (Exception e) {
                e.printStackTrace();
                System.out.println("Exception is thrown");
            }
        }
        this.waiting = false;
        if (ret.length() > 0) {
            return ret;
        }
        return defaultValue;
    }

    protected String[] promptValues(String ask, boolean newline, String defaultValue) {
        String s = this.prompt(ask, false, defaultValue, false);
        if (s != null && s.length() > 0) {
            ArrayList<String> list = new ArrayList<String>();
            StringTokenizer st = new StringTokenizer(s);
            while (st.hasMoreTokens()) {
                list.add(st.nextToken());
            }
            String[] array = new String[list.size()];
            for (int i = 0; i < list.size(); ++i) {
                array[i] = (String)list.get(i);
            }
            return array;
        }
        return null;
    }

    public void setInstanceID(String s) {
        this._instanceID = s;
    }

    public String getInstanceID() {
        return this._instanceID;
    }

    private void logout() throws Exception {
        if (this._presenceService instanceof PresenceSession) {
            ((PresenceSession)((Object)this._presenceService)).logout();
        }
        if (this._conferenceService instanceof ConferenceSession) {
            ((ConferenceSession)((Object)this._conferenceService)).logout();
        }
        if (this._newsService instanceof NewsSession) {
            ((NewsSession)((Object)this._newsService)).logout();
        }
        if (this._messageService instanceof NotificationSession) {
            ((NotificationSession)((Object)this._messageService)).logout();
        }
        if (this._personalStoreService instanceof PersonalStoreSession) {
            ((PersonalStoreSession)((Object)this._personalStoreService)).logout();
        }
        if (this._session != null) {
            this._session.logout();
        }
    }

    void readLoginInfo(String[] args, boolean includeResource) {
        if (args.length > 0 && args[0].equals("?")) {
            System.out.println("login host username password");
            return;
        }
        if (args.length >= 1) {
            this.server = args[0];
        } else {
            imServer = this.server = this.prompt("IM Service [" + imServer + "]: ", false, imServer);
        }
        this.user = args.length >= 2 ? args[1] : this.prompt("User Name [" + this.user + "]: ", false, this.user);
        if (includeResource && this.user.indexOf(47) < 0) {
            this.user = this.user + "/shell";
        }
        if (args.length >= 3) {
            this.password = args[2];
        } else if (includeResource) {
            this.password = this.prompt("Password [" + this.password + "]: ", false, this.password);
        } else {
            String dpassword = "";
            this.password = this.prompt("Password [" + dpassword + "]: ", false, dpassword);
            if (this.password == null) {
                this.password = dpassword;
            }
        }
    }

    void initSubSessions() throws Exception {
        if (_serviceModel) {
            this._presenceService = this._session.getPresenceService();
            this._presenceService.initialize(this);
            this._newsService = this._session.getNewsService();
            this._conferenceService = this._session.getConferenceService();
            this._conferenceService.initialize(this);
            this._messageService = this._session.getNotificationService();
            this._messageService.initialize(this);
            this._personalStoreService = this._session.getPersonalStoreService();
            this._personalStoreService.initialize(null);
            this._streamingService = this._session.getStreamingService();
            this._streamingService.initialize(this);
        } else {
            this._presenceService = (PresenceService)((Object)this._session.accessService("presence"));
            this._conferenceService = (ConferenceService)((Object)this._session.accessService("conference"));
            this._messageService = (NotificationService)((Object)this._session.accessService("notification"));
            this._newsService = (NewsService)((Object)this._session.accessService("news"));
            this._personalStoreService = (PersonalStoreService)((Object)this._session.accessService("pstore"));
        }
        this._principal = this._session.getPrincipal();
    }

    public void login(String[] args) throws Exception {
        this.readLoginInfo(args, true);
        this._session = this._factory.getSession(this.server, this.user, this.password, this);
        this.initSubSessions();
    }

    public void loginComponent(String[] args) throws Exception {
        this.readLoginInfo(args, false);
        this._compFactory = new CollaborationSessionFactory("com.sun.im.service.xmpp.XMPPComponentSessionProvider");
        CollaborationSessionProvider sprovider = this._compFactory.getCollaborationSessionProvider();
        ApplicationInfo appinfo = new ApplicationInfo();
        appinfo.setCategory("component");
        appinfo.setType("generic");
        sprovider.setApplicationInfo(appinfo);
        this._session = this._compFactory.getSession(this.server, this.user, this.password, this);
        if (_serviceModel) {
            this._messageService = this._session.getNotificationService();
            this._messageService.initialize(this);
        } else {
            this._messageService = (NotificationService)((Object)this._session.accessService("notification"));
        }
        this._principal = this._session.getPrincipal();
    }

    public void registerGateway(String[] args) throws Exception {
        if (args.length > 0 && args[0].equals("?")) {
            System.out.println("rgw username password");
            return;
        }
        Map m = this.listGateways(args);
        String gatewayChoice = this.prompt("Enter the gateway of your choice: ", false);
        PersonalGateway gateway = (PersonalGateway)m.get(gatewayChoice);
        Object user = null;
        Object password = null;
        if (gateway == null) {
            System.out.println("Gateway was not found");
            return;
        }
        gateway.register(new ShellRegistrationListener(this));
    }

    public void unregisterGateway(String[] args) throws Exception {
        if (args.length > 0 && args[0].equals("?")) {
            System.out.println("rgw username password");
            return;
        }
        System.out.println("List of Registered gateways");
        Iterator i = this._personalStoreService.getEntries("gateway").iterator();
        while (i.hasNext()) {
            PersonalGateway gateWayEntry = (PersonalGateway)i.next();
            System.out.println(" -" + gateWayEntry.getHostName());
        }
        String gatewayName = this.prompt("Gateway to un-register : ", false);
        PersonalGateway gateway = (PersonalGateway)this._personalStoreService.getEntry("gateway", gatewayName);
        if (gateway == null) {
            System.out.println("Gateway " + gatewayName + " was not found");
            return;
        }
        gateway.unregister(new ShellRegistrationListener(this));
    }

    public void registerUser(String[] args) throws Exception {
        if (args.length > 0 && args[0].equals("?")) {
            System.out.println("ru server");
            return;
        }
        String server = null;
        server = args.length >= 1 ? args[0] : this.prompt("IM Service : ", false);
        CollaborationSessionProvider sessionProvider = this._factory.getCollaborationSessionProvider();
        sessionProvider.register(server, new ShellRegistrationListener(this));
    }

    public void unregisterUser(String[] args) throws Exception {
        this._session.unregister(new ShellRegistrationListener(this));
    }

    public void changeUserPassword(String[] args) throws Exception {
        if (args.length > 0 && args[0].equals("?")) {
            System.out.println("cup server");
            return;
        }
        String password = null;
        password = args.length >= 1 ? args[0] : this.prompt("New Password : ", false);
        this._session.changePassword(password, new ShellRegistrationListener(this));
    }

    public Map listGateways(String[] args) throws Exception {
        if (args.length > 0 && args[0].equals("?")) {
            System.out.println("lgw");
            return null;
        }
        System.out.println("List of available gateways");
        PersonalStoreEntry[] pgw = this._personalStoreService.search(1, "*", "gateway");
        HashMap<String, PersonalStoreEntry> m = new HashMap<String, PersonalStoreEntry>();
        for (int i = 0; i < pgw.length; ++i) {
            System.out.println(i + 1 + ") " + pgw[i].getEntryId() + " <" + ((PersonalGateway)pgw[i]).getService() + ">");
            m.put(new Integer(i + 1).toString(), pgw[i]);
        }
        return m;
    }

    public Map listRegisteredGateways(String[] args) throws Exception {
        if (args.length > 0 && args[0].equals("?")) {
            System.out.println("lgw");
            return null;
        }
        System.out.println("List of Registered gateways");
        int j = 0;
        HashMap<String, PersonalGateway> m = new HashMap<String, PersonalGateway>();
        Iterator i = this._personalStoreService.getEntries("gateway").iterator();
        while (i.hasNext()) {
            PersonalGateway gateWayEntry = (PersonalGateway)i.next();
            System.out.println(j + 1 + ") " + gateWayEntry.getHostName() + " <" + gateWayEntry.getService() + ">");
            m.put(new Integer(j + 1).toString(), gateWayEntry);
        }
        return m;
    }

    public void onPresenceInfo(String presenceInfo) {
        PresenceHelper ph = null;
        try {
            ph = new PresenceHelper(presenceInfo);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        ArrayList tuples = (ArrayList)ph.getTuples();
        for (int i = 0; i < tuples.size(); ++i) {
            PresenceTuple t = (PresenceTuple)tuples.get(i);
            if (t.getNote() != null && t.getNote().length() > 0) {
                System.out.println("\n[Presence Info Received] Recipient=<" + this._principal.getUID() + "> Destination=<" + t.getContact() + "> Status=<" + t.getStatus() + "> Note=<" + t.getNote() + ">");
                continue;
            }
            System.out.println("\n[Presence Info Received] Recipient=<" + this._principal.getUID() + "> Destination=<" + t.getContact() + "> Status=<" + t.getStatus() + ">");
        }
    }

    private void publishPresenceInfo(String[] args) throws Exception {
        if (args.length > 0 && args[0].equals("?")) {
            System.out.println("ppi status  - publish presence status");
            return;
        }
        String status = args.length >= 1 ? args[0] : this.prompt("New presence status (OPEN, CLOSED, AWAY, IDLE, FORWARDED): ", false);
        String address = args.length >= 2 ? args[1] : this.prompt("Entity (Enter if this user): ", false);
        if (address.trim().length() == 0) {
            address = this._principal.getUID();
        }
        String note = this.prompt("Optional note: ", false);
        PresenceTuple pt = new PresenceTuple();
        pt.setContact(address);
        pt.setStatus(status);
        if (note != null && note.length() > 0) {
            pt.addNote(note);
        }
        Presence p = new Presence(pt);
        this._presenceService.publish(p);
    }

    public void fetchPresenceInfo(String[] args) throws Exception {
        if (args.length > 0 && args[0].equals("?")) {
            System.out.println("fpi [ entity ]");
            return;
        }
        if (args.length >= 1) {
            String[] entities = args;
        } else {
            String[] entities = this.promptValues("Entities (space-sparated): ", false, null);
        }
    }

    public void fetchPresence(String[] args) throws Exception {
        if (args.length > 0 && args[0].equals("?")) {
            System.out.println("fp [ entity ]");
            return;
        }
        String[] entities = args.length >= 1 ? args : this.promptValues("Entities (space-sparated): ", false, null);
        Presence p = null;
        try {
            if (entities.length > 1) {
                Presence[] ps = this._presenceService.fetchPresence(entities);
            } else {
                p = this._presenceService.fetchPresence(entities[0]);
            }
            this.printPresence(p);
        }
        catch (Exception e) {
            System.out.println("Cannot fetch presence information");
        }
    }

    public void subscribePresenceInfo(String[] args) throws Exception {
        if (args.length > 0 && args[0].equals("?")) {
            System.out.println("spi [ entity ]");
            return;
        }
        String[] entities = args.length >= 1 ? args : this.promptValues("Entities (space-sparated): ", false, null);
        if (entities.length > 1) {
            this._presenceService.subscribe(entities);
        } else {
            this._presenceService.subscribe(entities[0]);
        }
    }

    public void unsubscribePresenceInfo(String[] args) throws Exception {
        if (args.length > 0 && args[0].equals("?")) {
            System.out.println("uspi [ entity ]");
            return;
        }
        String[] entities = args.length >= 1 ? args : this.promptValues("Entities (space-sparated): ", false, null);
        if (entities.length > 1) {
            this._presenceService.unsubscribe(entities);
        } else {
            this._presenceService.unsubscribe(entities[0]);
        }
    }

    public void onCompletion() {
    }

    private PresenceAccessRule displayPresenceAcl() throws Exception {
        PresenceAccessRule par = (PresenceAccessRule)this._presenceService.getAccessRules(this._principal.getUID()).iterator().next();
        if (par.grant()) {
            System.out.println("This is a grant rule");
        } else {
            System.out.println("This is a deny rule");
        }
        System.out.println("Exceptions: ");
        Collection exceptPrincipals = par.getExceptPrincipals();
        Iterator i = exceptPrincipals.iterator();
        while (i.hasNext()) {
            System.out.println("    " + ((CollaborationPrincipal)i.next()).getUID());
        }
        System.out.println();
        return par;
    }

    public void showPresenceAcl(String[] args) throws Exception {
        this.displayPresenceAcl();
    }

    private void editPresenceAcl(String[] args) throws Exception {
        String uid;
        if (args.length > 0 && args[0].equals("?")) {
            System.out.println("pacl [ grant/deny ]");
            return;
        }
        System.out.println("Current presence access rule:");
        PresenceAccessRule par = this.displayPresenceAcl();
        boolean defaultAccess = par.grant();
        if (args.length > 0) {
            if (args[0].equalsIgnoreCase("deny")) {
                defaultAccess = false;
            } else if (args[0].equalsIgnoreCase("grant")) {
                defaultAccess = true;
            }
        }
        par.setGrant(defaultAccess);
        while ((uid = this.prompt("Remove exception for user (newline to skip): ", false)).length() > 1) {
            par.removeExceptPrincipal(uid);
        }
        while ((uid = this.prompt("Add exception for user (newline to skip): ", false)).length() > 1) {
            par.addExceptPrincipal(uid);
        }
        this._presenceService.saveAccessRules();
    }

    private void listPrivacyList(String[] args) throws Exception {
        if (args.length > 0 && args[0].equals("?")) {
            System.out.println("lpl");
            return;
        }
        System.out.println("Current privacy list");
        List l = this._session.listPrivacyLists();
        Iterator i = l.iterator();
        while (i.hasNext()) {
            System.out.println("- " + i.next());
        }
    }

    private void getPrivacyList(String[] args) throws Exception {
        if (args.length > 0 && args[0].equals("?")) {
            System.out.println("gpl [ name ]");
            return;
        }
        String name = "test";
        name = args.length > 0 ? args[0] : this.prompt("Enter the name of the Privacy List: ", false);
        PrivacyList list = this._session.getPrivacyList(name);
        if (list == null) {
            System.out.println("No such privacy list could be found");
            return;
        }
        System.out.println("Current privacy");
        Collection c = list.getPrivacyItems();
        Iterator itr = c.iterator();
        while (itr.hasNext()) {
            PrivacyItem item = (PrivacyItem)itr.next();
            System.out.println("Type[ " + item.getType() + " ] Access [ " + item.getAccess() + " ] Resource [ " + item.getResource() + " ]");
            System.out.println(" - " + item.getSubject());
        }
    }

    private void removePrivacyList(String[] args) throws Exception {
        if (args.length > 0 && args[0].equals("?")) {
            System.out.println("rpl [ name ]");
            return;
        }
        String name = "test";
        name = args.length > 0 ? args[0] : this.prompt("Enter the name of the Privacy List: ", false);
        this._session.removePrivacyList(name);
    }

    private void setPrivacyList(String[] args) throws Exception {
        if (args.length > 0 && args[0].equals("?")) {
            System.out.println("spl [ name ]");
            return;
        }
        String name = "test";
        name = args.length > 0 ? args[0] : this.prompt("Enter the name of the Privacy List: ", false);
        PrivacyList list = null;
        try {
            list = this._session.getPrivacyList(name);
        }
        catch (Exception e) {
            // empty catch block
        }
        if (list != null) {
            String sIndex;
            System.out.println("Current privacy list " + name);
            Collection c = list.getPrivacyItems();
            PrivacyItem[] items = new PrivacyItem[c.size()];
            int i = 0;
            Iterator itr = c.iterator();
            while (itr.hasNext()) {
                PrivacyItem item = (PrivacyItem)itr.next();
                System.out.println("[" + i++ + "]\tType[ " + item.getType() + " ] Access [ " + item.getAccess() + " ] Resource [ " + item.getResource() + " ]");
                System.out.println(" - " + item.getSubject());
            }
            while ((sIndex = this.prompt("Remove item index: ", false)).length() > 1) {
                int index = Integer.parseInt(sIndex);
                if (index >= 0 && index < items.length) {
                    list.removePrivacyItem(items[index]);
                    continue;
                }
                System.out.println("index out of bounds");
            }
        } else {
            list = this._session.createPrivacyList(name);
            System.out.println("creating new list");
        }
        String yesOrNo = "no";
        yesOrNo = this.prompt("Add a privacy item? ", true, "no");
        while (yesOrNo.equalsIgnoreCase("yes")) {
            String sType = this.prompt("    type (jid|subscription|group): ", false);
            String sAction = this.prompt("    action (allow|deny):           ", false);
            String sValue = this.prompt("    value:                         ", false);
            String sRes = this.prompt("    resources (message,iq,p-out):   ", false);
            int action = 1;
            if (sAction.equalsIgnoreCase("deny")) {
                action = 2;
            }
            PrivacyItem item = list.createPrivacyItem(sType, action);
            item.setSubject(sValue);
            int resource = 0;
            if (sRes == null || sRes.trim().length() == 0) {
                resource = -1;
            } else {
                if (sRes.indexOf("message") >= 0) {
                    resource |= 4;
                }
                if (sRes.indexOf("iq") >= 0) {
                    resource |= 8;
                }
                if (sRes.indexOf("presence-in") >= 0) {
                    resource |= 1;
                }
                if (sRes.indexOf("presence-out") >= 0) {
                    resource |= 2;
                }
            }
            item.setResource(resource);
            list.addPrivacyItem(item);
            yesOrNo = this.prompt("Add a privacy item? ", true, "no");
        }
        this._session.addPrivacyList(list);
    }

    public void setConfName(Hashtable h) {
        this._confnames = h;
    }

    private ShellConference findConference(String name) throws Exception {
        String confname = (String)this._confnames.get(name);
        if (confname != null) {
            return (ShellConference)this._conferences.get(confname);
        }
        return (ShellConference)this._conferences.get(name);
    }

    private ShellNewsChannel findNewsChannel(String theName, boolean subscribe) throws Exception {
        ShellNewsChannel nc = null;
        String fqName = Shell.appendDomainToAddress(theName, "pubsub." + this._session.getPrincipal().getDomainName());
        String channelName = (String)this._confnames.get(fqName);
        nc = channelName != null ? (ShellNewsChannel)this._conferences.get(channelName) : (ShellNewsChannel)this._conferences.get(fqName);
        if (nc == null) {
            try {
                nc = new ShellNewsChannel(this._principal.getUID(), this._newsService, fqName, subscribe);
                this.assignLocalName(fqName, nc.getConference().getDestination());
            }
            catch (NoSuchElementException e) {
                // empty catch block
            }
            if (nc != null) {
                this._conferences.put(nc.getConference().getDestination(), nc);
            }
        }
        return nc;
    }

    private void invite(String[] args) throws Exception {
        if (args.length > 0 && args[0].equals("?")) {
            System.out.println("iuc [ conf [ users ] ]");
            System.out.println("invite message");
            return;
        }
        String roomname = args.length > 0 ? args[0] : this.prompt("Conference: ", false);
        String names = "";
        names = args.length >= 2 ? args[1] : this.prompt("User(s) to invite (space-separated): ", false);
        String ret = this.prompt("Invite message: ", true);
        if (ret.equals("")) {
            ret = "<empty>";
        }
        ret = "     " + ret;
        ShellConference c = this.findConference(roomname);
        if (c == null) {
            System.out.println("[" + this._principal.getUID() + "] Conference " + roomname + " not found");
            return;
        }
        Conference conf = c.getConference();
        this._conferences.put(conf.getDestination(), c);
        InviteMessage newMsg = conf.createInviteMessage();
        MessagePart part = newMsg.newPart();
        part.setContent(ret);
        newMsg.addPart(part);
        StringTokenizer st = new StringTokenizer(names);
        while (st.hasMoreTokens()) {
            newMsg.addRecipient(st.nextToken());
        }
        conf.invite(30, newMsg, this);
    }

    private void addConferenceMessage(String[] args) throws Exception {
        if (args.length > 0 && args[0].equals("?")) {
            System.out.println("amc [ conference ]");
            System.out.println("msg line");
            return;
        }
        Message newMsg = null;
        String name = args.length >= 1 ? args[0] : this.prompt("Conference: ", false);
        ShellConference c = this.findConference(name);
        if (c == null) {
            System.out.println("Conference " + name + " not found");
            return;
        }
        String ret = this.prompt("enter the message", true);
        Conference conf = c.getConference();
        newMsg = conf.createMessage();
        MessagePart part = newMsg.newPart();
        part.setContent(ret);
        part.setContent(ret, "text/html");
        newMsg.addPart(part);
        conf.addMessage(newMsg);
    }

    private void addPublicConference(String[] args) throws Exception {
        if (args.length > 0 && args[0].equals("?")) {
            System.out.println("apc [ conf ] ");
            return;
        }
        String name = args.length >= 1 ? args[0] : this.prompt("Conference: ", false);
        try {
            ShellConference c = new ShellConference(this._principal.getUID(), this._conferenceService, name, true, true);
            c.setShell(this);
            this._conferences.put(c.getConference().getDestination(), c);
            this.assignLocalName(name, c.getConference().getDestination());
            System.out.println("Created public conference " + name + "=" + c.getConference().getDestination());
            this._conferences.put(name, c);
        }
        catch (Exception e) {
            System.out.println("Cannot create conference: " + e.getMessage());
        }
    }

    private void joinPublicConference(String[] args) throws Exception {
        if (args.length > 0 && args[0].equals("?")) {
            System.out.println("jpc [ conf ] ");
            return;
        }
        String name = args.length >= 1 ? args[0] : this.prompt("Conference: ", false);
        ShellConference c = this.findConference(name);
        if (c == null) {
            c = new ShellConference(this._principal.getUID(), this._conferenceService, name, false, true);
            c.setShell(this);
            this._conferences.put(name, c);
        } else {
            c.getConference().join(c);
        }
        if (c != null) {
            System.out.println("[" + this._principal.getUID() + "] Joined conference " + c.getConference().getDestination());
        } else {
            System.out.println("Failed to join conference " + name);
        }
    }

    private void listSubscribedPublicConference(String[] args) throws Exception {
        Collection coll = this._personalStoreService.getEntries("conference");
        System.out.println("Listing subscribed conferences - START");
        if (coll != null) {
            Iterator i = coll.iterator();
            while (i.hasNext()) {
                PersonalConference pc = (PersonalConference)i.next();
                System.out.println("    " + pc.getDisplayName() + " <" + pc.getAddress() + ">");
            }
        }
        System.out.println("Listing subscribed conferences - END");
    }

    private void subscribePublicConference(String[] args) throws Exception {
        if (args.length > 0 && args[0].equals("?")) {
            System.out.println("spc [ conf ] ");
            return;
        }
        String name = args.length >= 1 ? args[0] : this.prompt("Conference: ", false);
        ShellConference c = this.findConference(name);
        if (c == null) {
            try {
                c = new ShellConference(this._principal.getUID(), this._conferenceService, name, false, false);
                c.setShell(this);
            }
            catch (Exception e) {
                System.out.println(e.getMessage());
                return;
            }
            this._conferences.put(name, c);
        }
        if (c != null) {
            Conference conf = c.getConference();
            PersonalConference pc = (PersonalConference)this._personalStoreService.createEntry("conference", conf.getDestination());
            pc.setAddress(conf.getDestination());
            pc.save();
        } else {
            System.out.println("Failed to locate conference " + name);
        }
    }

    private void unsubscribePublicConference(String[] args) throws Exception {
        if (args.length > 0 && args[0].equals("?")) {
            System.out.println("upc [ conf ] ");
            return;
        }
        String name = args.length >= 1 ? args[0] : this.prompt("Conference: ", false);
        ShellConference c = this.findConference(name);
        if (c == null) {
            c = new ShellConference(this._principal.getUID(), this._conferenceService, name, false, false);
            c.setShell(this);
            this._conferences.put(name, c);
        }
        if (c != null) {
            Conference conf = c.getConference();
            PersonalStoreEntry pc = this._personalStoreService.getEntry("conference", conf.getDestination());
            if (pc != null) {
                pc.remove();
            }
        } else {
            System.out.println("Failed to locate conference " + name);
        }
    }

    private void addConference(String[] args) throws Exception {
        if (args.length > 0 && args[0].equals("?")) {
            System.out.println("ac");
            return;
        }
        String name = args.length >= 1 ? args[0] : this.prompt("Conference: ", false);
        ShellConference c = new ShellConference(this._principal.getUID(), this._conferenceService, name);
        c.setShell(this);
        String fqName = Shell.appendDomainToAddress(name, "muc." + this._session.getPrincipal().getDomainName());
        this._conferences.put(c.getConference().getDestination(), c);
        this._conferences.put(name, c);
        this._conferences.put(fqName, c);
        this.assignLocalName(name, c.getConference().getDestination());
        System.out.println("[" + this._principal.getUID() + "] Created private conference " + name);
    }

    private void delRoom(String[] args) throws Exception {
        if (args.length > 0 && args[0].equals("?")) {
            System.out.println("rc [ conf ]");
            return;
        }
        String name = args.length >= 1 ? args[0] : this.prompt("Conference: ", false);
        ShellConference c = this.findConference(name);
        if (c == null) {
            c = new ShellConference(this._principal.getUID(), this._conferenceService, name, false, false);
            c.setShell(this);
            if (c.getConference() == null) {
                System.out.println("Conference " + name + " not found.");
                return;
            }
        }
        this._conferences.remove(c.getConference().getDestination());
        this._conferences.remove(name);
        c.getConference().close();
    }

    public void quitRoom(String[] args) throws Exception {
        if (args.length > 0 && args[0].equals("?")) {
            System.out.println("lc [ conference ]");
            return;
        }
        String name = args.length >= 1 ? args[0] : this.prompt("Conference: ", false);
        ShellConference conf = this.findConference(name);
        if (conf != null) {
            conf.getConference().leave();
            this._conferences.remove(conf.getConference().getDestination());
            this._conferences.remove(name);
        } else {
            System.out.println("Conference not found");
        }
    }

    public void onInvite(Conference conference, InviteMessage message) {
        if (conference.isPublic()) {
            System.out.println("\nYou have been invited to conference <" + conference.getDestination() + "> by <" + message.getOriginator() + ">");
        } else {
            System.out.println("\nYou have been invited to a private conference by <" + message.getOriginator() + ">");
        }
        try {
            if (this.getYesOrNo("Do you want to join?\n", true)) {
                String name;
                if (!conference.isPublic()) {
                    name = this.prompt("Enter a local name for this conference: ", false, true);
                    String confAddress = conference.getDestination();
                    this.assignLocalName(name, confAddress);
                    String fqName = Shell.appendDomainToAddress(name, Shell.getDomainFromAddress(confAddress, null));
                    this.assignLocalName(fqName, confAddress);
                } else {
                    name = conference.getDestination();
                    this.assignLocalNameIfSameDomain(conference.getDestination());
                }
                ShellConference c = new ShellConference(this._principal.getUID(), this._conferenceService, conference, name);
                c.setShell(this);
                this._conferences.put(conference.getDestination(), c);
                this._conferences.put(name, c);
                message.rsvp(true);
                System.out.println("[" + this._principal.getUID() + "] Joined conference " + name);
            } else {
                message.rsvp(false);
                System.out.println("\nDeclining invitation");
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            System.out.println("\n Exception thrown: Failed to join a Conference");
        }
    }

    public void onRsvp(String destination, Message message, boolean accepted) {
        this.onRsvp(destination, accepted);
        Shell.printMessage(message);
    }

    public void onRsvp(String destination, boolean accepted) {
        if (accepted) {
            System.out.println(destination + " accepted your invitation.");
        } else {
            System.out.println(destination + " declined your invitation.");
        }
    }

    private String accessToString(int access) {
        switch (access) {
            case 1: {
                return "NONE";
            }
            case 2: {
                return "LISTEN";
            }
            case 4: {
                return "PUBLISH";
            }
            case 30: {
                return "MANAGE";
            }
        }
        System.out.println("Invalid access level: " + access);
        return "UNKNOWN";
    }

    private int accessToVal(String access) throws Exception {
        if (access.equalsIgnoreCase("NONE")) {
            return 1;
        }
        if (access.equalsIgnoreCase("LISTEN")) {
            return 2;
        }
        if (access.equalsIgnoreCase("PUBLISH")) {
            return 4;
        }
        if (access.equalsIgnoreCase("MANAGE")) {
            return 30;
        }
        throw new Exception("invalid access level: " + access);
    }

    private void displayConferenceAcl(String[] args) throws Exception {
        if (args.length > 0 && args[0].equals("?")) {
            System.out.println("dcacl [ public-conference ]");
            return;
        }
        String name = args.length >= 1 ? args[0] : this.prompt("Conference: ", false);
        ShellConference c = this.findConference(name);
        if (c == null) {
            c = new ShellConference(this._principal.getUID(), this._conferenceService, name, false, false);
            c.setShell(this);
            this._conferences.put(name, c);
        }
        Conference conf = c.getConference();
        Map accessList = conf.listPrivileges();
        Iterator i = accessList.keySet().iterator();
        while (i.hasNext()) {
            String uid = (String)i.next();
            System.out.println("User [" + uid + "] has " + this.accessToString((Integer)accessList.get(uid)) + " access");
        }
    }

    private void editConferenceAcl(String[] args) throws Exception {
        String member;
        String sNewDefaultAccess;
        Conference conf;
        String sDefaultAccess;
        if (args.length > 0 && args[0].equals("?")) {
            System.out.println("cacl [ public-conference ]");
            return;
        }
        String name = args.length >= 1 ? args[0] : this.prompt("Conference: ", false);
        ShellConference c = this.findConference(name);
        if (c == null) {
            c = new ShellConference(this._principal.getUID(), this._conferenceService, name, false, false);
            c.setShell(this);
            this._conferences.put(name, c);
        }
        if (!(sDefaultAccess = this.accessToString((conf = c.getConference()).getDefaultPrivilege())).equals(sNewDefaultAccess = this.prompt("Default access [" + sDefaultAccess + "] : ", false, sDefaultAccess))) {
            conf.setDefaultPrivilege(this.accessToVal(sNewDefaultAccess));
        }
        while (!(member = this.prompt("Modify Access for: ", false)).equals("")) {
            String sAccess = this.accessToString(conf.getPrivilege(member));
            String sNewAccess = this.prompt("New access level [" + sAccess + "]: ", false, sAccess);
            try {
                conf.setPrivilege(member, this.accessToVal(sNewAccess));
            }
            catch (Exception e) {
                System.out.println("Cannot set privilege for: " + name);
            }
        }
    }

    private void getDestinationProperty(String[] args) throws Exception {
        String att;
        if (args.length > 0 && args[0].equals("?")) {
            System.out.println("rmdp [ conference ]");
            return;
        }
        String name = args.length >= 1 ? args[0] : this.prompt("Conference: ", false);
        ShellConference c = this.findConference(name);
        if (c == null) {
            c = new ShellConference(this._principal.getUID(), this._conferenceService, name, false, false);
            c.setShell(this);
            this._conferences.put(name, c);
        }
        Conference conf = c.getConference();
        while (!(att = this.prompt("Property : ", false)).equals("")) {
            System.out.println("    " + att + " = " + conf.getProperty(att));
        }
    }

    private void removeDestinationProperty(String[] args) throws Exception {
        String att;
        if (args.length > 0 && args[0].equals("?")) {
            System.out.println("rmcp [ conference ]");
            return;
        }
        String name = args.length >= 1 ? args[0] : this.prompt("Conference: ", false);
        ShellConference c = this.findConference(name);
        if (c == null) {
            c = new ShellConference(this._principal.getUID(), this._conferenceService, name, false, false);
            c.setShell(this);
            this._conferences.put(name, c);
        }
        Conference conf = c.getConference();
        while (!(att = this.prompt("Property : ", false)).equals("")) {
            conf.setProperty(att, null);
        }
    }

    private void setDestinationProperty(String[] args) throws Exception {
        String att;
        if (args.length > 0 && args[0].equals("?")) {
            System.out.println("cacl [ conference ]");
            return;
        }
        String name = args.length >= 1 ? args[0] : this.prompt("Conference: ", false);
        ShellConference c = this.findConference(name);
        if (c == null) {
            c = new ShellConference(this._principal.getUID(), this._conferenceService, name, false, false);
            c.setShell(this);
            this._conferences.put(name, c);
        }
        Conference conf = c.getConference();
        while (!(att = this.prompt("Property : ", false)).equals("")) {
            String val = this.prompt("Value    : ", false);
            conf.setProperty(att, val);
        }
    }

    public void listPublicConferences(String[] args) throws Exception {
        PersonalStoreEntry[] pc = this._personalStoreService.search(0, "*", "conference");
        System.out.println("Listing public conferences - START");
        if (pc != null) {
            for (int i = 0; i < pc.length; ++i) {
                PersonalConference c = (PersonalConference)pc[i];
                System.out.println("    " + c.getDisplayName() + " <" + c.getAddress() + ">");
            }
        }
        System.out.println("Listing public conferences - END");
    }

    public void moderateRoom(String[] args) throws Exception {
        if (args.length > 0 && args[0].equals("?")) {
            System.out.println("mc [ conference ] [start | stop]");
            return;
        }
        String name = args.length >= 1 ? args[0] : this.prompt("Conference: ", false);
        String state = args.length >= 2 ? args[1] : this.prompt("[start|stop]: ", false);
        ShellConference c = this.findConference(name);
        if (c == null) {
            System.out.println("Conference " + name + " not found");
            return;
        }
        Conference conf = c.getConference();
        if (state.equalsIgnoreCase("start")) {
            conf.moderate(true);
        } else {
            conf.moderate(false);
        }
    }

    public void addModeratedMessage(String[] args) throws Exception {
        if (args.length > 0 && args[0].equals("?")) {
            System.out.println("ammc [ conference ]");
            System.out.println("msg line");
            return;
        }
        Message newMsg = null;
        String name = args.length >= 1 ? args[0] : this.prompt("Conference: ", false);
        ShellConference c = this.findConference(name);
        if (c == null) {
            System.out.println("Conference " + name + " not found");
            return;
        }
        String ret = this.prompt("enter the message", true);
        Conference conf = c.getConference();
        newMsg = conf.createMessage();
        MessagePart part = newMsg.newPart();
        part.setContent(ret);
        part.setContent(ret, "text/html");
        newMsg.addPart(part);
        conf.addModeratedMessage(newMsg, 32, null);
    }

    public void handleModeratedMessage(Conference conf, Message message, int status) throws Exception {
        if (status == 32) {
            conf.addModeratedMessage(message, 34, "waiting for approval");
            String nextStatus = this.prompt("Option (approve, reject, modify)[approve]: ", false, true);
            int s = 36;
            if ("REJECT".equalsIgnoreCase(nextStatus)) {
                s = 40;
            } else if ("MODIFY".equalsIgnoreCase(nextStatus)) {
                s = 38;
                MessagePart[] parts = message.getParts();
                String newMsg = this.prompt("enter modified message", true, parts[0].getContent(), true);
                parts[0].setContent(newMsg);
            }
            String reason = this.prompt("Reason for your decision: ", false, true);
            conf.addModeratedMessage(message, s, reason);
        }
    }

    public void listMembersInRoom(String[] args) throws Exception {
        String name = args.length >= 1 ? args[0] : this.prompt("Conference: ", false);
        ShellConference c = this.findConference(name);
        if (c == null) {
            c = new ShellConference(this._principal.getUID(), this._conferenceService, name, false, false);
            c.setShell(this);
            this._conferences.put(name, c);
        }
        Conference conf = c.getConference();
        Collection participants = conf.getParticipants();
        System.out.println("Number of participants - " + participants.size());
        Iterator i = participants.iterator();
        while (i.hasNext()) {
            System.out.println((String)i.next());
        }
    }

    private void addNewsMessage(String[] args) throws Exception {
        if (args.length > 0 && args[0].equals("?")) {
            System.out.println("amnc [ channel ]");
            System.out.println("subj line");
            System.out.println("msg line");
            return;
        }
        Message newMsg = null;
        String name = args.length >= 1 ? args[0] : this.prompt("News channel: ", false);
        ShellNewsChannel bb = this.findNewsChannel(name, true);
        if (bb == null) {
            System.out.println("News Channel " + name + " not found");
            return;
        }
        String topicSub = this.prompt("Subject: ", false);
        String ret = this.prompt("Message: ", true);
        if (ret.equals("")) {
            ret = "<empty>";
        }
        newMsg = bb.getConference().createMessage();
        MessagePart part = newMsg.newPart();
        newMsg.setHeader("subject", topicSub);
        part.setContent(ret);
        newMsg.addPart(part);
        try {
            bb.getConference().addMessage(newMsg);
        }
        catch (Exception e) {
            System.out.println("Exception thrown in addMessage");
        }
    }

    public void delNewsMessage(String[] args) throws Exception {
        if (args.length > 0 && args[0].equals("?")) {
            System.out.println("dmnc [ channel ]");
            System.out.println("[id]");
            return;
        }
        String name = args.length >= 1 ? args[0] : this.prompt("News channel: ", false);
        ShellNewsChannel bb = this.findNewsChannel(name, true);
        if (bb == null) {
            System.out.println("News channel " + name + " not found.");
            return;
        }
        String simpleId = "<unknown>";
        if (args.length >= 2) {
            simpleId = args[1];
        } else {
            bb.listMessages();
            simpleId = this.prompt("Id of the message delete: ", false);
        }
        String origId = (String)bb._numberToMessageId.get(simpleId);
        if (origId != null) {
            ((NewsChannel)bb.getConference()).removeMessage(origId);
            bb._messages.remove(origId);
            bb._numberToMessageId.remove(simpleId);
            bb._messageIdToNumber.remove(origId);
        } else {
            System.out.println("No message with this id: " + simpleId);
        }
    }

    public void addNewsChannel(String[] args) throws Exception {
        if (args.length > 0 && args[0].equals("?")) {
            System.out.println("cnc [ channel ]");
            return;
        }
        String name = args.length >= 1 ? args[0] : this.prompt("News channel: ", false);
        ShellNewsChannel nc = this.findNewsChannel(name, true);
        try {
            ShellNewsChannel bb = new ShellNewsChannel(this._principal.getUID(), this._newsService, name, 4);
            this._conferences.put(bb.getConference().getDestination(), bb);
        }
        catch (Exception e) {
            e.printStackTrace();
            System.out.println("Cannot create news channel: " + e.getMessage());
        }
    }

    public void subscribeNewsChannel(String[] args) throws Exception {
        if (args.length > 0 && args[0].equals("?")) {
            System.out.println("snc [ channel ]");
            return;
        }
        String name = args.length >= 1 ? args[0] : this.prompt("News channel: ", false);
        ShellNewsChannel bb = this.findNewsChannel(name, true);
        if (bb == null) {
            System.out.println("News channel " + name + " not found.");
            return;
        }
        System.out.println("subscribed to " + name);
    }

    public void unSubscribeNewsChannel(String[] args) throws Exception {
        if (args.length > 0 && args[0].equals("?")) {
            System.out.println("unc [ channel ]");
            return;
        }
        String name = args.length >= 1 ? args[0] : this.prompt("News channel: ", false);
        ShellNewsChannel bb = this.findNewsChannel(name, false);
        String fqName = Shell.appendDomainToAddress(name, "pubsub." + this._session.getPrincipal().getDomainName());
        if (bb == null) {
            System.out.println("News channel " + name + " not found.");
            return;
        }
        bb.getConference().leave();
        this._conferences.remove(fqName);
        bb._messages.clear();
        bb._messageIdToNumber.clear();
        bb._numberToMessageId.clear();
        System.out.println("unsubscribed from " + fqName);
    }

    public void listNewsChannels(String[] args) throws Exception {
        Collection bbList = this._newsService.listNewsChannels();
        System.out.println("Listing news channels - START");
        if (bbList != null) {
            Iterator bbIter = bbList.iterator();
            while (bbIter.hasNext()) {
                NewsChannel bb = (NewsChannel)bbIter.next();
                System.out.println("    " + bb.getDestination());
            }
        }
        System.out.println("Listing news channels - END");
    }

    public void listManagedNewsChannels(String[] args) throws Exception {
        Collection bbList = this._newsService.listNewsChannels(30);
        System.out.println("Listing news channels - START");
        if (bbList != null) {
            Iterator bbIter = bbList.iterator();
            while (bbIter.hasNext()) {
                NewsChannel bb = (NewsChannel)bbIter.next();
                System.out.println("    " + bb.getDestination());
            }
        }
        System.out.println("Listing news channels - END");
    }

    public void getSubscribedNewsChannels(String[] args) throws Exception {
        Collection bbList = this._newsService.getSubscribedNewsChannels();
        System.out.println("Listing news channels - START");
        if (bbList != null) {
            Iterator bbIter = bbList.iterator();
            while (bbIter.hasNext()) {
                NewsChannel bb = (NewsChannel)bbIter.next();
                System.out.println("    " + bb.getDestination());
            }
        }
        System.out.println("Listing news channels - END");
    }

    public void listNewsPrivileges(String[] args) throws Exception {
        if (args.length > 0 && args[0].equals("?")) {
            System.out.println("unc [ channel ]");
            return;
        }
        String name = args.length >= 1 ? args[0] : this.prompt("News channel: ", false);
        ShellNewsChannel bb = this.findNewsChannel(name, false);
        if (bb == null) {
            System.out.println("News channel " + name + " not found.");
            return;
        }
        Map privMap = bb.getConference().listPrivileges();
        System.out.println("Listing privilges of news channel - START");
        if (privMap != null) {
            Iterator i = privMap.keySet().iterator();
            while (i.hasNext()) {
                String userID = (String)i.next();
                Integer accesslevel = (Integer)privMap.get(userID);
                System.out.println("User " + userID + " has access " + this.accessInt2accessS(accesslevel));
            }
        }
        System.out.println("Listing privilges of news channel - END");
    }

    public void setNewsPrivileges(String[] args) throws Exception {
        if (args.length > 0 && args[0].equals("?")) {
            System.out.println("unc [ channel ]");
            return;
        }
        String name = args.length >= 1 ? args[0] : this.prompt("News channel: ", false);
        ShellNewsChannel bb = this.findNewsChannel(name, false);
        if (bb == null) {
            System.out.println("News channel " + name + " not found.");
            return;
        }
        HashMap<String, Integer> user2Access = new HashMap<String, Integer>();
        String userID = null;
        String access = null;
        int accesslevel = -1;
        while (!(userID = this.prompt("User (return if no more):", false)).equals("") && !(access = this.prompt("Access Level[NONE,LISTEN,PUBLISH,MANAGE]:", false)).equals("")) {
            accesslevel = this.accessS2accessInt(access);
            user2Access.put(userID, new Integer(accesslevel));
        }
        ((NewsChannel)bb.getConference()).setPrivileges(user2Access);
    }

    public void getNewsConfiguration(String[] args) throws Exception {
        if (args.length > 0 && args[0].equals("?")) {
            System.out.println("gnc [ channel ]");
            return;
        }
        String name = args.length >= 1 ? args[0] : this.prompt("News channel: ", false);
        ShellNewsChannel bb = this.findNewsChannel(name, false);
        if (bb == null) {
            System.out.println("news channel " + name + " not found");
            return;
        }
    }

    public void getNewsPrivilege(String[] args) throws Exception {
        if (args.length > 0 && args[0].equals("?")) {
            System.out.println("gunc [ channel ]");
            return;
        }
        String name = args.length >= 1 ? args[0] : this.prompt("News channel: ", false);
        ShellNewsChannel bb = this.findNewsChannel(name, false);
        if (bb == null) {
            System.out.println("news channel " + name + " not found");
            return;
        }
        System.out.println(this.accessInt2accessS(bb.getConference().getPrivilege()));
    }

    public void setNewsPrivilege(String[] args) throws Exception {
        if (args.length > 0 && args[0].equals("?")) {
            System.out.println("sunc [ channel ]");
            return;
        }
        String name = args.length >= 1 ? args[0] : this.prompt("News channel: ", false);
        ShellNewsChannel bb = this.findNewsChannel(name, false);
        if (bb == null) {
            System.out.println("news channel " + name + " not found");
            return;
        }
        int accesslevel = -1;
        String access = args.length >= 2 ? args[1] : this.prompt("Access Level[NONE,LISTEN,PUBLISH,MANAGE]:", false);
        accesslevel = this.accessS2accessInt(access);
        bb.getConference().setPrivilege(this._session.getPrincipal().getUID(), accesslevel);
    }

    public void getDefaultNewsPrivilege(String[] args) throws Exception {
        if (args.length > 0 && args[0].equals("?")) {
            System.out.println("gnc [ channel ]");
            return;
        }
        String name = args.length >= 1 ? args[0] : this.prompt("News channel: ", false);
        ShellNewsChannel bb = this.findNewsChannel(name, false);
        if (bb == null) {
            System.out.println("news channel " + name + " not found");
            return;
        }
        int defaultAccess = bb.getConference().getDefaultPrivilege();
        System.out.println("DEFAULT ACCESS ====" + this.accessInt2accessS(defaultAccess));
    }

    public void setDefaultNewsPrivilege(String[] args) throws Exception {
        if (args.length > 0 && args[0].equals("?")) {
            System.out.println("gnc [ channel ]");
            return;
        }
        String name = args.length >= 1 ? args[0] : this.prompt("News channel: ", false);
        int accesslevel = -1;
        String access = args.length >= 2 ? args[1] : this.prompt("Access Level[NONE,LISTEN,PUBLISH,MANAGE]:", false);
        accesslevel = this.accessS2accessInt(access);
        ShellNewsChannel bb = this.findNewsChannel(name, false);
        if (bb == null) {
            System.out.println("news channel " + name + " not found");
            return;
        }
        bb.getConference().setDefaultPrivilege(accesslevel);
    }

    public void delNewsChannel(String[] args) throws Exception {
        if (args.length > 0 && args[0].equals("?")) {
            System.out.println("rnc [ channel ]");
            return;
        }
        String name = args.length >= 1 ? args[0] : this.prompt("News channel: ", false);
        ShellNewsChannel bb = this.findNewsChannel(name, false);
        if (bb == null) {
            System.out.println("news channel " + name + " not found");
            return;
        }
        bb.getConference().close();
        bb._messages.clear();
        bb._messageIdToNumber.clear();
        bb._numberToMessageId.clear();
        String fqName = Shell.appendDomainToAddress(name, "pubsub." + this._principal.getDomainName());
        this._conferences.remove(fqName);
        System.out.println("News Channel " + fqName + " deleted");
    }

    private void listMessages(String[] args) throws Exception {
        if (args.length > 0 && args[0].equals("?")) {
            System.out.println("lmnc [ channel ]");
            return;
        }
        String name = args.length >= 1 ? args[0] : this.prompt("News channel: ", false);
        ShellNewsChannel bb = this.findNewsChannel(name, true);
        if (bb == null) {
            System.out.println("News channel " + name + " not found.");
            return;
        }
        bb.listMessages();
    }

    private void sendMessage(String[] args) throws Exception {
        String filename;
        if (args.length > 0 && args[0].equals("?")) {
            System.out.println("send [ users ]");
            System.out.println("subj line");
            System.out.println("msg line");
            return;
        }
        Message newMsg = null;
        String names = "";
        if (args.length >= 1) {
            names = names + args[0];
            for (int i = 1; i < args.length; ++i) {
                names = names + " " + args[i];
            }
        } else {
            names = this.prompt("recipient list (space-separated): ", false);
        }
        String sub = this.prompt("Subject: ", false);
        String ct = this.prompt("Content-Type [text/plain]: ", false, "text/plain");
        String ret = this.prompt("Message: ", true);
        newMsg = this._messageService.createMessage();
        newMsg.setHeader("subject", sub);
        newMsg.setContent(ret, ct);
        if ("text/html".equalsIgnoreCase(ct)) {
            newMsg.setContent(htmlConverter.convertToText(ret));
        }
        StringTokenizer st = new StringTokenizer(names);
        while (st.hasMoreTokens()) {
            String name = st.nextToken();
            newMsg.addRecipient(name);
        }
        newMsg.addPart(newMsg);
        while (!(filename = this.prompt("Attach File: ", false)).equals("")) {
            File f = new File(filename);
            if (f.exists()) {
                MessagePart mp = newMsg.newPart();
                String enc = this.prompt("Encoding [UTF-8]: ", false, "UTF-8");
                mp.setContent(new FileInputStream(f), enc);
                mp.setContentName(f.getName());
                newMsg.addPart(mp);
                continue;
            }
            System.out.println("File not found: " + f.getAbsolutePath());
        }
        this._messageService.sendMessage(newMsg, this);
    }

    public void onMessage(Message message) {
        System.out.println("[Message Received] Recipient=<" + this._principal.getUID() + "> From=<" + message.getOriginator() + ">");
        try {
            if (message.getContentType() != null && (message.getContentType().equalsIgnoreCase("application/x-iim-poll") || message.getContentType().equalsIgnoreCase("application/x-iim-poll-reply"))) {
                String content = message.getContent();
                PollHelper ph = new PollHelper(content);
                int noOfAnswers = ph.countAnswers();
                System.out.println("Poll Question: " + ph.getQuestion());
                System.out.println("Answers: ");
                for (int i = 0; i < noOfAnswers; ++i) {
                    System.out.println(i + " " + ph.getAnswer(i));
                }
            } else {
                Shell.printMessage(message);
                message.sendStatus(1);
            }
            this._receivedMessages.addElement(message);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void sendMessageReply(String[] args) throws Exception {
        if (this._receivedMessages.isEmpty()) {
            return;
        }
        Message message = (Message)this._receivedMessages.firstElement();
        System.out.println("Replying to " + message.getOriginator());
        Message newMsg = this._messageService.createMessage(message.getOriginator());
        String sub = this.prompt("Subject: ", true);
        String ret = this.prompt("Message: ", true);
        newMsg.setHeader("subject", sub);
        MessagePart part = newMsg.newPart();
        part.setContent(ret);
        newMsg.addPart(part);
        message.sendReply(newMsg);
        this._receivedMessages.remove(message);
    }

    private void sendMessageStatus(String[] args) throws Exception {
        if (this._receivedMessages.isEmpty()) {
            return;
        }
        Message message = (Message)this._receivedMessages.firstElement();
        this._receivedMessages.remove(message);
        try {
            message.sendStatus(7);
        }
        catch (Exception e) {
            System.out.println("Exception thrown in sendMessageStatus");
        }
    }

    public boolean onX509Certificate(X509Certificate[] chain) {
        return true;
    }

    public boolean Ask_onX509Certificate(X509Certificate[] chain) {
        StringBuffer chainS = new StringBuffer();
        chainS.append("Untrusted certificate received from server:\n");
        chainS.append("---------------------\n");
        for (int i = 0; i < chain.length; ++i) {
            chainS.append("\nIssuer DN: " + chain[i].getIssuerDN());
            chainS.append("\nSubject DN: " + chain[i].getSubjectDN());
            chainS.append("\nValidity: from " + chain[i].getNotBefore() + " to " + chain[i].getNotAfter());
            chainS.append("\n---------------------\n");
        }
        System.out.println(chainS.toString());
        try {
            return this.getYesOrNo("Do you trust this certificate? ", true);
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
    }

    public void onError(String pURL, String errorText) {
        System.out.println("[Presence Service Error] Destination=" + pURL + " cause=" + errorText);
    }

    public void onError(CollaborationException e) {
        e.printStackTrace();
        this._session = null;
        this._presenceService = null;
        this._newsService = null;
        this._conferenceService = null;
        this._messageService = null;
        this._personalStoreService = null;
        this._principal = null;
    }

    public boolean onReceipt(String destination, int deliveryStatus) {
        System.out.println("[Message Status Received] Recipient=<" + this._principal.getUID() + "> From=<" + destination + "> Status=<" + deliveryStatus + ">");
        return true;
    }

    public void onReply(Message message) {
        try {
            if (message.getContentType() != null && (message.getContentType().equalsIgnoreCase("application/x-iim-poll-reply") || message.getContentType().equalsIgnoreCase("application/x-iim-poll"))) {
                PollResponse pr = new PollResponse(message.getContent());
                Poll ph = (Poll)this._polls.get(pr.getPollID());
                System.out.println("[Poll Reply Received] Recipient=<" + this._principal.getUID() + "> Question=<" + ph.getQuestion() + "> Answer=<" + ph.parseAnswer(message.getContent()) + ">");
            } else {
                Shell.printMessage(message);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            System.exit(1);
        }
    }

    private void sendPollMessage(String[] args) throws Exception {
        String answer;
        String names;
        if (args.length > 0 && args[0].equals("?")) {
            System.out.println("poll [ users ]");
            return;
        }
        if (args.length >= 2) {
            names = args[1];
            for (int i = 2; i < args.length; ++i) {
                names = names + " " + args[i];
            }
        } else {
            names = this.prompt("To: ", false);
        }
        String question = this.prompt("Question: ", false);
        ArrayList<String> answers = new ArrayList<String>();
        while (!(answer = this.prompt("Answer (return if no more):", false)).equals("")) {
            answers.add(answer);
        }
        boolean allowCustom = false;
        String sCustom = this.prompt("Allow custom answers? (y/n): ", false);
        if (sCustom.equalsIgnoreCase("y")) {
            allowCustom = true;
        }
        Poll helper = new Poll(question, answers, allowCustom);
        Message message = this._messageService.createMessage();
        message.setContentType("application/x-iim-poll");
        message.setContent(helper.toString());
        StringTokenizer st = new StringTokenizer(names);
        while (st.hasMoreTokens()) {
            String name = st.nextToken();
            message.addRecipient(name);
        }
        this._polls.put(helper.getPollID(), helper);
        this._messageService.sendMessage(message, this);
    }

    private void sendPollResponse(String[] args) throws Exception {
        if (args.length > 0 && args[0].equals("?")) {
            System.out.println("pollr");
            return;
        }
        if (this._receivedMessages.isEmpty()) {
            return;
        }
        Message message = (Message)this._receivedMessages.firstElement();
        PollHelper helper = new PollHelper(message.getContent());
        System.out.println("Poll Question: " + helper.getQuestion());
        int noOfAnswers = helper.countAnswers();
        System.out.println("Answers: ");
        for (int i = 0; i < noOfAnswers; ++i) {
            System.out.println(i + " " + helper.getAnswer(i));
        }
        int iAnswer = -1;
        String answer = this.prompt("Index of the answer of your choice: ", false);
        try {
            iAnswer = new Integer(answer);
        }
        catch (Exception e) {
            answer = this.prompt("Custom answer: ", false);
        }
        Message reply = this._messageService.createMessage(message.getOriginator());
        reply.setContentType("application/x-iim-poll-reply");
        message.setContentType("application/x-iim-poll-reply");
        if (iAnswer >= 0) {
            reply.setContent(helper.createResponse(iAnswer));
        } else {
            reply.setContent(helper.createResponse(answer));
        }
        message.sendReply(reply);
        this._receivedMessages.remove(message);
    }

    private Collection getFolders(String[] args) throws Exception {
        Collection folders;
        if (args.length > 0) {
            CollaborationPrincipal p = this._session.createPrincipal(args[0]);
            folders = this._personalStoreService.getFolders(p, "abook");
        } else {
            folders = this._personalStoreService.getFolders("abook");
        }
        return folders;
    }

    private PersonalStoreFolder findFolder(Collection folders, String name) {
        Iterator i = folders.iterator();
        while (i.hasNext()) {
            PersonalStoreFolder f = (PersonalStoreFolder)i.next();
            if (!f.getDisplayName().equals(name)) continue;
            return f;
        }
        return null;
    }

    private void listContacts(String[] args) throws Exception {
        Collection folders = this.getFolders(args);
        Iterator i = folders.iterator();
        while (i.hasNext()) {
            PersonalStoreFolder f = (PersonalStoreFolder)i.next();
            Collection entries = f.getEntries();
            System.out.println(" - " + f.getDisplayName());
            Iterator j = entries.iterator();
            while (j.hasNext()) {
                PersonalStoreEntry c;
                PersonalStoreEntry e = (PersonalStoreEntry)j.next();
                if (e.getType() == "contact") {
                    c = (PersonalContact)e;
                    System.out.println("     - " + c.getDisplayName() + " <" + c.getAddress("im") + ">");
                    continue;
                }
                if (e.getType() == "group") {
                    c = (PersonalGroup)e;
                    System.out.println("     - " + c.getDisplayName() + " <" + c.getDistinguishedName() + ">");
                    continue;
                }
                System.out.println("     - " + e.getDisplayName() + " <" + e.getEntryId() + ">");
            }
        }
    }

    private void expandContactGroup(String[] args) throws Exception {
        PersonalGroup e;
        Collection folders = this.getFolders(args);
        String folder = this.prompt("Folder name          :", false);
        String id = this.prompt("Group id             :", false);
        PersonalStoreFolder f = this.findFolder(folders, folder);
        if (f == null) {
            System.out.println("No Such Folder: " + folder);
            return;
        }
        if (args.length > 0) {
            CollaborationPrincipal p = this._session.createPrincipal(args[0]);
            e = (PersonalGroup)this._personalStoreService.getEntry(p, "group", id);
        } else {
            e = (PersonalGroup)this._personalStoreService.getEntry("group", id);
        }
        if (e == null) {
            System.out.println("No Such Entry: " + id);
            return;
        }
        Collection c = e.expand();
        System.out.println("Listing group members - START");
        Iterator i = c.iterator();
        while (i.hasNext()) {
            CollaborationPrincipal principal = (CollaborationPrincipal)i.next();
            System.out.println("    " + principal.getDisplayName() + " <" + principal.getUID() + ">");
        }
        System.out.println("Listing group members - END");
    }

    private void searchEntries(String[] args) throws Exception {
        String type = this.prompt("Option (StartWith, EndsWith, Contains, Equals): ", false);
        String attribute = this.prompt("Option (mail, uid, name): ", false);
        String pattern = this.prompt("Search pattern: ", false);
        int searchType = 1;
        if (type.equalsIgnoreCase("startwith")) {
            searchType = 2;
        } else if (type.equalsIgnoreCase("endswith")) {
            searchType = 3;
        } else if (type.equalsIgnoreCase("contains")) {
            searchType = 1;
        } else if (type.equalsIgnoreCase("equals")) {
            searchType = 0;
        }
        int searchAttribute = 1;
        searchAttribute = attribute.equalsIgnoreCase("mail") ? 4 : (attribute.equalsIgnoreCase("uid") ? 2 : 1);
        PersonalStoreEntry[] entries = this._personalStoreService.search(searchType, pattern, "contact", searchAttribute);
        if (entries == null) {
            System.out.println("No entries found");
        } else {
            System.out.println("Start entries listing");
            for (int i = 0; i < entries.length; ++i) {
                PersonalStoreEntry entry = entries[i];
                if (entry.getType() == "contact") {
                    System.out.println("  " + entry.getDisplayName() + " (" + ((PersonalContact)entry).getAddress("im") + ")");
                    continue;
                }
                if (entry.getType() == "group") {
                    System.out.println("  " + entry.getDisplayName() + " (" + ((PersonalGroup)entry).getDistinguishedName() + ")");
                    continue;
                }
                System.out.println("  " + entry.getDisplayName() + " (" + entry.getEntryId() + ")");
            }
            System.out.println("End entries listing");
        }
    }

    private void addContact(String[] args) throws Exception {
        Collection folders = this.getFolders(args);
        String folder = this.prompt("Folder name: ", false);
        String name = this.prompt("Contact id: ", false);
        PersonalStoreFolder f = this.findFolder(folders, folder);
        if (f == null) {
            System.out.println("No such Folder: " + folder);
        }
        String localUID = Shell.getLocalPartFromAddress(name);
        CollaborationPrincipal[] searchResults = this._personalStoreService.searchPrincipals(0, localUID);
        boolean found = false;
        CollaborationPrincipal cp = null;
        if (searchResults != null) {
            for (int i = 0; i < searchResults.length; ++i) {
                cp = searchResults[i];
                if (!cp.getUID().equalsIgnoreCase(name)) continue;
                found = true;
                break;
            }
        }
        if (found) {
            PersonalContact entry = (PersonalContact)this._personalStoreService.getEntry("contact", name);
            if (entry == null) {
                entry = (PersonalContact)this._personalStoreService.createEntry("contact", cp.getDisplayName());
            }
            entry.addAddress("im", name, 0);
            entry.addToFolder(f);
            entry.save();
        } else {
            System.out.println("No entry found in the directory with the name " + name);
        }
    }

    public void addLegacyContact(String[] args) throws Exception {
        if (args.length > 0 && args[0].equals("?")) {
            System.out.println("alcon [ entity ]");
            return;
        }
        this.subscribePresenceInfo(args);
    }

    private void removeContact(String[] args) throws Exception {
        PersonalContact e;
        Collection folders = this.getFolders(args);
        String folder = this.prompt("Folder name: ", false);
        String id = this.prompt("Contact id: ", false);
        PersonalStoreFolder f = this.findFolder(folders, folder);
        if (f == null) {
            System.out.println("No Such Folder: " + folder);
            return;
        }
        if (args.length > 0) {
            CollaborationPrincipal p = this._session.createPrincipal(args[0]);
            e = (PersonalContact)this._personalStoreService.getEntry(p, "contact", id);
        } else {
            e = (PersonalContact)this._personalStoreService.getEntry("contact", id);
        }
        if (e == null) {
            System.out.println("No Such Entry: " + id);
            return;
        }
        e.removeFromFolder(f);
        e.save();
    }

    public void removeLegacyContact(String[] args) throws Exception {
        if (args.length > 0 && args[0].equals("?")) {
            System.out.println("rlcon [ entity ]");
            return;
        }
        this.unsubscribePresenceInfo(args);
    }

    private void addContactGroup(String[] args) throws Exception {
        Collection folders = this.getFolders(args);
        String folder = this.prompt("Folder name  :", false);
        String name = this.prompt("Group id     :", false);
        PersonalStoreFolder f = this.findFolder(folders, folder);
        if (f == null) {
            throw new Exception("No such Folder: " + folder);
        }
        boolean found = false;
        PersonalStoreEntry[] searchResults = this._personalStoreService.search(1, name, "group");
        if (searchResults == null) {
            System.out.println("No entry found in the directory with the name " + name);
            return;
        }
        PersonalStoreEntry e = null;
        for (int i = 0; i < searchResults.length; ++i) {
            e = searchResults[i];
            if (!e.getDisplayName().equalsIgnoreCase(name)) continue;
            found = true;
            break;
        }
        if (found) {
            PersonalGroup entry = (PersonalGroup)this._personalStoreService.getEntry("group", e.getEntryId());
            if (entry == null) {
                entry = (PersonalGroup)this._personalStoreService.createEntry("group", e.getDisplayName());
            }
            entry.setDistinguishedName(e.getEntryId());
            entry.addToFolder(f);
            entry.save();
        } else {
            System.out.println("No entry found in the directory with the name " + name);
        }
    }

    private void removeContactGroup(String[] args) throws Exception {
        PersonalGroup e;
        Collection folders = this.getFolders(args);
        String folder = this.prompt("Folder name          :", false);
        String id = this.prompt("Group id             :", false);
        PersonalStoreFolder f = this.findFolder(folders, folder);
        if (f == null) {
            System.out.println("No Such Folder: " + folder);
            return;
        }
        if (args.length > 0) {
            CollaborationPrincipal p = this._session.createPrincipal(args[0]);
            e = (PersonalGroup)this._personalStoreService.getEntry(p, "group", id);
        } else {
            e = (PersonalGroup)this._personalStoreService.getEntry("group", id);
        }
        if (e == null) {
            System.out.println("No Such Entry: " + id);
            return;
        }
        e.removeFromFolder(f);
        e.save();
    }

    private void removeContactFolder(String[] args) throws Exception {
        String folder;
        Collection folders = this.getFolders(args);
        PersonalStoreFolder f = this.findFolder(folders, folder = this.prompt("Folder name:", false));
        if (f == null) {
            throw new Exception("No such Folder: " + folder);
        }
        f.remove();
    }

    private void renameContactFolder(String[] args) throws Exception {
        Collection folders = this.getFolders(args);
        String oldFolder = this.prompt("Old Folder name:", false);
        String newFolder = this.prompt("New Folder name:", false);
        PersonalStoreFolder f = this.findFolder(folders, oldFolder);
        if (f == null) {
            throw new Exception("No such Folder: " + oldFolder);
        }
        f.rename(newFolder);
        f.save();
    }

    private void addContactFolder(String[] args) throws Exception {
        PersonalStoreFolder f;
        String folder = this.prompt("Folder name: ", false);
        if (args.length > 0) {
            CollaborationPrincipal p = this._session.createPrincipal(args[0]);
            f = (PersonalStoreFolder)this._personalStoreService.createEntry(p, "abook", folder);
        } else {
            f = (PersonalStoreFolder)this._personalStoreService.createEntry("abook", folder);
        }
        f.save();
    }

    private void listProfile(String[] args) throws Exception {
        PersonalProfile profile = this._personalStoreService.getProfile();
        Map m = profile.getProperties();
        Object[] keys = m.keySet().toArray();
        Arrays.sort(keys, 0, keys.length, new Comparator(){

            public int compare(Object o1, Object o2) {
                return ((String)o1).compareTo(o2);
            }
        });
        for (int i = 0; i < keys.length; ++i) {
            String p = (String)keys[i];
            Object propValue = m.get(p);
            if (propValue instanceof Set) {
                Object[] propValuesArray = ((Set)propValue).toArray();
                Arrays.sort(propValuesArray, 0, propValuesArray.length, new Comparator(){

                    public int compare(Object o1, Object o2) {
                        return ((String)o1).compareTo(o2);
                    }
                });
                System.out.print(p + " = [ ");
                for (int j = 0; j < propValuesArray.length; ++j) {
                    System.out.print(propValuesArray[j] + "  ");
                }
                System.out.println(" ]");
                continue;
            }
            System.out.println(p + " = " + propValue);
        }
    }

    private void getProfile(String[] args) throws Exception {
        String propName = this.prompt("Property Name :", false);
        PersonalProfile profile = this._personalStoreService.getProfile();
        String v = profile.getProperty(propName, "");
        System.out.println(propName + " = " + v);
    }

    private void changeProfile(String[] args) throws Exception {
        String propName = this.prompt("Property Name  :", false);
        String propVal = this.prompt("Property Value :", false);
        PersonalProfile p = this._personalStoreService.getProfile();
        p.setProperty(propName, propVal);
        p.save();
    }

    private void removeProfile(String[] args) throws Exception {
        PersonalProfile profile = this._personalStoreService.getProfile();
        profile.remove();
    }

    private void removeSubscription(String[] args) throws Exception {
        if (args.length > 0 && args[0].equals("?")) {
            System.out.println("rsub [ conference|news id ]");
            return;
        }
        boolean isNews = false;
        String type = "conference";
        type = args.length > 0 ? args[0] : this.prompt("Subscription type:", false);
        String id = null;
        id = args.length > 1 ? args[1] : this.prompt("Subscription target:", false);
        PersonalStoreEntry entry = this._personalStoreService.getEntry(type, id);
        if (entry != null) {
            entry.remove();
        } else {
            System.out.println("No such Subscription: " + type + " " + id);
        }
    }

    private void addSubscription(String[] args) throws Exception {
        if (args.length > 0 && args[0].equals("?")) {
            System.out.println("asub [ conference|news id ]");
            return;
        }
        boolean isNews = false;
        String type = "conference";
        type = args.length > 0 ? args[0] : this.prompt("Subscription type:", false);
        String id = null;
        id = args.length > 1 ? args[1] : this.prompt("Subscription target:", false);
        PersonalStoreEntry[] entry = this._personalStoreService.search(0, id, type);
        if (entry != null) {
            entry[0].save();
        } else {
            System.out.println("No such Subscription target: " + type + " " + id);
        }
    }

    private void listSubscriptions(String[] args) throws Exception {
        if (args.length > 0 && args[0].equals("?")) {
            System.out.println("asub [ conference|news ]");
            return;
        }
        boolean isNews = false;
        String type = "conference";
        type = args.length > 0 ? args[0] : this.prompt("Subscription type:", false);
        Collection c = this._personalStoreService.getEntries(type);
        Iterator i = c.iterator();
        while (i.hasNext()) {
            PersonalConference dest = (PersonalConference)i.next();
            System.out.println(dest.getAddress());
        }
    }

    private void startStream(String[] args) throws Exception {
        String rcpt = this.prompt("Enter the recipient:", false);
        String fileName = this.prompt("Enter the file name:", false);
        boolean computeHash = this.getYesOrNo("Compute Hash?", false);
        String desc = this.prompt("Enter the description:", false);
        String[] methods = new String[]{"http://jabber.org/protocol/ibb", "jabber:iq:oob"};
        File f = new File(fileName);
        try {
            SenderFileStreamingProfile profile = new SenderFileStreamingProfile(f, computeHash, desc);
            ContentStreamListenerImpl listener = new ContentStreamListenerImpl();
            ContentStream cs = this._streamingService.open(rcpt, methods, profile, listener);
            listener.setContentStream(cs);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void onContentStream(String sender, ReceiverStreamingProfile profile, ContentStream stream) {
        block12: {
            ReceiverFileStreamingProfile fileProfile = (ReceiverFileStreamingProfile)profile;
            System.out.println("Received a request for content streaming from " + sender);
            System.out.println("\tName - " + fileProfile.getName());
            System.out.println("\tDescription - " + fileProfile.getDescription());
            System.out.println("\tSize - " + fileProfile.size());
            String[] methods = stream.getSupportedMethods();
            for (int i = 0; i < methods.length; ++i) {
                System.out.println("\t\tMethod[" + i + "] " + methods[i]);
            }
            try {
                boolean ret = this.getYesOrNo("Do you accept the stream?", true);
                if (ret) {
                    String dir = this.prompt("Enter the dir to save the file:", false, true);
                    File f = new File(dir);
                    fileProfile.addOutput(f);
                    int i = -1;
                    while (true) {
                        try {
                            String index = this.prompt("Enter the preferred method[0]:", false, "0", true);
                            i = Integer.parseInt(index);
                            if (i >= 0 && i < methods.length) {
                                break;
                            }
                        }
                        catch (NumberFormatException e) {
                            e.printStackTrace();
                        }
                        System.out.println("Enter correct values");
                    }
                    ContentStreamListenerImpl listener = new ContentStreamListenerImpl(profile);
                    listener.setContentStream(stream);
                    stream.accept(methods[i], profile, listener);
                    break block12;
                }
                String reason = this.prompt("What is the reason for rejection?\n Enter 1. if Method is not supported or \n2. if The file is not acceptable or the custom reason:", false, true);
                if (reason.equals("1")) {
                    stream.reject("no-valid-streams");
                } else if (reason.equals("2")) {
                    stream.reject("bad-profile");
                } else {
                    stream.reject(reason);
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    protected static void printMessage(Message message) {
        System.out.println("");
        try {
            System.out.println("    Subject: " + message.getHeader("subject"));
            System.out.println("    Content-type: " + message.getContentType());
            MessagePart[] parts = message.getParts();
            for (int i = 0; i < parts.length; ++i) {
                System.out.println("    Part " + i);
                System.out.println("        Content-type: " + parts[i].getContentType());
                try {
                    String str;
                    BufferedReader br = new BufferedReader(new InputStreamReader(parts[i].getInputStream()));
                    while ((str = br.readLine()) != null) {
                        System.out.println(str);
                    }
                    continue;
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }
        catch (Exception ce) {
            ce.printStackTrace();
        }
    }

    private static void exitUsage(String errorText) {
        System.out.println("usage error: " + errorText);
        System.out.println("usage: \n\tjava com.sun.im.service.sample.Shell [-i <input-file> -factory <session-factory-class-name>] [-debug] [-sso] [-org <orgname>] [-servicemodel | -sessionmodel]");
        System.exit(0);
    }

    public static void readArgs(String[] argv) {
        for (int i = 0; i < argv.length; ++i) {
            if (argv[i].equals("-i")) {
                if (i + 1 < argv.length) {
                    _inputFileName = argv[++i];
                    continue;
                }
                Shell.exitUsage("Missing input file");
                continue;
            }
            if (argv[i].equals("-factory")) {
                if (i + 1 < argv.length) {
                    System.setProperty("com.sun.im.service.CollaborationSessionFactory", argv[++i]);
                    continue;
                }
                Shell.exitUsage("Missing factory");
                continue;
            }
            if (argv[i].equals("-debug")) {
                System.setProperty("com.iplanet.im.client.api.debug", "true");
                System.setProperty("com.sun.im.xmpp.log", "debug");
                System.setProperty("com.sun.im.service.xmpp.log", "debug");
                try {
                    Logger logger = LogManager.getLogger("com.sun.im");
                    PatternLayout layout = new PatternLayout("%d{HH:mm:ss,SSS} %-5p %c [%t] %m%n");
                    ConsoleAppender appender = new ConsoleAppender((Layout)layout, "System.out");
                    logger.setLevel(Level.DEBUG);
                    logger.addAppender(appender);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                continue;
            }
            if (argv[i].equals("-org") || argv[i].equals("-orgname")) {
                if (i + 1 < argv.length) {
                    _defaultDomain = argv[++i];
                    continue;
                }
                Shell.exitUsage("Missing sso org");
                continue;
            }
            if (argv[i].equals("-service") || argv[i].equals("-host")) {
                if (i + 1 < argv.length) {
                    imServer = argv[++i];
                    continue;
                }
                Shell.exitUsage("Missing host name");
                continue;
            }
            if (argv[i].equals("-sso")) {
                _usesso = true;
                continue;
            }
            if (argv[i].equals("-servicemodel")) {
                _serviceModel = true;
                continue;
            }
            if (argv[i].equals("-sessionmodel")) {
                _serviceModel = false;
                continue;
            }
            Shell.exitUsage("Illegal option: " + argv[i]);
        }
    }

    public static void main(String[] argv) {
        try {
            BufferedReader br = null;
            Shell.readArgs(argv);
            if (_inputFileName != null) {
                br = new BufferedReader(new FileReader(_inputFileName));
            }
            Shell interp = br != null ? new Shell(br, false) : new Shell();
            interp.start();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void onSubscribeRequest(Presence p) {
        Object[] o = p.getTuples().toArray();
        PresenceTuple pt = (PresenceTuple)o[0];
        String contact = pt.getContact();
        System.out.println("User <" + contact + "> is requesting for subscription.");
        try {
            boolean ret = this.getYesOrNo("Do you approve subscription?\n", true);
            if (ret) {
                this._presenceService.authorize(contact);
            } else {
                this._presenceService.cancel(contact);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void onPresenceNotify(String presentityURL, String presenceInfo, Date expires) {
    }

    public void onSubscribed(Presence p) {
        Object[] o = p.getTuples().toArray();
        PresenceTuple pt = (PresenceTuple)o[0];
        System.out.println("\nUser <" + pt.getContact() + "> is subscribed");
    }

    public void onUnsubscribed(Presence p) {
        Object[] o = p.getTuples().toArray();
        PresenceTuple pt = (PresenceTuple)o[0];
        System.out.println("\nUser <" + pt.getContact() + "> is unsubscribed");
    }

    public void onPresence(Presence p) {
        this.printPresence(p);
    }

    public boolean onUnsubscribeRequest(Presence p) {
        Object[] o = p.getTuples().toArray();
        PresenceTuple pt = (PresenceTuple)o[0];
        System.out.println("User <" + pt.getContact() + "> is requesting for unsubscription.");
        try {
            return this.getYesOrNo("Do you approve unsubscription? ", true);
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
    }

    public void printPresence(Presence p) {
        Object[] o = p.getTuples().toArray();
        PresenceTuple pt = (PresenceTuple)o[0];
        if (pt.getNote() != null && pt.getNote().length() > 0) {
            System.out.println("[Presence Info Received] Recipient=<" + this._principal.getUID() + "> Destination=<" + pt.getContact() + "> Status=<" + pt.getStatus() + "> Note=<" + pt.getNote() + ">");
        } else {
            System.out.println("[Presence Info Received] Recipient=<" + this._principal.getUID() + "> Destination=<" + pt.getContact() + "> Status=<" + pt.getStatus() + ">");
        }
    }

    private int accessS2accessInt(String access) {
        int accesslevel = -1;
        if (access.equalsIgnoreCase("NONE")) {
            accesslevel = 1;
        } else if (access.equalsIgnoreCase("LISTEN")) {
            accesslevel = 2;
        } else if (access.equalsIgnoreCase("PUBLISH")) {
            accesslevel = 4;
        } else if (access.equalsIgnoreCase("MANAGE")) {
            accesslevel = 30;
        }
        return accesslevel;
    }

    private String accessInt2accessS(int accesslevel) {
        String access = null;
        if (accesslevel == 1) {
            access = "NONE";
        } else if (accesslevel == 4) {
            access = "PUBLISH";
        } else if (accesslevel == 2) {
            access = "LISTEN";
        } else if (accesslevel == 30) {
            access = "MANAGE";
        }
        return access;
    }

    static String getDomainFromAddress(String in, String defaultDomain) {
        int i = in.lastIndexOf(64);
        if (i > 0 && in.charAt(i - 1) != '\\') {
            return in.substring(i + 1);
        }
        return defaultDomain;
    }

    static String getLocalPartFromAddress(String in) {
        int i = in.lastIndexOf(64);
        if (i > 0 && in.charAt(i - 1) != '\\') {
            return in.substring(0, i);
        }
        return in;
    }

    static String getResourceFromAddress(String in) {
        int i = in.lastIndexOf(47);
        if (i > 0 && in.charAt(i - 1) != '\\') {
            return in.substring(i + 1);
        }
        return null;
    }

    static String appendDomainToAddress(String in, String defaultDomain) {
        int i = in.lastIndexOf(64);
        if (i > 0 && in.charAt(i - 1) != '\\') {
            return in;
        }
        return in + "@" + defaultDomain;
    }

    public void onUnsubscribe(Presence p) {
    }

    static {
        _serviceModel = true;
        _usesso = false;
        try {
            imServer = InetAddress.getLocalHost().getHostName();
        }
        catch (Exception e) {
            imServer = "localhost";
        }
        htmlConverter = new HTMLConverter();
        _inputFileName = null;
    }

    class AsyncReader {
        private boolean _isActive = false;
        private LinkedList _values = new LinkedList();

        AsyncReader() {
        }

        public synchronized void write(String val) {
            this._values.add(val);
            this.notify();
        }

        public boolean isActive() {
            return this._isActive;
        }

        public synchronized String read(String ask) {
            String result = null;
            this._isActive = true;
            System.out.print(ask);
            while (this._values.size() == 0) {
                try {
                    this.wait();
                }
                catch (Exception exception) {}
            }
            result = (String)this._values.removeFirst();
            this._isActive = false;
            return result;
        }
    }
}

