/*
 * Decompiled with CFR 0.152.
 */
package com.sun.im.service.shells;

import com.iplanet.am.sdk.AMStoreConnection;
import com.iplanet.sso.SSOToken;
import com.iplanet.sso.SSOTokenManager;
import com.sun.identity.security.AdminDNAction;
import com.sun.identity.security.AdminPasswordAction;
import com.sun.im.identity.util.Auth;
import com.sun.im.service.shells.Shell;
import java.io.BufferedReader;
import java.security.AccessController;
import java.security.Principal;

class SSOShell
extends Shell {
    private static AMStoreConnection _adminConnection;

    public SSOShell() throws Exception {
    }

    public SSOShell(BufferedReader br, boolean multiShells) throws Exception {
        super(br, multiShells);
    }

    public void login(String[] args) throws Exception {
        String sid;
        this.readLoginInfo(args, true);
        if (this.interactive) {
            System.out.println("login through Identity Server");
            System.out.println("default domain " + _defaultDomain);
        }
        SSOToken token = null;
        try {
            String domain = SSOShell.getDomainFromAddress(this.user, _defaultDomain);
            int i = domain.lastIndexOf(47);
            if (i > 0) {
                domain = domain.substring(0, i);
            }
            String ssoOrg = _adminConnection.getOrganizationDN(domain, null);
            token = Auth.getSSOToken((String)ssoOrg, (String)SSOShell.getLocalPartFromAddress(this.user), (String)this.password);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        if (token != null) {
            if (this.interactive) {
                System.out.println("Authentication Success!");
            }
            sid = token.getTokenID().toString();
        } else {
            if (this.interactive) {
                System.out.println("Authentication Failed!");
            }
            sid = null;
        }
        String resource = SSOShell.getResourceFromAddress(this.user);
        this.user = SSOShell.getLocalPartFromAddress(this.user);
        if (resource != null) {
            this.user = this.user + "/" + resource;
        }
        this._session = this._factory.getSession(this.server, this.user, sid, this);
        this.initSubSessions();
    }

    static {
        try {
            String password = (String)AccessController.doPrivileged(new AdminPasswordAction());
            String adminDN = (String)AccessController.doPrivileged(new AdminDNAction());
            SSOTokenManager manager = SSOTokenManager.getInstance();
            SSOToken token = manager.createSSOToken((Principal)new MyPrincipal(adminDN), password);
            _adminConnection = new AMStoreConnection(token);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    static class MyPrincipal
    implements Principal {
        String name;

        MyPrincipal(String dn) {
            this.name = dn;
        }

        public String getName() {
            return this.name;
        }

        public String toString() {
            return this.name;
        }

        public boolean equals(Object o) {
            if (o == null) {
                return false;
            }
            return o.toString().equals(this.name);
        }

        public int hashCode() {
            return this.name.hashCode();
        }
    }
}

