/*
 * Decompiled with CFR 0.152.
 */
package com.sun.im.service.sample;

import com.sun.im.service.CollaborationException;
import com.sun.im.service.CollaborationSession;
import com.sun.im.service.CollaborationSessionFactory;
import com.sun.im.service.Conference;
import com.sun.im.service.ConferenceSession;
import com.sun.im.service.ConferenceSessionListener;
import com.sun.im.service.InviteMessage;
import com.sun.im.service.Message;
import com.sun.im.service.MessagePart;
import com.sun.im.service.SecureSessionListener;
import com.sun.im.service.sample.TalkConference;
import java.io.BufferedReader;
import java.io.InputStreamReader;
import java.security.cert.X509Certificate;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.StringTokenizer;

public class Talk
extends Thread
implements SecureSessionListener,
ConferenceSessionListener {
    private ConferenceSession _session;
    private Hashtable _conferences = new Hashtable();
    private boolean bYesOrNo;
    private boolean _shutdown = false;
    private boolean invitePending = false;
    private TalkConference _currentConference = null;
    private Object mutex = new Object();
    private String _user;
    private static BufferedReader _reader;

    public Talk(CollaborationSessionFactory fac, String server, String user, String password) throws Exception {
        this._user = user;
        CollaborationSession s = fac.getSession(server, user, password, this);
        this._session = (ConferenceSession)s.accessService("conference");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean promptYesOrNo(String ask) throws Exception {
        boolean answer = false;
        System.out.print(ask);
        Object object = this.mutex;
        synchronized (object) {
            this.mutex.wait();
            answer = this.bYesOrNo;
        }
        return answer;
    }

    public void onError(CollaborationException e) {
        e.printStackTrace();
    }

    public boolean onX509Certificate(X509Certificate[] chain) {
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        while (!this._shutdown) {
            try {
                System.out.print(this._user + "> ");
                String s = _reader.readLine();
                if (s == null) break;
                if ((s = s.trim()).equals("")) continue;
                if (s.startsWith("+")) {
                    StringTokenizer st = new StringTokenizer(s);
                    String cmd = st.nextToken();
                    String[] args = new String[st.countTokens()];
                    int i = 0;
                    while (st.hasMoreTokens()) {
                        args[i++] = st.nextToken();
                    }
                    if (cmd.equalsIgnoreCase("+invite")) {
                        this.invite(args);
                        continue;
                    }
                    if (cmd.equalsIgnoreCase("+leave")) {
                        this.leave(args);
                        continue;
                    }
                    if (cmd.equalsIgnoreCase("+list")) {
                        this.list();
                        continue;
                    }
                    if (!cmd.equalsIgnoreCase("+active")) continue;
                    this.active(args);
                    continue;
                }
                if (this.invitePending) {
                    Object object;
                    if (s.equalsIgnoreCase("y") || s.equalsIgnoreCase("yes")) {
                        object = this.mutex;
                        synchronized (object) {
                            this.bYesOrNo = true;
                            this.mutex.notify();
                            continue;
                        }
                    }
                    object = this.mutex;
                    synchronized (object) {
                        this.bYesOrNo = false;
                        this.mutex.notify();
                        continue;
                    }
                }
                if (this._currentConference != null) {
                    this._currentConference.addMessage(s);
                    continue;
                }
                System.out.println("No active conference!");
                System.out.println("you first need to select one using the +active command.");
                this.list();
            }
            catch (Exception e) {
                System.out.println("Error " + e.toString());
                e.printStackTrace();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void onInvite(Conference conference, InviteMessage message) {
        System.out.println(message.getOriginator() + " has invited to a conference ");
        System.out.println("conference address: " + conference.getDestination());
        System.out.print("Invite Message: ");
        Talk.printMessage(message);
        if (this._conferences.get(conference.getDestination()) != null) {
            System.out.println("already invited");
        }
        try {
            this.invitePending = true;
            if (this.promptYesOrNo("Do you want to join this conference? ")) {
                TalkConference c = new TalkConference(this._user, this._session, conference);
                this._conferences.put(c.getDestination(), c);
                if (this._currentConference == null) {
                    this._currentConference = c;
                }
                System.out.println("Conference " + c.getDestination() + " now active");
            } else {
                System.out.println("Invitation declined");
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            System.out.println("Failed to join.");
        }
        finally {
            this.invitePending = false;
        }
    }

    private synchronized void active(String[] args) {
        if (args.length > 0 && args[0].equals("?")) {
            System.out.println("+active [ conference ]");
            return;
        }
        String confId = null;
        confId = args.length > 0 ? args[0] : Talk.prompt("New active conference: ", false);
        TalkConference c = (TalkConference)this._conferences.get(confId);
        if (c == null) {
            System.out.println("Conference " + confId + " not found");
            return;
        }
        this._currentConference = c;
        System.out.println("The new active conference is " + confId);
    }

    private void invite(String[] args) throws Exception {
        String user;
        TalkConference c;
        if (args.length > 0 && args[0].equals("?")) {
            System.out.println("+invite [ conference ]");
            return;
        }
        String confId = null;
        if (args.length > 0) {
            confId = args[0];
            c = (TalkConference)this._conferences.get(confId);
            if (c == null) {
                System.out.println("Conference " + confId + " not found");
                return;
            }
        } else {
            c = new TalkConference(this._user, this._session);
            this._conferences.put(c.getDestination(), c);
        }
        this._currentConference = c;
        Message newMsg = c.createInviteMessage();
        newMsg.setOriginator("yoyo@yoyo.com");
        while ((user = Talk.prompt("invite (enter one address, return if done): ", false)).length() > 0) {
            newMsg.addRecipient(user);
        }
        String msg = Talk.prompt("Invite message: ", true);
        MessagePart part = newMsg.newPart();
        part.setContent(msg);
        newMsg.addPart(part);
        this._currentConference.invite(newMsg);
    }

    public void leave(String[] args) throws Exception {
        TalkConference c;
        if (args.length > 0 && args[0].equals("?")) {
            System.out.println("+leave [ conference ]");
            return;
        }
        if (args.length >= 1) {
            String confId = args[0];
            c = (TalkConference)this._conferences.get(confId);
            if (c == null) {
                System.out.println("Conference not found");
                return;
            }
        } else {
            c = this._currentConference;
            this._currentConference = null;
        }
        c.leave();
    }

    public void list() throws Exception {
        Enumeration keys = this._conferences.keys();
        while (keys.hasMoreElements()) {
            System.out.println((String)keys.nextElement());
        }
    }

    public static void main(String[] args) {
        String user;
        _reader = new BufferedReader(new InputStreamReader(System.in));
        if (args.length > 0 && args[0].equals("?")) {
            System.out.println("login host username password");
            return;
        }
        String server = args.length >= 1 ? args[0] : Talk.prompt("Hostname [localhost:9909]\t: ", false, "localhost:9909");
        if (args.length >= 2) {
            user = args[1];
        } else {
            String username = System.getProperty("user.name");
            user = Talk.prompt("User name [" + username + "]\t: ", false, username);
        }
        String password = args.length >= 3 ? args[2] : Talk.prompt("Password [iplanet]\t: ", false, "iplanet");
        System.setProperty("com.sun.im.service.CollaborationSessionFactory", "com.iplanet.im.client.api.iIMSecureSessionFactory");
        try {
            CollaborationSessionFactory fac = new CollaborationSessionFactory();
            Talk talk = new Talk(fac, server, user, password);
            talk.start();
            talk.join();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static void printMessage(Message message) {
        String from = message.getOriginator();
        System.out.print(from.substring(0, from.indexOf("@")) + "> ");
        MessagePart[] parts = message.getParts();
        for (int i = 0; i < parts.length; ++i) {
            try {
                String str;
                BufferedReader br = new BufferedReader(new InputStreamReader(parts[i].getInputStream()));
                while ((str = br.readLine()) != null) {
                    System.out.println(str);
                }
                continue;
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    private static String prompt(String ask, boolean newline) {
        return Talk.prompt(ask, newline, "");
    }

    private static String prompt(String ask, boolean newline, String defaultValue) {
        String ret = defaultValue;
        if (newline) {
            System.out.println(ask);
        } else {
            System.out.print(ask);
        }
        try {
            String s = _reader.readLine();
            if (s.length() > 0) {
                ret = s;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return ret;
    }
}

