/*
 * Decompiled with CFR 0.152.
 */
package com.sun.im.service.sample;

import com.sun.im.service.CollaborationException;
import com.sun.im.service.Message;
import com.sun.im.service.NewsChannel;
import com.sun.im.service.NewsChannelListener;
import com.sun.im.service.NewsSession;
import com.sun.im.service.sample.News;
import java.util.Collection;
import java.util.Hashtable;
import java.util.Iterator;

class NewsChannelListenerImpl
implements NewsChannelListener {
    NewsChannel _nc;
    boolean _subscribed;
    private Hashtable _messages = new Hashtable();

    public NewsChannelListenerImpl(NewsSession s, String name, boolean create, boolean subscribe) throws Exception {
        this._subscribed = subscribe;
        this._nc = create ? s.newNewsChannel(name, this, 30) : s.getNewsChannel(name, this);
        if (this._nc == null) {
            throw new Exception("Failed to create or access news channel");
        }
    }

    public void addMessage(String subject, String body) throws Exception {
        Message newMsg = this._nc.createMessage();
        newMsg.setContent(body);
        newMsg.setHeader("subject", subject);
        this._nc.addMessage(newMsg);
        this._messages.put(newMsg.getMessageId(), newMsg);
    }

    public void onMessageModified(String messageId, Message message) {
    }

    public void onMessageAdded(Message message) {
        if (this._subscribed) {
            System.out.println("[" + this._nc.getDestination() + "] Message added");
            News.printMessage(message);
            System.out.print("News> ");
        }
        this._messages.put(message.getMessageId(), message);
    }

    public void onMessageRemoved(String messageId) {
        if (this._subscribed) {
            System.out.println("[" + this._nc.getDestination() + "] Message deleted: " + messageId);
            System.out.print("News> ");
        }
        this._messages.remove(messageId);
    }

    public void onError(CollaborationException e) {
        e.printStackTrace();
        System.out.print("News> ");
    }

    public void remove() {
    }

    public void removeMessage(String messageId) throws Exception {
        this._nc.removeMessage(messageId);
        this._messages.remove(messageId);
    }

    public void onEvent(String event) {
    }

    public void listMessages() throws Exception {
        if (this._messages.size() == 0) {
            Thread.sleep(200L);
        }
        Collection c = this._messages.values();
        System.out.println("[" + this._nc.getDestination() + "] begin message list");
        Iterator i = c.iterator();
        while (i.hasNext()) {
            Message m = (Message)i.next();
            News.printMessage(m);
        }
        System.out.println("[" + this._nc.getDestination() + "] end message list");
        System.out.print("News> ");
    }

    public void onModeratedMessageAdded(Message message) {
    }

    public void onModeratedMessageStatus(Message message, int status, String reason) {
    }
}

