/*
 * Decompiled with CFR 0.152.
 */
package com.sun.im.service.sample;

import com.sun.im.service.CollaborationException;
import com.sun.im.service.CollaborationSession;
import com.sun.im.service.CollaborationSessionFactory;
import com.sun.im.service.CollaborationSessionListener;
import com.sun.im.service.Message;
import com.sun.im.service.MessagePart;
import com.sun.im.service.NewsSession;
import com.sun.im.service.sample.NewsChannelListenerImpl;
import java.io.BufferedReader;
import java.io.InputStreamReader;
import java.util.Hashtable;
import java.util.StringTokenizer;

public class News
extends Thread
implements CollaborationSessionListener {
    private NewsSession _session;
    private Hashtable _channels = new Hashtable();
    private static BufferedReader _reader;

    public News(CollaborationSessionFactory fac, String server, String user, String password) throws Exception {
        CollaborationSession s = fac.getSession(server, user, password, this);
        this._session = (NewsSession)s.accessService("news");
    }

    public void onError(CollaborationException e) {
        e.printStackTrace();
    }

    public void run() {
        block4: while (true) {
            try {
                while (true) {
                    System.out.print("News> ");
                    String s = _reader.readLine();
                    if (s == null) break block4;
                    if ((s = s.trim()).equals("")) continue;
                    if (s.startsWith("?") || s.equalsIgnoreCase("help")) {
                        System.out.println("read <news-channel>      // read messages from a news channel");
                        System.out.println("post <news-channel>      // post a new message");
                        System.out.println("delete <news-channel>    // remove a news channel message");
                        System.out.println("create <news-channel>    // create a new news channel");
                        continue;
                    }
                    StringTokenizer st = new StringTokenizer(s);
                    String cmd = st.nextToken();
                    String channel = null;
                    try {
                        channel = st.nextToken();
                    }
                    catch (Exception e) {
                        System.out.println("Missing news channel name");
                        continue;
                    }
                    if (s.startsWith("read ")) {
                        this.read(channel);
                        continue;
                    }
                    if (s.startsWith("post ")) {
                        this.postMessage(channel);
                        continue;
                    }
                    if (s.startsWith("delete ")) {
                        this.removeMessage(channel);
                        continue;
                    }
                    if (s.startsWith("create ")) {
                        this.createChannel(channel);
                        continue;
                    }
                    if (s.startsWith("remove ")) {
                        this.removeChannel(channel);
                        continue;
                    }
                    System.out.println("unrecognized command: " + cmd);
                }
            }
            catch (Exception e) {
                System.out.println("Error " + e.toString());
                e.printStackTrace();
                continue;
            }
            break;
        }
    }

    private NewsChannelListenerImpl getChannel(String name) throws Exception {
        NewsChannelListenerImpl c = (NewsChannelListenerImpl)this._channels.get(name);
        if (c == null) {
            c = new NewsChannelListenerImpl(this._session, name, false, false);
        }
        return c;
    }

    private void read(String name) throws Exception {
        NewsChannelListenerImpl c = this.getChannel(name);
        if (c != null) {
            c.listMessages();
        } else {
            System.out.println("No such news channel: " + name);
        }
    }

    private void removeChannel(String name) throws Exception {
        NewsChannelListenerImpl c = this.getChannel(name);
        if (c != null) {
            c.remove();
        } else {
            System.out.println("No such news channel: " + name);
        }
    }

    private void createChannel(String name) throws Exception {
        NewsChannelListenerImpl c = null;
        try {
            c = this.getChannel(name);
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (c == null) {
            c = new NewsChannelListenerImpl(this._session, name, true, false);
        } else {
            System.out.println("There is already a news channel called " + name);
        }
    }

    private void postMessage(String name) throws Exception {
        NewsChannelListenerImpl c = this.getChannel(name);
        if (c != null) {
            String subject = News.prompt("Subject: ", false, "");
            String body = News.prompt("Content: ", true, "");
            c.addMessage(subject, body);
        } else {
            System.out.println("No such news channel: " + name);
        }
    }

    private void removeMessage(String name) throws Exception {
        NewsChannelListenerImpl c = this.getChannel(name);
        if (c != null) {
            c.listMessages();
            String id = News.prompt("ID of message to remove: ", false, "");
            c.removeMessage(id);
        } else {
            System.out.println("No such news channel: " + name);
        }
    }

    public static void main(String[] args) {
        String user;
        _reader = new BufferedReader(new InputStreamReader(System.in));
        if (args.length > 0 && args[0].equals("?")) {
            System.out.println("Talk host username password");
            return;
        }
        String server = args.length >= 1 ? args[0] : News.prompt("Hostname [localhost:9909]\t: ", false, "localhost:9909");
        if (args.length >= 2) {
            user = args[1];
        } else {
            String username = System.getProperty("user.name");
            user = News.prompt("User name [" + username + "]\t: ", false, username);
        }
        String password = args.length >= 3 ? args[2] : News.prompt("Password [iplanet]\t: ", false, "iplanet");
        try {
            CollaborationSessionFactory fac = new CollaborationSessionFactory();
            News talk = new News(fac, server, user, password);
            talk.start();
            talk.join();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static void printMessage(Message message) {
        System.out.println("    Message-Id: " + message.getMessageId());
        System.out.println("    From: " + message.getOriginator());
        System.out.println("    Subject: " + message.getHeader("subject"));
        System.out.println("    Content-type: " + message.getContentType());
        MessagePart[] parts = message.getParts();
        for (int i = 0; i < parts.length; ++i) {
            try {
                String str;
                BufferedReader br = new BufferedReader(new InputStreamReader(parts[i].getInputStream()));
                while ((str = br.readLine()) != null) {
                    System.out.println(str);
                }
                continue;
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    private static String prompt(String ask, boolean newline) {
        return News.prompt(ask, newline, "");
    }

    private static String prompt(String ask, boolean newline, String defaultValue) {
        String ret = defaultValue;
        if (newline) {
            System.out.println(ask);
        } else {
            System.out.print(ask);
        }
        try {
            String s = _reader.readLine();
            if (s.length() > 0) {
                ret = s;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return ret;
    }
}

