/*
 * Decompiled with CFR 0.152.
 */
package com.sun.im.service.jso.x.pubsub;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import net.outer_planes.jso.ElementNode;
import org.jabberstudio.jso.NSI;
import org.jabberstudio.jso.StreamDataFactory;
import org.jabberstudio.jso.StreamElement;
import org.jabberstudio.jso.StreamObject;
import org.jabberstudio.jso.x.pubsub.PubSubItems;

public class PubSubItemsNode
extends ElementNode
implements PubSubItems {
    private static final String ATTR_ID = "id";
    private static final NSI NSI_ID = new NSI("id", "http://jabber.org/protocol/pubsub#event");
    private static final NSI NSI_ITEM = new NSI("item", "http://jabber.org/protocol/pubsub#event");
    private static final NSI NSI_RETRACT = new NSI("retract", "http://jabber.org/protocol/pubsub#event");

    public PubSubItemsNode(StreamDataFactory sdf) {
        super(sdf, NAME);
    }

    public PubSubItemsNode(StreamElement parent, PubSubItemsNode base) {
        super(parent, base);
    }

    public void setNodeIdentifier(String nodeValue) throws IllegalArgumentException {
        this.setAttributeValue("node", nodeValue);
    }

    public String getNodeIdentifier() {
        return this.getAttributeValue("node");
    }

    public void addPubSubItem(String id) {
        StreamElement elem = this.createPubSubItem(id);
        this.add(elem);
    }

    public void addPubSubItem(String id, String content) {
        StreamElement elem = this.createPubSubItem(id);
        elem.addText(content);
        this.add(elem);
    }

    public void removePubSubItem(String id) {
        StreamElement item = this.getPubSubItem(id);
        if (item != null) {
            this.remove(item);
        }
    }

    public List listPubSubItems() {
        ArrayList<StreamElement> l = new ArrayList<StreamElement>();
        Iterator i = this.listElements("item").iterator();
        while (i.hasNext()) {
            StreamElement item = (StreamElement)i.next();
            l.add(item);
        }
        return l;
    }

    public void addPubSubRetractItem(String id) {
        StreamElement elem = this.createPubSubRetractItem(id);
        this.add(elem);
    }

    public StreamElement createPubSubItem(String itemId) {
        StreamElement item = this.getDataFactory().createElementNode(NSI_ITEM);
        item.setAttributeValue(ATTR_ID, itemId);
        return item;
    }

    public StreamElement createPubSubRetractItem(String itemId) {
        StreamElement item = this.getDataFactory().createElementNode(NSI_RETRACT);
        item.setAttributeValue(ATTR_ID, itemId);
        return item;
    }

    public StreamElement getPubSubItem(String id) {
        Iterator i = this.listElements("item").iterator();
        while (i.hasNext()) {
            StreamElement item = (StreamElement)i.next();
            if (!item.getAttributeValue(ATTR_ID).equals(id)) continue;
            return item;
        }
        return null;
    }

    public StreamElement getPubSubRetractItem() {
        return this.getFirstElement(NSI_RETRACT);
    }

    public boolean hasPubSubRetractItem() {
        return this.getFirstElement(NSI_RETRACT) != null;
    }

    public void clearPubSubItems() {
        Iterator i = this.listElements("item").iterator();
        while (i.hasNext()) {
            StreamElement item = (StreamElement)i.next();
            this.remove(item);
        }
    }

    public StreamObject copy(StreamElement parent) {
        return new PubSubItemsNode(parent, this);
    }
}

