/*
 * Decompiled with CFR 0.152.
 */
package com.sun.im.service.jso.x.muc;

import net.outer_planes.jso.ElementNode;
import org.jabberstudio.jso.JID;
import org.jabberstudio.jso.NSI;
import org.jabberstudio.jso.StreamDataFactory;
import org.jabberstudio.jso.StreamElement;
import org.jabberstudio.jso.StreamObject;
import org.jabberstudio.jso.util.Utilities;
import org.jabberstudio.jso.x.muc.Affiliation;
import org.jabberstudio.jso.x.muc.MUCItem;
import org.jabberstudio.jso.x.muc.MUCRole;

public class MUCItemNode
extends ElementNode
implements MUCItem {
    public static final NSI ATTRNAME_JID = new NSI("jid", null);
    public static final NSI ATTRNAME_NICK = new NSI("nick", null);
    public static final NSI ATTRNAME_AFFILIATION = new NSI("affiliation", null);
    public static final NSI ATTRNAME_ROLE = new NSI("role", null);
    public static final NSI ELEMNAME_REASON = new NSI("reason", null);
    public static final NSI ELEMNAME_ACTOR = new NSI("actor", null);
    public static final NSI ATTRNAME_NAME = new NSI("jid", null);

    public MUCItemNode(StreamDataFactory sdf, String namespace) {
        super(sdf, new NSI("item", namespace));
    }

    protected MUCItemNode(StreamElement parent, MUCItemNode base) {
        super(parent, base);
    }

    public void setRole(MUCRole.Type type) throws IllegalArgumentException {
        this.setAttributeObject(ATTRNAME_ROLE, (Object)type);
    }

    public Affiliation.Type getAffiliation() {
        Object val = this.getAttributeObject(ATTRNAME_AFFILIATION);
        Affiliation.Type type = null;
        if (val instanceof Affiliation.Type) {
            type = (Affiliation.Type)val;
        } else if (val != null) {
            String temp = val.toString();
            if (Utilities.equateStrings(temp, Affiliation.ADMIN.toString())) {
                type = Affiliation.ADMIN;
            } else if (Utilities.equateStrings(temp, Affiliation.MEMBER.toString())) {
                type = Affiliation.MEMBER;
            } else if (Utilities.equateStrings(temp, Affiliation.NONE.toString())) {
                type = Affiliation.NONE;
            } else if (Utilities.equateStrings(temp, Affiliation.OUTCAST.toString())) {
                type = Affiliation.OUTCAST;
            } else if (Utilities.equateStrings(temp, Affiliation.OWNER.toString())) {
                type = Affiliation.OWNER;
            }
            if (type != null) {
                this.setAttributeObject(ATTRNAME_AFFILIATION, (Object)type);
            }
        }
        return type;
    }

    public JID getJID() {
        String val = this.getAttributeValue(ATTRNAME_JID);
        return val != null ? new JID(val) : null;
    }

    public String getNick() {
        String val = this.getAttributeValue(ATTRNAME_NICK);
        return val != null ? val : null;
    }

    public String getReason() {
        StreamElement res = this.getFirstElement(ELEMNAME_REASON);
        return res != null ? res.normalizeTrimText() : null;
    }

    public StreamElement getActorElement() {
        return this.getFirstElement(ELEMNAME_ACTOR);
    }

    public JID getActor() {
        StreamElement act = this.getActorElement();
        String jid = null;
        if (act != null) {
            jid = act.getAttributeValue(ATTRNAME_JID);
        }
        return jid != null ? new JID(jid) : null;
    }

    public void setActor(JID jid) {
        StreamElement act = this.getActorElement();
        if (act == null) {
            act = this.addElement(ELEMNAME_ACTOR);
        }
        act.setAttributeValue(ATTRNAME_JID, jid != null ? jid.toString() : "");
    }

    public void removeActor() {
        StreamElement act = this.getActorElement();
        if (act != null) {
            act.detach();
        }
    }

    public MUCRole.Type getRole() {
        Object val = this.getAttributeObject(ATTRNAME_ROLE);
        MUCRole.Type type = null;
        if (val instanceof MUCRole.Type) {
            type = (MUCRole.Type)val;
        } else if (val != null) {
            String temp = val.toString();
            if (Utilities.equateStrings(temp, MUCRole.MODERATOR.toString())) {
                type = MUCRole.MODERATOR;
            } else if (Utilities.equateStrings(temp, MUCRole.NONE.toString())) {
                type = MUCRole.NONE;
            } else if (Utilities.equateStrings(temp, MUCRole.PARTICIPANT.toString())) {
                type = MUCRole.PARTICIPANT;
            } else if (Utilities.equateStrings(temp, MUCRole.VISITOR.toString())) {
                type = MUCRole.VISITOR;
            }
            if (type != null) {
                this.setAttributeObject(ATTRNAME_ROLE, (Object)type);
            }
        }
        return type;
    }

    public void setAffiliation(Affiliation.Type type) throws IllegalArgumentException {
        this.setAttributeObject(ATTRNAME_AFFILIATION, (Object)type);
    }

    public void setJID(JID jid) throws IllegalArgumentException {
        if (jid == null) {
            throw new IllegalArgumentException("jid cannot be null");
        }
        this.setAttributeValue(ATTRNAME_JID, jid.toString());
    }

    public void setNick(String nick) throws IllegalArgumentException {
        if (nick == null || nick.equals("")) {
            throw new IllegalArgumentException("nick cannot be null or \"\"");
        }
        this.setAttributeValue(ATTRNAME_NICK, nick);
    }

    public void setReason(String reason) throws IllegalArgumentException {
        StreamElement res = this.getFirstElement(ELEMNAME_REASON);
        if (res == null) {
            res = this.addElement(ELEMNAME_REASON);
        }
        res.addText(reason);
    }

    public StreamObject copy(StreamElement parent) {
        return new MUCItemNode(parent, this);
    }
}

