/*
 * Decompiled with CFR 0.152.
 */
package com.sun.im.service;

import com.sun.im.service.PresenceTuple;
import com.sun.im.service.util.XMLProcessingException;
import com.sun.im.service.util.XMLUtil;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class Presence
implements Serializable {
    private HashMap _notes;
    private LinkedList _tuples = new LinkedList();
    private PresenceTuple xmpp_tuple;
    public String url;
    private HashMap _namespaces = null;
    private String _sNamespaces = null;
    private HashMap customElements;
    private StringBuffer serializedCustomElements;

    public Presence(String id) {
        this.url = id;
        this.addNamespace("icp", "urn:sun:icp:xml:ns:cpim-pidf");
    }

    public Presence(PresenceTuple tuple) {
        this.xmpp_tuple = tuple;
    }

    public Collection getTuples() {
        if (this.xmpp_tuple == null) {
            return this._tuples;
        }
        ArrayList<PresenceTuple> ret = new ArrayList<PresenceTuple>();
        ret.add(this.xmpp_tuple);
        return ret;
    }

    public synchronized void addTuple(PresenceTuple t) {
        if (this.xmpp_tuple != null) {
            return;
        }
        if (this._tuples.contains(t)) {
            this._tuples.remove(t);
        }
        t.presentityID = this.url;
        t.presentity = this;
        if (t._namespaces != null) {
            if (this._namespaces == null) {
                this._namespaces = t._namespaces;
            } else {
                this._namespaces.putAll(t._namespaces);
            }
        }
        this._tuples.add(t);
    }

    public synchronized void removeTuple(PresenceTuple t) {
        if (this.xmpp_tuple != null) {
            return;
        }
        t.presentityID = null;
        t.presentity = null;
        this._tuples.remove(t);
    }

    public void addTuple(PresenceTuple[] t) {
        if (this.xmpp_tuple != null) {
            return;
        }
        for (int i = 0; i < t.length; ++i) {
            t[i].presentityID = this.url;
            this.addTuple(t[i]);
        }
    }

    public String toString() {
        if (this.xmpp_tuple != null) {
            return null;
        }
        StringBuffer buf = new StringBuffer();
        try {
            this.copyTo(buf);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return buf.toString();
    }

    protected void copyTo(StringBuffer buf) throws Exception {
        buf.append("<presence entity='");
        buf.append(this.url);
        buf.append("' ");
        String s = this.getNamespaces();
        if (s != null) {
            buf.append(s);
        }
        buf.append(">");
        Iterator<Object> i = this.getTuples().iterator();
        while (i.hasNext()) {
            PresenceTuple t = (PresenceTuple)i.next();
            t.copyTo(buf);
        }
        if (this._notes != null && this._notes.size() > 0) {
            i = this._notes.entrySet().iterator();
            while (i.hasNext()) {
                Map.Entry entry = (Map.Entry)i.next();
                String lang = (String)entry.getKey();
                String note = (String)entry.getValue();
                XMLUtil.appendElementTag(buf, "", "note", false, false);
                buf.append(" ");
                buf.append("lang");
                buf.append("='");
                buf.append(lang);
                buf.append("'>");
                buf.append(note);
                XMLUtil.appendElementTag(buf, "", "note", true, true);
            }
        }
        if ((s = this.getSerializedCustomElements()) != null) {
            buf.append(s);
        }
        buf.append("</presence>\n");
    }

    protected String addNamespace(String prefix, String nsURI) {
        String origURI;
        String uniquePrefix = prefix;
        String res = null;
        if (this._namespaces == null) {
            this._namespaces = new HashMap();
        }
        int i = 0;
        while ((origURI = (String)this._namespaces.get(uniquePrefix)) != null && !origURI.equalsIgnoreCase(nsURI)) {
            res = uniquePrefix = Integer.toString(nsURI.hashCode() + i);
            ++i;
        }
        this._namespaces.put(uniquePrefix, nsURI);
        return res;
    }

    protected boolean hasNamespaceURI(String prefix) {
        return this._namespaces.get(prefix) != null;
    }

    protected String getNamespaceURI(String s) {
        if (s.indexOf(58) < 0) {
            return (String)this._namespaces.get(s);
        }
        return s;
    }

    public void setNamespaces(String namespaceList) {
        this._sNamespaces = namespaceList;
    }

    public String getNamespaces() {
        if (this._sNamespaces != null) {
            return this._sNamespaces;
        }
        StringBuffer buf = new StringBuffer();
        if (this._namespaces != null) {
            Iterator i = this._namespaces.keySet().iterator();
            while (i.hasNext()) {
                String prefix = (String)i.next();
                String urn = (String)this._namespaces.get(prefix);
                buf.append("xmlns");
                if (prefix != null && prefix.length() > 0) {
                    buf.append(":" + prefix);
                }
                buf.append("='");
                buf.append(urn);
                buf.append("' ");
            }
        }
        this._sNamespaces = buf.toString();
        return this._sNamespaces;
    }

    protected void addCustomElement(Element element) throws XMLProcessingException {
        String key;
        LinkedList<Element> list;
        if (this.customElements == null) {
            this.customElements = new HashMap();
        }
        if ((list = (LinkedList<Element>)this.customElements.get(key = (String)this._namespaces.get(XMLUtil.getNamespacePrefix(element)))) == null) {
            list = new LinkedList<Element>();
            list.add(element);
            this.customElements.put(key, list);
        } else {
            list.add(element);
        }
    }

    public void addSerializedCustomElement(String sElement, String namespaceURI, boolean validateXML) throws XMLProcessingException {
        String prefix = null;
        Document dummyDoc = null;
        String s = sElement;
        if (validateXML) {
            dummyDoc = XMLUtil.createDocFromString(sElement);
        }
        if (namespaceURI != null) {
            String newPrefix;
            if (validateXML) {
                Node parentNode;
                if (dummyDoc != null && (parentNode = dummyDoc.getFirstChild()) != null) {
                    Node curNode = parentNode.getFirstChild();
                    prefix = XMLUtil.getNamespacePrefix((Element)curNode);
                }
            } else {
                prefix = XMLUtil.getPrefixFromXMLString(sElement);
            }
            if ((newPrefix = this.addNamespace(namespaceURI, prefix)) != null) {
                s = XMLUtil.replacePrefix(sElement, prefix, newPrefix);
            }
        }
        if (this.serializedCustomElements == null) {
            this.serializedCustomElements = new StringBuffer(s);
        } else {
            this.serializedCustomElements.append(s);
        }
    }

    public String getSerializedCustomElements() throws XMLProcessingException {
        if (this.customElements == null) {
            return null;
        }
        StringBuffer buf = this.serializedCustomElements;
        Iterator i = this.customElements.values().iterator();
        while (i.hasNext()) {
            List list = (List)i.next();
            if (list == null) continue;
            Iterator j = list.iterator();
            while (j.hasNext()) {
                Element elt = (Element)j.next();
                String s = XMLUtil.dumpNodeAsString(elt);
                if (buf == null) {
                    buf = new StringBuffer(s);
                    continue;
                }
                buf.append(s);
            }
        }
        if (buf != null) {
            return buf.toString();
        }
        return null;
    }

    public List getCustomElements(String namespace) {
        if (this.customElements == null) {
            return null;
        }
        String nsURI = this.getNamespaceURI(namespace);
        if (nsURI == null) {
            return null;
        }
        return (List)this.customElements.get(nsURI);
    }

    public String getSerializedCustomElements(String namespace) throws XMLProcessingException {
        if (this.customElements == null) {
            return null;
        }
        String nsURI = this.getNamespaceURI(namespace);
        if (nsURI == null) {
            return null;
        }
        List list = this.getCustomElements(nsURI);
        StringBuffer buf = null;
        if (list != null) {
            Iterator j = list.iterator();
            while (j.hasNext()) {
                Element elt = (Element)j.next();
                String s = XMLUtil.dumpNodeAsString(elt);
                if (buf == null) {
                    buf = new StringBuffer(s);
                    continue;
                }
                buf.append(s);
            }
        }
        if (buf != null) {
            return buf.toString();
        }
        return null;
    }

    public String getNote(String lang) {
        if (this.xmpp_tuple != null) {
            return this.xmpp_tuple.getNote(lang);
        }
        if (this._notes != null) {
            return (String)this._notes.get(lang);
        }
        return null;
    }

    public String getNote() {
        if (this.xmpp_tuple != null) {
            return this.xmpp_tuple.getNote();
        }
        if (this._notes == null) {
            return null;
        }
        String text = this.getNote(System.getProperty("user.language"));
        if (text == null && this._notes.size() == 1) {
            text = (String)this._notes.values().iterator().next();
        }
        return text;
    }

    public void addNote(String lang, String text) {
        if (this.xmpp_tuple != null) {
            this.xmpp_tuple.addNote(lang, text);
            return;
        }
        if (this._notes == null) {
            this._notes = new HashMap(3);
        }
        this._notes.put(lang, text);
    }

    public void addNote(String text) {
        this.addNote(System.getProperty("user.language"), text);
    }
}

