/*
 * Decompiled with CFR 0.152.
 */
package com.sun.im.service;

import com.sun.im.service.PolsterHelperAnswer;
import com.sun.im.service.util.SAX;
import java.io.InputStream;
import java.util.HashMap;
import java.util.List;
import org.jabberstudio.jso.JSOImplementation;
import org.jabberstudio.jso.NSI;
import org.jabberstudio.jso.StreamDataFactory;
import org.jabberstudio.jso.x.xdata.XDataField;
import org.jabberstudio.jso.x.xdata.XDataForm;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class PolsterHelper
extends DefaultHandler {
    private HashMap _answers;
    private String _customId = null;
    private String _question;
    private int _state;
    private PolsterHelperAnswer _currentAnswer;
    private StringBuffer _quotedAnswer;
    private StringBuffer _pollMessage;
    private static final int IN_ID = 1;
    private static final int IN_POLLTYPE = 2;
    private static final int IN_ACCESS = 3;
    private static final int IN_QUESTION = 4;
    private static final int IN_ANSWER = 5;
    private static final int IN_CUSTOM = 6;
    public static final String ELEMENT_FIELD = "field";
    public static final String ELEMENT_VALUE = "value";
    public static final String ELEMENT_OPTION = "option";
    public static final String ATTRIBUTE_VAR = "var";
    public static final String ATTRIBUTE_LABEL = "label";
    public static final String ATTRIBUTE_ID = "id";
    public static final String ATTRIBUTE_QUESTION = "question";
    public static final String ATTRIBUTE_POLLTYPE = "polltype";
    public static final String ATTRIBUTE_ACCESS = "access";
    public static final String ATTRIBUTE_CUSTOM = "custom";
    private JSOImplementation _jso = JSOImplementation.getInstance();
    private StreamDataFactory _sdf = this._jso.createDataFactory();

    public PolsterHelper(String question, List answers, boolean custom) {
        this._answers = new HashMap();
        XDataForm xdf = (XDataForm)this._sdf.createElementNode(new NSI("x", "jabber:x:data"), null);
        xdf.setType(XDataForm.FORM);
        this._pollMessage = new StringBuffer();
        if (custom) {
            XDataField c = xdf.addField(ATTRIBUTE_CUSTOM, XDataField.TEXT_SINGLE);
            c.setLabel("Custom Reply");
            this._answers.put(ATTRIBUTE_CUSTOM, new PolsterHelperAnswer());
        }
        XDataField q = xdf.addField(ATTRIBUTE_QUESTION, XDataField.LIST_SINGLE);
        q.setLabel(question);
        for (int i = 0; i < answers.size(); ++i) {
            String id = new Integer(i).toString();
            q.addOption((String)answers.get(i), id);
            this._answers.put(id, new PolsterHelperAnswer(id, (String)answers.get(i)));
        }
        this._pollMessage.append(xdf.toString());
    }

    public void characters(char[] ch, int start, int length) throws SAXException {
        switch (this._state) {
            case 5: {
                String id = String.copyValueOf(ch, start, length);
                this._currentAnswer = (PolsterHelperAnswer)this._answers.get(id);
                if (this._currentAnswer != null) break;
                throw new SAXException("No answer matching id " + id);
            }
            case 6: {
                this._quotedAnswer.append(ch, start, length);
                break;
            }
            default: {
                throw new SAXException("No characters at this stage");
            }
        }
    }

    public void startDocument() throws SAXException {
    }

    public void endElement(String nsuri, String localName, String fqName) throws SAXException {
        if (this._state == 5 || this._state == 6) {
            ++this._currentAnswer.count;
        }
    }

    public void startElement(String nsuri, String localName, String fqName, Attributes attributes) throws SAXException {
        if (fqName.equals(ELEMENT_FIELD)) {
            String attr = attributes.getValue(ATTRIBUTE_VAR);
            if (attr.equals(ATTRIBUTE_QUESTION)) {
                this._state = 5;
            } else if (attr.equals(ATTRIBUTE_CUSTOM)) {
                this._state = 6;
            }
        } else if (fqName.equals(ELEMENT_VALUE)) {
            this._quotedAnswer = new StringBuffer();
        }
    }

    public String parseAnswer(InputStream in) throws Exception {
        SAX.parse(in, (DefaultHandler)this);
        if (this._currentAnswer.custom) {
            return this._quotedAnswer.toString();
        }
        return this._currentAnswer.text;
    }

    public String parseAnswer(String str) throws Exception {
        SAX.parse(str, (DefaultHandler)this);
        if (this._currentAnswer.custom) {
            return this._quotedAnswer.toString();
        }
        return this._currentAnswer.text;
    }

    public String toString() {
        return this._pollMessage.toString();
    }
}

