/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cpp.picklist;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import javax.swing.event.EventListenerList;
import org.netbeans.modules.cpp.picklist.PicklistDataEvent;
import org.netbeans.modules.cpp.picklist.PicklistDataListener;
import org.netbeans.modules.cpp.picklist.PicklistElement;
import org.netbeans.modules.cpp.picklist.PicklistModel;

public class DefaultPicklistModel
implements PicklistModel,
Serializable {
    private static final long serialVersionUID = -8893287476464434693L;
    private int maxSize = 10;
    private static int increaseSize = 10;
    private PicklistElement[] picklist = null;
    private int picklistSize = 0;
    protected EventListenerList listenerList = null;
    static /* synthetic */ Class class$org$netbeans$modules$cpp$picklist$PicklistDataListener;

    public DefaultPicklistModel() {
        this.initialize(0);
    }

    public DefaultPicklistModel(int max) {
        this.initialize(max);
    }

    private EventListenerList getListenerList() {
        if (this.listenerList == null) {
            this.listenerList = new EventListenerList();
        }
        return this.listenerList;
    }

    private void initialize(int max) {
        if (max <= 0) {
            this.maxSize = 0;
            this.picklist = new PicklistElement[increaseSize];
        } else {
            this.maxSize = max;
            this.picklist = new PicklistElement[increaseSize];
        }
    }

    public void addElement(PicklistElement elem) {
        this.addElement(elem, true);
    }

    public synchronized void addElement(PicklistElement elem, boolean check) {
        int foundAt = this.contains(elem);
        int shiftDownFrom = 0;
        if (check && foundAt >= 0) {
            shiftDownFrom = foundAt;
            --this.picklistSize;
        } else {
            if (this.picklistSize == this.picklist.length) {
                PicklistElement[] picklist2 = new PicklistElement[this.picklist.length + increaseSize];
                for (int i = 0; i < this.picklist.length; ++i) {
                    picklist2[i] = this.picklist[i];
                }
                this.picklist = picklist2;
            }
            shiftDownFrom = this.picklistSize;
        }
        for (int i = shiftDownFrom; i > 0; --i) {
            this.picklist[i] = this.picklist[i - 1];
        }
        this.picklist[0] = elem;
        ++this.picklistSize;
        if (this.maxSize > 0 && this.picklistSize > this.maxSize) {
            --this.picklistSize;
        }
        this.fireContentsChanged(this);
    }

    public int contains(PicklistElement elem) {
        int foundAt = -1;
        if (elem != null) {
            for (int i = 0; i < this.picklistSize; ++i) {
                if (!this.picklist[i].equals(elem)) continue;
                foundAt = i;
                break;
            }
        }
        return foundAt;
    }

    public PicklistElement getElementAt(int index) {
        if (index >= 0 && index < this.picklistSize) {
            return this.picklist[index];
        }
        return null;
    }

    public PicklistElement[] getElements() {
        PicklistElement[] ret = new PicklistElement[this.picklistSize];
        for (int i = 0; i < this.picklistSize; ++i) {
            ret[i] = this.picklist[i];
        }
        return ret;
    }

    public String[] getElementsDisplayName() {
        PicklistElement[] elements = this.getElements();
        String[] elementsDisplayName = new String[this.getSize()];
        for (int i = 0; i < this.getSize(); ++i) {
            elementsDisplayName[i] = elements[i].displayName();
        }
        return elementsDisplayName;
    }

    public int getMaxSize() {
        return this.maxSize;
    }

    public PicklistElement getMostRecentUsedElement() {
        if (this.picklistSize > 0) {
            return this.picklist[0];
        }
        return null;
    }

    public int getSize() {
        return this.picklistSize;
    }

    public void removeAllElements() {
        this.picklistSize = 0;
        this.fireContentsChanged(this);
    }

    public PicklistElement removeElement(PicklistElement elem) {
        return this.removeElementAt(this.contains(elem));
    }

    public PicklistElement removeElementAt(int index) {
        PicklistElement toBeRemoved = null;
        if (index < 0 || index >= this.picklistSize) {
            return toBeRemoved;
        }
        toBeRemoved = this.picklist[index];
        for (int i = index; i < this.picklistSize - 1; ++i) {
            this.picklist[i] = this.picklist[i + 1];
        }
        --this.picklistSize;
        this.fireContentsChanged(this);
        return toBeRemoved;
    }

    public PicklistElement replaceElementAt(PicklistElement elem, int index) {
        PicklistElement toBeReplaced = null;
        if (index < 0 || index >= this.picklistSize) {
            return toBeReplaced;
        }
        toBeReplaced = this.picklist[index];
        this.picklist[index] = elem;
        this.fireContentsChanged(this);
        return toBeReplaced;
    }

    public void addPicklistDataListener(PicklistDataListener l) {
        this.getListenerList().add(class$org$netbeans$modules$cpp$picklist$PicklistDataListener == null ? (class$org$netbeans$modules$cpp$picklist$PicklistDataListener = DefaultPicklistModel.class$("org.netbeans.modules.cpp.picklist.PicklistDataListener")) : class$org$netbeans$modules$cpp$picklist$PicklistDataListener, l);
    }

    public void removePicklistDataListener(PicklistDataListener l) {
        this.getListenerList().remove(class$org$netbeans$modules$cpp$picklist$PicklistDataListener == null ? (class$org$netbeans$modules$cpp$picklist$PicklistDataListener = DefaultPicklistModel.class$("org.netbeans.modules.cpp.picklist.PicklistDataListener")) : class$org$netbeans$modules$cpp$picklist$PicklistDataListener, l);
    }

    public PicklistModel clonePicklist() {
        DefaultPicklistModel newpicklist = new DefaultPicklistModel(this.maxSize);
        for (int i = this.getSize() - 1; i >= 0; --i) {
            newpicklist.addElement(this.getElementAt(i), false);
        }
        return newpicklist;
    }

    public void copyPicklist(PicklistModel picklist) {
        this.removeAllElements();
        for (int i = picklist.getSize() - 1; i >= 0; --i) {
            this.addElement(picklist.getElementAt(i), false);
        }
    }

    public void dumpElements() {
        for (int i = 0; i < this.picklistSize; ++i) {
            System.out.println("[" + i + "] " + this.picklist[i].displayName());
        }
        System.out.println();
    }

    protected void fireContentsChanged(Object source) {
        Object[] listeners = this.getListenerList().getListenerList();
        PicklistDataEvent e = null;
        for (int i = listeners.length - 2; i >= 0; i -= 2) {
            if (listeners[i] != (class$org$netbeans$modules$cpp$picklist$PicklistDataListener == null ? DefaultPicklistModel.class$("org.netbeans.modules.cpp.picklist.PicklistDataListener") : class$org$netbeans$modules$cpp$picklist$PicklistDataListener)) continue;
            if (e == null) {
                e = new PicklistDataEvent(source, PicklistDataEvent.CONTENTS_CHANGED);
            }
            ((PicklistDataListener)listeners[i + 1]).contentsChanged(e);
        }
    }

    public void savePicklist(ObjectOutputStream out) {
        try {
            out.writeObject(this);
        }
        catch (IOException ioe) {
            System.out.println("DefaultPicklistModel - savePicklist - ioe " + ioe);
        }
    }

    public void savePicklist(String dir, String name) {
        File dirfile = new File(dir);
        if (!dirfile.exists()) {
            dirfile.mkdirs();
        }
        try {
            ObjectOutputStream oos = new ObjectOutputStream(new FileOutputStream(dir + File.separator + name));
            this.savePicklist(oos);
            oos.flush();
            oos.close();
        }
        catch (Exception e) {
            System.out.println("e " + e);
        }
    }

    public static PicklistModel restorePicklist(ObjectInputStream in) throws Exception {
        PicklistModel picklist = null;
        try {
            picklist = (PicklistModel)in.readObject();
        }
        catch (Exception e) {
            System.err.println("DefaultPicklistModel - restorePicklist - e " + e);
            throw e;
        }
        return picklist;
    }

    public static PicklistModel restorePicklist(String dir, String name) {
        PicklistModel ret = null;
        File file = new File(dir + File.separator + name);
        if (file.exists()) {
            try {
                ObjectInputStream ois = new ObjectInputStream(new FileInputStream(dir + File.separator + name));
                ret = DefaultPicklistModel.restorePicklist(ois);
                ois.close();
            }
            catch (Exception e) {
                System.err.println("DefaultPicklistModel - restorePicklist - e " + e);
                System.err.println("DefaultPicklistModel - restorePicklist - deleting serialized data");
                System.err.println("" + dir + File.separator + name + " deleted");
                file.delete();
            }
        }
        return ret;
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        try {
            out.writeObject(new Integer(this.maxSize));
            out.writeObject(new Integer(this.picklistSize));
            for (int i = 0; i < this.picklistSize; ++i) {
                out.writeObject(this.picklist[i]);
            }
        }
        catch (IOException ioe) {
            System.err.println("DefaultPicklistModel - writeObject - ioe " + ioe);
            throw ioe;
        }
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        try {
            this.maxSize = (Integer)in.readObject();
            this.picklistSize = (Integer)in.readObject();
            this.picklist = new PicklistElement[this.picklistSize];
            for (int i = 0; i < this.picklistSize; ++i) {
                PicklistElement e;
                this.picklist[i] = e = (PicklistElement)in.readObject();
            }
        }
        catch (IOException e) {
            System.err.println("DefaultPicklistModel - readObject - e " + e);
            throw e;
        }
        catch (ClassNotFoundException e) {
            System.err.println("DefaultPicklistModel - readObject - e " + e);
            throw e;
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

