/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cpp.picklist;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.ResourceBundle;
import javax.accessibility.AccessibleContext;
import javax.swing.AbstractAction;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextArea;
import javax.swing.KeyStroke;
import org.netbeans.api.javahelp.Help;
import org.netbeans.modules.cpp.picklist.ElementChangeEvent;
import org.netbeans.modules.cpp.picklist.ElementChangeListener;
import org.netbeans.modules.cpp.picklist.ElementPanel;
import org.openide.awt.EqualFlowLayout;
import org.openide.util.HelpCtx;
import org.openide.util.Lookup;
import org.openide.util.Utilities;

public class ActionDialog
extends JDialog
implements ElementChangeListener {
    public static int CANCEL_OPTION = 0;
    public static int ACTION_OPTION = 1;
    protected int returnValue = 0;
    private ElementPanel elementPanel = null;
    private Point lastLocation = null;
    private JButton actionButton;
    private JPanel buttonPanel;
    private JButton cancelButton;
    private JLabel errorLabel;
    private JTextArea guidanceTextArea;
    private JButton helpButton;
    private JPanel mainPanel;
    static /* synthetic */ Class class$org$netbeans$api$javahelp$Help;

    public ActionDialog(Frame parent) {
        super(parent, true);
        this.initComponents();
        this.buttonPanel.setLayout((LayoutManager)new EqualFlowLayout(2, 5, 0));
        this.setTitle(this.getTitleText());
        this.guidanceTextArea.setText(this.getGuidanceText());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(6, 12, 0, 11);
        gridBagConstraints.weightx = 1.0;
        this.elementPanel = this.getElementPanel();
        this.elementPanel.addChangeListener(this);
        this.mainPanel.add((Component)this.elementPanel, gridBagConstraints);
        this.actionButton.setText(this.getActionButtonText());
        this.pack();
        this.getRootPane().setDefaultButton(this.actionButton);
        String escape = "ActionDialog-escape";
        this.getRootPane().getActionMap().put(escape, new EscapeKeyAction());
        this.getRootPane().getInputMap(0).put(KeyStroke.getKeyStroke(27, 0), escape);
        this.getRootPane().getInputMap(1).put(KeyStroke.getKeyStroke(27, 0), escape);
        String help = "ActionDialog-F1";
        this.getRootPane().getActionMap().put(help, new HelpKeyAction());
        this.getRootPane().getInputMap(0).put(KeyStroke.getKeyStroke(112, 0), help);
        this.getRootPane().getInputMap(1).put(KeyStroke.getKeyStroke(112, 0), help);
        this.getRootPane().setFocusable(false);
        this.helpButton.setEnabled(this.getHelpCtx() != null);
        this.pack();
        if (this.lastLocation != null) {
            this.setLocation(this.lastLocation);
        } else {
            this.setBounds(Utilities.findCenterBounds((Dimension)this.getSize()));
        }
        this.initAccessibility();
    }

    private void initAccessibility() {
        AccessibleContext context = this.getAccessibleContext();
        context.setAccessibleName(this.getTitle());
        context.setAccessibleDescription(this.guidanceTextArea.getText());
        this.helpButton.getAccessibleContext().setAccessibleDescription(this.helpButton.getText());
        this.cancelButton.getAccessibleContext().setAccessibleDescription(this.cancelButton.getText());
        this.actionButton.getAccessibleContext().setAccessibleDescription(this.actionButton.getText());
    }

    private void initComponents() {
        this.mainPanel = new JPanel();
        this.guidanceTextArea = new JTextArea();
        this.errorLabel = new JLabel();
        this.buttonPanel = new JPanel();
        this.actionButton = new JButton();
        this.cancelButton = new JButton();
        this.helpButton = new JButton();
        this.setTitle("Make");
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent evt) {
                ActionDialog.this.returnValue = CANCEL_OPTION;
                ActionDialog.this.closeDialog(evt);
            }
        });
        this.mainPanel.setLayout(new GridBagLayout());
        this.guidanceTextArea.setBackground(new Color(204, 204, 204));
        this.guidanceTextArea.setEditable(false);
        this.guidanceTextArea.setLineWrap(true);
        this.guidanceTextArea.setText("G.T.:");
        this.guidanceTextArea.setWrapStyleWord(true);
        this.guidanceTextArea.setFocusable(false);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(12, 12, 0, 12);
        this.mainPanel.add((Component)this.guidanceTextArea, gridBagConstraints);
        this.errorLabel.setForeground(new Color(89, 79, 191));
        this.errorLabel.setText(" ");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(6, 12, 0, 11);
        this.mainPanel.add((Component)this.errorLabel, gridBagConstraints);
        this.buttonPanel.setLayout(new GridBagLayout());
        this.actionButton.setText("Action");
        this.actionButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                ActionDialog.this.actionButtonActionPerformed(evt);
            }
        });
        this.buttonPanel.add((Component)this.actionButton, new GridBagConstraints());
        this.cancelButton.setText(ResourceBundle.getBundle("org/netbeans/modules/cpp/picklist/Bundle").getString("ACTIONDIALOG_CANCEL_BUTTON_TXT"));
        this.cancelButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                ActionDialog.this.cancelButtonActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.insets = new Insets(0, 5, 0, 0);
        this.buttonPanel.add((Component)this.cancelButton, gridBagConstraints);
        this.helpButton.setMnemonic(ResourceBundle.getBundle("org/netbeans/modules/cpp/picklist/Bundle").getString("ACTIONDIALOG_HELP_BUTTON_MN").charAt(0));
        this.helpButton.setText(ResourceBundle.getBundle("org/netbeans/modules/cpp/picklist/Bundle").getString("ACTIONDIALOG_HELP_BUTTON_TXT"));
        this.helpButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                ActionDialog.this.helpButtonActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.insets = new Insets(0, 5, 0, 0);
        this.buttonPanel.add((Component)this.helpButton, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 13;
        gridBagConstraints.insets = new Insets(17, 11, 12, 11);
        this.mainPanel.add((Component)this.buttonPanel, gridBagConstraints);
        this.getContentPane().add((Component)this.mainPanel, "Center");
        this.pack();
    }

    public void handleHelp() {
        HelpCtx helpCtx = this.getHelpCtx();
        if (helpCtx != null) {
            Help h = (Help)Lookup.getDefault().lookup(class$org$netbeans$api$javahelp$Help == null ? (class$org$netbeans$api$javahelp$Help = ActionDialog.class$("org.netbeans.api.javahelp.Help")) : class$org$netbeans$api$javahelp$Help);
            if (h == null) {
                return;
            }
            h.showHelp(helpCtx);
        }
    }

    private void helpButtonActionPerformed(ActionEvent evt) {
        this.handleHelp();
    }

    private void cancelButtonActionPerformed(ActionEvent evt) {
        this.returnValue = CANCEL_OPTION;
        this.closeDialog(null);
    }

    private void actionButtonActionPerformed(ActionEvent evt) {
        this.returnValue = ACTION_OPTION;
        this.handleAction();
    }

    private void closeDialog(WindowEvent evt) {
        this.lastLocation = this.getLocation();
        this.setVisible(false);
        this.dispose();
    }

    public static void main(String[] args) {
        new ActionDialog(new JFrame()).show();
    }

    protected String getTitleText() {
        return "TitleText";
    }

    protected ElementPanel getElementPanel() {
        return new ElementPanel();
    }

    protected String getGuidanceText() {
        return "GuidanceText:";
    }

    protected String getActionButtonText() {
        return "ActionButtonText";
    }

    protected char getActionButtonMn() {
        return 'A';
    }

    protected void handleAction() {
        this.closeDialog(null);
    }

    protected HelpCtx getHelpCtx() {
        return null;
    }

    public void contentsChanged(ElementChangeEvent e) {
        switch (e.getType()) {
            case 2: {
                this.actionButton.setEnabled(true);
                this.getRootPane().setDefaultButton(this.actionButton);
                break;
            }
            case 3: {
                this.actionButton.setEnabled(false);
                break;
            }
            case 4: {
                this.errorLabel.setText(e.getText());
                break;
            }
            case 5: {
                this.errorLabel.setText(" ");
            }
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    private class HelpKeyAction
    extends AbstractAction {
        private HelpKeyAction() {
        }

        public void actionPerformed(ActionEvent evt) {
            ActionDialog.this.handleHelp();
        }
    }

    private class EscapeKeyAction
    extends AbstractAction {
        private EscapeKeyAction() {
        }

        public void actionPerformed(ActionEvent evt) {
            ActionDialog.this.returnValue = CANCEL_OPTION;
            ActionDialog.this.closeDialog(null);
        }
    }
}

