/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cpp.makewizard;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.io.File;
import java.util.LinkedList;
import javax.swing.DefaultListModel;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import org.netbeans.modules.cpp.makewizard.EnterItemsPanel;
import org.netbeans.modules.cpp.makewizard.MakeVarName;
import org.netbeans.modules.cpp.makewizard.MakefileWizard;
import org.netbeans.modules.cpp.makewizard.StdLibFlags;
import org.netbeans.modules.cpp.makewizard.TargetData;
import org.openide.util.NbBundle;

public class UserLibsPanel
extends EnterItemsPanel {
    static final long serialVersionUID = 3971722083122307369L;
    private int key;
    private boolean initialized;
    private JPanel stdLibPanel = null;
    private JTextField stdLibsText;
    private JLabel stdLibsLabel = null;
    private boolean stdLibPanelAdded = false;
    static /* synthetic */ Class class$org$netbeans$modules$cpp$makewizard$UserLibsPanel;

    UserLibsPanel(MakefileWizard wd) {
        super(wd);
        String subtitle = new String(this.getString("LBL_UserLibsPanel"));
        this.setSubTitle(subtitle);
        this.getAccessibleContext().setAccessibleDescription(subtitle);
        this.initialized = false;
    }

    private void create() {
        this.create(this.getString("LBL_UserLibs"), this.getString("MNEM_UserLibs").charAt(0), 72);
        this.stdLibPanel = new JPanel();
        this.stdLibPanel.setLayout(new GridBagLayout());
        this.stdLibsLabel = new JLabel();
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 18;
        this.stdLibPanel.add((Component)this.stdLibsLabel, gridBagConstraints);
        this.stdLibsText = new JTextField();
        this.stdLibsLabel.setLabelFor(this.stdLibsText);
        this.stdLibsText.setEditable(false);
        this.stdLibsText.setFocusable(false);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.gridx = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(0, 0, 0, 0);
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        this.stdLibPanel.add((Component)this.stdLibsText, gridBagConstraints);
    }

    private void addStdLibPanel() {
        if (!this.stdLibPanelAdded) {
            GridBagConstraints grid = new GridBagConstraints();
            grid.anchor = 18;
            grid.gridx = 0;
            grid.gridwidth = 0;
            grid.gridheight = 1;
            grid.weightx = 1.0;
            grid.weighty = 0.0;
            grid.fill = 2;
            grid.insets.top = 11;
            this.addComponent(this.stdLibPanel, grid);
            this.stdLibPanelAdded = true;
        }
    }

    private void removeStdLibPanel() {
        if (this.stdLibPanelAdded) {
            this.remove(this.stdLibPanel);
            this.stdLibPanelAdded = false;
        }
    }

    protected String getListLabel() {
        return this.getString("LBL_LibraryList");
    }

    protected char getListMnemonic() {
        return this.getString("MNEM_LibraryList").charAt(0);
    }

    protected String validateInput(String token) {
        if (token.charAt(0) == '-') {
            char c = token.charAt(1);
            if (c == 'L' || c == 'l' || c == 'B') {
                return token;
            }
            return null;
        }
        return token;
    }

    protected boolean checkErrorConditions(int tcount, LinkedList list, boolean nefiles) {
        return tcount == 1 && list.size() == 0;
    }

    protected EnterItemsPanel.ErrorInfo getErrorInfo() {
        return new EnterItemsPanel.ErrorInfo(this.getString("DLG_ULP_EmptyRE"), this.getString("MSG_NoFilesMatched"));
    }

    protected void addMultipleFiles(Object[] objects) {
        for (int i = 0; i < objects.length; ++i) {
            EnterItemsPanel.ListItem item;
            String name;
            if (!(objects[i] instanceof EnterItemsPanel.ListItem) || (name = (item = (EnterItemsPanel.ListItem)objects[i]).getName()).length() == 0 || name.charAt(0) == '-' || name.charAt(0) == '$' || name.indexOf(File.separator) >= 0 || name.endsWith(".a") || name.endsWith(".so")) continue;
            item.setName("-l" + name);
        }
        super.addMultipleFiles(objects);
    }

    public void addNotify() {
        TargetData target = this.getMakefileData().getCurrentTarget();
        int targetType = target.getTargetType();
        this.key = target.getKey();
        if (!this.initialized) {
            this.create();
            this.initialized = true;
        }
        if (targetType == 5) {
            // empty if block
        }
        if (targetType == 5) {
            MakeVarName var = new MakeVarName();
            var.setTargetName(target.getName());
            String s = var.makeRef("SYSLIBS_");
            if (target.getUserLibsList() == null) {
                target.setUserLibsList(new String[]{s});
            }
            StdLibFlags flags = target.getStdLibFlags();
            int os = this.getMakefileData().getMakefileOS();
            int toolset = this.getMakefileData().getToolset();
            String txt = flags.getSysLibFlags(toolset, os, this.getMakefileData().getCompilerFlags().is64Bit(), target);
            this.stdLibsText.setText(txt);
            this.stdLibsText.setToolTipText(txt);
            String ltxt = NbBundle.getMessage((Class)(class$org$netbeans$modules$cpp$makewizard$UserLibsPanel == null ? (class$org$netbeans$modules$cpp$makewizard$UserLibsPanel = UserLibsPanel.class$("org.netbeans.modules.cpp.makewizard.UserLibsPanel")) : class$org$netbeans$modules$cpp$makewizard$UserLibsPanel), (String)"LBL_SYSLIB", (Object)s);
            this.stdLibsLabel.setText(ltxt);
            this.addStdLibPanel();
        } else {
            this.removeStdLibPanel();
        }
        DefaultListModel model = (DefaultListModel)this.getList().getModel();
        model.removeAllElements();
        String[] slist = target.getUserLibsList();
        if (slist != null) {
            for (int i = 0; i < slist.length; ++i) {
                model.addElement(slist[i]);
            }
        }
        super.addNotify();
    }

    public void removeNotify() {
        super.removeNotify();
        TargetData target = this.getMakefileData().getTarget(this.key);
        target.setUserLibsList(this.getListItems());
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

