/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cpp.makewizard;

import java.util.ArrayList;
import org.netbeans.modules.cpp.loaders.CCFSrcLoader;
import org.netbeans.modules.cpp.loaders.HDataLoader;
import org.netbeans.modules.cpp.makewizard.CompilerFlags;
import org.netbeans.modules.cpp.makewizard.MakefileWizard;
import org.netbeans.modules.cpp.makewizard.OptionSource;
import org.netbeans.modules.cpp.makewizard.StdLibFlags;

public final class TargetData {
    private int targetType;
    private String name;
    private String outputDirectory;
    private int key;
    private String[] sourcesList;
    private String[] includesList;
    private StdLibFlags stdLibFlags;
    private String[] userLibsList;
    private String targetName;
    private String dependsOn;
    private String subdirectory;
    private String makeFlags;
    private ArrayList actions;
    private boolean compilable;
    private boolean complex;
    private boolean haveCppFiles;
    private boolean haveCFiles;
    private boolean haveFortranFiles;
    private boolean haveXdFiles;
    private boolean haveAssemblyFiles;
    public static final int SIMPLE_EXECUTABLE = 1;
    public static final int SIMPLE_ARCHIVE = 2;
    public static final int SIMPLE_SHAREDLIB = 3;
    public static final int COMPLEX_EXECUTABLE = 5;
    public static final int COMPLEX_ARCHIVE = 6;
    public static final int COMPLEX_SHAREDLIB = 7;
    public static final int COMPLEX_MAKE_TARGET = 8;
    public static final int COMPLEX_CUSTOM_TARGET = 9;
    private String indent = new String("");

    public TargetData(int targetType, String name, String outputDirectory, int key) {
        this.targetType = targetType;
        this.name = name;
        this.outputDirectory = outputDirectory;
        this.key = key;
        this.sourcesList = null;
        this.includesList = null;
        this.stdLibFlags = new StdLibFlags();
        this.userLibsList = null;
        this.targetName = null;
        this.dependsOn = null;
        this.subdirectory = null;
        this.makeFlags = null;
        this.actions = null;
        this.compilable = false;
        this.haveCppFiles = false;
        this.haveCFiles = false;
        this.haveFortranFiles = false;
        this.haveXdFiles = false;
        this.haveAssemblyFiles = false;
        this.compilable = targetType != 8 && targetType != 9;
        this.complex = targetType != 1 && targetType != 2 && targetType != 3;
    }

    public TargetData(TargetData old) {
        int i;
        this.targetType = old.targetType;
        this.name = new String(old.name);
        this.outputDirectory = new String(old.outputDirectory);
        this.key = old.key;
        this.sourcesList = null;
        this.targetName = old.targetName;
        this.dependsOn = old.dependsOn;
        this.subdirectory = old.subdirectory;
        this.makeFlags = old.makeFlags;
        this.actions = old.actions;
        this.compilable = old.compilable;
        this.complex = old.complex;
        this.haveCppFiles = false;
        this.haveCFiles = false;
        this.haveFortranFiles = false;
        this.haveXdFiles = false;
        this.haveAssemblyFiles = false;
        if (this.includesList != null) {
            this.includesList = new String[old.includesList.length];
            for (i = 0; i < this.includesList.length; ++i) {
                this.includesList[i] = old.includesList[i];
            }
        }
        if (this.stdLibFlags != null) {
            this.stdLibFlags = new StdLibFlags(old.stdLibFlags);
        }
        if (this.userLibsList != null) {
            this.userLibsList = new String[old.userLibsList.length];
            for (i = 0; i < this.userLibsList.length; ++i) {
                this.userLibsList[i] = old.userLibsList[i];
            }
        }
    }

    public int getTargetType() {
        return this.targetType;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public int getKey() {
        return this.key;
    }

    public String[] getSourcesList() {
        return this.sourcesList;
    }

    public void setSourcesList(String[] sourcesList) {
        this.sourcesList = sourcesList;
        this.haveCppFiles = false;
        this.haveCFiles = false;
        this.haveFortranFiles = false;
        this.haveXdFiles = false;
        this.haveAssemblyFiles = false;
        for (int i = 0; sourcesList != null && i < sourcesList.length; ++i) {
            if (!this.haveCppFiles && this.isCppFile(sourcesList[i])) {
                this.haveCppFiles = true;
            }
            if (!this.haveCFiles && this.isCFile(sourcesList[i])) {
                this.haveCFiles = true;
            }
            if (!this.haveFortranFiles && this.isFortranFile(sourcesList[i])) {
                this.haveFortranFiles = true;
            }
            if (!this.haveXdFiles && this.isXdFile(sourcesList[i])) {
                this.haveXdFiles = true;
            }
            if (this.haveAssemblyFiles || !this.isAssemblyFile(sourcesList[i])) continue;
            this.haveAssemblyFiles = true;
        }
    }

    public boolean isComplete() {
        if (this.targetType == 8 && (this.targetName != null || this.dependsOn != null || this.subdirectory != null || this.makeFlags != null)) {
            return true;
        }
        if (this.targetType == 9 && this.actions != null && this.actions.size() > 0) {
            return true;
        }
        return this.sourcesList != null && this.sourcesList.length > 0;
    }

    public String[] getIncludesList() {
        return this.includesList;
    }

    public void setIncludesList(String[] includesList) {
        this.includesList = includesList;
    }

    public String[] getUserLibsList() {
        return this.userLibsList;
    }

    public void setUserLibsList(String[] userLibsList) {
        this.userLibsList = userLibsList;
    }

    public String getOutputDirectory() {
        return this.outputDirectory;
    }

    public void setOutputDirectory(String outputDirectory) {
        String cwd = MakefileWizard.getMakefileWizard().getMakefileData().getBaseDirectory();
        this.outputDirectory = outputDirectory.startsWith(cwd) && outputDirectory.length() > cwd.length() ? outputDirectory.substring(cwd.length() + 1) : outputDirectory;
    }

    public StdLibFlags getStdLibFlags() {
        return this.stdLibFlags;
    }

    public String getTargetName() {
        return this.targetName;
    }

    public void setTargetName(String targetName) {
        this.targetName = targetName;
    }

    public String getDependsOn() {
        return this.dependsOn;
    }

    public void setDependsOn(String dependsOn) {
        this.dependsOn = dependsOn;
    }

    public String getSubdirectory() {
        return this.subdirectory;
    }

    public void setSubdirectory(String subdirectory) {
        this.subdirectory = subdirectory;
    }

    public String getMakeFlags() {
        return this.makeFlags;
    }

    public void setMakeFlags(String makeFlags) {
        this.makeFlags = makeFlags;
    }

    public ArrayList getActions() {
        if (this.actions == null) {
            this.actions = new ArrayList();
        }
        return this.actions;
    }

    public void setActions(ArrayList actions) {
        this.actions = actions;
    }

    public boolean isConvertable(int newType) {
        return this.targetType == 1 && newType == 5 || this.targetType == 2 && newType == 6 || this.targetType == 3 && newType == 7 || this.targetType == 5 && newType == 1 || this.targetType == 6 && newType == 2 || this.targetType == 7 && newType == 3;
    }

    public void convert() {
        CompilerFlags copts = MakefileWizard.getMakefileWizard().getMakefileData().getCompilerFlags();
        switch (this.targetType) {
            case 1: {
                this.targetType = 5;
                break;
            }
            case 2: {
                this.targetType = 6;
                break;
            }
            case 3: {
                this.targetType = 7;
            }
        }
        if (copts.isSimpleDebug()) {
            copts.setOptionSource(OptionSource.DEVELOPMENT);
            copts.setDevelDebug(true);
        } else if (copts.isSimpleOptimize()) {
            copts.setOptionSource(OptionSource.FINAL);
            copts.setFinalOptimize(true);
        }
    }

    public void convert(int newType) {
        CompilerFlags copts = MakefileWizard.getMakefileWizard().getMakefileData().getCompilerFlags();
        this.targetType = newType;
        if (copts.getOptionSource() == OptionSource.FINAL) {
            copts.setSimpleOptimize(copts.isFinalOptimize());
        } else {
            copts.setSimpleDebug(true);
            copts.setSimpleOptimize(!copts.isDevelDebug());
        }
    }

    public boolean isExecutable() {
        return this.targetType == 1 || this.targetType == 5;
    }

    public boolean isArchive() {
        return this.targetType == 2 || this.targetType == 6;
    }

    public boolean isSharedLib() {
        return this.targetType == 3 || this.targetType == 7;
    }

    public boolean isMakeTarget() {
        return this.targetType == 8;
    }

    public boolean isCustomTarget() {
        return this.targetType == 9;
    }

    public boolean isCppFile(String file) {
        String[] cppExtensions = CCFSrcLoader.getCppExtensions();
        for (int i = 0; i < cppExtensions.length; ++i) {
            if (!file.endsWith(cppExtensions[i])) continue;
            return true;
        }
        return false;
    }

    public boolean isCFile(String file) {
        String[] cExtensions = CCFSrcLoader.getCExtensions();
        for (int i = 0; i < cExtensions.length; ++i) {
            if (!file.endsWith(cExtensions[i])) continue;
            return true;
        }
        return false;
    }

    public boolean isHdrFile(String file) {
        String[] hdrExtensions = HDataLoader.getHdrExtensions();
        for (int i = 0; i < hdrExtensions.length; ++i) {
            if (!file.endsWith(hdrExtensions[i])) continue;
            return true;
        }
        return false;
    }

    public boolean isFortranFile(String file) {
        String[] fortranExtensions = CCFSrcLoader.getFortranExtensions();
        for (int i = 0; i < fortranExtensions.length; ++i) {
            if (!file.endsWith(fortranExtensions[i])) continue;
            return true;
        }
        return false;
    }

    public boolean isXdFile(String file) {
        return file.endsWith(".xd");
    }

    public boolean isAssemblyFile(String file) {
        String[] assemExtensions = CCFSrcLoader.getAssemExtensions();
        for (int i = 0; i < assemExtensions.length; ++i) {
            if (!file.endsWith(assemExtensions[i])) continue;
            return true;
        }
        return false;
    }

    public boolean isComplex() {
        return this.complex;
    }

    public boolean isLinked() {
        return this.targetType == 1 || this.targetType == 5 || this.targetType == 3 || this.targetType == 7;
    }

    public boolean isCompilable() {
        return this.compilable;
    }

    public boolean containsCppFiles() {
        return this.haveCppFiles;
    }

    public boolean containsCFiles() {
        return this.haveCFiles;
    }

    public boolean containsFortranFiles() {
        return this.haveFortranFiles;
    }

    public boolean containsXdFiles() {
        return this.haveXdFiles;
    }

    public boolean containsAssemblyFiles() {
        return this.haveAssemblyFiles;
    }

    public void dump() {
        int i;
        this.println("    name            = \"" + this.name + "\"");
        this.println("    type            = " + (this.targetType == 1 ? "SIMPLE_EXECUTABLE" : (this.targetType == 2 ? "SIMPLE_ARCHIVE" : (this.targetType == 3 ? "SIMPLE_SHAREDLIB" : (this.targetType == 5 ? "COMPLEX_EXECUTABLE" : (this.targetType == 6 ? "COMPLEX_ARCHIVE" : (this.targetType == 7 ? "COMPLEX_SHAREDLIB" : (this.targetType == 8 ? "COMPLEX_MAKE_TARGET" : (this.targetType == 9 ? "COMPLEX_CUSTOM_TARGET" : "Unknown")))))))));
        this.println("    key             = " + this.key);
        this.println("    outputDirectory = \"" + this.outputDirectory + "\"");
        if (this.sourcesList == null || this.sourcesList.length == 0) {
            this.println("    sourcesList     = {}");
        } else {
            this.println("    sourcesList     = {");
            for (i = 0; i < this.sourcesList.length; ++i) {
                this.println("        \"" + this.sourcesList[i] + "\"");
            }
            this.println("    }");
        }
        if (this.includesList == null || this.includesList.length == 0) {
            this.println("    includesList    = {}");
        } else {
            this.println("    includesList    = {");
            for (i = 0; i < this.includesList.length; ++i) {
                this.println("        \"" + this.includesList[i] + "\"");
            }
            this.println("    }");
        }
        this.stdLibFlags.dump();
        if (this.userLibsList == null || this.userLibsList.length == 0) {
            this.println("    userLibsList    = {}");
        } else {
            this.println("    userLibsList    = {");
            for (i = 0; i < this.userLibsList.length; ++i) {
                this.println("        \"" + this.userLibsList[i] + "\"");
            }
            this.println("    }");
        }
        this.println("    targetName      = \"" + this.targetName + "\"");
        this.println("    dependsOn       = \"" + this.dependsOn + "\"");
        this.println("    subdirectory    = \"" + this.subdirectory + "\"");
        this.println("    makeFlags       = \"" + this.makeFlags + "\"");
        if (this.actions == null || this.actions.size() == 0) {
            this.println("    actions         = {}");
        } else {
            this.println("    actions         = {");
            for (i = 0; i < this.actions.size(); ++i) {
                this.println("        " + this.actions.get(i).toString());
            }
            this.println("    }");
        }
    }

    public void dump(String in) {
        this.setIndent(in);
        this.dump();
    }

    private void println(String s) {
        System.out.println(this.indent + s);
    }

    private void setIndent(String indent) {
        this.indent = indent;
    }
}

