/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cpp.makewizard;

import java.util.ResourceBundle;
import org.netbeans.modules.cpp.makewizard.StdLib;
import org.netbeans.modules.cpp.makewizard.TargetData;
import org.openide.util.NbBundle;

public final class StdLibFlags {
    public StdLib motif = new StdLib(this.getString("TB_Motif"), this.getString("MNEM_Motif").charAt(0), "-lXm -lXt -lXext -lX11");
    public StdLib math = new StdLib(this.getString("TB_Math"), this.getString("MNEM_Math").charAt(0), "-lm");
    public StdLib socketnsl = new StdLib(this.getString("TB_Nsl"), this.getString("MNEM_Nsl").charAt(0), "-lsocket -lnsl");
    public StdLib solthread = new StdLib(this.getString("TB_SolThreads"), this.getString("MNEM_SolThreads").charAt(0), "-lthread");
    public StdLib posixthread = new StdLib(this.getString("TB_PosixThreads"), this.getString("MNEM_PosixThreads").charAt(0), "-lpthread");
    public StdLib posix4 = new StdLib(this.getString("TB_Posix4"), this.getString("MNEM_Posix4").charAt(0), "-lposix4");
    public StdLib i18n = new StdLib(this.getString("TB_I18n"), this.getString("MNEM_I18n").charAt(0), "-lintl");
    public StdLib genlib = new StdLib(this.getString("TB_GenLib"), this.getString("MNEM_GenLib").charAt(0), "-lm");
    public StdLib dynamiclib = new StdLib(this.getString("TB_DynamicLib"), this.getString("MNEM_DynamicLib").charAt(0), "-ldl");
    public StdLib curses = new StdLib(this.getString("TB_Curses"), this.getString("MNEM_Curses").charAt(0), "-lcurses");
    public StdLib rwtools = new StdLib(this.getString("TB_RWTools"), this.getString("MNEM_RWTools").charAt(0), "-library=rwtools7,iostream");
    public StdLib perflib = new StdLib(this.getString("TB_PerfLib"), this.getString("MNEM_PerfLib").charAt(0), "-xlic_lib=sunperf");
    private StdLib[] solarisStdLibs = new StdLib[]{this.motif, this.perflib, this.math, this.socketnsl, this.solthread, this.posixthread, this.posix4, this.i18n, this.genlib, this.curses, this.rwtools};
    private StdLib[] linuxStdLibs = new StdLib[]{this.motif, this.math, this.posixthread, this.dynamiclib, this.curses};
    private int linkType;
    public static final int STATIC_LINK_TYPE = 0;
    public static final int DYNAMIC_LINK_TYPE = 1;
    private String indent = new String("    ");
    private ResourceBundle bundle = null;
    static /* synthetic */ Class class$org$netbeans$modules$cpp$makewizard$MakefileWizardPanel;

    public StdLibFlags() {
        this.linkType = 1;
    }

    public StdLibFlags(StdLibFlags old) {
        this.motif = new StdLib(old.motif);
        this.math = new StdLib(old.math);
        this.socketnsl = new StdLib(old.socketnsl);
        this.solthread = new StdLib(old.solthread);
        this.posixthread = new StdLib(old.posixthread);
        this.posix4 = new StdLib(old.posix4);
        this.i18n = new StdLib(old.i18n);
        this.genlib = new StdLib(old.genlib);
        this.dynamiclib = new StdLib(old.dynamiclib);
        this.curses = new StdLib(old.curses);
        this.rwtools = new StdLib(old.rwtools);
        this.perflib = new StdLib(old.perflib);
    }

    public StdLib[] getSolarisStdLibs() {
        return this.solarisStdLibs;
    }

    public StdLib[] getLinuxStdLibs() {
        return this.linuxStdLibs;
    }

    public boolean isMotifLibs() {
        return this.motif.isUsed();
    }

    public void setMotifLibs(boolean motifLibs) {
        this.motif.setUsed(motifLibs);
    }

    public int getLinkType() {
        return this.linkType;
    }

    public void setLinkType(int linkType) {
        if (linkType == 0 || linkType == 1) {
            this.linkType = linkType;
        }
    }

    public String getSysLibFlags(int toolset, int os, boolean is64Bit, TargetData t) {
        StringBuffer buf = new StringBuffer(1024);
        if (this.getLinkType() == 1) {
            if (toolset == 0) {
                // empty if block
            }
        } else if (this.getLinkType() == 0) {
            if (toolset == 0) {
                buf.append("-Bstatic ");
            } else {
                buf.append("-static ");
            }
        }
        if (this.isMotifLibs() && !t.containsXdFiles()) {
            if (os == 0) {
                if (is64Bit) {
                    buf.append("-L/usr/openwin/lib/sparcv9 ");
                    buf.append("-L/usr/dt/lib/sparcv9 ");
                    buf.append("-R/usr/openwin/lib/sparcv9 ");
                    buf.append("-R/usr/dt/lib/sparcv9 ");
                } else {
                    buf.append("-L/usr/openwin/lib -L/usr/dt/lib ");
                    buf.append("-R/usr/openwin/lib -R/usr/dt/lib ");
                }
            } else if (os == 1) {
                if (is64Bit) {
                    buf.append("-L/usr/X11R6/lib ");
                } else {
                    buf.append("-L/usr/X11R6/lib ");
                }
            }
        }
        StdLib[] stdLibs = os == 0 ? this.getSolarisStdLibs() : this.getLinuxStdLibs();
        if (t.containsXdFiles()) {
            this.motif.setUsed(false);
            this.socketnsl.setUsed(false);
            this.genlib.setUsed(false);
        }
        for (int i = 0; i < stdLibs.length; ++i) {
            if (!stdLibs[i].isUsed()) continue;
            buf.append(stdLibs[i].getCmd());
            buf.append(" ");
        }
        return buf.toString();
    }

    protected void dump() {
        this.println("    stdLibFlags = {");
        this.println("    }\n");
    }

    public void dump(String in) {
        this.setIndent(in);
        this.dump();
    }

    private void println(String s) {
        System.out.println(this.indent + s);
    }

    private void setIndent(String indent) {
        this.indent = indent;
    }

    private String getString(String s) {
        if (this.bundle == null) {
            this.bundle = NbBundle.getBundle((Class)(class$org$netbeans$modules$cpp$makewizard$MakefileWizardPanel == null ? (class$org$netbeans$modules$cpp$makewizard$MakefileWizardPanel = StdLibFlags.class$("org.netbeans.modules.cpp.makewizard.MakefileWizardPanel")) : class$org$netbeans$modules$cpp$makewizard$MakefileWizardPanel));
        }
        return this.bundle.getString(s);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

