/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cpp.makewizard;

import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import org.netbeans.modules.cpp.makewizard.MakefileWizard;
import org.netbeans.modules.cpp.makewizard.MakefileWizardPanel;
import org.netbeans.modules.cpp.makewizard.StdLib;
import org.netbeans.modules.cpp.makewizard.StdLibFlags;
import org.netbeans.modules.cpp.makewizard.TargetData;
import org.netbeans.modules.cpp.utils.IpeUtils;

public class StandardLibsPanel
extends MakefileWizardPanel {
    static final long serialVersionUID = -1354448784992649011L;
    private JLabel libsLabel;
    private JPanel mainPanel;
    private JPanel currentCheckBoxPanel;
    private JPanel solarisCheckBoxPanel;
    private JPanel linuxCheckBoxPanel;
    private JCheckBox[] solarisCheckBoxes;
    private JCheckBox[] linuxCheckBoxes;
    private JComboBox linkModeCB;
    private int key;
    private boolean initialized;

    public StandardLibsPanel(MakefileWizard wd) {
        super(wd);
        String subtitle = new String(this.getString("LBL_StandardLibsPanel"));
        this.setSubTitle(subtitle);
        this.getAccessibleContext().setAccessibleDescription(subtitle);
        this.initialized = false;
    }

    private void create() {
        this.setLayout(new GridBagLayout());
        JPanel panel = new JPanel();
        this.mainPanel = new JPanel();
        panel.setLayout(new FlowLayout(0, 0, 0));
        this.mainPanel.setLayout(new GridBagLayout());
        this.libsLabel = new JLabel(this.getString("LBL_StdLibs"));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.insets = new Insets(0, 0, 0, 0);
        gridBagConstraints.anchor = 18;
        this.mainPanel.add((Component)this.libsLabel, gridBagConstraints);
        JPanel linkPanel = new JPanel();
        linkPanel.setLayout(new GridBagLayout());
        JLabel linkLabel = new JLabel(this.getString("LBL_LinkMode"));
        linkLabel.setDisplayedMnemonic(this.getString("MNEM_LinkMode").charAt(0));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(5, 0, 0, 0);
        linkPanel.add((Component)linkLabel, gridBagConstraints);
        this.linkModeCB = new JComboBox();
        linkLabel.setLabelFor(this.linkModeCB);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.gridx = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(0, 5, 0, 0);
        gridBagConstraints.anchor = 18;
        linkPanel.add((Component)this.linkModeCB, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.insets = new Insets(5, 0, 0, 0);
        gridBagConstraints.anchor = 18;
        this.mainPanel.add((Component)linkPanel, gridBagConstraints);
        panel.add(this.mainPanel);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        this.add((Component)panel, gridBagConstraints);
    }

    private void addCheckBoxPanel(JPanel checkBoxPanel) {
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.insets = new Insets(5, 0, 0, 0);
        gridBagConstraints.anchor = 18;
        this.mainPanel.add((Component)checkBoxPanel, gridBagConstraints);
    }

    private void removeCheckBoxPanel(JPanel checkBoxPanel) {
        if (checkBoxPanel != null) {
            this.mainPanel.remove(checkBoxPanel);
        }
    }

    private JPanel getCheckBoxPanel() {
        JPanel p;
        if (this.getMakefileData().getMakefileOS() == 0) {
            if (this.solarisCheckBoxPanel == null) {
                StdLib[] stdLibs = this.getMakefileData().getCurrentTarget().getStdLibFlags().getSolarisStdLibs();
                this.solarisCheckBoxes = new JCheckBox[stdLibs.length];
                this.solarisCheckBoxPanel = this.constructCheckBoxPanel(stdLibs, this.solarisCheckBoxes);
            }
            p = this.solarisCheckBoxPanel;
        } else {
            if (this.linuxCheckBoxPanel == null) {
                StdLib[] stdLibs = this.getMakefileData().getCurrentTarget().getStdLibFlags().getLinuxStdLibs();
                this.linuxCheckBoxes = new JCheckBox[stdLibs.length];
                this.linuxCheckBoxPanel = this.constructCheckBoxPanel(stdLibs, this.linuxCheckBoxes);
            }
            p = this.linuxCheckBoxPanel;
        }
        return p;
    }

    private JCheckBox[] getCheckBoxes() {
        if (this.getMakefileData().getMakefileOS() == 0) {
            return this.solarisCheckBoxes;
        }
        return this.linuxCheckBoxes;
    }

    private JPanel constructCheckBoxPanel(StdLib[] stdLibs, JCheckBox[] checkBoxes) {
        JPanel panel = new JPanel();
        panel.setLayout(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.insets = new Insets(0, 0, 0, 0);
        gridBagConstraints.anchor = 18;
        for (int i = 0; i < stdLibs.length; ++i) {
            checkBoxes[i] = new JCheckBox(stdLibs[i].getName());
            checkBoxes[i].setMnemonic(stdLibs[i].getMnemonic());
            panel.add((Component)checkBoxes[i], gridBagConstraints);
        }
        return panel;
    }

    public void addNotify() {
        TargetData target = this.getMakefileData().getCurrentTarget();
        StdLibFlags stdLibFlags = target.getStdLibFlags();
        StdLib[] stdLibs = this.getMakefileData().getMakefileOS() == 0 ? stdLibFlags.getSolarisStdLibs() : stdLibFlags.getLinuxStdLibs();
        this.key = target.getKey();
        if (!this.initialized) {
            this.create();
            this.initialized = true;
        }
        if (this.getCheckBoxPanel() != this.currentCheckBoxPanel) {
            this.removeCheckBoxPanel(this.currentCheckBoxPanel);
            this.currentCheckBoxPanel = this.getCheckBoxPanel();
            this.addCheckBoxPanel(this.currentCheckBoxPanel);
        }
        IpeUtils.requestFocus(this.getCheckBoxes()[0]);
        if (target.containsXdFiles()) {
            stdLibFlags.motif.setUsed(true);
            stdLibFlags.socketnsl.setUsed(true);
            stdLibFlags.genlib.setUsed(true);
        }
        for (int i = 0; i < stdLibs.length; ++i) {
            this.getCheckBoxes()[i].setSelected(stdLibs[i].isUsed());
        }
        this.linkModeCB.removeAllItems();
        if (this.getMakefileData().getToolset() == 0) {
            this.linkModeCB.addItem(this.getString("CB_Static_Sun"));
            this.linkModeCB.addItem(this.getString("CB_Dynamic_Sun"));
        } else {
            this.linkModeCB.addItem(this.getString("CB_Static_GNU"));
            this.linkModeCB.addItem(this.getString("CB_Dynamic_GNU"));
        }
        this.linkModeCB.setSelectedIndex(stdLibFlags.getLinkType());
        super.addNotify();
    }

    public void removeNotify() {
        super.removeNotify();
        TargetData target = this.getMakefileData().getTarget(this.key);
        StdLibFlags stdLibFlags = target.getStdLibFlags();
        StdLib[] stdLibs = this.getMakefileData().getMakefileOS() == 0 ? stdLibFlags.getSolarisStdLibs() : stdLibFlags.getLinuxStdLibs();
        for (int i = 0; i < stdLibs.length; ++i) {
            stdLibs[i].setUsed(this.getCheckBoxes()[i].isSelected());
        }
        stdLibFlags.setLinkType(this.linkModeCB.getSelectedIndex());
    }
}

