/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cpp.makewizard;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.ResourceBundle;
import org.netbeans.modules.cpp.makewizard.CompilerFlags;
import org.netbeans.modules.cpp.makewizard.MakefileWizard;
import org.netbeans.modules.cpp.makewizard.TargetData;
import org.netbeans.modules.cpp.utils.IpeUtils;
import org.openide.util.NbBundle;

public final class MakefileData {
    public static final int EXECUTABLE_MAKEFILE_TYPE = 1;
    public static final int ARCHIVE_MAKEFILE_TYPE = 2;
    public static final int SHAREDLIB_MAKEFILE_TYPE = 3;
    public static final int COMPLEX_MAKEFILE_TYPE = 4;
    public static final int SUN_TOOLSET_TYPE = 0;
    public static final int GNU_TOOLSET_TYPE = 1;
    public static final int SUNGNU_TOOLSET_TYPE = 2;
    public static final int SOLARIS_OS_TYPE = 0;
    public static final int LINUX_OS_TYPE = 1;
    public static final int UNIX_OS_TYPE = 2;
    private int conformLevelCSun = 1;
    public static final String[] conformLevelsCSun = new String[]{"-Xc", "", "-Xs"};
    private int conformLevelCppSun = 1;
    public static final String[] conformLevelsCppSun = new String[]{"-compat=4", ""};
    private int conformLevelCGNU = 1;
    public static final String[] conformLevelsCGNU = new String[]{"-ansi", ""};
    private int conformLevelCppGNU = 1;
    public static final String[] conformLevelsCppGNU = new String[]{"-ansi", ""};
    private int makefileType;
    private int toolset;
    private int makefileOS;
    private String baseDirectory;
    private String makefileName;
    private String makefileDirName;
    private ArrayList targetList;
    private CompilerFlags compilerFlags;
    private ResourceBundle bundle;
    private String cCompilerSun;
    private String cCompilerGNU;
    private String cppCompilerSun;
    private String cppCompilerGNU;
    private String fCompilerSun;
    private String fCompilerGNU;
    private int ftype;
    private boolean moduleEnabled;
    private String xdCompiler;
    private String asmPath;
    private static String binDir;
    public static final int COMPAT_DEFAULT = 0;
    public static final int COMPAT_ANSI = 1;
    public static final int COMPAT_4_2 = 2;
    public static final boolean EXPAND = true;
    private String indent;
    static /* synthetic */ Class class$org$netbeans$modules$cpp$makewizard$MakefileWizardPanel;

    public MakefileData() {
        this.makefileType = 4;
        this.toolset = 2;
        this.makefileOS = 2;
        this.baseDirectory = new String(System.getProperty("user.dir"));
        this.makefileName = this.getString("DFLT_MakefileName");
        this.targetList = new ArrayList();
        this.compilerFlags = new CompilerFlags();
        binDir = null;
        this.moduleEnabled = false;
    }

    public MakefileData(MakefileData old) {
        this.bundle = NbBundle.getBundle((Class)(class$org$netbeans$modules$cpp$makewizard$MakefileWizardPanel == null ? (class$org$netbeans$modules$cpp$makewizard$MakefileWizardPanel = MakefileData.class$("org.netbeans.modules.cpp.makewizard.MakefileWizardPanel")) : class$org$netbeans$modules$cpp$makewizard$MakefileWizardPanel));
        this.makefileType = old.getMakefileType();
        this.toolset = old.getToolset();
        this.makefileOS = old.getMakefileOS();
        this.baseDirectory = old.getBaseDirectory();
        this.makefileName = old.getMakefileName();
        this.makefileDirName = old.getMakefileDirName();
        this.targetList = new ArrayList();
        this.compilerFlags = new CompilerFlags();
    }

    public String getMakefilePath() {
        String path;
        String name = IpeUtils.expandPath(this.makefileName);
        if (name.charAt(0) == File.separatorChar) {
            path = this.makefileName;
        } else {
            File file = new File(this.getBaseDirectory(true), name);
            try {
                path = file.getCanonicalPath();
            }
            catch (IOException ex) {
                path = file.getAbsolutePath();
            }
        }
        return path;
    }

    public String defaultOutputDirectory() {
        String toolset = "toolset";
        String OS = "os";
        String dir = null;
        if (this.getToolset() == 0) {
            toolset = "Sun";
        } else if (this.getToolset() == 1) {
            toolset = "GNU";
        }
        if (this.getMakefileOS() == 0) {
            OS = "Solaris";
        } else if (this.getMakefileOS() == 1) {
            OS = "Linux";
        }
        dir = toolset + "-" + System.getProperty("os.arch") + "-" + OS;
        return dir;
    }

    public int getMakefileType() {
        return this.makefileType;
    }

    public void setMakefileType(int makefileType) {
        this.makefileType = makefileType;
    }

    public String getConformFlagCSun() {
        return conformLevelsCSun[this.conformLevelCSun];
    }

    public int getConformLevelCSun() {
        return this.conformLevelCSun;
    }

    public void setConformLevelCSun(int level) {
        this.conformLevelCSun = level;
    }

    public String getConformFlagCppSun() {
        return conformLevelsCppSun[this.conformLevelCppSun];
    }

    public int getConformLevelCppSun() {
        return this.conformLevelCppSun;
    }

    public void setConformLevelCppSun(int level) {
        this.conformLevelCppSun = level;
    }

    public String getConformFlagCGNU() {
        return conformLevelsCGNU[this.conformLevelCGNU];
    }

    public int getConformLevelCGNU() {
        return this.conformLevelCGNU;
    }

    public void setConformLevelCGNU(int level) {
        this.conformLevelCGNU = level;
    }

    public String getConformFlagCppGNU() {
        return conformLevelsCppGNU[this.conformLevelCppGNU];
    }

    public int getConformLevelCppGNU() {
        return this.conformLevelCppGNU;
    }

    public void setConformLevelCppGNU(int level) {
        this.conformLevelCppGNU = level;
    }

    public int getToolset() {
        return this.toolset;
    }

    public void setToolset(int toolset) {
        this.toolset = toolset;
    }

    public int getMakefileOS() {
        return this.makefileOS;
    }

    public void setMakefileOS(int makefileOS) {
        this.makefileOS = makefileOS;
    }

    public String getBaseDirectory() {
        return this.baseDirectory;
    }

    public String getBaseDirectory(boolean expand) {
        if (expand) {
            return IpeUtils.expandPath(this.baseDirectory);
        }
        return this.baseDirectory;
    }

    public void setBaseDirectory(String baseDirectory) {
        String dir = IpeUtils.trimSlashes(baseDirectory);
        if (dir == null || dir.length() == 0) {
            return;
        }
        char fc = dir.charAt(0);
        this.baseDirectory = fc == File.separatorChar || fc == '$' || fc == '~' ? dir : this.baseDirectory + File.separator + dir;
    }

    public String getMakefileName() {
        return this.makefileName;
    }

    public void setMakefileName(String makefileName) {
        if (makefileName.length() > 0) {
            this.makefileName = makefileName;
        }
    }

    public String getMakefileDirName() {
        return this.makefileDirName;
    }

    public void setMakefileDirName(String makefileDirName) {
        if (makefileDirName.length() > 0) {
            this.makefileDirName = makefileDirName;
        }
    }

    public CompilerFlags getCompilerFlags() {
        return this.compilerFlags;
    }

    public ArrayList getTargetList() {
        if (this.targetList == null) {
            this.targetList = new ArrayList(this.makefileType == 4 ? 15 : 1);
        }
        return this.targetList;
    }

    public TargetData getCurrentTarget() {
        int key = MakefileWizard.getMakefileWizard().getCurrentTargetKey();
        return this.getTarget(key);
    }

    public TargetData getTarget(int key) {
        TargetData target = null;
        for (int i = 0; i < this.targetList.size() && (target = (TargetData)this.targetList.get(i)).getKey() != key; ++i) {
        }
        return target;
    }

    public boolean isComplete(boolean ignoreCurrent) {
        TargetData ct = this.getCurrentTarget();
        for (int i = 0; i < this.targetList.size(); ++i) {
            TargetData target = (TargetData)this.targetList.get(i);
            if (target == ct && ignoreCurrent || target.isComplete()) continue;
            return false;
        }
        return this.targetList.size() > 0;
    }

    public boolean isComplete() {
        return this.isComplete(false);
    }

    public String getCCompiler(int toolset) {
        if (toolset == 0) {
            return this.getCCompilerSun();
        }
        if (toolset == 1) {
            return this.getCCompilerGNU();
        }
        return null;
    }

    public String getCCompilerSun() {
        if (this.cCompilerSun == null) {
            this.cCompilerSun = "cc";
        }
        return this.cCompilerSun;
    }

    public String getCCompilerGNU() {
        if (this.cCompilerGNU == null) {
            this.cCompilerGNU = "gcc";
        }
        return this.cCompilerGNU;
    }

    public void setCCompiler(int toolset, String cCompiler) {
        if (toolset == 0) {
            this.setCCompilerSun(cCompiler);
        } else if (toolset == 1) {
            this.setCCompilerGNU(cCompiler);
        }
    }

    public void setCCompilerSun(String cCompiler) {
        this.cCompilerSun = cCompiler;
    }

    public void setCCompilerGNU(String cCompiler) {
        this.cCompilerGNU = cCompiler;
    }

    public String getCppCompiler(int toolset) {
        if (toolset == 0) {
            return this.getCppCompilerSun();
        }
        if (toolset == 1) {
            return this.getCppCompilerGNU();
        }
        return null;
    }

    public String getCppCompilerSun() {
        if (this.cppCompilerSun == null) {
            this.cppCompilerSun = "CC";
        }
        return this.cppCompilerSun;
    }

    public String getCppCompilerGNU() {
        if (this.cppCompilerGNU == null) {
            this.cppCompilerGNU = "g++";
        }
        return this.cppCompilerGNU;
    }

    public void setCppCompiler(int toolset, String cppCompiler) {
        if (toolset == 0) {
            this.setCppCompilerSun(cppCompiler);
        } else if (toolset == 1) {
            this.setCppCompilerGNU(cppCompiler);
        }
    }

    public void setCppCompilerSun(String cppCompiler) {
        this.cppCompilerSun = cppCompiler;
    }

    public void setCppCompilerGNU(String cppCompiler) {
        this.cppCompilerGNU = cppCompiler;
    }

    public String getFCompiler(int toolset) {
        if (toolset == 0) {
            return this.getFCompilerSun();
        }
        if (toolset == 1) {
            return this.getFCompilerGNU();
        }
        return null;
    }

    public String getFCompilerSun() {
        if (this.fCompilerSun == null) {
            this.fCompilerSun = "f95";
        }
        return this.fCompilerSun;
    }

    public String getFCompilerGNU() {
        if (this.fCompilerGNU == null) {
            this.fCompilerGNU = "g77";
        }
        return this.fCompilerGNU;
    }

    public void setFCompiler(int toolset, String fCompiler) {
        if (toolset == 0) {
            this.setFCompilerSun(fCompiler);
        } else if (toolset == 1) {
            this.setFCompilerGNU(fCompiler);
        }
    }

    public void setFCompilerSun(String fCompiler) {
        this.fCompilerSun = fCompiler;
    }

    public void setFCompilerGNU(String fCompiler) {
        this.fCompilerGNU = fCompiler;
    }

    public String getAsmPath() {
        if (this.asmPath == null) {
            this.asmPath = "as";
        }
        return this.asmPath;
    }

    public void setAsmPath(String asmPath) {
        this.asmPath = asmPath;
    }

    private String getString(String s) {
        if (this.bundle == null) {
            this.bundle = NbBundle.getBundle((Class)(class$org$netbeans$modules$cpp$makewizard$MakefileWizardPanel == null ? (class$org$netbeans$modules$cpp$makewizard$MakefileWizardPanel = MakefileData.class$("org.netbeans.modules.cpp.makewizard.MakefileWizardPanel")) : class$org$netbeans$modules$cpp$makewizard$MakefileWizardPanel));
        }
        return this.bundle.getString(s);
    }

    public final boolean isModuleEnabled() {
        return this.moduleEnabled;
    }

    public void setModuleEnabled(boolean moduleEnabled) {
        this.moduleEnabled = moduleEnabled;
    }

    public void dump() {
        this.setIndent("");
        this.println("\n\nDumping Makefile:");
        this.println("    makefileType     = " + this.makefileType);
        this.println("    toolset " + this.toolset);
        this.println("    makefileOS     = " + this.makefileOS);
        this.println("    baseDirectory = \"" + this.baseDirectory + "\"");
        this.println("    makefileName     = \"" + this.makefileName + "\"");
        this.println("    makefileDirName  = \"" + this.makefileDirName + "\"");
        this.compilerFlags.dump(this.indent + "    ");
        this.println("    targetList.size  = " + this.targetList.size());
        for (int i = 0; i < this.targetList.size(); ++i) {
            this.println("    targetList[" + i + "]    = {");
            ((TargetData)this.targetList.get(i)).dump(this.indent + "    ");
            this.println("    }");
        }
    }

    public void dump(String indent) {
        this.setIndent(indent);
        this.dump();
    }

    private void println(String s) {
        System.out.println(this.indent + s);
    }

    private void setIndent(String indent) {
        this.indent = indent;
    }

    public boolean validateTargetName(String name, int type) {
        boolean ok = true;
        if (name == null || name.length() == 0) {
            ok = false;
        } else {
            switch (type) {
                case 5: 
                case 6: 
                case 7: {
                    ok = this.dontContainChar(name, ":#= \t()");
                    break;
                }
                case 8: 
                case 9: {
                    ok = this.dontContainChar(name, ":#= \t");
                    break;
                }
            }
        }
        return ok;
    }

    private boolean dontContainChar(String name, String chars) {
        boolean ok = true;
        if (chars != null && chars.length() != 0) {
            for (int i = 0; i < chars.length(); ++i) {
                if (name.indexOf(chars.charAt(i)) < 0) continue;
                ok = false;
                break;
            }
        }
        return ok;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

