/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cpp.makewizard;

import org.netbeans.modules.cpp.makewizard.OptionSource;

public final class CompilerFlags {
    private boolean simpleDebug = false;
    private boolean simpleOptimize = false;
    private boolean develDebug = true;
    private OptionSource optionSource = OptionSource.DEVELOPMENT;
    private boolean finalOptimize = false;
    private boolean finalStrip = false;
    private boolean comp64bit = false;
    private String cFlagsSun;
    private String cFlagsGNU;
    private String ccFlagsSun;
    private String ccFlagsGNU;
    private String f90Flags;
    private String indent;

    public boolean isSimpleDebug() {
        return this.simpleDebug;
    }

    public void setSimpleDebug(boolean simpleDebug) {
        this.simpleDebug = simpleDebug;
    }

    public boolean isSimpleOptimize() {
        return this.simpleOptimize;
    }

    public void setSimpleOptimize(boolean simpleOptimize) {
        this.simpleOptimize = simpleOptimize;
    }

    public boolean isDevelDebug() {
        return this.develDebug;
    }

    public void setDevelDebug(boolean develDebug) {
        this.develDebug = develDebug;
    }

    public OptionSource getOptionSource() {
        return this.optionSource;
    }

    public void setOptionSource(OptionSource optionSource) {
        this.optionSource = optionSource;
    }

    public boolean isFinalOptimize() {
        return this.finalOptimize;
    }

    public void setFinalOptimize(boolean finalOptimize) {
        this.finalOptimize = finalOptimize;
    }

    public boolean isFinalStrip() {
        return this.finalStrip;
    }

    public void setFinalStrip(boolean finalStrip) {
        this.finalStrip = finalStrip;
    }

    public boolean is64Bit() {
        return this.comp64bit;
    }

    public void set64Bit(boolean comp64bit) {
        this.comp64bit = comp64bit;
    }

    public String getCFlags(int toolset) {
        if (toolset == 0) {
            return this.getCFlagsSun();
        }
        if (toolset == 1) {
            return this.getCFlagsGNU();
        }
        return null;
    }

    public String getCFlagsSun() {
        if (this.cFlagsSun == null) {
            this.cFlagsSun = "$(BASICOPTS) -xCC";
        }
        return this.cFlagsSun;
    }

    public String getCFlagsGNU() {
        if (this.cFlagsGNU == null) {
            this.cFlagsGNU = "$(BASICOPTS)";
        }
        return this.cFlagsGNU;
    }

    public void setCFlags(int toolset, String cFlags) {
        if (toolset == 0) {
            this.setCFlagsSun(cFlags);
        } else if (toolset == 1) {
            this.setCFlagsGNU(cFlags);
        }
    }

    public void setCFlagsSun(String cFlags) {
        this.cFlagsSun = cFlags;
    }

    public void setCFlagsGNU(String cFlags) {
        this.cFlagsGNU = cFlags;
    }

    public String getCcFlags(int toolset) {
        if (toolset == 0) {
            return this.getCcFlagsSun();
        }
        if (toolset == 1) {
            return this.getCcFlagsGNU();
        }
        return null;
    }

    public String getCcFlagsSun() {
        if (this.ccFlagsSun == null) {
            this.ccFlagsSun = "$(BASICOPTS)";
        }
        return this.ccFlagsSun;
    }

    public String getCcFlagsGNU() {
        if (this.ccFlagsGNU == null) {
            this.ccFlagsGNU = "$(BASICOPTS)";
        }
        return this.ccFlagsGNU;
    }

    public void setCcFlags(int toolset, String ccFlags) {
        if (toolset == 0) {
            this.setCcFlagsSun(ccFlags);
        } else if (toolset == 1) {
            this.setCcFlagsGNU(ccFlags);
        }
    }

    public void setCcFlagsSun(String ccFlags) {
        this.ccFlagsSun = ccFlags;
    }

    public void setCcFlagsGNU(String ccFlags) {
        this.ccFlagsGNU = ccFlags;
    }

    public String getF90Flags() {
        if (this.f90Flags == null) {
            this.f90Flags = "$(BASICOPTS)";
        }
        return this.f90Flags;
    }

    public void setF90Flags(String f90Flags) {
        this.f90Flags = f90Flags;
    }

    public String getBasicOptions(int toolset) {
        if (toolset == 0) {
            return this.getBasicOptionsSun();
        }
        if (toolset == 1) {
            return this.getBasicOptionsGNU();
        }
        return null;
    }

    public String getBasicOptionsSun() {
        StringBuffer basicOptions = new StringBuffer(64);
        if (this.optionSource == OptionSource.SIMPLE) {
            if (this.simpleDebug) {
                basicOptions.append("-g ");
            }
            if (this.simpleOptimize) {
                basicOptions.append("-xO3 ");
            }
        } else if (this.optionSource == OptionSource.DEVELOPMENT) {
            if (this.develDebug) {
                basicOptions.append("-g ");
            } else {
                basicOptions.append("-g -xO3 ");
            }
        } else {
            if (this.finalOptimize) {
                basicOptions.append("-xO3 ");
            }
            if (this.finalStrip) {
                basicOptions.append("-s ");
            }
        }
        if (this.comp64bit) {
            basicOptions.append("-xarch=generic64 ");
        }
        return basicOptions.toString().trim();
    }

    public String getBasicOptionsGNU() {
        StringBuffer basicOptions = new StringBuffer(64);
        if (this.optionSource == OptionSource.SIMPLE) {
            if (this.simpleDebug) {
                basicOptions.append("-g ");
            }
            if (this.simpleOptimize) {
                basicOptions.append("-O ");
            }
        } else if (this.optionSource == OptionSource.DEVELOPMENT) {
            if (this.develDebug) {
                basicOptions.append("-g ");
            } else {
                basicOptions.append("-g -O ");
            }
        } else {
            if (this.finalOptimize) {
                basicOptions.append("-O ");
            }
            if (this.finalStrip) {
                basicOptions.append("-s ");
            }
        }
        if (this.comp64bit) {
            basicOptions.append("-m64 ");
        }
        return basicOptions.toString().trim();
    }

    public void dump() {
        this.println("Dumping CompilerFlags {");
        this.println("    Simple Debug      = ", this.simpleDebug);
        this.println("    Simple Optimize   = ", this.simpleOptimize);
        this.println("    OptionSource      = " + this.optionSource.toString());
        this.println("    Devel Debug       = True");
        this.println("    Devel Optimize    = ", !this.develDebug);
        this.println("    Final Optimize    = ", this.finalOptimize);
        this.println("    FinalStrip        = ", this.finalStrip);
        this.println("    64 Bit            = ", this.comp64bit);
        this.println("}");
    }

    public void dump(String in) {
        this.setIndent(in);
        this.dump();
    }

    private void println(String s) {
        System.out.println(this.indent + s);
    }

    private void println(String s, boolean tf) {
        System.out.println(this.indent + s + (tf ? "True" : "False"));
    }

    private void setIndent(String indent) {
        this.indent = indent;
    }
}

