/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cpp.makepicklist;

import java.io.File;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import org.netbeans.modules.cpp.picklist.PicklistElement;
import org.netbeans.modules.cpp.picklist.PicklistUtils;

public class MakePicklistElement
implements PicklistElement,
Serializable {
    private static final long serialVersionUID = -8893287493243243693L;
    private String makefile = null;
    private String targets = null;
    private String buildDirectory = null;
    private String makeCommand = null;
    private String otherArguments = null;

    public MakePicklistElement(String makefile, String targets, String buildDirectory, String makeCommand, String otherArguments) {
        this.makefile = makefile;
        this.targets = targets.trim();
        this.buildDirectory = buildDirectory;
        int i = this.makefile.lastIndexOf(File.separatorChar);
        if (i >= 0) {
            this.buildDirectory = PicklistUtils.toAbsolutePath(this.makefile.substring(0, i), buildDirectory);
        }
        this.makeCommand = makeCommand.trim();
        this.otherArguments = otherArguments.trim();
    }

    public boolean equals(PicklistElement elem) {
        boolean equal = true;
        equal = this.makefile.equals(((MakePicklistElement)elem).makefile);
        if (equal && this.targets != null) {
            equal = this.targets.equals(((MakePicklistElement)elem).targets);
        }
        if (equal && this.otherArguments != null) {
            equal = this.otherArguments.equals(((MakePicklistElement)elem).otherArguments);
        }
        return equal;
    }

    public String displayName() {
        String argsandcom = "";
        if (this.targets.length() > 0 || this.otherArguments.length() > 0) {
            if (this.otherArguments.length() > 0) {
                argsandcom = argsandcom + this.otherArguments;
            }
            if (this.targets.length() > 0 && this.otherArguments.length() > 0) {
                argsandcom = argsandcom + " ";
            }
            if (this.targets.length() > 0) {
                argsandcom = argsandcom + this.targets;
            }
        }
        return PicklistUtils.formatDisplayString(this.makefile, argsandcom, true);
    }

    public PicklistElement cloneElement() {
        return new MakePicklistElement(this.makefile, this.targets, this.buildDirectory, this.makeCommand, this.otherArguments);
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        try {
            out.writeObject(this.makefile);
            out.writeObject(this.targets);
            out.writeObject(this.buildDirectory);
            out.writeObject(this.makeCommand);
            out.writeObject(this.otherArguments);
        }
        catch (IOException ioe) {
            System.err.println("MakePicklistElement - writeObject - ioe " + ioe);
            throw ioe;
        }
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        try {
            this.makefile = (String)in.readObject();
            this.targets = (String)in.readObject();
            this.buildDirectory = (String)in.readObject();
            this.makeCommand = (String)in.readObject();
            this.otherArguments = (String)in.readObject();
        }
        catch (IOException e) {
            System.err.println("MakePicklistElement - readObject - e " + e);
            throw e;
        }
        catch (ClassNotFoundException e) {
            System.err.println("MakePicklistElement - readObject - e " + e);
            throw e;
        }
    }

    public String getMakefile() {
        return this.makefile;
    }

    public void setMakefile(String makefile) {
        this.makefile = makefile;
    }

    public String getTargets() {
        return this.targets;
    }

    public void setTargets(String targets) {
        this.targets = targets;
    }

    public String getBuildDirectory() {
        return this.buildDirectory;
    }

    public void setBuildDirectory(String buildDirectory) {
        this.buildDirectory = buildDirectory;
    }

    public String getMakeCommand() {
        return this.makeCommand;
    }

    public void setMakeCommand(String makeCommand) {
        this.makeCommand = makeCommand;
    }

    public String getOtherArguments() {
        return this.otherArguments;
    }

    public void setOtherArguments(String otherArguments) {
        this.otherArguments = otherArguments;
    }
}

