/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cpp.makepicklist;

import java.io.File;
import java.util.ResourceBundle;
import org.netbeans.modules.cpp.builds.MakeExecSupport;
import org.netbeans.modules.cpp.loaders.MakefileDataNode;
import org.netbeans.modules.cpp.makepicklist.MakeElementPanel;
import org.netbeans.modules.cpp.makewizard.MakefileWizard;
import org.netbeans.modules.cpp.makewizard.MakefileWizardEvent;
import org.netbeans.modules.cpp.makewizard.MakefileWizardListener;
import org.netbeans.modules.cpp.picklist.ElementChangeEvent;
import org.netbeans.modules.cpp.picklist.PicklistUtils;
import org.netbeans.modules.cpp.utils.CppUtils;
import org.openide.util.NbBundle;

public class MakeActionElementPanel
extends MakeElementPanel
implements MakefileWizardListener {
    private MakefileDataNode foundMakefile = null;
    private ResourceBundle bundle;
    static /* synthetic */ Class class$org$netbeans$modules$cpp$makepicklist$MakeActionElementPanel;

    public MakeActionElementPanel() {
        MakefileWizard.addMakefileWizardListener(this);
    }

    public void validate() {
        String makefilePath = this.getMakefile();
        if (makefilePath == null || makefilePath.length() == 0) {
            this.fireChanged(new ElementChangeEvent(this, 5));
            this.fireChanged(new ElementChangeEvent(this, 3));
            this.blankAttrFields();
            this.setAttrFieldsEnabled(false);
            this.foundMakefile = null;
            return;
        }
        File makefileFile = new File(makefilePath);
        if (!makefileFile.exists()) {
            this.fireChanged(new ElementChangeEvent(this, 4, this.getString("ERROR_DONTEXIST")));
            this.fireChanged(new ElementChangeEvent(this, 3));
            this.blankAttrFields();
            this.setAttrFieldsEnabled(false);
            this.foundMakefile = null;
            return;
        }
        if (makefileFile.isDirectory()) {
            this.fireChanged(new ElementChangeEvent(this, 4, this.getString("ERROR_NOTAMAKEFILE")));
            this.fireChanged(new ElementChangeEvent(this, 3));
            this.blankAttrFields();
            this.setAttrFieldsEnabled(false);
            this.foundMakefile = null;
            return;
        }
        MakefileDataNode makefileNode = PicklistUtils.findMakefileDataNode(makefilePath);
        this.initPanel(makefileNode);
    }

    public void initPanelFromNode(MakefileDataNode makefileNode) {
        if (makefileNode != null && makefileNode.getDataObject() != null) {
            this.setMakefile(CppUtils.getPath(makefileNode.getDataObject().getPrimaryFile()));
        }
        this.initPanel(makefileNode);
    }

    private void initPanel(MakefileDataNode makefileNode) {
        String makefilePath = this.getMakefile();
        MakeExecSupport mes = PicklistUtils.findMakeExecSupport(makefileNode);
        if (mes == null) {
            this.fireChanged(new ElementChangeEvent(this, 4, this.getString("ERROR_NOTAMAKEFILE")));
            this.fireChanged(new ElementChangeEvent(this, 3));
            this.blankAttrFields();
            this.setAttrFieldsEnabled(false);
            this.foundMakefile = null;
            return;
        }
        this.fireChanged(new ElementChangeEvent(this, 5));
        this.fireChanged(new ElementChangeEvent(this, 2));
        this.setAttrFieldsEnabled(true);
        this.addTargetItems(mes.getMakeTargetsArray());
        if (makefileNode != this.foundMakefile) {
            String buildDirectory = mes.getBuildDirectory();
            int i = makefilePath.lastIndexOf(File.separatorChar);
            if (i >= 0) {
                buildDirectory = PicklistUtils.toAbsolutePath(makefilePath.substring(0, i), buildDirectory);
            }
            this.setTargets("");
            this.setBuildDirectory(buildDirectory);
            this.setMakeCommand(mes.getMakeCommand());
            this.setOtherArguments(mes.getMakeOptions());
        }
        this.foundMakefile = makefileNode;
    }

    public void makefileCreated(MakefileWizardEvent e) {
        this.setMakefile(e.getMakefilePath());
        this.blankAttrFields();
        this.setAttrFieldsEnabled(false);
        this.foundMakefile = null;
    }

    private String getString(String s) {
        if (this.bundle == null) {
            this.bundle = NbBundle.getBundle((Class)(class$org$netbeans$modules$cpp$makepicklist$MakeActionElementPanel == null ? (class$org$netbeans$modules$cpp$makepicklist$MakeActionElementPanel = MakeActionElementPanel.class$("org.netbeans.modules.cpp.makepicklist.MakeActionElementPanel")) : class$org$netbeans$modules$cpp$makepicklist$MakeActionElementPanel));
        }
        return this.bundle.getString(s);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

