/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cpp.loadpicklist;

import org.netbeans.modules.cpp.loadpicklist.LoadExecutablePicklistElement;
import org.netbeans.modules.cpp.makewizard.MakefileWizard;
import org.netbeans.modules.cpp.makewizard.MakefileWizardEvent;
import org.netbeans.modules.cpp.makewizard.MakefileWizardListener;
import org.netbeans.modules.cpp.picklist.DefaultPicklistModel;
import org.netbeans.modules.cpp.utils.IpeUtils;

public class LoadPicklist
extends DefaultPicklistModel
implements MakefileWizardListener {
    private static LoadPicklist instance = null;
    private static int picklistMaxSize = 100;
    private static String savehome = null;
    private static String savedir = "/system/picklists";
    private static String savename = "load";

    public LoadPicklist() {
        instance = this;
        MakefileWizard.addMakefileWizardListener(this);
    }

    public LoadPicklist(int max) {
        super(max);
        instance = this;
        MakefileWizard.addMakefileWizardListener(this);
    }

    private static String getSavehome() {
        if (savehome == null) {
            savehome = System.getProperty("netbeans.user");
        }
        if (savehome == null) {
            savehome = "/tmp";
        }
        return savehome;
    }

    public static LoadPicklist getInstance() {
        if (instance == null) {
            try {
                instance = LoadPicklist.restorePicklist();
            }
            catch (Exception e) {
                System.out.println("LoadPicklist - getInstance - e " + e);
                System.out.println("Cannot restore picklist ...");
            }
            if (instance == null) {
                instance = new LoadPicklist(picklistMaxSize);
            }
        }
        return instance;
    }

    public void savePicklist() {
        this.savePicklist(LoadPicklist.getSavehome() + savedir, savename);
    }

    public static LoadPicklist restorePicklist() {
        instance = (LoadPicklist)LoadPicklist.restorePicklist(LoadPicklist.getSavehome() + savedir, savename);
        if (instance != null) {
            MakefileWizard.addMakefileWizardListener(instance);
        }
        return instance;
    }

    public void makefileCreated(MakefileWizardEvent e) {
        String[] executables = e.getExecutables();
        if (executables != null) {
            for (int i = 0; i < executables.length; ++i) {
                this.addElement(new LoadExecutablePicklistElement(executables[i], "", IpeUtils.getDirName(executables[i])));
            }
        }
        this.savePicklist();
    }
}

