/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cpp.loaders;

import java.io.IOException;
import java.util.Set;
import org.netbeans.modules.cpp.execution.BinaryExecSupport;
import org.netbeans.modules.cpp.loaders.CppEditorSupport;
import org.openide.debugger.Debugger;
import org.openide.filesystems.FileObject;
import org.openide.loaders.DataFolder;
import org.openide.loaders.DataObject;
import org.openide.loaders.DataObjectExistsException;
import org.openide.loaders.MultiDataObject;
import org.openide.loaders.MultiFileLoader;
import org.openide.nodes.CookieSet;
import org.openide.nodes.Node;
import org.openide.util.HelpCtx;
import org.openide.util.Lookup;
import org.openide.util.NbBundle;

public abstract class CCFSrcObject
extends MultiDataObject {
    static final long serialVersionUID = -6788084224129713370L;
    public static final String OBJ_EXTENSION = "o";
    private static CircularQueue cq;
    static /* synthetic */ Class class$org$netbeans$modules$cpp$loaders$CCFSrcObject;
    static /* synthetic */ Class class$org$openide$cookies$ExecCookie;
    static /* synthetic */ Class class$org$openide$cookies$DebuggerCookie;
    static /* synthetic */ Class class$org$openide$debugger$Debugger;

    public CCFSrcObject(FileObject pf, MultiFileLoader loader) throws DataObjectExistsException {
        super(pf, loader);
        this.init();
        if (cq == null) {
            cq = new CircularQueue(10, 0L);
        }
        cq.add(System.currentTimeMillis());
    }

    protected void init() {
        CookieSet cookies = this.getCookieSet();
        MultiDataObject.Entry primary = this.getPrimaryEntry();
        cookies.add((Node.Cookie)new CppEditorSupport(primary));
        cookies.add((Node.Cookie)new BinaryExecSupport(primary));
    }

    public final Set getDeleteList() {
        return this.secondaryEntries();
    }

    public HelpCtx getHelpCtx() {
        return HelpCtx.DEFAULT_HELP;
    }

    protected abstract Node createNodeDelegate();

    public final void removeSecondaryEntryAccess(MultiDataObject.Entry fe) {
        this.removeSecondaryEntry(fe);
    }

    protected DataObject handleCreateFromTemplate(DataFolder df, String name) throws IOException {
        if (name != null && !CCFSrcObject.isValidName(name)) {
            throw new IOException(NbBundle.getMessage((Class)(class$org$netbeans$modules$cpp$loaders$CCFSrcObject == null ? (class$org$netbeans$modules$cpp$loaders$CCFSrcObject = CCFSrcObject.class$("org.netbeans.modules.cpp.loaders.CCFSrcObject")) : class$org$netbeans$modules$cpp$loaders$CCFSrcObject), (String)"FMT_Not_Valid_FileName", (Object)name));
        }
        return super.handleCreateFromTemplate(df, name);
    }

    static boolean isValidName(String name) {
        int len = name.length();
        if (len == 0) {
            return false;
        }
        for (int i = 0; i < len; ++i) {
            char c = name.charAt(i);
            if (Character.isLetterOrDigit(c) || c == '.' || c == '-' || c == '_' || !Character.isISOControl(c)) continue;
            return false;
        }
        return true;
    }

    public Node.Cookie getCookie(Class c) {
        if (c.isAssignableFrom(class$org$openide$cookies$ExecCookie == null ? (class$org$openide$cookies$ExecCookie = CCFSrcObject.class$("org.openide.cookies.ExecCookie")) : class$org$openide$cookies$ExecCookie)) {
            return null;
        }
        if (c.isAssignableFrom(class$org$openide$cookies$DebuggerCookie == null ? (class$org$openide$cookies$DebuggerCookie = CCFSrcObject.class$("org.openide.cookies.DebuggerCookie")) : class$org$openide$cookies$DebuggerCookie)) {
            Debugger defaultDebugger = (Debugger)Lookup.getDefault().lookup(class$org$openide$debugger$Debugger == null ? (class$org$openide$debugger$Debugger = CCFSrcObject.class$("org.openide.debugger.Debugger")) : class$org$openide$debugger$Debugger);
            if (defaultDebugger == null || defaultDebugger.getState() == 1) {
                return null;
            }
            return super.getCookie(c);
        }
        return super.getCookie(c);
    }

    public long sum(int num) {
        return cq.sum(num);
    }

    public long mostRecent() {
        return cq.mostRecent();
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    public class CircularQueue {
        private Long[] queue;
        private int head;
        private int count;
        private int size;
        private long created;

        public CircularQueue(int size) {
            this.size = size;
            this.queue = new Long[size];
            this.created = System.currentTimeMillis();
            this.head = 0;
            this.count = 0;
        }

        public CircularQueue(int size, long created) {
            this(size);
            this.created = created;
        }

        public void add(long val) {
            ++this.count;
            this.queue[this.head++] = new Long(val - this.created);
            if (this.head >= this.size) {
                this.head = 0;
            }
        }

        public long sum(int num) {
            long sum = 0L;
            if (num > this.count) {
                return -1L;
            }
            int i = this.head - 1;
            while (num-- > 0) {
                if (i < 0) {
                    i = this.size - 1;
                }
                sum += this.queue[i--].longValue();
            }
            return sum;
        }

        public long mostRecent() {
            return this.sum(1);
        }
    }
}

