/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cpp.loaders;

import java.io.File;
import java.io.IOException;
import java.text.DateFormat;
import java.text.Format;
import java.util.Date;
import java.util.Map;
import java.util.Properties;
import org.netbeans.modules.cpp.loaders.AssemSrcObject;
import org.netbeans.modules.cpp.loaders.CCSrcObject;
import org.netbeans.modules.cpp.loaders.CSrcObject;
import org.netbeans.modules.cpp.loaders.FortranSrcObject;
import org.netbeans.modules.cpp.settings.CppSettings;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.loaders.DataObjectExistsException;
import org.openide.loaders.FileEntry;
import org.openide.loaders.MultiDataObject;
import org.openide.loaders.MultiFileLoader;
import org.openide.util.MapFormat;
import org.openide.util.NbBundle;
import org.openide.util.actions.SystemAction;

public final class CCFSrcLoader
extends MultiFileLoader {
    static final long serialVersionUID = 6801389470714975682L;
    private static int count;
    private static final String[] cppExtensions;
    private static final String[] fortranExtensions;
    protected static SystemAction[] standardActions;
    static /* synthetic */ Class class$org$openide$actions$OpenAction;
    static /* synthetic */ Class class$org$openide$actions$FileSystemAction;
    static /* synthetic */ Class class$org$openide$actions$CutAction;
    static /* synthetic */ Class class$org$openide$actions$CopyAction;
    static /* synthetic */ Class class$org$openide$actions$PasteAction;
    static /* synthetic */ Class class$org$openide$actions$DeleteAction;
    static /* synthetic */ Class class$org$openide$actions$RenameAction;
    static /* synthetic */ Class class$org$openide$actions$SaveAsTemplateAction;
    static /* synthetic */ Class class$org$openide$actions$ToolsAction;
    static /* synthetic */ Class class$org$openide$actions$PropertiesAction;
    static /* synthetic */ Class class$org$netbeans$modules$cpp$loaders$CCFSrcLoader;
    static /* synthetic */ Class class$org$netbeans$modules$cpp$settings$CppSettings;

    protected CCFSrcLoader() {
        super("org.netbeans.modules.cpp.loaders.CCFSrcObject");
    }

    protected CCFSrcLoader(String representationClassName) {
        super(representationClassName);
    }

    protected CCFSrcLoader(Class representationClass) {
        super(representationClass);
    }

    protected SystemAction[] createDefaultActions() {
        return new SystemAction[]{SystemAction.get((Class)(class$org$openide$actions$OpenAction == null ? (class$org$openide$actions$OpenAction = CCFSrcLoader.class$("org.openide.actions.OpenAction")) : class$org$openide$actions$OpenAction)), SystemAction.get((Class)(class$org$openide$actions$FileSystemAction == null ? (class$org$openide$actions$FileSystemAction = CCFSrcLoader.class$("org.openide.actions.FileSystemAction")) : class$org$openide$actions$FileSystemAction)), null, SystemAction.get((Class)(class$org$openide$actions$CutAction == null ? (class$org$openide$actions$CutAction = CCFSrcLoader.class$("org.openide.actions.CutAction")) : class$org$openide$actions$CutAction)), SystemAction.get((Class)(class$org$openide$actions$CopyAction == null ? (class$org$openide$actions$CopyAction = CCFSrcLoader.class$("org.openide.actions.CopyAction")) : class$org$openide$actions$CopyAction)), SystemAction.get((Class)(class$org$openide$actions$PasteAction == null ? (class$org$openide$actions$PasteAction = CCFSrcLoader.class$("org.openide.actions.PasteAction")) : class$org$openide$actions$PasteAction)), null, SystemAction.get((Class)(class$org$openide$actions$DeleteAction == null ? (class$org$openide$actions$DeleteAction = CCFSrcLoader.class$("org.openide.actions.DeleteAction")) : class$org$openide$actions$DeleteAction)), SystemAction.get((Class)(class$org$openide$actions$RenameAction == null ? (class$org$openide$actions$RenameAction = CCFSrcLoader.class$("org.openide.actions.RenameAction")) : class$org$openide$actions$RenameAction)), null, SystemAction.get((Class)(class$org$openide$actions$SaveAsTemplateAction == null ? (class$org$openide$actions$SaveAsTemplateAction = CCFSrcLoader.class$("org.openide.actions.SaveAsTemplateAction")) : class$org$openide$actions$SaveAsTemplateAction)), null, SystemAction.get((Class)(class$org$openide$actions$ToolsAction == null ? (class$org$openide$actions$ToolsAction = CCFSrcLoader.class$("org.openide.actions.ToolsAction")) : class$org$openide$actions$ToolsAction)), SystemAction.get((Class)(class$org$openide$actions$PropertiesAction == null ? (class$org$openide$actions$PropertiesAction = CCFSrcLoader.class$("org.openide.actions.PropertiesAction")) : class$org$openide$actions$PropertiesAction))};
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected SystemAction[] defaultActions() {
        if (standardActions != null) {
            return standardActions;
        }
        Class<?> clazz = ((Object)((Object)this)).getClass();
        synchronized (clazz) {
            if (standardActions == null) {
                standardActions = this.createDefaultActions();
            }
        }
        return standardActions;
    }

    protected String defaultDisplayName() {
        return NbBundle.getMessage((Class)(class$org$netbeans$modules$cpp$loaders$CCFSrcLoader == null ? (class$org$netbeans$modules$cpp$loaders$CCFSrcLoader = CCFSrcLoader.class$("org.netbeans.modules.cpp.loaders.CCFSrcLoader")) : class$org$netbeans$modules$cpp$loaders$CCFSrcLoader), (String)"PROP_CCFSrcLoader_Name");
    }

    protected FileObject findPrimaryFile(FileObject fo) {
        int i;
        if (fo.isFolder()) {
            return null;
        }
        if (fo.hasExt("c")) {
            this.countFile();
            return fo;
        }
        for (i = 0; i < cppExtensions.length; ++i) {
            if (!fo.hasExt(cppExtensions[i])) continue;
            this.countFile();
            return fo;
        }
        for (i = 0; i < fortranExtensions.length; ++i) {
            if (!fo.hasExt(fortranExtensions[i])) continue;
            this.countFile();
            return fo;
        }
        if (fo.hasExt("s")) {
            this.countFile();
            return fo;
        }
        if (fo.hasExt("o")) {
            FileObject fb = FileUtil.findBrother((FileObject)fo, (String)"c");
            if (fb != null) {
                // empty if block
            }
            if (fb == null) {
                for (i = 0; i < cppExtensions.length && (fb = FileUtil.findBrother((FileObject)fo, (String)cppExtensions[i])) == null; ++i) {
                }
            }
            if (fb == null) {
                for (i = 0; i < fortranExtensions.length && (fb = FileUtil.findBrother((FileObject)fo, (String)fortranExtensions[i])) == null; ++i) {
                }
            }
            if (fb == null && fo.hasExt("s")) {
                fb = FileUtil.findBrother((FileObject)fo, (String)"s");
            }
            if (fb != null) {
                fb.setImportant(true);
                fo.setImportant(false);
                this.countFile();
                return fb;
            }
        }
        return null;
    }

    protected MultiDataObject createMultiObject(FileObject primaryFile) throws DataObjectExistsException, IOException {
        int i;
        if (primaryFile.hasExt("c")) {
            return new CSrcObject(primaryFile, this);
        }
        for (i = 0; i < cppExtensions.length; ++i) {
            if (!primaryFile.hasExt(cppExtensions[i])) continue;
            return new CCSrcObject(primaryFile, this);
        }
        for (i = 0; i < fortranExtensions.length; ++i) {
            if (!primaryFile.hasExt(fortranExtensions[i])) continue;
            return new FortranSrcObject(primaryFile, this);
        }
        if (primaryFile.hasExt("c")) {
            return new AssemSrcObject(primaryFile, this);
        }
        return new CSrcObject(primaryFile, this);
    }

    protected MultiDataObject.Entry createPrimaryEntry(MultiDataObject obj, FileObject primaryFile) {
        return new CCFFormat(obj, primaryFile);
    }

    protected MultiDataObject.Entry createSecondaryEntry(MultiDataObject obj, FileObject secondaryFile) {
        secondaryFile.setImportant(false);
        return new FileEntry.Numb(obj, secondaryFile);
    }

    private void countFile() {
        if (File.separatorChar == '/') {
            ++count;
        }
    }

    public static int getCCFFilesCount() {
        return count;
    }

    public static String[] getCExtensions() {
        return new String[]{new String("c")};
    }

    public static String[] getCppExtensions() {
        return cppExtensions;
    }

    public static String[] getFortranExtensions() {
        return fortranExtensions;
    }

    public static String[] getAssemExtensions() {
        return new String[]{new String("s")};
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static {
        int i;
        count = 0;
        cppExtensions = new String[]{"cc", "cpp", "c++", "cxx", "C"};
        fortranExtensions = new String[]{"f", "F", "f90", "F90", "f95", "F95", "for", "il", "mod"};
        for (i = 0; i < cppExtensions.length; ++i) {
            FileUtil.setMIMEType((String)cppExtensions[i], (String)"text/x-c++");
        }
        for (i = 0; i < fortranExtensions.length; ++i) {
            FileUtil.setMIMEType((String)fortranExtensions[i], (String)"text/x-fortran");
        }
        FileUtil.setMIMEType((String)"xd", (String)"text/x-visu");
        FileUtil.setMIMEType((String)"l", (String)"text/x-lex");
        FileUtil.setMIMEType((String)"y", (String)"text/x-yacc");
        FileUtil.setMIMEType((String)"as", (String)"text/x-sparc-asm");
        FileUtil.setMIMEType((String)"asm", (String)"text/x-sparc-asm");
    }

    public static class CCFFormat
    extends FileEntry.Format {
        public CCFFormat(MultiDataObject obj, FileObject primaryFile) {
            super(obj, primaryFile);
        }

        protected Format createFormat(FileObject target, String name, String ext) {
            Properties map = ((CppSettings)CppSettings.findObject((Class)(class$org$netbeans$modules$cpp$settings$CppSettings == null ? (class$org$netbeans$modules$cpp$settings$CppSettings = CCFSrcLoader.class$("org.netbeans.modules.cpp.settings.CppSettings")) : class$org$netbeans$modules$cpp$settings$CppSettings), (boolean)true)).getReplaceableStringsProps();
            String packageName = target.getPackageName('_');
            if (!packageName.equals("")) {
                packageName = packageName + "_";
            }
            map.put("PACKAGE_AND_NAME", packageName + name);
            map.put("NAME", name);
            int crop = name.lastIndexOf(95);
            if (crop != -1) {
                name = name.substring(0, crop);
            }
            map.put("CROPPEDNAME", name);
            map.put("DATE", DateFormat.getDateInstance(1).format(new Date()));
            map.put("TIME", DateFormat.getTimeInstance(3).format(new Date()));
            map.put("NBDIR", System.getProperty("netbeans.home"));
            map.put("QUOTES", "\"");
            MapFormat format = new MapFormat((Map)map);
            format.setLeftBrace("%<%");
            format.setRightBrace("%>%");
            return format;
        }
    }
}

