/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cpp.execution;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.text.MessageFormat;
import java.util.ResourceBundle;
import org.netbeans.modules.cpp.executepicklist.ExecutePicklist;
import org.netbeans.modules.cpp.executepicklist.ExecutePicklistElement;
import org.netbeans.modules.cpp.loaders.ShellDataObject;
import org.netbeans.modules.cpp.picklist.PicklistUtils;
import org.netbeans.modules.cpp.settings.ShellSettings;
import org.netbeans.modules.cpp.utils.CppUtils;
import org.netbeans.modules.cpp.utils.IpeUtils;
import org.openide.LifecycleManager;
import org.openide.execution.Executor;
import org.openide.filesystems.FileObject;
import org.openide.loaders.DataNode;
import org.openide.loaders.ExecutionSupport;
import org.openide.loaders.MultiDataObject;
import org.openide.nodes.Node;
import org.openide.nodes.PropertySupport;
import org.openide.nodes.Sheet;
import org.openide.util.NbBundle;
import org.openide.util.Utilities;

public class ShellExecSupport
extends ExecutionSupport {
    private static final String PROP_RUN_DIRECTORY = "rundirectory";
    private static final String PROP_SHELL_COMMAND = "shellcommand";
    private ResourceBundle bundle = null;
    static /* synthetic */ Class class$java$lang$String;
    static /* synthetic */ Class class$org$netbeans$modules$cpp$execution$ShellExecSupport;

    public ShellExecSupport(MultiDataObject.Entry entry) {
        super(entry);
    }

    protected Executor defaultExecutor() {
        return ShellSettings.getDefault().getShellExecutor();
    }

    public void start() {
        MultiDataObject dataObject = this.getEntry().getDataObject();
        if (dataObject instanceof ShellDataObject) {
            ShellDataObject shellDataObject = (ShellDataObject)dataObject;
            DataNode dataNode = (DataNode)shellDataObject.getNodeDelegate();
            ExecutionSupport bes = PicklistUtils.findExecutionSupport(dataNode);
            String executablePath = CppUtils.getPath(dataNode.getDataObject().getPrimaryFile());
            String args = "";
            if (bes.getArguments().length > 0) {
                args = bes.getArguments()[0];
            }
            for (int j = 1; j < bes.getArguments().length; ++j) {
                args = args + " " + bes.getArguments()[j];
            }
            String runDirectory = IpeUtils.getDirName(executablePath);
            if (bes instanceof ShellExecSupport) {
                runDirectory = PicklistUtils.toAbsolutePath(IpeUtils.getDirName(executablePath), ((ShellExecSupport)bes).getRunDirectory());
            }
            ExecutePicklist.getInstance().addElement(new ExecutePicklistElement(executablePath, args, runDirectory));
            ExecutePicklist.getInstance().savePicklist();
        }
        if (ShellSettings.getDefault().getSaveAll()) {
            LifecycleManager.getDefault().saveAll();
        }
        super.start();
    }

    public void addProperties(Sheet.Set set) {
        super.addProperties(set);
        set.put((Node.Property)this.createRunDirectoryProperty());
        set.put((Node.Property)this.createShellCommandProperty());
    }

    private PropertySupport createRunDirectoryProperty() {
        return new PropertySupport.ReadWrite(PROP_RUN_DIRECTORY, class$java$lang$String == null ? (class$java$lang$String = ShellExecSupport.class$("java.lang.String")) : class$java$lang$String, this.getString("PROP_RUN_DIRECTORY"), this.getString("HINT_RUN_DIRECTORY")){

            public Object getValue() {
                return ShellExecSupport.this.getRunDirectory();
            }

            public void setValue(Object val) {
                ShellExecSupport.this.setRunDirectory((String)val);
            }

            public boolean supportsDefaultValue() {
                return true;
            }

            public void restoreDefaultValue() {
                this.setValue(null);
            }

            public boolean canWrite() {
                return !ShellExecSupport.this.getEntry().getFile().getParent().isReadOnly();
            }
        };
    }

    private PropertySupport createShellCommandProperty() {
        return new PropertySupport.ReadWrite(PROP_SHELL_COMMAND, class$java$lang$String == null ? (class$java$lang$String = ShellExecSupport.class$("java.lang.String")) : class$java$lang$String, this.getString("PROP_SHELL_COMMAND"), this.getString("HINT_SHELL_COMMAND")){

            public Object getValue() {
                return ShellExecSupport.this.getShellCommand();
            }

            public void setValue(Object val) {
                ShellExecSupport.this.setShellCommand((String)val);
            }

            public boolean supportsDefaultValue() {
                return true;
            }

            public void restoreDefaultValue() {
                this.setValue(null);
            }

            public boolean canWrite() {
                return !ShellExecSupport.this.getEntry().getFile().getParent().isReadOnly();
            }
        };
    }

    public String getRunDirectory() {
        String dir = (String)this.getEntry().getFile().getAttribute(PROP_RUN_DIRECTORY);
        if (dir == null) {
            dir = ".";
            this.setRunDirectory(dir);
        }
        return dir;
    }

    public void setRunDirectory(String dir) {
        block2: {
            try {
                this.getEntry().getFile().setAttribute(PROP_RUN_DIRECTORY, (Object)dir);
            }
            catch (IOException ex) {
                String msg = MessageFormat.format("INTERNAL ERROR: Cannot set run directory", CppUtils.getPath(this.getEntry().getFile()));
                if (!Boolean.getBoolean("netbeans.debug.exceptions")) break block2;
                ex.printStackTrace();
            }
        }
    }

    public String getShellCommand() {
        String shellCommand = (String)this.getEntry().getFile().getAttribute(PROP_SHELL_COMMAND);
        if (shellCommand == null || shellCommand.length() == 0) {
            shellCommand = "";
        }
        return shellCommand;
    }

    public String[] getShellCommandAndArgs(FileObject fo) {
        String ext;
        String shellCommand = this.getShellCommand();
        if (shellCommand == null || shellCommand.length() == 0) {
            String fullFileName = CppUtils.getPath(fo);
            try {
                BufferedReader in = new BufferedReader(new FileReader(fullFileName));
                if (in != null) {
                    String firstLine = in.readLine();
                    if (firstLine != null && firstLine.startsWith("#!") && firstLine.length() > 2) {
                        int i = 2;
                        while (Character.isWhitespace(firstLine.charAt(i))) {
                            ++i;
                        }
                        shellCommand = firstLine.substring(i);
                    }
                    in.close();
                }
            }
            catch (Exception e) {
                // empty catch block
            }
        }
        if (!(shellCommand != null && shellCommand.length() != 0 || (ext = fo.getExt()) == null || ext.length() <= 0 || new File(shellCommand = "/bin/" + ext).exists())) {
            shellCommand = null;
        }
        if (shellCommand == null || shellCommand.length() == 0) {
            shellCommand = ShellSettings.getDefault().getDefaultShellCommand();
        }
        String[] argvParsed = Utilities.parseParameters((String)shellCommand);
        return argvParsed;
    }

    public void setShellCommand(String command) {
        block2: {
            try {
                this.getEntry().getFile().setAttribute(PROP_SHELL_COMMAND, (Object)command);
            }
            catch (IOException ex) {
                String msg = MessageFormat.format("INTERNAL ERROR: Cannot set shell command", CppUtils.getPath(this.getEntry().getFile()));
                if (!Boolean.getBoolean("netbeans.debug.exceptions")) break block2;
                ex.printStackTrace();
            }
        }
    }

    private String getString(String s) {
        if (this.bundle == null) {
            this.bundle = NbBundle.getBundle((Class)(class$org$netbeans$modules$cpp$execution$ShellExecSupport == null ? (class$org$netbeans$modules$cpp$execution$ShellExecSupport = ShellExecSupport.class$("org.netbeans.modules.cpp.execution.ShellExecSupport")) : class$org$netbeans$modules$cpp$execution$ShellExecSupport));
        }
        return this.bundle.getString(s);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

