/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cpp.execution;

import java.io.IOException;
import java.text.MessageFormat;
import java.util.ResourceBundle;
import org.netbeans.modules.cpp.executepicklist.ExecutePicklist;
import org.netbeans.modules.cpp.executepicklist.ExecutePicklistElement;
import org.netbeans.modules.cpp.loaders.ExeElfObject;
import org.netbeans.modules.cpp.picklist.PicklistUtils;
import org.netbeans.modules.cpp.settings.CppSettings;
import org.netbeans.modules.cpp.utils.CppUtils;
import org.netbeans.modules.cpp.utils.IpeUtils;
import org.openide.debugger.DebuggerType;
import org.openide.execution.Executor;
import org.openide.loaders.DataNode;
import org.openide.loaders.ExecSupport;
import org.openide.loaders.ExecutionSupport;
import org.openide.loaders.MultiDataObject;
import org.openide.nodes.Node;
import org.openide.nodes.PropertySupport;
import org.openide.nodes.Sheet;
import org.openide.util.NbBundle;

public final class BinaryExecSupport
extends ExecSupport {
    private static final String PROP_RUN_DIRECTORY = "rundirectory";
    private PropertySupport rundirectoryProperty = null;
    private ResourceBundle bundle = null;
    static /* synthetic */ Class class$java$lang$String;
    static /* synthetic */ Class class$org$netbeans$modules$cpp$execution$BinaryExecSupport;

    public BinaryExecSupport(MultiDataObject.Entry entry) {
        super(entry);
    }

    protected DebuggerType defaultDebuggerType() {
        return CppSettings.getDefault().getDebugger();
    }

    protected Executor defaultExecutor() {
        return CppSettings.getDefault().getExecutor();
    }

    public void start() {
        MultiDataObject dataObject = this.getEntry().getDataObject();
        if (dataObject instanceof ExeElfObject) {
            ExeElfObject exeElfObject = (ExeElfObject)dataObject;
            DataNode exeElfNode = (DataNode)exeElfObject.getNodeDelegate();
            ExecutionSupport bes = PicklistUtils.findExecutionSupport(exeElfNode);
            String executablePath = CppUtils.getPath(exeElfNode.getDataObject().getPrimaryFile());
            String args = "";
            if (bes.getArguments().length > 0) {
                args = bes.getArguments()[0];
            }
            for (int j = 1; j < bes.getArguments().length; ++j) {
                args = args + " " + bes.getArguments()[j];
            }
            String runDirectory = IpeUtils.getDirName(executablePath);
            if (bes instanceof BinaryExecSupport) {
                runDirectory = PicklistUtils.toAbsolutePath(IpeUtils.getDirName(executablePath), ((BinaryExecSupport)bes).getRunDirectory());
            }
            ExecutePicklist.getInstance().addElement(new ExecutePicklistElement(executablePath, args, runDirectory));
            ExecutePicklist.getInstance().savePicklist();
        }
        super.start();
    }

    public void addProperties(Sheet.Set set) {
        super.addProperties(set);
        set.put((Node.Property)this.createRunDirectoryProperty());
    }

    private PropertySupport createRunDirectoryProperty() {
        return new PropertySupport.ReadWrite(PROP_RUN_DIRECTORY, class$java$lang$String == null ? (class$java$lang$String = BinaryExecSupport.class$("java.lang.String")) : class$java$lang$String, this.getString("PROP_RUN_DIRECTORY"), this.getString("HINT_RUN_DIRECTORY")){

            public Object getValue() {
                return BinaryExecSupport.this.getRunDirectory();
            }

            public void setValue(Object val) {
                BinaryExecSupport.this.setRunDirectory((String)val);
            }

            public boolean supportsDefaultValue() {
                return true;
            }

            public void restoreDefaultValue() {
                this.setValue(null);
            }

            public boolean canWrite() {
                return !BinaryExecSupport.this.getEntry().getFile().getParent().isReadOnly();
            }
        };
    }

    public String getRunDirectory() {
        String dir = (String)this.getEntry().getFile().getAttribute(PROP_RUN_DIRECTORY);
        if (dir == null) {
            dir = ".";
            this.setRunDirectory(dir);
        }
        return dir;
    }

    public void setRunDirectory(String dir) {
        block2: {
            try {
                this.getEntry().getFile().setAttribute(PROP_RUN_DIRECTORY, (Object)dir);
            }
            catch (IOException ex) {
                String msg = MessageFormat.format("INTERNAL ERROR: Cannot set run directory", CppUtils.getPath(this.getEntry().getFile()));
                if (!Boolean.getBoolean("netbeans.debug.exceptions")) break block2;
                ex.printStackTrace();
            }
        }
    }

    private String getString(String s) {
        if (this.bundle == null) {
            this.bundle = NbBundle.getBundle((Class)(class$org$netbeans$modules$cpp$execution$BinaryExecSupport == null ? (class$org$netbeans$modules$cpp$execution$BinaryExecSupport = BinaryExecSupport.class$("org.netbeans.modules.cpp.execution.BinaryExecSupport")) : class$org$netbeans$modules$cpp$execution$BinaryExecSupport));
        }
        return this.bundle.getString(s);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

