/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cpp.executepicklist;

import java.util.EventObject;
import org.netbeans.modules.cpp.editor.CCFSrcFileIterator;
import org.netbeans.modules.cpp.editor.SrcFileWizardListener;
import org.netbeans.modules.cpp.executepicklist.ExecutePicklistElement;
import org.netbeans.modules.cpp.loaders.ShellDataObject;
import org.netbeans.modules.cpp.makewizard.MakefileWizard;
import org.netbeans.modules.cpp.makewizard.MakefileWizardEvent;
import org.netbeans.modules.cpp.makewizard.MakefileWizardListener;
import org.netbeans.modules.cpp.picklist.DefaultPicklistModel;
import org.netbeans.modules.cpp.utils.CppUtils;
import org.netbeans.modules.cpp.utils.IpeUtils;
import org.openide.loaders.DataObject;

public class ExecutePicklist
extends DefaultPicklistModel
implements MakefileWizardListener,
SrcFileWizardListener {
    private static ExecutePicklist instance = null;
    private static int picklistMaxSize = 100;
    private static String savehome = null;
    private static String savedir = "/system/picklists";
    private static String savename = "execute";

    public ExecutePicklist() {
        instance = this;
        MakefileWizard.addMakefileWizardListener(this);
        CCFSrcFileIterator.addSrcFileWizardListener(this);
    }

    public ExecutePicklist(int max) {
        super(max);
        instance = this;
        MakefileWizard.addMakefileWizardListener(this);
        CCFSrcFileIterator.addSrcFileWizardListener(this);
    }

    private static String getSavehome() {
        if (savehome == null) {
            savehome = System.getProperty("netbeans.user");
        }
        if (savehome == null) {
            savehome = "/tmp";
        }
        return savehome;
    }

    public static ExecutePicklist getInstance() {
        if (instance == null) {
            try {
                instance = ExecutePicklist.restorePicklist();
            }
            catch (Exception e) {
                System.out.println("ExecutePicklist - getInstance - e " + e);
                System.out.println("Cannot restore picklist ...");
            }
            if (instance == null) {
                instance = new ExecutePicklist(picklistMaxSize);
            }
        }
        return instance;
    }

    public void savePicklist() {
        this.savePicklist(ExecutePicklist.getSavehome() + savedir, savename);
    }

    public static ExecutePicklist restorePicklist() {
        instance = (ExecutePicklist)ExecutePicklist.restorePicklist(ExecutePicklist.getSavehome() + savedir, savename);
        if (instance != null) {
            MakefileWizard.addMakefileWizardListener(instance);
            CCFSrcFileIterator.addSrcFileWizardListener(instance);
        }
        return instance;
    }

    public void makefileCreated(MakefileWizardEvent e) {
        String[] executables = e.getExecutables();
        if (executables != null) {
            for (int i = 0; i < executables.length; ++i) {
                this.addElement(new ExecutePicklistElement(executables[i], "", IpeUtils.getDirName(executables[i])));
            }
        }
        this.savePicklist();
    }

    public void srcFileCreated(EventObject eo) {
        DataObject result = (DataObject)eo.getSource();
        if (result instanceof ShellDataObject) {
            ExecutePicklist.getInstance().addElement(new ExecutePicklistElement(CppUtils.getPath(result.getPrimaryFile()), "", CppUtils.getDirectory(result.getPrimaryFile())));
            ExecutePicklist.getInstance().savePicklist();
        }
    }
}

