/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cpp.editor.parser;

import javax.swing.JEditorPane;
import javax.swing.text.StyledDocument;
import org.openide.ErrorManager;
import org.openide.cookies.LineCookie;
import org.openide.loaders.DataObject;
import org.openide.nodes.AbstractNode;
import org.openide.nodes.Children;
import org.openide.text.EditorSupport;
import org.openide.text.Line;
import org.openide.text.NbDocument;

public abstract class ViewNode
extends AbstractNode {
    private Line line = null;
    private DataObject dao = null;
    private int lineno = 0;
    private char kind;
    private String scope;
    private int scopeCluster;
    private int cluster;
    private String sortName;
    private int scopeLevels = 0;
    static /* synthetic */ Class class$org$openide$cookies$LineCookie;
    static /* synthetic */ Class class$org$openide$text$EditorSupport;

    public ViewNode(String name, DataObject dao, int lineno, char kind, String scope, int scopeCluster, int cluster) {
        super(Children.LEAF);
        this.dao = dao;
        this.lineno = lineno;
        this.kind = kind;
        this.scope = scope;
        this.scopeCluster = scopeCluster;
        this.cluster = cluster;
        this.setName(name);
        if (scope != null) {
            this.sortName = this.createSortScope(scope) + "::" + cluster + name;
            this.setDisplayName(name);
        } else {
            this.sortName = cluster + name;
            this.setDisplayName(name);
        }
    }

    private String createSortScope(String scope) {
        String sortScope = "";
        if (scope == null) {
            this.scopeLevels = 0;
            sortScope = "";
        } else {
            int index;
            this.scopeLevels = 1;
            int startIndex = 0;
            while ((index = scope.indexOf("::", startIndex)) >= 0) {
                sortScope = sortScope + this.scopeCluster + scope.substring(startIndex, index) + "::";
                ++this.scopeLevels;
                startIndex = index + 2;
            }
            sortScope = sortScope + this.scopeCluster + scope.substring(startIndex);
        }
        return sortScope;
    }

    public String getSortName() {
        return this.sortName;
    }

    public int getScopeLevel() {
        return this.scopeLevels;
    }

    public String getScope() {
        return this.scope;
    }

    public int getScopeCluster() {
        return this.scopeCluster;
    }

    public int getCluster() {
        return this.cluster;
    }

    public Line getLine() {
        if (this.line == null) {
            this.line = this.lineNumberToLine();
        }
        if (this.line == null) {
            ErrorManager.getDefault().notify((Throwable)new Exception("No Line info for line " + this.lineno + " in " + this.dao.getPrimaryFile().getNameExt()));
        }
        return this.line;
    }

    public int getLineNo() {
        return this.lineno;
    }

    public void goToLine() {
        this.getLine().show(2);
    }

    private Line lineNumberToLine() {
        Line.Set ls;
        LineCookie lc = (LineCookie)this.dao.getCookie(class$org$openide$cookies$LineCookie == null ? (class$org$openide$cookies$LineCookie = ViewNode.class$("org.openide.cookies.LineCookie")) : class$org$openide$cookies$LineCookie);
        Line l = null;
        if (lc != null && (ls = lc.getLineSet()) != null) {
            l = ls.getCurrent(this.lineno - 1);
        }
        return l;
    }

    public int getLineOffset() {
        EditorSupport cppEditorSupport = (EditorSupport)this.dao.getCookie(class$org$openide$text$EditorSupport == null ? (class$org$openide$text$EditorSupport = ViewNode.class$("org.openide.text.EditorSupport")) : class$org$openide$text$EditorSupport);
        return NbDocument.findLineOffset((StyledDocument)cppEditorSupport.getDocument(), (int)(this.lineno - 1));
    }

    public void goToOffset(JEditorPane jEditorPane) {
        jEditorPane.getCaret().setDot(this.getLineOffset());
        jEditorPane.requestFocus();
    }

    public char getKind() {
        return this.kind;
    }

    public DataObject getDataObject() {
        return this.dao;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

