/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cpp.editor.fortran;

import org.netbeans.editor.Syntax;
import org.netbeans.editor.TokenID;
import org.netbeans.modules.cpp.editor.fortran.FTokenContext;
import org.netbeans.modules.cpp.settings.CppSettings;

public class FSyntax
extends Syntax {
    private static final int AFTER_SLASH = 1;
    private static final int AFTER_EQ = 2;
    private static final int AFTER_STAR = 3;
    private static final int AFTER_LESSTHAN = 4;
    private static final int AFTER_GREATERTHAN = 5;
    private static final int AFTER_B = 6;
    private static final int AFTER_O = 7;
    private static final int AFTER_Z = 8;
    private static final int AFTER_DOT = 9;
    private static final int IN_STRING = 10;
    private static final int IN_STRING_AFTER_BSLASH = 11;
    private static final int IN_LINE_COMMENT = 12;
    private static final int IN_IDENTIFIER = 13;
    private static final int IN_DOT_IDENTIFIER = 14;
    private static final int IN_WHITESPACE = 15;
    private static final int IN_INT = 16;
    private static final int IN_BINARY = 17;
    private static final int IN_OCTAL = 18;
    private static final int IN_HEX = 19;
    private static final int IN_REAL = 20;
    private static boolean STRING_IN_DOUBLE_QUOTE = true;
    private static boolean HAS_NUMERIC_UNDERSCORE = false;
    protected int lastNL = 0;

    public FSyntax() {
        this.tokenContextPath = FTokenContext.contextPath;
    }

    protected boolean isLineBeyondLimit() {
        if (this.offset - this.lastNL > 132 && this.lastNL >= 0 && this.state != 12) {
            this.state = 12;
            return true;
        }
        return false;
    }

    protected TokenID parseToken() {
        while (this.offset < this.stopOffset) {
            char actChar = this.buffer[this.offset];
            block0 : switch (this.state) {
                case -1: {
                    if (this.isLineBeyondLimit()) {
                        --this.offset;
                        break;
                    }
                    switch (actChar) {
                        case '\n': {
                            this.lastNL = this.offset++;
                            return FTokenContext.WHITESPACE;
                        }
                        case 'B': 
                        case 'b': {
                            this.state = 6;
                            break block0;
                        }
                        case 'O': 
                        case 'o': {
                            this.state = 7;
                            break block0;
                        }
                        case 'Z': 
                        case 'z': {
                            this.state = 8;
                            break block0;
                        }
                        case '\"': {
                            this.state = 10;
                            STRING_IN_DOUBLE_QUOTE = true;
                            break block0;
                        }
                        case '\'': {
                            char beforeApostrophe;
                            if (this.offset > 0 && Character.isJavaIdentifierPart(beforeApostrophe = this.buffer[this.offset - 1])) {
                                ++this.offset;
                                return FTokenContext.APOSTROPHE_CHAR;
                            }
                            this.state = 10;
                            STRING_IN_DOUBLE_QUOTE = false;
                            break block0;
                        }
                        case '/': {
                            this.state = 1;
                            break block0;
                        }
                        case '=': {
                            this.state = 2;
                            break block0;
                        }
                        case '+': {
                            ++this.offset;
                            return FTokenContext.OP_PLUS;
                        }
                        case '-': {
                            ++this.offset;
                            return FTokenContext.OP_MINUS;
                        }
                        case '*': {
                            this.state = 3;
                            break block0;
                        }
                        case '!': {
                            this.state = 12;
                            break block0;
                        }
                        case 'C': 
                        case 'c': {
                            if (this.lastNL != this.offset - 1 && this.offset != 0 || CppSettings.getDefault().isFreeFormatFortran()) break block0;
                            this.state = 12;
                            break block0;
                        }
                        case '<': {
                            this.state = 4;
                            break block0;
                        }
                        case '>': {
                            this.state = 5;
                            break block0;
                        }
                        case '.': {
                            this.state = 9;
                            break block0;
                        }
                        case ',': {
                            ++this.offset;
                            return FTokenContext.COMMA;
                        }
                        case ':': {
                            ++this.offset;
                            return FTokenContext.COLON;
                        }
                        case '%': {
                            ++this.offset;
                            return FTokenContext.PERCENT;
                        }
                        case '&': {
                            ++this.offset;
                            return FTokenContext.AMPERSAND;
                        }
                        case '(': {
                            ++this.offset;
                            return FTokenContext.LPAREN;
                        }
                        case ')': {
                            ++this.offset;
                            return FTokenContext.RPAREN;
                        }
                        case ';': {
                            ++this.offset;
                            return FTokenContext.SEMICOLON;
                        }
                        case '?': {
                            ++this.offset;
                            return FTokenContext.QUESTION_MARK;
                        }
                        case '$': {
                            ++this.offset;
                            return FTokenContext.CURRENCY;
                        }
                    }
                    if (Character.isWhitespace(actChar)) {
                        this.state = 15;
                        break;
                    }
                    if (Character.isDigit(actChar)) {
                        this.state = 16;
                        break;
                    }
                    if (Character.isJavaIdentifierStart(actChar)) {
                        this.state = 13;
                        break;
                    }
                    ++this.offset;
                    return FTokenContext.ERR_INVALID_CHAR;
                }
                case 15: {
                    if (this.isLineBeyondLimit()) {
                        return FTokenContext.WHITESPACE;
                    }
                    if (Character.isWhitespace(actChar) && actChar != '\n') break;
                    this.state = -1;
                    return FTokenContext.WHITESPACE;
                }
                case 6: {
                    if (this.isLineBeyondLimit()) {
                        return FTokenContext.IDENTIFIER;
                    }
                    switch (actChar) {
                        case '\"': 
                        case '\'': {
                            if (!Character.isDigit(this.buffer[this.offset + 1])) break;
                            this.state = 17;
                            break block0;
                        }
                    }
                    this.state = 13;
                    --this.offset;
                    break;
                }
                case 7: {
                    if (this.isLineBeyondLimit()) {
                        return FTokenContext.IDENTIFIER;
                    }
                    switch (actChar) {
                        case '\"': 
                        case '\'': {
                            if (!Character.isDigit(this.buffer[this.offset + 1])) break;
                            this.state = 18;
                            break block0;
                        }
                    }
                    this.state = 13;
                    --this.offset;
                    break;
                }
                case 8: {
                    if (this.isLineBeyondLimit()) {
                        return FTokenContext.IDENTIFIER;
                    }
                    switch (actChar) {
                        case '\"': 
                        case '\'': {
                            if (!Character.isLetterOrDigit(this.buffer[this.offset + 1])) break;
                            this.state = 19;
                            break block0;
                        }
                    }
                    this.state = 13;
                    --this.offset;
                    break;
                }
                case 12: {
                    switch (actChar) {
                        case '\n': {
                            this.state = -1;
                            this.lastNL = this.offset++;
                            return FTokenContext.LINE_COMMENT;
                        }
                    }
                    break;
                }
                case 10: {
                    if (this.isLineBeyondLimit()) {
                        return FTokenContext.ERR_INCOMPLETE_STRING_LITERAL;
                    }
                    switch (actChar) {
                        case '\\': {
                            this.state = 11;
                            break;
                        }
                        case '\n': {
                            this.state = -1;
                            this.lastNL = this.offset++;
                            this.supposedTokenID = FTokenContext.STRING_LITERAL;
                            return this.supposedTokenID;
                        }
                        case '\"': {
                            if (!STRING_IN_DOUBLE_QUOTE) break;
                            ++this.offset;
                            this.state = -1;
                            return FTokenContext.STRING_LITERAL;
                        }
                        case '\'': {
                            if (STRING_IN_DOUBLE_QUOTE) break;
                            ++this.offset;
                            this.state = -1;
                            return FTokenContext.STRING_LITERAL;
                        }
                    }
                    break;
                }
                case 11: {
                    if (this.isLineBeyondLimit()) {
                        return FTokenContext.ERR_INCOMPLETE_STRING_LITERAL;
                    }
                    switch (actChar) {
                        case '\"': 
                        case '\'': 
                        case '\\': {
                            break;
                        }
                        default: {
                            --this.offset;
                        }
                    }
                    this.state = 10;
                    break;
                }
                case 1: {
                    if (this.isLineBeyondLimit()) {
                        return FTokenContext.OP_DIV;
                    }
                    switch (actChar) {
                        case '/': {
                            ++this.offset;
                            this.state = -1;
                            return FTokenContext.OP_CONCAT;
                        }
                        case '=': {
                            ++this.offset;
                            this.state = -1;
                            return FTokenContext.OP_NOT_EQ;
                        }
                    }
                    this.state = -1;
                    return FTokenContext.OP_DIV;
                }
                case 2: {
                    if (this.isLineBeyondLimit()) {
                        return FTokenContext.EQ;
                    }
                    switch (actChar) {
                        case '=': {
                            ++this.offset;
                            this.state = -1;
                            return FTokenContext.OP_LOG_EQ;
                        }
                    }
                    this.state = -1;
                    return FTokenContext.EQ;
                }
                case 3: {
                    if (this.isLineBeyondLimit()) {
                        return FTokenContext.OP_MUL;
                    }
                    switch (actChar) {
                        case '*': {
                            ++this.offset;
                            this.state = -1;
                            return FTokenContext.OP_POWER;
                        }
                    }
                    this.state = -1;
                    return FTokenContext.OP_MUL;
                }
                case 4: {
                    if (this.isLineBeyondLimit()) {
                        return FTokenContext.OP_LT;
                    }
                    switch (actChar) {
                        case '=': {
                            ++this.offset;
                            this.state = -1;
                            return FTokenContext.OP_LT_EQ;
                        }
                    }
                    this.state = -1;
                    return FTokenContext.OP_LT;
                }
                case 5: {
                    if (this.isLineBeyondLimit()) {
                        return FTokenContext.OP_GT;
                    }
                    switch (actChar) {
                        case '=': {
                            ++this.offset;
                            this.state = -1;
                            return FTokenContext.OP_GT_EQ;
                        }
                    }
                    this.state = -1;
                    return FTokenContext.OP_GT;
                }
                case 13: {
                    TokenID tid;
                    if (this.isLineBeyondLimit()) {
                        TokenID tid2 = FSyntax.matchKeyword(this.buffer, this.tokenOffset, this.offset - this.tokenOffset);
                        return tid2 != null ? tid2 : FTokenContext.IDENTIFIER;
                    }
                    if (actChar == '=' && (tid = FSyntax.matchKeyword(this.buffer, this.tokenOffset, this.offset - this.tokenOffset + 1)) != null) {
                        ++this.offset;
                        this.state = -1;
                        return tid;
                    }
                    if (Character.isJavaIdentifierPart(actChar)) break;
                    this.state = -1;
                    tid = FSyntax.matchKeyword(this.buffer, this.tokenOffset, this.offset - this.tokenOffset);
                    return tid != null ? tid : FTokenContext.IDENTIFIER;
                }
                case 17: {
                    if (this.isLineBeyondLimit()) {
                        return FTokenContext.ERR_INVALID_BINARY_LITERAL;
                    }
                    if (actChar == '\'' || actChar == '\"') {
                        this.state = -1;
                        ++this.offset;
                        return FTokenContext.NUM_LITERAL_BINARY;
                    }
                    if ((!Character.isDigit(actChar) || actChar <= '1') && Character.isDigit(actChar)) break;
                    this.state = -1;
                    return FTokenContext.ERR_INVALID_BINARY_LITERAL;
                }
                case 18: {
                    if (this.isLineBeyondLimit()) {
                        return FTokenContext.ERR_INVALID_OCTAL_LITERAL;
                    }
                    if (actChar == '\'' || actChar == '\"') {
                        this.state = -1;
                        ++this.offset;
                        return FTokenContext.NUM_LITERAL_OCTAL;
                    }
                    if ((!Character.isDigit(actChar) || actChar <= '7') && Character.isDigit(actChar)) break;
                    this.state = -1;
                    return FTokenContext.ERR_INVALID_OCTAL_LITERAL;
                }
                case 19: {
                    if (this.isLineBeyondLimit()) {
                        return FTokenContext.ERR_INVALID_HEX_LITERAL;
                    }
                    if (actChar == '\'' || actChar == '\"') {
                        this.state = -1;
                        ++this.offset;
                        return FTokenContext.NUM_LITERAL_HEX;
                    }
                    if (Character.isDigit(actChar) || Character.toLowerCase(actChar) >= 'a' && Character.toLowerCase(actChar) <= 'f') break;
                    this.state = -1;
                    return FTokenContext.ERR_INVALID_HEX_LITERAL;
                }
                case 16: {
                    if (this.isLineBeyondLimit()) {
                        return FTokenContext.NUM_LITERAL_INT;
                    }
                    switch (actChar) {
                        case '_': {
                            ++this.offset;
                            HAS_NUMERIC_UNDERSCORE = true;
                            break block0;
                        }
                        case '.': {
                            if (HAS_NUMERIC_UNDERSCORE) {
                                ++this.offset;
                                this.state = -1;
                                HAS_NUMERIC_UNDERSCORE = false;
                                return FTokenContext.ERR_INVALID_INTEGER;
                            }
                            this.state = 20;
                            break block0;
                        }
                        case 'D': 
                        case 'E': 
                        case 'd': 
                        case 'e': {
                            if (HAS_NUMERIC_UNDERSCORE) break block0;
                            this.state = 20;
                            break block0;
                        }
                    }
                    if ((!HAS_NUMERIC_UNDERSCORE || Character.isLetterOrDigit(actChar)) && (HAS_NUMERIC_UNDERSCORE || Character.isDigit(actChar))) break;
                    this.state = -1;
                    HAS_NUMERIC_UNDERSCORE = false;
                    return FTokenContext.NUM_LITERAL_INT;
                }
                case 20: {
                    if (this.isLineBeyondLimit()) {
                        return FTokenContext.NUM_LITERAL_REAL;
                    }
                    switch (actChar) {
                        case '_': {
                            ++this.offset;
                            HAS_NUMERIC_UNDERSCORE = true;
                            break block0;
                        }
                        case 'D': 
                        case 'E': 
                        case 'd': 
                        case 'e': {
                            if (!HAS_NUMERIC_UNDERSCORE) break block0;
                        }
                        default: {
                            if ((!HAS_NUMERIC_UNDERSCORE || Character.isLetterOrDigit(actChar)) && (HAS_NUMERIC_UNDERSCORE || Character.isDigit(actChar))) break block0;
                            this.state = -1;
                            HAS_NUMERIC_UNDERSCORE = false;
                            return FTokenContext.NUM_LITERAL_REAL;
                        }
                    }
                }
                case 9: {
                    if (this.isLineBeyondLimit()) {
                        return FTokenContext.DOT;
                    }
                    if (Character.isDigit(actChar)) {
                        this.state = 20;
                        break;
                    }
                    if (Character.isJavaIdentifierPart(actChar)) {
                        this.state = 14;
                        break;
                    }
                    this.state = -1;
                    return FTokenContext.DOT;
                }
                case 14: {
                    if (this.isLineBeyondLimit()) {
                        this.offset = this.tokenOffset + 1;
                        this.state = -1;
                        return FTokenContext.DOT;
                    }
                    if (Character.isJavaIdentifierPart(actChar)) break;
                    this.offset += actChar == '.' ? 1 : 0;
                    this.state = -1;
                    TokenID tid = FSyntax.matchKeyword(this.buffer, this.tokenOffset, this.offset - this.tokenOffset);
                    if (tid != null) {
                        return tid;
                    }
                    this.offset = this.tokenOffset + 1;
                    this.state = -1;
                    return FTokenContext.DOT;
                }
            }
            ++this.offset;
        }
        if (this.lastBuffer) {
            switch (this.state) {
                case 15: {
                    this.state = -1;
                    return FTokenContext.WHITESPACE;
                }
                case 6: 
                case 7: 
                case 8: {
                    this.state = -1;
                    return FTokenContext.IDENTIFIER;
                }
                case 17: {
                    this.state = -1;
                    return FTokenContext.ERR_INVALID_BINARY_LITERAL;
                }
                case 18: {
                    this.state = -1;
                    return FTokenContext.ERR_INVALID_OCTAL_LITERAL;
                }
                case 19: {
                    this.state = -1;
                    return FTokenContext.ERR_INVALID_HEX_LITERAL;
                }
                case 13: 
                case 14: {
                    this.state = -1;
                    TokenID kwd = FSyntax.matchKeyword(this.buffer, this.tokenOffset, this.offset - this.tokenOffset);
                    return kwd != null ? kwd : FTokenContext.IDENTIFIER;
                }
                case 10: 
                case 11: {
                    return FTokenContext.STRING_LITERAL;
                }
                case 1: {
                    this.state = -1;
                    return FTokenContext.OP_DIV;
                }
                case 2: {
                    this.state = -1;
                    return FTokenContext.EQ;
                }
                case 3: {
                    this.state = -1;
                    return FTokenContext.OP_MUL;
                }
                case 12: {
                    return FTokenContext.LINE_COMMENT;
                }
                case 4: {
                    this.state = -1;
                    return FTokenContext.OP_LT;
                }
                case 5: {
                    this.state = -1;
                    return FTokenContext.OP_GT;
                }
                case 16: {
                    this.state = -1;
                    return FTokenContext.NUM_LITERAL_INT;
                }
                case 20: {
                    this.state = -1;
                    return FTokenContext.NUM_LITERAL_REAL;
                }
                case 9: {
                    this.state = -1;
                    return FTokenContext.DOT;
                }
            }
        }
        switch (this.state) {
            case 15: {
                return FTokenContext.WHITESPACE;
            }
        }
        return null;
    }

    public String getStateName(int stateNumber) {
        switch (stateNumber) {
            case 15: {
                return "IN_WHITESPACE";
            }
            case 12: {
                return "IN_LINE_COMMENT";
            }
            case 10: {
                return "IN_STRING";
            }
            case 11: {
                return "IN_STRING_AFTER_BSLASH";
            }
            case 13: {
                return "IN_IDENTIFIER";
            }
            case 14: {
                return "IN_DOT_IDENTIFIER";
            }
            case 17: {
                return "IN_BINARY";
            }
            case 18: {
                return "IN_OCTAL";
            }
            case 19: {
                return "IN_HEX";
            }
            case 16: {
                return "IN_INT";
            }
            case 20: {
                return "IN_REAL";
            }
            case 6: {
                return "AFTER_B";
            }
            case 7: {
                return "AFTER_O";
            }
            case 8: {
                return "AFTER_Z";
            }
            case 1: {
                return "AFTER_SLASH";
            }
            case 2: {
                return "AFTER_EQ";
            }
            case 3: {
                return "AFTER_STAR";
            }
            case 4: {
                return "AFTER_LESSTHAN";
            }
            case 5: {
                return "AFTER_GREATERTHAN";
            }
            case 9: {
                return "AFTER_DOT";
            }
        }
        return super.getStateName(stateNumber);
    }

    public static TokenID matchKeyword(char[] buffer, int offset, int len) {
        if (len > 17) {
            return null;
        }
        if (len <= 1) {
            return null;
        }
        switch (Character.toLowerCase(buffer[offset++])) {
            case '.': {
                if (len < 4 || len > 7) {
                    return null;
                }
                switch (Character.toLowerCase(buffer[offset++])) {
                    case 'a': {
                        return len == 5 && Character.toLowerCase(buffer[offset++]) == 'n' && Character.toLowerCase(buffer[offset++]) == 'd' && Character.toLowerCase(buffer[offset++]) == '.' ? FTokenContext.KWOP_AND : null;
                    }
                    case 'e': {
                        switch (Character.toLowerCase(buffer[offset++])) {
                            case 'q': {
                                if (len == 4 && Character.toLowerCase(buffer[offset++]) == '.') {
                                    return FTokenContext.KWOP_EQ;
                                }
                                if (len == 5 && Character.toLowerCase(buffer[offset++]) == 'v' && Character.toLowerCase(buffer[offset++]) == '.') {
                                    return FTokenContext.KWOP_EQV;
                                }
                                return null;
                            }
                        }
                        return null;
                    }
                    case 'f': {
                        return len == 7 && Character.toLowerCase(buffer[offset++]) == 'a' && Character.toLowerCase(buffer[offset++]) == 'l' && Character.toLowerCase(buffer[offset++]) == 's' && Character.toLowerCase(buffer[offset++]) == 'e' && Character.toLowerCase(buffer[offset++]) == '.' ? FTokenContext.KWOP_FALSE : null;
                    }
                    case 'g': {
                        switch (Character.toLowerCase(buffer[offset++])) {
                            case 'e': {
                                return len == 4 && Character.toLowerCase(buffer[offset++]) == '.' ? FTokenContext.KWOP_GE : null;
                            }
                            case 't': {
                                return len == 4 && Character.toLowerCase(buffer[offset++]) == '.' ? FTokenContext.KWOP_GT : null;
                            }
                        }
                        return null;
                    }
                    case 'l': {
                        switch (Character.toLowerCase(buffer[offset++])) {
                            case 'e': {
                                return len == 4 && Character.toLowerCase(buffer[offset++]) == '.' ? FTokenContext.KWOP_LE : null;
                            }
                            case 't': {
                                return len == 4 && Character.toLowerCase(buffer[offset++]) == '.' ? FTokenContext.KWOP_LT : null;
                            }
                        }
                        return null;
                    }
                    case 'n': {
                        switch (Character.toLowerCase(buffer[offset++])) {
                            case 'e': {
                                if (len == 4 && Character.toLowerCase(buffer[offset++]) == '.') {
                                    return FTokenContext.KWOP_NE;
                                }
                                if (len == 6 && Character.toLowerCase(buffer[offset++]) == 'q' && Character.toLowerCase(buffer[offset++]) == 'v' && Character.toLowerCase(buffer[offset++]) == '.') {
                                    return FTokenContext.KWOP_NEQV;
                                }
                                return null;
                            }
                            case 'o': {
                                return len == 5 && Character.toLowerCase(buffer[offset++]) == 't' && Character.toLowerCase(buffer[offset++]) == '.' ? FTokenContext.KWOP_NOT : null;
                            }
                        }
                        return null;
                    }
                    case 'o': {
                        return len == 4 && Character.toLowerCase(buffer[offset++]) == 'r' && Character.toLowerCase(buffer[offset++]) == '.' ? FTokenContext.KWOP_OR : null;
                    }
                    case 't': {
                        return len == 6 && Character.toLowerCase(buffer[offset++]) == 'r' && Character.toLowerCase(buffer[offset++]) == 'u' && Character.toLowerCase(buffer[offset++]) == 'e' && Character.toLowerCase(buffer[offset++]) == '.' ? FTokenContext.KWOP_OR : null;
                    }
                }
                return null;
            }
            case 'a': {
                if (len < 7 || len > 11) {
                    return null;
                }
                switch (Character.toLowerCase(buffer[offset++])) {
                    case 'c': {
                        switch (Character.toLowerCase(buffer[offset++])) {
                            case 'c': {
                                return len == 7 && Character.toLowerCase(buffer[offset++]) == 'e' && Character.toLowerCase(buffer[offset++]) == 's' && Character.toLowerCase(buffer[offset++]) == 's' && Character.toLowerCase(buffer[offset++]) == '=' ? FTokenContext.KW_ACCESS_EQ : null;
                            }
                            case 't': {
                                return len == 7 && Character.toLowerCase(buffer[offset++]) == 'i' && Character.toLowerCase(buffer[offset++]) == 'o' && Character.toLowerCase(buffer[offset++]) == 'n' && Character.toLowerCase(buffer[offset++]) == '=' ? FTokenContext.KW_ACTION_EQ : null;
                            }
                        }
                        return null;
                    }
                    case 'd': {
                        return len == 8 && Character.toLowerCase(buffer[offset++]) == 'v' && Character.toLowerCase(buffer[offset++]) == 'a' && Character.toLowerCase(buffer[offset++]) == 'n' && Character.toLowerCase(buffer[offset++]) == 'c' && Character.toLowerCase(buffer[offset++]) == 'e' && Character.toLowerCase(buffer[offset++]) == '=' ? FTokenContext.KW_ADVANCE_EQ : null;
                    }
                    case 'l': {
                        if (len >= 8 && Character.toLowerCase(buffer[offset++]) == 'l' && Character.toLowerCase(buffer[offset++]) == 'o' && Character.toLowerCase(buffer[offset++]) == 'c' && Character.toLowerCase(buffer[offset++]) == 'a' && Character.toLowerCase(buffer[offset++]) == 't') {
                            if (len == 11 && Character.toLowerCase(buffer[offset++]) == 'a' && Character.toLowerCase(buffer[offset++]) == 'b' && Character.toLowerCase(buffer[offset++]) == 'l' && Character.toLowerCase(buffer[offset++]) == 'e') {
                                return FTokenContext.KW_ALLOCATABLE;
                            }
                            if (len == 8 && Character.toLowerCase(buffer[offset++]) == 'e') {
                                return FTokenContext.KW_ALLOCATE;
                            }
                            return null;
                        }
                        return null;
                    }
                    case 'p': {
                        return len == 10 && Character.toLowerCase(buffer[offset++]) == 'o' && Character.toLowerCase(buffer[offset++]) == 's' && Character.toLowerCase(buffer[offset++]) == 't' && Character.toLowerCase(buffer[offset++]) == 'r' && Character.toLowerCase(buffer[offset++]) == 'o' && Character.toLowerCase(buffer[offset++]) == 'p' && Character.toLowerCase(buffer[offset++]) == 'h' && Character.toLowerCase(buffer[offset++]) == 'e' ? FTokenContext.KW_APOSTROPHE : null;
                    }
                    case 's': {
                        return len == 10 && Character.toLowerCase(buffer[offset++]) == 's' && Character.toLowerCase(buffer[offset++]) == 'i' && Character.toLowerCase(buffer[offset++]) == 'g' && Character.toLowerCase(buffer[offset++]) == 'n' && Character.toLowerCase(buffer[offset++]) == 'm' && Character.toLowerCase(buffer[offset++]) == 'e' && Character.toLowerCase(buffer[offset++]) == 'n' && Character.toLowerCase(buffer[offset++]) == 't' ? FTokenContext.KW_ASSIGNMENT : null;
                    }
                }
                return null;
            }
            case 'b': {
                if (len < 5 || len > 9) {
                    return null;
                }
                switch (Character.toLowerCase(buffer[offset++])) {
                    case 'a': {
                        return len == 9 && Character.toLowerCase(buffer[offset++]) == 'c' && Character.toLowerCase(buffer[offset++]) == 'k' && Character.toLowerCase(buffer[offset++]) == 's' && Character.toLowerCase(buffer[offset++]) == 'p' && Character.toLowerCase(buffer[offset++]) == 'a' && Character.toLowerCase(buffer[offset++]) == 'c' && Character.toLowerCase(buffer[offset++]) == 'e' ? FTokenContext.KW_BACKSPACE : null;
                    }
                    case 'l': {
                        switch (Character.toLowerCase(buffer[offset++])) {
                            case 'a': {
                                return len == 6 && Character.toLowerCase(buffer[offset++]) == 'n' && Character.toLowerCase(buffer[offset++]) == 'k' && Character.toLowerCase(buffer[offset++]) == '=' ? FTokenContext.KW_BLANK_EQ : null;
                            }
                            case 'o': {
                                if (len >= 5 && Character.toLowerCase(buffer[offset++]) == 'c' && Character.toLowerCase(buffer[offset++]) == 'k') {
                                    if (len == 5) {
                                        return FTokenContext.KW_BLOCK;
                                    }
                                    if (len == 9 && Character.toLowerCase(buffer[offset++]) == 'd' && Character.toLowerCase(buffer[offset++]) == 'a' && Character.toLowerCase(buffer[offset++]) == 't' && Character.toLowerCase(buffer[offset++]) == 'a') {
                                        return FTokenContext.KW_BLOCKDATA;
                                    }
                                    return null;
                                }
                                return null;
                            }
                        }
                        return null;
                    }
                }
                return null;
            }
            case 'c': {
                if (len < 4 || len > 9) {
                    return null;
                }
                switch (Character.toLowerCase(buffer[offset++])) {
                    case 'a': {
                        switch (Character.toLowerCase(buffer[offset++])) {
                            case 'l': {
                                return len == 4 && Character.toLowerCase(buffer[offset++]) == 'l' ? FTokenContext.KW_CALL : null;
                            }
                            case 's': {
                                return len == 4 && Character.toLowerCase(buffer[offset++]) == 'e' ? FTokenContext.KW_CASE : null;
                            }
                        }
                        return null;
                    }
                    case 'h': {
                        return len == 9 && Character.toLowerCase(buffer[offset++]) == 'a' && Character.toLowerCase(buffer[offset++]) == 'r' && Character.toLowerCase(buffer[offset++]) == 'a' && Character.toLowerCase(buffer[offset++]) == 'c' && Character.toLowerCase(buffer[offset++]) == 't' && Character.toLowerCase(buffer[offset++]) == 'e' && Character.toLowerCase(buffer[offset++]) == 'r' ? FTokenContext.KW_CHARACTER : null;
                    }
                    case 'l': {
                        return len == 5 && Character.toLowerCase(buffer[offset++]) == 'o' && Character.toLowerCase(buffer[offset++]) == 's' && Character.toLowerCase(buffer[offset++]) == 'e' ? FTokenContext.KW_CLOSE : null;
                    }
                    case 'o': {
                        switch (Character.toLowerCase(buffer[offset++])) {
                            case 'm': {
                                switch (Character.toLowerCase(buffer[offset++])) {
                                    case 'm': {
                                        return len == 6 && Character.toLowerCase(buffer[offset++]) == 'o' && Character.toLowerCase(buffer[offset++]) == 'n' ? FTokenContext.KW_COMMON : null;
                                    }
                                    case 'p': {
                                        return len == 7 && Character.toLowerCase(buffer[offset++]) == 'l' && Character.toLowerCase(buffer[offset++]) == 'e' && Character.toLowerCase(buffer[offset++]) == 'x' ? FTokenContext.KW_COMPLEX : null;
                                    }
                                }
                                return null;
                            }
                            case 'n': {
                                if (len == 8 && Character.toLowerCase(buffer[offset++]) == 't') {
                                    switch (Character.toLowerCase(buffer[offset++])) {
                                        case 'a': {
                                            return len == 8 && Character.toLowerCase(buffer[offset++]) == 'i' && Character.toLowerCase(buffer[offset++]) == 'n' && Character.toLowerCase(buffer[offset++]) == 's' ? FTokenContext.KW_CONTAINS : null;
                                        }
                                        case 'i': {
                                            return len == 8 && Character.toLowerCase(buffer[offset++]) == 'n' && Character.toLowerCase(buffer[offset++]) == 'u' && Character.toLowerCase(buffer[offset++]) == 'e' ? FTokenContext.KW_CONTINUE : null;
                                        }
                                    }
                                    return null;
                                }
                                return null;
                            }
                        }
                        return null;
                    }
                    case 'y': {
                        return len == 5 && Character.toLowerCase(buffer[offset++]) == 'c' && Character.toLowerCase(buffer[offset++]) == 'l' && Character.toLowerCase(buffer[offset++]) == 'e' ? FTokenContext.KW_CYCLE : null;
                    }
                }
                return null;
            }
            case 'd': {
                if (len < 2 || len > 15) {
                    return null;
                }
                switch (Character.toLowerCase(buffer[offset++])) {
                    case 'a': {
                        return len == 4 && Character.toLowerCase(buffer[offset++]) == 't' && Character.toLowerCase(buffer[offset++]) == 'a' ? FTokenContext.KW_DATA : null;
                    }
                    case 'e': {
                        switch (Character.toLowerCase(buffer[offset++])) {
                            case 'a': {
                                return len == 10 && Character.toLowerCase(buffer[offset++]) == 'l' && Character.toLowerCase(buffer[offset++]) == 'l' && Character.toLowerCase(buffer[offset++]) == 'o' && Character.toLowerCase(buffer[offset++]) == 'c' && Character.toLowerCase(buffer[offset++]) == 'a' && Character.toLowerCase(buffer[offset++]) == 't' && Character.toLowerCase(buffer[offset++]) == 'e' ? FTokenContext.KW_DEALLOCATE : null;
                            }
                            case 'f': {
                                return len == 7 && Character.toLowerCase(buffer[offset++]) == 'a' && Character.toLowerCase(buffer[offset++]) == 'u' && Character.toLowerCase(buffer[offset++]) == 'l' && Character.toLowerCase(buffer[offset++]) == 't' ? FTokenContext.KW_DEFAULT : null;
                            }
                            case 'l': {
                                return len == 6 && Character.toLowerCase(buffer[offset++]) == 'i' && Character.toLowerCase(buffer[offset++]) == 'm' && Character.toLowerCase(buffer[offset++]) == '=' ? FTokenContext.KW_DELIM_EQ : null;
                            }
                        }
                        return null;
                    }
                    case 'i': {
                        switch (Character.toLowerCase(buffer[offset++])) {
                            case 'm': {
                                return len == 9 && Character.toLowerCase(buffer[offset++]) == 'e' && Character.toLowerCase(buffer[offset++]) == 'n' && Character.toLowerCase(buffer[offset++]) == 's' && Character.toLowerCase(buffer[offset++]) == 'i' && Character.toLowerCase(buffer[offset++]) == 'o' && Character.toLowerCase(buffer[offset++]) == 'n' ? FTokenContext.KW_DIMENSION : null;
                            }
                            case 'r': {
                                return len == 7 && Character.toLowerCase(buffer[offset++]) == 'e' && Character.toLowerCase(buffer[offset++]) == 'c' && Character.toLowerCase(buffer[offset++]) == 't' && Character.toLowerCase(buffer[offset++]) == '=' ? FTokenContext.KW_DIRECT_EQ : null;
                            }
                        }
                        return null;
                    }
                    case 'o': {
                        if (len == 2) {
                            return FTokenContext.KW_DO;
                        }
                        if (len >= 6 && Character.toLowerCase(buffer[offset++]) == 'u' && Character.toLowerCase(buffer[offset++]) == 'b' && Character.toLowerCase(buffer[offset++]) == 'l' && Character.toLowerCase(buffer[offset++]) == 'e') {
                            if (len == 6) {
                                return FTokenContext.KW_DOUBLE;
                            }
                            if (len == 15 && Character.toLowerCase(buffer[offset++]) == 'p' && Character.toLowerCase(buffer[offset++]) == 'r' && Character.toLowerCase(buffer[offset++]) == 'e' && Character.toLowerCase(buffer[offset++]) == 'c' && Character.toLowerCase(buffer[offset++]) == 'i' && Character.toLowerCase(buffer[offset++]) == 's' && Character.toLowerCase(buffer[offset++]) == 'i' && Character.toLowerCase(buffer[offset++]) == 'o' && Character.toLowerCase(buffer[offset++]) == 'n') {
                                return FTokenContext.KW_DOUBLEPRECISION;
                            }
                            return null;
                        }
                        return null;
                    }
                }
                return null;
            }
            case 'e': {
                if (len < 3 || len > 13) {
                    return null;
                }
                switch (Character.toLowerCase(buffer[offset++])) {
                    case 'l': {
                        switch (Character.toLowerCase(buffer[offset++])) {
                            case 'e': {
                                return len == 9 && Character.toLowerCase(buffer[offset++]) == 'm' && Character.toLowerCase(buffer[offset++]) == 'e' && Character.toLowerCase(buffer[offset++]) == 'n' && Character.toLowerCase(buffer[offset++]) == 't' && Character.toLowerCase(buffer[offset++]) == 'a' && Character.toLowerCase(buffer[offset++]) == 'l' ? FTokenContext.KW_ELEMENTAL : null;
                            }
                            case 's': {
                                if (len >= 4 && Character.toLowerCase(buffer[offset++]) == 'e') {
                                    if (len == 4) {
                                        return FTokenContext.KW_ELSE;
                                    }
                                    if (len == 6 && Character.toLowerCase(buffer[offset++]) == 'i' && Character.toLowerCase(buffer[offset++]) == 'f') {
                                        return FTokenContext.KW_ELSEIF;
                                    }
                                    if (len == 9 && Character.toLowerCase(buffer[offset++]) == 'w' && Character.toLowerCase(buffer[offset++]) == 'h' && Character.toLowerCase(buffer[offset++]) == 'e' && Character.toLowerCase(buffer[offset++]) == 'r' && Character.toLowerCase(buffer[offset++]) == 'e') {
                                        return FTokenContext.KW_ELSEWHERE;
                                    }
                                    return null;
                                }
                                return null;
                            }
                        }
                        return null;
                    }
                    case 'n': {
                        switch (Character.toLowerCase(buffer[offset++])) {
                            case 'd': {
                                if (len == 3) {
                                    return FTokenContext.KW_END;
                                }
                                switch (Character.toLowerCase(buffer[offset++])) {
                                    case '=': {
                                        return len == 4 ? FTokenContext.KW_END_EQ : null;
                                    }
                                    case 'b': {
                                        if (len >= 8 && Character.toLowerCase(buffer[offset++]) == 'l' && Character.toLowerCase(buffer[offset++]) == 'o' && Character.toLowerCase(buffer[offset++]) == 'c' && Character.toLowerCase(buffer[offset++]) == 'k') {
                                            if (len == 8) {
                                                return FTokenContext.KW_ENDBLOCK;
                                            }
                                            if (len == 12 && Character.toLowerCase(buffer[offset++]) == 'd' && Character.toLowerCase(buffer[offset++]) == 'a' && Character.toLowerCase(buffer[offset++]) == 't' && Character.toLowerCase(buffer[offset++]) == 'a') {
                                                return FTokenContext.KW_ENDBLOCKDATA;
                                            }
                                            return null;
                                        }
                                        return null;
                                    }
                                    case 'd': {
                                        return len == 5 && Character.toLowerCase(buffer[offset++]) == 'o' ? FTokenContext.KW_ENDDO : null;
                                    }
                                    case 'f': {
                                        switch (Character.toLowerCase(buffer[offset++])) {
                                            case 'i': {
                                                return len == 7 && Character.toLowerCase(buffer[offset++]) == 'l' && Character.toLowerCase(buffer[offset++]) == 'e' ? FTokenContext.KW_ENDFILE : null;
                                            }
                                            case 'o': {
                                                return len == 9 && Character.toLowerCase(buffer[offset++]) == 'r' && Character.toLowerCase(buffer[offset++]) == 'a' && Character.toLowerCase(buffer[offset++]) == 'l' && Character.toLowerCase(buffer[offset++]) == 'l' ? FTokenContext.KW_ENDFORALL : null;
                                            }
                                            case 'u': {
                                                return len == 11 && Character.toLowerCase(buffer[offset++]) == 'n' && Character.toLowerCase(buffer[offset++]) == 'c' && Character.toLowerCase(buffer[offset++]) == 't' && Character.toLowerCase(buffer[offset++]) == 'i' && Character.toLowerCase(buffer[offset++]) == 'o' && Character.toLowerCase(buffer[offset++]) == 'n' ? FTokenContext.KW_ENDFUNCTION : null;
                                            }
                                        }
                                        return null;
                                    }
                                    case 'i': {
                                        switch (Character.toLowerCase(buffer[offset++])) {
                                            case 'f': {
                                                return len == 5 ? FTokenContext.KW_ENDIF : null;
                                            }
                                            case 'n': {
                                                return len == 12 && Character.toLowerCase(buffer[offset++]) == 't' && Character.toLowerCase(buffer[offset++]) == 'e' && Character.toLowerCase(buffer[offset++]) == 'r' && Character.toLowerCase(buffer[offset++]) == 'f' && Character.toLowerCase(buffer[offset++]) == 'a' && Character.toLowerCase(buffer[offset++]) == 'c' && Character.toLowerCase(buffer[offset++]) == 'e' ? FTokenContext.KW_ENDINTERFACE : null;
                                            }
                                        }
                                        return null;
                                    }
                                    case 'm': {
                                        switch (Character.toLowerCase(buffer[offset++])) {
                                            case 'a': {
                                                return len == 6 && Character.toLowerCase(buffer[offset++]) == 'p' ? FTokenContext.KW_ENDMAP : null;
                                            }
                                            case 'o': {
                                                return len == 9 && Character.toLowerCase(buffer[offset++]) == 'd' && Character.toLowerCase(buffer[offset++]) == 'u' && Character.toLowerCase(buffer[offset++]) == 'l' && Character.toLowerCase(buffer[offset++]) == 'e' ? FTokenContext.KW_ENDMODULE : null;
                                            }
                                        }
                                        return null;
                                    }
                                    case 'p': {
                                        return len == 10 && Character.toLowerCase(buffer[offset++]) == 'r' && Character.toLowerCase(buffer[offset++]) == 'o' && Character.toLowerCase(buffer[offset++]) == 'g' && Character.toLowerCase(buffer[offset++]) == 'r' && Character.toLowerCase(buffer[offset++]) == 'a' && Character.toLowerCase(buffer[offset++]) == 'm' ? FTokenContext.KW_ENDPROGRAM : null;
                                    }
                                    case 's': {
                                        switch (Character.toLowerCase(buffer[offset++])) {
                                            case 'e': {
                                                return len == 9 && Character.toLowerCase(buffer[offset++]) == 'l' && Character.toLowerCase(buffer[offset++]) == 'e' && Character.toLowerCase(buffer[offset++]) == 'c' && Character.toLowerCase(buffer[offset++]) == 't' ? FTokenContext.KW_ENDSELECT : null;
                                            }
                                            case 't': {
                                                return len == 12 && Character.toLowerCase(buffer[offset++]) == 'r' && Character.toLowerCase(buffer[offset++]) == 'u' && Character.toLowerCase(buffer[offset++]) == 'c' && Character.toLowerCase(buffer[offset++]) == 't' && Character.toLowerCase(buffer[offset++]) == 'u' && Character.toLowerCase(buffer[offset++]) == 'r' && Character.toLowerCase(buffer[offset++]) == 'e' ? FTokenContext.KW_ENDSTRUCTURE : null;
                                            }
                                            case 'u': {
                                                return len == 13 && Character.toLowerCase(buffer[offset++]) == 'b' && Character.toLowerCase(buffer[offset++]) == 'r' && Character.toLowerCase(buffer[offset++]) == 'o' && Character.toLowerCase(buffer[offset++]) == 'u' && Character.toLowerCase(buffer[offset++]) == 't' && Character.toLowerCase(buffer[offset++]) == 'i' && Character.toLowerCase(buffer[offset++]) == 'n' && Character.toLowerCase(buffer[offset++]) == 'e' ? FTokenContext.KW_ENDSUBROUTINE : null;
                                            }
                                        }
                                        return null;
                                    }
                                    case 't': {
                                        return len == 7 && Character.toLowerCase(buffer[offset++]) == 'y' && Character.toLowerCase(buffer[offset++]) == 'p' && Character.toLowerCase(buffer[offset++]) == 'e' ? FTokenContext.KW_ENDTYPE : null;
                                    }
                                    case 'u': {
                                        return len == 8 && Character.toLowerCase(buffer[offset++]) == 'n' && Character.toLowerCase(buffer[offset++]) == 'i' && Character.toLowerCase(buffer[offset++]) == 'o' && Character.toLowerCase(buffer[offset++]) == 'n' ? FTokenContext.KW_ENDUNION : null;
                                    }
                                    case 'w': {
                                        return len == 8 && Character.toLowerCase(buffer[offset++]) == 'h' && Character.toLowerCase(buffer[offset++]) == 'e' && Character.toLowerCase(buffer[offset++]) == 'r' && Character.toLowerCase(buffer[offset++]) == 'e' ? FTokenContext.KW_ENDWHERE : null;
                                    }
                                }
                                return null;
                            }
                            case 't': {
                                return len == 5 && Character.toLowerCase(buffer[offset++]) == 'r' && Character.toLowerCase(buffer[offset++]) == 'y' ? FTokenContext.KW_ENTRY : null;
                            }
                        }
                        return null;
                    }
                    case 'o': {
                        return len == 4 && Character.toLowerCase(buffer[offset++]) == 'r' && Character.toLowerCase(buffer[offset++]) == '=' ? FTokenContext.KW_EOR_EQ : null;
                    }
                    case 'q': {
                        return len == 11 && Character.toLowerCase(buffer[offset++]) == 'u' && Character.toLowerCase(buffer[offset++]) == 'i' && Character.toLowerCase(buffer[offset++]) == 'v' && Character.toLowerCase(buffer[offset++]) == 'a' && Character.toLowerCase(buffer[offset++]) == 'l' && Character.toLowerCase(buffer[offset++]) == 'a' && Character.toLowerCase(buffer[offset++]) == 'n' && Character.toLowerCase(buffer[offset++]) == 'c' && Character.toLowerCase(buffer[offset++]) == 'e' ? FTokenContext.KW_EQUIVALENCE : null;
                    }
                    case 'r': {
                        return len == 4 && Character.toLowerCase(buffer[offset++]) == 'r' && Character.toLowerCase(buffer[offset++]) == '=' ? FTokenContext.KW_ERR_EQ : null;
                    }
                    case 'x': {
                        switch (Character.toLowerCase(buffer[offset++])) {
                            case 'i': {
                                switch (Character.toLowerCase(buffer[offset++])) {
                                    case 's': {
                                        return len == 6 && Character.toLowerCase(buffer[offset++]) == 't' && Character.toLowerCase(buffer[offset++]) == '=' ? FTokenContext.KW_EXIST_EQ : null;
                                    }
                                    case 't': {
                                        return len == 4 ? FTokenContext.KW_EXIT : null;
                                    }
                                }
                                return null;
                            }
                            case 't': {
                                return len == 8 && Character.toLowerCase(buffer[offset++]) == 'e' && Character.toLowerCase(buffer[offset++]) == 'r' && Character.toLowerCase(buffer[offset++]) == 'n' && Character.toLowerCase(buffer[offset++]) == 'a' && Character.toLowerCase(buffer[offset++]) == 'l' ? FTokenContext.KW_EXTERNAL : null;
                            }
                        }
                        return null;
                    }
                }
                return null;
            }
            case 'f': {
                if (len < 4 || len > 9) {
                    return null;
                }
                switch (Character.toLowerCase(buffer[offset++])) {
                    case 'i': {
                        if (len >= 4 && Character.toLowerCase(buffer[offset++]) == 'l' && Character.toLowerCase(buffer[offset++]) == 'e') {
                            if (len == 4) {
                                return FTokenContext.KW_FILE;
                            }
                            if (len == 5 && Character.toLowerCase(buffer[offset++]) == '=') {
                                return FTokenContext.KW_FILE_EQ;
                            }
                            return null;
                        }
                        return null;
                    }
                    case 'o': {
                        switch (Character.toLowerCase(buffer[offset++])) {
                            case 'r': {
                                switch (Character.toLowerCase(buffer[offset++])) {
                                    case 'a': {
                                        return len == 6 && Character.toLowerCase(buffer[offset++]) == 'l' && Character.toLowerCase(buffer[offset++]) == 'l' ? FTokenContext.KW_FORALL : null;
                                    }
                                    case 'm': {
                                        switch (Character.toLowerCase(buffer[offset++])) {
                                            case '=': {
                                                return len == 5 ? FTokenContext.KW_FORM_EQ : null;
                                            }
                                            case 'a': {
                                                if (len >= 6 && Character.toLowerCase(buffer[offset++]) == 't') {
                                                    if (len == 6) {
                                                        return FTokenContext.KW_FORMAT;
                                                    }
                                                    if (len == 9 && Character.toLowerCase(buffer[offset++]) == 't' && Character.toLowerCase(buffer[offset++]) == 'e' && Character.toLowerCase(buffer[offset++]) == 'd') {
                                                        return FTokenContext.KW_FORMATTED;
                                                    }
                                                    return null;
                                                }
                                                return null;
                                            }
                                        }
                                        return null;
                                    }
                                }
                                return null;
                            }
                        }
                        return null;
                    }
                    case 'u': {
                        return len == 8 && Character.toLowerCase(buffer[offset++]) == 'n' && Character.toLowerCase(buffer[offset++]) == 'c' && Character.toLowerCase(buffer[offset++]) == 't' && Character.toLowerCase(buffer[offset++]) == 'i' && Character.toLowerCase(buffer[offset++]) == 'o' && Character.toLowerCase(buffer[offset++]) == 'n' ? FTokenContext.KW_FUNCTION : null;
                    }
                }
                return null;
            }
            case 'g': {
                if (len < 2 || len > 4) {
                    return null;
                }
                if (len >= 2 && Character.toLowerCase(buffer[offset++]) == 'o') {
                    if (len == 2) {
                        return FTokenContext.KW_GO;
                    }
                    if (len == 4 && Character.toLowerCase(buffer[offset++]) == 't' && Character.toLowerCase(buffer[offset++]) == 'o') {
                        return FTokenContext.KW_GOTO;
                    }
                    return null;
                }
                return null;
            }
            case 'i': {
                if (len < 2 || len > 9) {
                    return null;
                }
                switch (Character.toLowerCase(buffer[offset++])) {
                    case 'f': {
                        return len == 2 ? FTokenContext.KW_IF : null;
                    }
                    case 'm': {
                        return len == 8 && Character.toLowerCase(buffer[offset++]) == 'p' && Character.toLowerCase(buffer[offset++]) == 'l' && Character.toLowerCase(buffer[offset++]) == 'i' && Character.toLowerCase(buffer[offset++]) == 'c' && Character.toLowerCase(buffer[offset++]) == 'i' && Character.toLowerCase(buffer[offset++]) == 't' ? FTokenContext.KW_IMPLICIT : null;
                    }
                    case 'n': {
                        if (len == 2) {
                            return FTokenContext.KW_IN;
                        }
                        switch (Character.toLowerCase(buffer[offset++])) {
                            case 'c': {
                                return len == 7 && Character.toLowerCase(buffer[offset++]) == 'l' && Character.toLowerCase(buffer[offset++]) == 'u' && Character.toLowerCase(buffer[offset++]) == 'd' && Character.toLowerCase(buffer[offset++]) == 'e' ? FTokenContext.KW_INCLUDE : null;
                            }
                            case 'o': {
                                return len == 5 && Character.toLowerCase(buffer[offset++]) == 'u' && Character.toLowerCase(buffer[offset++]) == 't' ? FTokenContext.KW_INOUT : null;
                            }
                            case 'q': {
                                return len == 7 && Character.toLowerCase(buffer[offset++]) == 'u' && Character.toLowerCase(buffer[offset++]) == 'i' && Character.toLowerCase(buffer[offset++]) == 'r' && Character.toLowerCase(buffer[offset++]) == 'e' ? FTokenContext.KW_INQUIRE : null;
                            }
                            case 't': {
                                switch (Character.toLowerCase(buffer[offset++])) {
                                    case 'e': {
                                        switch (Character.toLowerCase(buffer[offset++])) {
                                            case 'g': {
                                                return len == 7 && Character.toLowerCase(buffer[offset++]) == 'e' && Character.toLowerCase(buffer[offset++]) == 'r' ? FTokenContext.KW_INTEGER : null;
                                            }
                                            case 'n': {
                                                return len == 6 && Character.toLowerCase(buffer[offset++]) == 't' ? FTokenContext.KW_INTENT : null;
                                            }
                                            case 'r': {
                                                return len == 9 && Character.toLowerCase(buffer[offset++]) == 'f' && Character.toLowerCase(buffer[offset++]) == 'a' && Character.toLowerCase(buffer[offset++]) == 'c' && Character.toLowerCase(buffer[offset++]) == 'e' ? FTokenContext.KW_INTERFACE : null;
                                            }
                                        }
                                        return null;
                                    }
                                    case 'r': {
                                        return len == 9 && Character.toLowerCase(buffer[offset++]) == 'i' && Character.toLowerCase(buffer[offset++]) == 'n' && Character.toLowerCase(buffer[offset++]) == 's' && Character.toLowerCase(buffer[offset++]) == 'i' && Character.toLowerCase(buffer[offset++]) == 'c' ? FTokenContext.KW_INTRINSIC : null;
                                    }
                                }
                                return null;
                            }
                        }
                        return null;
                    }
                    case 'o': {
                        return len == 7 && Character.toLowerCase(buffer[offset++]) == 's' && Character.toLowerCase(buffer[offset++]) == 't' && Character.toLowerCase(buffer[offset++]) == 'a' && Character.toLowerCase(buffer[offset++]) == 't' && Character.toLowerCase(buffer[offset++]) == '=' ? FTokenContext.KW_IOSTAT_EQ : null;
                    }
                }
                return null;
            }
            case 'k': {
                return len == 4 && Character.toLowerCase(buffer[offset++]) == 'i' && Character.toLowerCase(buffer[offset++]) == 'n' && Character.toLowerCase(buffer[offset++]) == 'd' ? FTokenContext.KW_KIND : null;
            }
            case 'l': {
                if (len < 3 || len > 7) {
                    return null;
                }
                switch (Character.toLowerCase(buffer[offset++])) {
                    case 'e': {
                        return len == 3 && Character.toLowerCase(buffer[offset++]) == 'n' ? FTokenContext.KW_LEN : null;
                    }
                    case 'o': {
                        return len == 7 && Character.toLowerCase(buffer[offset++]) == 'g' && Character.toLowerCase(buffer[offset++]) == 'i' && Character.toLowerCase(buffer[offset++]) == 'c' && Character.toLowerCase(buffer[offset++]) == 'a' && Character.toLowerCase(buffer[offset++]) == 'l' ? FTokenContext.KW_LOGICAL : null;
                    }
                }
                return null;
            }
            case 'm': {
                switch (Character.toLowerCase(buffer[offset++])) {
                    case 'a': {
                        return len == 3 && Character.toLowerCase(buffer[offset++]) == 'p' ? FTokenContext.KW_MAP : null;
                    }
                    case 'o': {
                        return len == 6 && Character.toLowerCase(buffer[offset++]) == 'd' && Character.toLowerCase(buffer[offset++]) == 'u' && Character.toLowerCase(buffer[offset++]) == 'l' && Character.toLowerCase(buffer[offset++]) == 'e' ? FTokenContext.KW_MODULE : null;
                    }
                }
                return null;
            }
            case 'n': {
                if (len < 4 || len > 8) {
                    return null;
                }
                switch (Character.toLowerCase(buffer[offset++])) {
                    case 'a': {
                        if (len >= 5 && Character.toLowerCase(buffer[offset++]) == 'm' && Character.toLowerCase(buffer[offset++]) == 'e') {
                            switch (Character.toLowerCase(buffer[offset++])) {
                                case '=': {
                                    return len == 5 ? FTokenContext.KW_NAME_EQ : null;
                                }
                                case 'd': {
                                    return len == 6 && Character.toLowerCase(buffer[offset++]) == '=' ? FTokenContext.KW_NAMED_EQ : null;
                                }
                                case 'l': {
                                    return len == 8 && Character.toLowerCase(buffer[offset++]) == 'i' && Character.toLowerCase(buffer[offset++]) == 's' && Character.toLowerCase(buffer[offset++]) == 't' ? FTokenContext.KW_NAMELIST : null;
                                }
                            }
                            return null;
                        }
                        return null;
                    }
                    case 'e': {
                        return len == 7 && Character.toLowerCase(buffer[offset++]) == 'x' && Character.toLowerCase(buffer[offset++]) == 't' && Character.toLowerCase(buffer[offset++]) == 'r' && Character.toLowerCase(buffer[offset++]) == 'e' && Character.toLowerCase(buffer[offset++]) == 'c' ? FTokenContext.KW_NEXTREC : null;
                    }
                    case 'm': {
                        return len == 4 && Character.toLowerCase(buffer[offset++]) == 'l' && Character.toLowerCase(buffer[offset++]) == '=' ? FTokenContext.KW_NML_EQ : null;
                    }
                    case 'o': {
                        return len == 4 && Character.toLowerCase(buffer[offset++]) == 'n' && Character.toLowerCase(buffer[offset++]) == 'e' ? FTokenContext.KW_NONE : null;
                    }
                    case 'u': {
                        switch (Character.toLowerCase(buffer[offset++])) {
                            case 'l': {
                                return len == 7 && Character.toLowerCase(buffer[offset++]) == 'l' && Character.toLowerCase(buffer[offset++]) == 'i' && Character.toLowerCase(buffer[offset++]) == 'f' && Character.toLowerCase(buffer[offset++]) == 'y' ? FTokenContext.KW_NULLIFY : null;
                            }
                            case 'm': {
                                return len == 7 && Character.toLowerCase(buffer[offset++]) == 'b' && Character.toLowerCase(buffer[offset++]) == 'e' && Character.toLowerCase(buffer[offset++]) == 'r' && Character.toLowerCase(buffer[offset++]) == '=' ? FTokenContext.KW_NUMBER_EQ : null;
                            }
                        }
                        return null;
                    }
                }
                return null;
            }
            case 'o': {
                if (len < 3 || len > 8) {
                    return null;
                }
                switch (Character.toLowerCase(buffer[offset++])) {
                    case 'n': {
                        return len == 4 && Character.toLowerCase(buffer[offset++]) == 'l' && Character.toLowerCase(buffer[offset++]) == 'y' ? FTokenContext.KW_ONLY : null;
                    }
                    case 'p': {
                        switch (Character.toLowerCase(buffer[offset++])) {
                            case 'e': {
                                switch (Character.toLowerCase(buffer[offset++])) {
                                    case 'n': {
                                        if (len == 4) {
                                            return FTokenContext.KW_OPEN;
                                        }
                                        if (len == 7 && Character.toLowerCase(buffer[offset++]) == 'e' && Character.toLowerCase(buffer[offset++]) == 'd' && Character.toLowerCase(buffer[offset++]) == '=') {
                                            return FTokenContext.KW_OPENED_EQ;
                                        }
                                        return null;
                                    }
                                    case 'r': {
                                        return len == 8 && Character.toLowerCase(buffer[offset++]) == 'a' && Character.toLowerCase(buffer[offset++]) == 't' && Character.toLowerCase(buffer[offset++]) == 'o' && Character.toLowerCase(buffer[offset++]) == 'r' ? FTokenContext.KW_OPERATOR : null;
                                    }
                                }
                                return null;
                            }
                            case 't': {
                                return len == 8 && Character.toLowerCase(buffer[offset++]) == 'i' && Character.toLowerCase(buffer[offset++]) == 'o' && Character.toLowerCase(buffer[offset++]) == 'n' && Character.toLowerCase(buffer[offset++]) == 'a' && Character.toLowerCase(buffer[offset++]) == 'l' ? FTokenContext.KW_OPTIONAL : null;
                            }
                        }
                        return null;
                    }
                    case 'u': {
                        return len == 3 && Character.toLowerCase(buffer[offset++]) == 't' ? FTokenContext.KW_OUT : null;
                    }
                }
                return null;
            }
            case 'p': {
                if (len < 4 || len > 9) {
                    return null;
                }
                switch (Character.toLowerCase(buffer[offset++])) {
                    case 'a': {
                        switch (Character.toLowerCase(buffer[offset++])) {
                            case 'd': {
                                return len == 4 && Character.toLowerCase(buffer[offset++]) == '=' ? FTokenContext.KW_PAD_EQ : null;
                            }
                            case 'r': {
                                return len == 9 && Character.toLowerCase(buffer[offset++]) == 'a' && Character.toLowerCase(buffer[offset++]) == 'm' && Character.toLowerCase(buffer[offset++]) == 'e' && Character.toLowerCase(buffer[offset++]) == 't' && Character.toLowerCase(buffer[offset++]) == 'e' && Character.toLowerCase(buffer[offset++]) == 'r' ? FTokenContext.KW_PARAMETER : null;
                            }
                        }
                        return null;
                    }
                    case 'o': {
                        switch (Character.toLowerCase(buffer[offset++])) {
                            case 'i': {
                                return len == 7 && Character.toLowerCase(buffer[offset++]) == 'n' && Character.toLowerCase(buffer[offset++]) == 't' && Character.toLowerCase(buffer[offset++]) == 'e' && Character.toLowerCase(buffer[offset++]) == 'r' ? FTokenContext.KW_POINTER : null;
                            }
                            case 's': {
                                return len == 9 && Character.toLowerCase(buffer[offset++]) == 'i' && Character.toLowerCase(buffer[offset++]) == 't' && Character.toLowerCase(buffer[offset++]) == 'i' && Character.toLowerCase(buffer[offset++]) == 'o' && Character.toLowerCase(buffer[offset++]) == 'n' && Character.toLowerCase(buffer[offset++]) == '=' ? FTokenContext.KW_POSITION_EQ : null;
                            }
                        }
                        return null;
                    }
                    case 'r': {
                        switch (Character.toLowerCase(buffer[offset++])) {
                            case 'e': {
                                return len == 9 && Character.toLowerCase(buffer[offset++]) == 'c' && Character.toLowerCase(buffer[offset++]) == 'i' && Character.toLowerCase(buffer[offset++]) == 's' && Character.toLowerCase(buffer[offset++]) == 'i' && Character.toLowerCase(buffer[offset++]) == 'o' && Character.toLowerCase(buffer[offset++]) == 'n' ? FTokenContext.KW_PRECISION : null;
                            }
                            case 'i': {
                                switch (Character.toLowerCase(buffer[offset++])) {
                                    case 'n': {
                                        return len == 5 && Character.toLowerCase(buffer[offset++]) == 't' ? FTokenContext.KW_PRINT : null;
                                    }
                                    case 'v': {
                                        return len == 7 && Character.toLowerCase(buffer[offset++]) == 'a' && Character.toLowerCase(buffer[offset++]) == 't' && Character.toLowerCase(buffer[offset++]) == 'e' ? FTokenContext.KW_PRIVATE : null;
                                    }
                                }
                                return null;
                            }
                            case 'o': {
                                switch (Character.toLowerCase(buffer[offset++])) {
                                    case 'c': {
                                        return len == 9 && Character.toLowerCase(buffer[offset++]) == 'e' && Character.toLowerCase(buffer[offset++]) == 'd' && Character.toLowerCase(buffer[offset++]) == 'u' && Character.toLowerCase(buffer[offset++]) == 'r' && Character.toLowerCase(buffer[offset++]) == 'e' ? FTokenContext.KW_PROCEDURE : null;
                                    }
                                    case 'g': {
                                        return len == 7 && Character.toLowerCase(buffer[offset++]) == 'r' && Character.toLowerCase(buffer[offset++]) == 'a' && Character.toLowerCase(buffer[offset++]) == 'm' ? FTokenContext.KW_PROGRAM : null;
                                    }
                                }
                                return null;
                            }
                        }
                        return null;
                    }
                    case 'u': {
                        switch (Character.toLowerCase(buffer[offset++])) {
                            case 'b': {
                                return len == 6 && Character.toLowerCase(buffer[offset++]) == 'l' && Character.toLowerCase(buffer[offset++]) == 'i' && Character.toLowerCase(buffer[offset++]) == 'c' ? FTokenContext.KW_PUBLIC : null;
                            }
                            case 'r': {
                                return len == 4 && Character.toLowerCase(buffer[offset++]) == 'e' ? FTokenContext.KW_PURE : null;
                            }
                        }
                        return null;
                    }
                }
                return null;
            }
            case 'q': {
                return len == 5 && Character.toLowerCase(buffer[offset++]) == 'u' && Character.toLowerCase(buffer[offset++]) == 'o' && Character.toLowerCase(buffer[offset++]) == 't' && Character.toLowerCase(buffer[offset++]) == 'e' ? FTokenContext.KW_QUOTE : null;
            }
            case 'r': {
                if (len < 4 || len > 10) {
                    return null;
                }
                if (Character.toLowerCase(buffer[offset++]) != 'e') {
                    return null;
                }
                switch (Character.toLowerCase(buffer[offset++])) {
                    case 'a': {
                        switch (Character.toLowerCase(buffer[offset++])) {
                            case 'd': {
                                if (len == 4) {
                                    return FTokenContext.KW_READ;
                                }
                                switch (Character.toLowerCase(buffer[offset++])) {
                                    case '=': {
                                        return len == 5 ? FTokenContext.KW_READ_EQ : null;
                                    }
                                    case 'w': {
                                        return len == 10 && Character.toLowerCase(buffer[offset++]) == 'r' && Character.toLowerCase(buffer[offset++]) == 'i' && Character.toLowerCase(buffer[offset++]) == 't' && Character.toLowerCase(buffer[offset++]) == 'e' && Character.toLowerCase(buffer[offset++]) == '=' ? FTokenContext.KW_READWRITE_EQ : null;
                                    }
                                }
                                return null;
                            }
                            case 'l': {
                                return len == 4 ? FTokenContext.KW_REAL : null;
                            }
                        }
                        return null;
                    }
                    case 'c': {
                        switch (Character.toLowerCase(buffer[offset++])) {
                            case '=': {
                                return len == 4 ? FTokenContext.KW_REC_EQ : null;
                            }
                            case 'l': {
                                return len == 5 && Character.toLowerCase(buffer[offset++]) == '=' ? FTokenContext.KW_RECL_EQ : null;
                            }
                            case 'u': {
                                return len == 9 && Character.toLowerCase(buffer[offset++]) == 'r' && Character.toLowerCase(buffer[offset++]) == 's' && Character.toLowerCase(buffer[offset++]) == 'i' && Character.toLowerCase(buffer[offset++]) == 'v' && Character.toLowerCase(buffer[offset++]) == 'e' ? FTokenContext.KW_RECURSIVE : null;
                            }
                        }
                        return null;
                    }
                    case 's': {
                        return len == 6 && Character.toLowerCase(buffer[offset++]) == 'u' && Character.toLowerCase(buffer[offset++]) == 'l' && Character.toLowerCase(buffer[offset++]) == 't' ? FTokenContext.KW_RESULT : null;
                    }
                    case 't': {
                        return len == 6 && Character.toLowerCase(buffer[offset++]) == 'u' && Character.toLowerCase(buffer[offset++]) == 'r' && Character.toLowerCase(buffer[offset++]) == 'n' ? FTokenContext.KW_RETURN : null;
                    }
                    case 'w': {
                        return len == 6 && Character.toLowerCase(buffer[offset++]) == 'i' && Character.toLowerCase(buffer[offset++]) == 'n' && Character.toLowerCase(buffer[offset++]) == 'd' ? FTokenContext.KW_REWIND : null;
                    }
                }
                return null;
            }
            case 's': {
                if (len < 4 || len > 11) {
                    return null;
                }
                if (len == 4) {
                    switch (Character.toLowerCase(buffer[offset++])) {
                        case 'a': {
                            return len == 4 && Character.toLowerCase(buffer[offset++]) == 'v' && Character.toLowerCase(buffer[offset++]) == 'e' ? FTokenContext.KW_SAVE : null;
                        }
                        case 'i': {
                            return len == 4 && Character.toLowerCase(buffer[offset++]) == 'z' && Character.toLowerCase(buffer[offset++]) == 'e' ? FTokenContext.KW_SIZE : null;
                        }
                        case 't': {
                            return len == 4 && Character.toLowerCase(buffer[offset++]) == 'o' && Character.toLowerCase(buffer[offset++]) == 'p' ? FTokenContext.KW_STOP : null;
                        }
                    }
                    return null;
                }
                switch (Character.toLowerCase(buffer[offset++])) {
                    case 'e': {
                        switch (Character.toLowerCase(buffer[offset++])) {
                            case 'l': {
                                if (len >= 6 && Character.toLowerCase(buffer[offset++]) == 'e' && Character.toLowerCase(buffer[offset++]) == 'c' && Character.toLowerCase(buffer[offset++]) == 't') {
                                    if (len == 6) {
                                        return FTokenContext.KW_SELECT;
                                    }
                                    if (len == 10 && Character.toLowerCase(buffer[offset++]) == 'c' && Character.toLowerCase(buffer[offset++]) == 'a' && Character.toLowerCase(buffer[offset++]) == 's' && Character.toLowerCase(buffer[offset++]) == 'e') {
                                        return FTokenContext.KW_SELECTCASE;
                                    }
                                    return null;
                                }
                                return null;
                            }
                            case 'q': {
                                if (len >= 8 && Character.toLowerCase(buffer[offset++]) == 'u' && Character.toLowerCase(buffer[offset++]) == 'e' && Character.toLowerCase(buffer[offset++]) == 'n') {
                                    switch (Character.toLowerCase(buffer[offset++])) {
                                        case 'c': {
                                            return len == 8 && Character.toLowerCase(buffer[offset++]) == 'e' ? FTokenContext.KW_SEQUENCE : null;
                                        }
                                        case 't': {
                                            return len == 11 && Character.toLowerCase(buffer[offset++]) == 'i' && Character.toLowerCase(buffer[offset++]) == 'a' && Character.toLowerCase(buffer[offset++]) == 'l' && Character.toLowerCase(buffer[offset++]) == '=' ? FTokenContext.KW_SEQUENTIAL_EQ : null;
                                        }
                                    }
                                    return null;
                                }
                                return null;
                            }
                        }
                        return null;
                    }
                    case 'i': {
                        return len == 5 && Character.toLowerCase(buffer[offset++]) == 'z' && Character.toLowerCase(buffer[offset++]) == 'e' && Character.toLowerCase(buffer[offset++]) == '=' ? FTokenContext.KW_SIZE_EQ : null;
                    }
                    case 't': {
                        switch (Character.toLowerCase(buffer[offset++])) {
                            case 'a': {
                                if (len >= 5 && Character.toLowerCase(buffer[offset++]) != 't') {
                                    switch (Character.toLowerCase(buffer[offset++])) {
                                        case '=': {
                                            return len == 5 ? FTokenContext.KW_STAT_EQ : null;
                                        }
                                        case 'u': {
                                            return len == 7 && Character.toLowerCase(buffer[offset++]) == 's' && Character.toLowerCase(buffer[offset++]) == '=' ? FTokenContext.KW_STATUS_EQ : null;
                                        }
                                    }
                                    return null;
                                }
                                return null;
                            }
                            case 'r': {
                                return len == 9 && Character.toLowerCase(buffer[offset++]) == 'u' && Character.toLowerCase(buffer[offset++]) == 'c' && Character.toLowerCase(buffer[offset++]) == 't' && Character.toLowerCase(buffer[offset++]) == 'u' && Character.toLowerCase(buffer[offset++]) == 'r' && Character.toLowerCase(buffer[offset++]) == 'e' ? FTokenContext.KW_STRUCTURE : null;
                            }
                        }
                        return null;
                    }
                    case 'u': {
                        return len == 10 && Character.toLowerCase(buffer[offset++]) == 'b' && Character.toLowerCase(buffer[offset++]) == 'r' && Character.toLowerCase(buffer[offset++]) == 'o' && Character.toLowerCase(buffer[offset++]) == 'u' && Character.toLowerCase(buffer[offset++]) == 't' && Character.toLowerCase(buffer[offset++]) == 'i' && Character.toLowerCase(buffer[offset++]) == 'n' && Character.toLowerCase(buffer[offset++]) == 'e' ? FTokenContext.KW_SUBROUTINE : null;
                    }
                }
                return null;
            }
            case 't': {
                if (len < 2 || len > 6) {
                    return null;
                }
                switch (Character.toLowerCase(buffer[offset++])) {
                    case 'a': {
                        return len == 6 && Character.toLowerCase(buffer[offset++]) == 'r' && Character.toLowerCase(buffer[offset++]) == 'g' && Character.toLowerCase(buffer[offset++]) == 'e' && Character.toLowerCase(buffer[offset++]) == 't' ? FTokenContext.KW_TARGET : null;
                    }
                    case 'h': {
                        return len == 4 && Character.toLowerCase(buffer[offset++]) == 'e' && Character.toLowerCase(buffer[offset++]) == 'n' ? FTokenContext.KW_THEN : null;
                    }
                    case 'o': {
                        return len == 2 ? FTokenContext.KW_TO : null;
                    }
                    case 'y': {
                        return len == 4 && Character.toLowerCase(buffer[offset++]) == 'p' && Character.toLowerCase(buffer[offset++]) == 'e' ? FTokenContext.KW_TYPE : null;
                    }
                }
                return null;
            }
            case 'u': {
                if (len < 3 || len > 12) {
                    return null;
                }
                switch (Character.toLowerCase(buffer[offset++])) {
                    case 'n': {
                        switch (Character.toLowerCase(buffer[offset++])) {
                            case 'f': {
                                return len == 12 && Character.toLowerCase(buffer[offset++]) == 'o' && Character.toLowerCase(buffer[offset++]) == 'r' && Character.toLowerCase(buffer[offset++]) == 'm' && Character.toLowerCase(buffer[offset++]) == 'a' && Character.toLowerCase(buffer[offset++]) == 't' && Character.toLowerCase(buffer[offset++]) == 't' && Character.toLowerCase(buffer[offset++]) == 'e' && Character.toLowerCase(buffer[offset++]) == 'd' && Character.toLowerCase(buffer[offset++]) == '=' ? FTokenContext.KW_UNFORMATTED_EQ : null;
                            }
                            case 'i': {
                                return len == 5 && Character.toLowerCase(buffer[offset++]) == 'o' && Character.toLowerCase(buffer[offset++]) == 'n' ? FTokenContext.KW_UNION : null;
                            }
                        }
                        return null;
                    }
                    case 's': {
                        return len == 3 && Character.toLowerCase(buffer[offset++]) == 'e' ? FTokenContext.KW_USE : null;
                    }
                }
                return null;
            }
            case 'w': {
                if (len < 5 || len > 6) {
                    return null;
                }
                switch (Character.toLowerCase(buffer[offset++])) {
                    case 'h': {
                        switch (Character.toLowerCase(buffer[offset++])) {
                            case 'e': {
                                return len == 5 && Character.toLowerCase(buffer[offset++]) == 'r' && Character.toLowerCase(buffer[offset++]) == 'e' ? FTokenContext.KW_WHERE : null;
                            }
                            case 'i': {
                                return len == 5 && Character.toLowerCase(buffer[offset++]) == 'l' && Character.toLowerCase(buffer[offset++]) == 'e' ? FTokenContext.KW_WHILE : null;
                            }
                        }
                        return null;
                    }
                    case 'r': {
                        if (len >= 5 && Character.toLowerCase(buffer[offset++]) == 'i' && Character.toLowerCase(buffer[offset++]) == 't' && Character.toLowerCase(buffer[offset++]) == 'e') {
                            if (len == 5) {
                                return FTokenContext.KW_WRITE;
                            }
                            if (len == 6 && Character.toLowerCase(buffer[offset++]) == '=') {
                                return FTokenContext.KW_WRITE_EQ;
                            }
                            return null;
                        }
                        return null;
                    }
                }
                return null;
            }
        }
        return null;
    }

    public void loadState(Syntax.StateInfo stateInfo) {
        super.loadState(stateInfo);
        this.lastNL = this.offset - ((MyStateInfo)stateInfo).getColumn();
    }

    public void storeState(Syntax.StateInfo stateInfo) {
        super.storeState(stateInfo);
        ((MyStateInfo)stateInfo).setColumn(this.offset - this.lastNL);
    }

    public int compareState(Syntax.StateInfo stateInfo) {
        if (super.compareState(stateInfo) == 1) {
            return 1;
        }
        return ((MyStateInfo)stateInfo).getColumn() == this.offset - this.lastNL ? 0 : 1;
    }

    public Syntax.StateInfo createStateInfo() {
        return new MyStateInfo();
    }

    public static class MyStateInfo
    extends Syntax.BaseStateInfo {
        private int column;

        public int getColumn() {
            return this.column;
        }

        public void setColumn(int column) {
            this.column = column;
        }
    }
}

