/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cpp.editor.cplusplus;

import org.netbeans.editor.Syntax;
import org.netbeans.editor.TokenID;
import org.netbeans.modules.cpp.editor.cplusplus.CCTokenContext;

public class CCSyntax
extends Syntax {
    private static final int ISI_WHITESPACE = 2;
    private static final int ISI_LINE_COMMENT = 4;
    private static final int ISI_BLOCK_COMMENT = 5;
    private static final int ISI_STRING = 6;
    private static final int ISI_STRING_A_BSLASH = 7;
    private static final int ISI_CHAR = 8;
    private static final int ISI_CHAR_A_BSLASH = 9;
    private static final int ISI_IDENTIFIER = 10;
    private static final int ISA_SLASH = 11;
    private static final int ISA_EQ = 12;
    private static final int ISA_GT = 13;
    private static final int ISA_GTGT = 14;
    private static final int ISA_LT = 16;
    private static final int ISA_LTLT = 17;
    private static final int ISA_PLUS = 18;
    private static final int ISA_MINUS = 19;
    private static final int ISA_STAR = 20;
    private static final int ISA_STAR_I_BLOCK_COMMENT = 21;
    private static final int ISA_PIPE = 22;
    private static final int ISA_PERCENT = 23;
    private static final int ISA_AND = 24;
    private static final int ISA_XOR = 25;
    private static final int ISA_EXCLAMATION = 26;
    private static final int ISA_ZERO = 27;
    private static final int ISI_INT = 28;
    private static final int ISI_OCTAL = 29;
    private static final int ISI_DOUBLE = 30;
    private static final int ISI_DOUBLE_EXP = 31;
    private static final int ISI_HEX = 32;
    private static final int ISA_DOT = 33;
    private static final int ISA_HASH = 34;
    private static final int ISA_BACKSLASH = 35;
    private static final int ISA_LINE_CONTINUATION = 36;

    public CCSyntax() {
        this.tokenContextPath = CCTokenContext.contextPath;
    }

    protected TokenID parseToken() {
        while (this.offset < this.stopOffset) {
            char actChar = this.buffer[this.offset];
            block0 : switch (this.state) {
                case -1: {
                    switch (actChar) {
                        case '\"': {
                            this.state = 6;
                            break block0;
                        }
                        case '\'': {
                            this.state = 8;
                            break block0;
                        }
                        case '/': {
                            this.state = 11;
                            break block0;
                        }
                        case '\\': {
                            this.state = 35;
                            break block0;
                        }
                        case '=': {
                            this.state = 12;
                            break block0;
                        }
                        case '>': {
                            this.state = 13;
                            break block0;
                        }
                        case '<': {
                            this.state = 16;
                            break block0;
                        }
                        case '+': {
                            this.state = 18;
                            break block0;
                        }
                        case '-': {
                            this.state = 19;
                            break block0;
                        }
                        case '*': {
                            this.state = 20;
                            break block0;
                        }
                        case '|': {
                            this.state = 22;
                            break block0;
                        }
                        case '%': {
                            this.state = 23;
                            break block0;
                        }
                        case '&': {
                            this.state = 24;
                            break block0;
                        }
                        case '^': {
                            this.state = 25;
                            break block0;
                        }
                        case '~': {
                            ++this.offset;
                            return CCTokenContext.NEG;
                        }
                        case '!': {
                            this.state = 26;
                            break block0;
                        }
                        case '0': {
                            this.state = 27;
                            break block0;
                        }
                        case '.': {
                            this.state = 33;
                            break block0;
                        }
                        case ',': {
                            ++this.offset;
                            return CCTokenContext.COMMA;
                        }
                        case ';': {
                            ++this.offset;
                            return CCTokenContext.SEMICOLON;
                        }
                        case ':': {
                            ++this.offset;
                            return CCTokenContext.COLON;
                        }
                        case '?': {
                            ++this.offset;
                            return CCTokenContext.QUESTION;
                        }
                        case '(': {
                            ++this.offset;
                            return CCTokenContext.LPAREN;
                        }
                        case ')': {
                            ++this.offset;
                            return CCTokenContext.RPAREN;
                        }
                        case '[': {
                            ++this.offset;
                            return CCTokenContext.LBRACKET;
                        }
                        case ']': {
                            ++this.offset;
                            return CCTokenContext.RBRACKET;
                        }
                        case '{': {
                            ++this.offset;
                            return CCTokenContext.LBRACE;
                        }
                        case '}': {
                            ++this.offset;
                            return CCTokenContext.RBRACE;
                        }
                        case '#': {
                            this.state = 34;
                            break block0;
                        }
                    }
                    if (Character.isWhitespace(actChar)) {
                        this.state = 2;
                        break;
                    }
                    if (Character.isDigit(actChar)) {
                        this.state = 28;
                        break;
                    }
                    if (Character.isJavaIdentifierStart(actChar)) {
                        this.state = 10;
                        break;
                    }
                    ++this.offset;
                    return CCTokenContext.INVALID_CHAR;
                }
                case 2: {
                    if (Character.isWhitespace(actChar)) break;
                    this.state = -1;
                    return CCTokenContext.WHITESPACE;
                }
                case 4: {
                    switch (actChar) {
                        case '\n': {
                            this.state = -1;
                            return CCTokenContext.LINE_COMMENT;
                        }
                    }
                    break;
                }
                case 5: {
                    switch (actChar) {
                        case '*': {
                            this.state = 21;
                        }
                    }
                    break;
                }
                case 6: {
                    switch (actChar) {
                        case '\\': {
                            this.state = 7;
                            break block0;
                        }
                        case '\n': {
                            this.state = -1;
                            this.supposedTokenID = CCTokenContext.STRING_LITERAL;
                            return this.supposedTokenID;
                        }
                        case '\"': {
                            ++this.offset;
                            this.state = -1;
                            return CCTokenContext.STRING_LITERAL;
                        }
                    }
                    break;
                }
                case 7: {
                    switch (actChar) {
                        case '\"': 
                        case '\\': {
                            break;
                        }
                        default: {
                            --this.offset;
                        }
                    }
                    this.state = 6;
                    break;
                }
                case 8: {
                    switch (actChar) {
                        case '\\': {
                            this.state = 9;
                            break block0;
                        }
                        case '\n': {
                            this.state = -1;
                            this.supposedTokenID = CCTokenContext.CHAR_LITERAL;
                            return this.supposedTokenID;
                        }
                        case '\'': {
                            ++this.offset;
                            this.state = -1;
                            return CCTokenContext.CHAR_LITERAL;
                        }
                    }
                    break;
                }
                case 9: {
                    switch (actChar) {
                        case '\'': 
                        case '\\': {
                            break;
                        }
                        default: {
                            --this.offset;
                        }
                    }
                    this.state = 8;
                    break;
                }
                case 10: {
                    if (Character.isJavaIdentifierPart(actChar)) break;
                    this.state = -1;
                    TokenID tid = CCSyntax.matchKeyword(this.buffer, this.tokenOffset, this.offset - this.tokenOffset);
                    return tid != null ? tid : CCTokenContext.IDENTIFIER;
                }
                case 11: {
                    switch (actChar) {
                        case '=': {
                            ++this.offset;
                            this.state = -1;
                            return CCTokenContext.DIV_EQ;
                        }
                        case '/': {
                            this.state = 4;
                            break block0;
                        }
                        case '*': {
                            this.state = 5;
                            break block0;
                        }
                    }
                    this.state = -1;
                    return CCTokenContext.DIV;
                }
                case 35: {
                    switch (actChar) {
                        case '\n': {
                            this.state = 36;
                            break block0;
                        }
                    }
                    this.state = -1;
                    return CCTokenContext.INVALID_BACKSLASH;
                }
                case 36: {
                    this.state = -1;
                    return CCTokenContext.BACKSLASH;
                }
                case 34: {
                    if (Character.isJavaIdentifierPart(actChar) && this.offset != this.stopOffset - 1) break;
                    int len = this.offset - this.tokenOffset;
                    if (Character.isJavaIdentifierPart(actChar)) {
                        ++len;
                        ++this.offset;
                    }
                    this.state = -1;
                    TokenID tid = CCSyntax.matchCPPKeyword(this.buffer, this.tokenOffset, len);
                    return tid != null ? tid : CCTokenContext.IDENTIFIER;
                }
                case 12: {
                    switch (actChar) {
                        case '=': {
                            ++this.offset;
                            return CCTokenContext.EQ_EQ;
                        }
                    }
                    this.state = -1;
                    return CCTokenContext.EQ;
                }
                case 13: {
                    switch (actChar) {
                        case '>': {
                            this.state = 14;
                            break block0;
                        }
                        case '=': {
                            ++this.offset;
                            return CCTokenContext.GT_EQ;
                        }
                    }
                    this.state = -1;
                    return CCTokenContext.GT;
                }
                case 14: {
                    switch (actChar) {
                        case '=': {
                            ++this.offset;
                            return CCTokenContext.RSSHIFT_EQ;
                        }
                    }
                    this.state = -1;
                    return CCTokenContext.RSSHIFT;
                }
                case 16: {
                    switch (actChar) {
                        case '<': {
                            this.state = 17;
                            break block0;
                        }
                        case '=': {
                            ++this.offset;
                            return CCTokenContext.LT_EQ;
                        }
                    }
                    this.state = -1;
                    return CCTokenContext.LT;
                }
                case 17: {
                    switch (actChar) {
                        case '<': {
                            this.state = -1;
                            ++this.offset;
                            return CCTokenContext.INVALID_OPERATOR;
                        }
                        case '=': {
                            ++this.offset;
                            return CCTokenContext.LSHIFT_EQ;
                        }
                    }
                    this.state = -1;
                    return CCTokenContext.LSHIFT;
                }
                case 18: {
                    switch (actChar) {
                        case '+': {
                            ++this.offset;
                            return CCTokenContext.PLUS_PLUS;
                        }
                        case '=': {
                            ++this.offset;
                            return CCTokenContext.PLUS_EQ;
                        }
                    }
                    this.state = -1;
                    return CCTokenContext.PLUS;
                }
                case 19: {
                    switch (actChar) {
                        case '-': {
                            ++this.offset;
                            return CCTokenContext.MINUS_MINUS;
                        }
                        case '=': {
                            ++this.offset;
                            return CCTokenContext.MINUS_EQ;
                        }
                    }
                    this.state = -1;
                    return CCTokenContext.MINUS;
                }
                case 20: {
                    switch (actChar) {
                        case '=': {
                            ++this.offset;
                            return CCTokenContext.MUL_EQ;
                        }
                        case '/': {
                            ++this.offset;
                            this.state = -1;
                            return CCTokenContext.INVALID_COMMENT_END;
                        }
                    }
                    this.state = -1;
                    return CCTokenContext.MUL;
                }
                case 21: {
                    switch (actChar) {
                        case '/': {
                            ++this.offset;
                            this.state = -1;
                            return CCTokenContext.BLOCK_COMMENT;
                        }
                    }
                    --this.offset;
                    this.state = 5;
                    break;
                }
                case 22: {
                    switch (actChar) {
                        case '=': {
                            ++this.offset;
                            this.state = -1;
                            return CCTokenContext.OR_EQ;
                        }
                        case '|': {
                            ++this.offset;
                            this.state = -1;
                            return CCTokenContext.OR_OR;
                        }
                    }
                    this.state = -1;
                    return CCTokenContext.OR;
                }
                case 23: {
                    switch (actChar) {
                        case '=': {
                            ++this.offset;
                            this.state = -1;
                            return CCTokenContext.MOD_EQ;
                        }
                    }
                    this.state = -1;
                    return CCTokenContext.MOD;
                }
                case 24: {
                    switch (actChar) {
                        case '=': {
                            ++this.offset;
                            this.state = -1;
                            return CCTokenContext.AND_EQ;
                        }
                        case '&': {
                            ++this.offset;
                            this.state = -1;
                            return CCTokenContext.AND_AND;
                        }
                    }
                    this.state = -1;
                    return CCTokenContext.AND;
                }
                case 25: {
                    switch (actChar) {
                        case '=': {
                            ++this.offset;
                            this.state = -1;
                            return CCTokenContext.XOR_EQ;
                        }
                    }
                    this.state = -1;
                    return CCTokenContext.XOR;
                }
                case 26: {
                    switch (actChar) {
                        case '=': {
                            ++this.offset;
                            this.state = -1;
                            return CCTokenContext.NOT_EQ;
                        }
                    }
                    this.state = -1;
                    return CCTokenContext.NOT;
                }
                case 27: {
                    switch (actChar) {
                        case '.': {
                            this.state = 30;
                            break block0;
                        }
                        case 'X': 
                        case 'x': {
                            this.state = 32;
                            break block0;
                        }
                        case 'L': 
                        case 'l': {
                            ++this.offset;
                            this.state = -1;
                            return CCTokenContext.LONG_LITERAL;
                        }
                        case 'F': 
                        case 'f': {
                            ++this.offset;
                            this.state = -1;
                            return CCTokenContext.FLOAT_LITERAL;
                        }
                        case 'D': 
                        case 'd': {
                            ++this.offset;
                            this.state = -1;
                            return CCTokenContext.DOUBLE_LITERAL;
                        }
                        case '8': 
                        case '9': {
                            this.state = -1;
                            ++this.offset;
                            return CCTokenContext.INVALID_OCTAL_LITERAL;
                        }
                        case 'E': 
                        case 'e': {
                            this.state = 31;
                            break block0;
                        }
                    }
                    if (Character.isDigit(actChar)) {
                        this.state = 29;
                        break;
                    }
                    this.state = -1;
                    return CCTokenContext.INT_LITERAL;
                }
                case 28: {
                    switch (actChar) {
                        case 'L': 
                        case 'l': {
                            ++this.offset;
                            this.state = -1;
                            return CCTokenContext.LONG_LITERAL;
                        }
                        case '.': {
                            this.state = 30;
                            break block0;
                        }
                        case 'F': 
                        case 'f': {
                            ++this.offset;
                            this.state = -1;
                            return CCTokenContext.FLOAT_LITERAL;
                        }
                        case 'D': 
                        case 'd': {
                            ++this.offset;
                            this.state = -1;
                            return CCTokenContext.DOUBLE_LITERAL;
                        }
                        case 'E': 
                        case 'e': {
                            this.state = 31;
                            break block0;
                        }
                    }
                    if (actChar >= '0' && actChar <= '9') break;
                    this.state = -1;
                    return CCTokenContext.INT_LITERAL;
                }
                case 29: {
                    if (actChar >= '0' && actChar <= '7') break;
                    this.state = -1;
                    return CCTokenContext.OCTAL_LITERAL;
                }
                case 30: {
                    switch (actChar) {
                        case 'F': 
                        case 'f': {
                            ++this.offset;
                            this.state = -1;
                            return CCTokenContext.FLOAT_LITERAL;
                        }
                        case 'D': 
                        case 'd': {
                            ++this.offset;
                            this.state = -1;
                            return CCTokenContext.DOUBLE_LITERAL;
                        }
                        case 'E': 
                        case 'e': {
                            this.state = 31;
                            break block0;
                        }
                    }
                    if (actChar >= '0' && actChar <= '9' || actChar == '.') break;
                    this.state = -1;
                    return CCTokenContext.DOUBLE_LITERAL;
                }
                case 31: {
                    switch (actChar) {
                        case 'F': 
                        case 'f': {
                            ++this.offset;
                            this.state = -1;
                            return CCTokenContext.FLOAT_LITERAL;
                        }
                        case 'D': 
                        case 'd': {
                            ++this.offset;
                            this.state = -1;
                            return CCTokenContext.DOUBLE_LITERAL;
                        }
                    }
                    if (Character.isDigit(actChar) || actChar == '-' || actChar == '+') break;
                    this.state = -1;
                    return CCTokenContext.DOUBLE_LITERAL;
                }
                case 32: {
                    if (actChar >= 'a' && actChar <= 'f' || actChar >= 'A' && actChar <= 'F' || Character.isDigit(actChar)) break;
                    this.state = -1;
                    return CCTokenContext.HEX_LITERAL;
                }
                case 33: {
                    if (Character.isDigit(actChar)) {
                        this.state = 30;
                        break;
                    }
                    this.state = -1;
                    return CCTokenContext.DOT;
                }
            }
            ++this.offset;
        }
        if (this.lastBuffer) {
            switch (this.state) {
                case 2: {
                    this.state = -1;
                    return CCTokenContext.WHITESPACE;
                }
                case 10: {
                    this.state = -1;
                    TokenID kwd = CCSyntax.matchKeyword(this.buffer, this.tokenOffset, this.offset - this.tokenOffset);
                    return kwd != null ? kwd : CCTokenContext.IDENTIFIER;
                }
                case 4: {
                    return CCTokenContext.LINE_COMMENT;
                }
                case 5: 
                case 21: {
                    return CCTokenContext.BLOCK_COMMENT;
                }
                case 6: 
                case 7: {
                    return CCTokenContext.STRING_LITERAL;
                }
                case 8: 
                case 9: {
                    return CCTokenContext.CHAR_LITERAL;
                }
                case 27: 
                case 28: {
                    this.state = -1;
                    return CCTokenContext.INT_LITERAL;
                }
                case 29: {
                    this.state = -1;
                    return CCTokenContext.OCTAL_LITERAL;
                }
                case 30: 
                case 31: {
                    this.state = -1;
                    return CCTokenContext.DOUBLE_LITERAL;
                }
                case 32: {
                    this.state = -1;
                    return CCTokenContext.HEX_LITERAL;
                }
                case 35: {
                    this.state = -1;
                    return CCTokenContext.BACKSLASH;
                }
                case 36: {
                    this.state = -1;
                    return CCTokenContext.LINE_CONTINUATION;
                }
                case 33: {
                    this.state = -1;
                    return CCTokenContext.DOT;
                }
                case 11: {
                    this.state = -1;
                    return CCTokenContext.DIV;
                }
                case 12: {
                    this.state = -1;
                    return CCTokenContext.EQ;
                }
                case 13: {
                    this.state = -1;
                    return CCTokenContext.GT;
                }
                case 14: {
                    this.state = -1;
                    return CCTokenContext.RSSHIFT;
                }
                case 16: {
                    this.state = -1;
                    return CCTokenContext.LT;
                }
                case 17: {
                    this.state = -1;
                    return CCTokenContext.LSHIFT;
                }
                case 18: {
                    this.state = -1;
                    return CCTokenContext.PLUS;
                }
                case 19: {
                    this.state = -1;
                    return CCTokenContext.MINUS;
                }
                case 20: {
                    this.state = -1;
                    return CCTokenContext.MUL;
                }
                case 22: {
                    this.state = -1;
                    return CCTokenContext.OR;
                }
                case 23: {
                    this.state = -1;
                    return CCTokenContext.MOD;
                }
                case 24: {
                    this.state = -1;
                    return CCTokenContext.AND;
                }
                case 25: {
                    this.state = -1;
                    return CCTokenContext.XOR;
                }
                case 26: {
                    this.state = -1;
                    return CCTokenContext.NOT;
                }
                case 34: {
                    this.state = -1;
                    return CCTokenContext.HASH;
                }
            }
        }
        switch (this.state) {
            case 2: {
                return CCTokenContext.WHITESPACE;
            }
        }
        return null;
    }

    public String getStateName(int stateNumber) {
        switch (stateNumber) {
            case 2: {
                return "ISI_WHITESPACE";
            }
            case 4: {
                return "ISI_LINE_COMMENT";
            }
            case 5: {
                return "ISI_BLOCK_COMMENT";
            }
            case 6: {
                return "ISI_STRING";
            }
            case 7: {
                return "ISI_STRING_A_BSLASH";
            }
            case 8: {
                return "ISI_CHAR";
            }
            case 9: {
                return "ISI_CHAR_A_BSLASH";
            }
            case 10: {
                return "ISI_IDENTIFIER";
            }
            case 11: {
                return "ISA_SLASH";
            }
            case 35: {
                return "ISA_BACKSLASH";
            }
            case 12: {
                return "ISA_EQ";
            }
            case 13: {
                return "ISA_GT";
            }
            case 14: {
                return "ISA_GTGT";
            }
            case 16: {
                return "ISA_LT";
            }
            case 17: {
                return "ISA_LTLT";
            }
            case 18: {
                return "ISA_PLUS";
            }
            case 19: {
                return "ISA_MINUS";
            }
            case 20: {
                return "ISA_STAR";
            }
            case 21: {
                return "ISA_STAR_I_BLOCK_COMMENT";
            }
            case 22: {
                return "ISA_PIPE";
            }
            case 23: {
                return "ISA_PERCENT";
            }
            case 24: {
                return "ISA_AND";
            }
            case 25: {
                return "ISA_XOR";
            }
            case 26: {
                return "ISA_EXCLAMATION";
            }
            case 27: {
                return "ISA_ZERO";
            }
            case 28: {
                return "ISI_INT";
            }
            case 29: {
                return "ISI_OCTAL";
            }
            case 30: {
                return "ISI_DOUBLE";
            }
            case 31: {
                return "ISI_DOUBLE_EXP";
            }
            case 32: {
                return "ISI_HEX";
            }
            case 33: {
                return "ISA_DOT";
            }
            case 34: {
                return "ISA_HASH";
            }
        }
        return super.getStateName(stateNumber);
    }

    public static TokenID matchKeyword(char[] buffer, int offset, int len) {
        if (len > 16) {
            return null;
        }
        if (len <= 1) {
            return null;
        }
        switch (buffer[offset++]) {
            case 'a': {
                if (len <= 3) {
                    return null;
                }
                switch (buffer[offset++]) {
                    case 's': {
                        return len == 3 && buffer[offset++] == 'm' ? CCTokenContext.ASM : null;
                    }
                    case 'u': {
                        return len == 4 && buffer[offset++] == 't' && buffer[offset++] == 'o' ? CCTokenContext.AUTO : null;
                    }
                }
                return null;
            }
            case 'b': {
                if (len <= 3) {
                    return null;
                }
                switch (buffer[offset++]) {
                    case 'o': {
                        return len == 4 && buffer[offset++] == 'o' && buffer[offset++] == 'l' ? CCTokenContext.BOOLEAN : null;
                    }
                    case 'r': {
                        return len == 5 && buffer[offset++] == 'e' && buffer[offset++] == 'a' && buffer[offset++] == 'k' ? CCTokenContext.BREAK : null;
                    }
                    case 'y': {
                        return len == 4 && buffer[offset++] == 't' && buffer[offset++] == 'e' ? CCTokenContext.BYTE : null;
                    }
                }
                return null;
            }
            case 'c': {
                if (len <= 3) {
                    return null;
                }
                switch (buffer[offset++]) {
                    case 'a': {
                        switch (buffer[offset++]) {
                            case 's': {
                                return len == 4 && buffer[offset++] == 'e' ? CCTokenContext.CASE : null;
                            }
                            case 't': {
                                return len == 5 && buffer[offset++] == 'c' && buffer[offset++] == 'h' ? CCTokenContext.CATCH : null;
                            }
                        }
                        return null;
                    }
                    case 'h': {
                        return len == 4 && buffer[offset++] == 'a' && buffer[offset++] == 'r' ? CCTokenContext.CHAR : null;
                    }
                    case 'l': {
                        return len == 5 && buffer[offset++] == 'a' && buffer[offset++] == 's' && buffer[offset++] == 's' ? CCTokenContext.CLASS : null;
                    }
                    case 'o': {
                        if (len <= 4) {
                            return null;
                        }
                        if (buffer[offset++] != 'n') {
                            return null;
                        }
                        switch (buffer[offset++]) {
                            case 's': {
                                if (len == 5) {
                                    return buffer[offset++] == 't' ? CCTokenContext.CONST : null;
                                }
                                if (len == 10) {
                                    return buffer[offset++] == 't' && buffer[offset++] == '_' && buffer[offset++] == 'c' && buffer[offset++] == 'a' && buffer[offset++] == 's' && buffer[offset++] == 't' ? CCTokenContext.CONST_CAST : null;
                                }
                                return null;
                            }
                            case 't': {
                                return len == 8 && buffer[offset++] == 'i' && buffer[offset++] == 'n' && buffer[offset++] == 'u' && buffer[offset++] == 'e' ? CCTokenContext.CONTINUE : null;
                            }
                        }
                        return null;
                    }
                }
                return null;
            }
            case 'd': {
                if (len <= 1) {
                    return null;
                }
                switch (buffer[offset++]) {
                    case 'e': {
                        switch (buffer[offset++]) {
                            case 'f': {
                                return len == 7 && buffer[offset++] == 'a' && buffer[offset++] == 'u' && buffer[offset++] == 'l' && buffer[offset++] == 't' ? CCTokenContext.DEFAULT : null;
                            }
                            case 'l': {
                                return len == 6 && buffer[offset++] == 'e' && buffer[offset++] == 't' && buffer[offset++] == 'e' ? CCTokenContext.DELETE : null;
                            }
                        }
                        return null;
                    }
                    case 'o': {
                        if (len == 2) {
                            return CCTokenContext.DO;
                        }
                        return len == 6 && buffer[offset++] == 'u' && buffer[offset++] == 'b' && buffer[offset++] == 'l' && buffer[offset++] == 'e' ? CCTokenContext.DOUBLE : null;
                    }
                    case 'y': {
                        return len == 12 && buffer[offset++] == 'n' && buffer[offset++] == 'a' && buffer[offset++] == 'm' && buffer[offset++] == 'i' && buffer[offset++] == 'c' && buffer[offset++] == '_' && buffer[offset++] == 'c' && buffer[offset++] == 'a' && buffer[offset++] == 's' && buffer[offset++] == 't' ? CCTokenContext.DYNAMIC_CAST : null;
                    }
                }
                return null;
            }
            case 'e': {
                if (len <= 3) {
                    return null;
                }
                switch (buffer[offset++]) {
                    case 'l': {
                        return len == 4 && buffer[offset++] == 's' && buffer[offset++] == 'e' ? CCTokenContext.ELSE : null;
                    }
                    case 'n': {
                        return len == 4 && buffer[offset++] == 'u' && buffer[offset++] == 'm' ? CCTokenContext.ENUM : null;
                    }
                    case 'x': {
                        switch (buffer[offset++]) {
                            case 'p': {
                                switch (buffer[offset++]) {
                                    case 'l': {
                                        return len == 8 && buffer[offset++] == 'i' && buffer[offset++] == 'c' && buffer[offset++] == 'i' && buffer[offset++] == 't' ? CCTokenContext.EXPLICIT : null;
                                    }
                                    case 'o': {
                                        return len == 6 && buffer[offset++] == 'r' && buffer[offset++] == 't' ? CCTokenContext.EXPORT : null;
                                    }
                                }
                                return null;
                            }
                            case 't': {
                                return len == 6 && buffer[offset++] == 'e' && buffer[offset++] == 'r' && buffer[offset++] == 'n' ? CCTokenContext.EXTERN : null;
                            }
                        }
                        return null;
                    }
                }
                return null;
            }
            case 'f': {
                if (len <= 2) {
                    return null;
                }
                switch (buffer[offset++]) {
                    case 'a': {
                        return len == 5 && buffer[offset++] == 'l' && buffer[offset++] == 's' && buffer[offset++] == 'e' ? CCTokenContext.FALSE : null;
                    }
                    case 'l': {
                        return len == 5 && buffer[offset++] == 'o' && buffer[offset++] == 'a' && buffer[offset++] == 't' ? CCTokenContext.FLOAT : null;
                    }
                    case 'o': {
                        return len == 3 && buffer[offset++] == 'r' ? CCTokenContext.FOR : null;
                    }
                    case 'r': {
                        return len == 6 && buffer[offset++] == 'i' && buffer[offset++] == 'e' && buffer[offset++] == 'n' && buffer[offset++] == 'd' ? CCTokenContext.FRIEND : null;
                    }
                }
                return null;
            }
            case 'g': {
                return len == 4 && buffer[offset++] == 'o' && buffer[offset++] == 't' && buffer[offset++] == 'o' ? CCTokenContext.GOTO : null;
            }
            case 'i': {
                switch (buffer[offset++]) {
                    case 'f': {
                        return len == 2 ? CCTokenContext.IF : null;
                    }
                    case 'n': {
                        switch (buffer[offset++]) {
                            case 't': {
                                return len == 3 ? CCTokenContext.INT : null;
                            }
                            case 'l': {
                                return len == 6 && buffer[offset++] == 'i' && buffer[offset++] == 'n' && buffer[offset++] == 'e' ? CCTokenContext.INLINE : null;
                            }
                        }
                        return null;
                    }
                }
                return null;
            }
            case 'l': {
                return len == 4 && buffer[offset++] == 'o' && buffer[offset++] == 'n' && buffer[offset++] == 'g' ? CCTokenContext.LONG : null;
            }
            case 'm': {
                return len == 7 && buffer[offset++] == 'u' && buffer[offset++] == 't' && buffer[offset++] == 'a' && buffer[offset++] == 'b' && buffer[offset++] == 'l' && buffer[offset++] == 'e' ? CCTokenContext.MUTABLE : null;
            }
            case 'n': {
                if (len <= 2) {
                    return null;
                }
                switch (buffer[offset++]) {
                    case 'a': {
                        return len == 9 && buffer[offset++] == 'm' && buffer[offset++] == 'e' && buffer[offset++] == 's' && buffer[offset++] == 'p' && buffer[offset++] == 'a' && buffer[offset++] == 'c' && buffer[offset++] == 'e' ? CCTokenContext.NAMESPACE : null;
                    }
                    case 'e': {
                        return len == 3 && buffer[offset++] == 'w' ? CCTokenContext.NEW : null;
                    }
                    case 'u': {
                        return len == 4 && buffer[offset++] == 'l' && buffer[offset++] == 'l' ? CCTokenContext.NULL : null;
                    }
                }
                return null;
            }
            case 'o': {
                return len == 8 && buffer[offset++] == 'p' && buffer[offset++] == 'e' && buffer[offset++] == 'r' && buffer[offset++] == 'a' && buffer[offset++] == 't' && buffer[offset++] == 'o' && buffer[offset++] == 'r' ? CCTokenContext.OPERATOR : null;
            }
            case 'p': {
                if (len <= 5) {
                    return null;
                }
                switch (buffer[offset++]) {
                    case 'r': {
                        if (len <= 6) {
                            return null;
                        }
                        switch (buffer[offset++]) {
                            case 'i': {
                                return len == 7 && buffer[offset++] == 'v' && buffer[offset++] == 'a' && buffer[offset++] == 't' && buffer[offset++] == 'e' ? CCTokenContext.PRIVATE : null;
                            }
                            case 'o': {
                                return len == 9 && buffer[offset++] == 't' && buffer[offset++] == 'e' && buffer[offset++] == 'c' && buffer[offset++] == 't' && buffer[offset++] == 'e' && buffer[offset++] == 'd' ? CCTokenContext.PROTECTED : null;
                            }
                        }
                        return null;
                    }
                    case 'u': {
                        return len == 6 && buffer[offset++] == 'b' && buffer[offset++] == 'l' && buffer[offset++] == 'i' && buffer[offset++] == 'c' ? CCTokenContext.PUBLIC : null;
                    }
                }
                return null;
            }
            case 'r': {
                if (len < 6 || buffer[offset++] != 'e') {
                    return null;
                }
                switch (buffer[offset++]) {
                    case 'g': {
                        return len == 8 && buffer[offset++] == 'i' && buffer[offset++] == 's' && buffer[offset++] == 't' && buffer[offset++] == 'e' && buffer[offset++] == 'r' ? CCTokenContext.REGISTER : null;
                    }
                    case 'i': {
                        return len == 16 && buffer[offset++] == 'n' && buffer[offset++] == 't' && buffer[offset++] == 'e' && buffer[offset++] == 'r' && buffer[offset++] == 'p' && buffer[offset++] == 'r' && buffer[offset++] == 'e' && buffer[offset++] == 't' && buffer[offset++] == '_' && buffer[offset++] == 'c' && buffer[offset++] == 'a' && buffer[offset++] == 's' && buffer[offset++] == 't' ? CCTokenContext.REINTERPRET_CAST : null;
                    }
                    case 't': {
                        return len == 6 && buffer[offset++] == 'u' && buffer[offset++] == 'r' && buffer[offset++] == 'n' ? CCTokenContext.RETURN : null;
                    }
                }
                return null;
            }
            case 's': {
                if (len <= 4) {
                    return null;
                }
                switch (buffer[offset++]) {
                    case 'h': {
                        return len == 5 && buffer[offset++] == 'o' && buffer[offset++] == 'r' && buffer[offset++] == 't' ? CCTokenContext.SHORT : null;
                    }
                    case 'i': {
                        switch (buffer[offset++]) {
                            case 'z': {
                                return len == 6 && buffer[offset++] == 'e' && buffer[offset++] == 'o' && buffer[offset++] == 'f' ? CCTokenContext.SIZEOF : null;
                            }
                            case 'g': {
                                return len == 6 && buffer[offset++] == 'n' && buffer[offset++] == 'e' && buffer[offset++] == 'd' ? CCTokenContext.SIGNED : null;
                            }
                        }
                        return null;
                    }
                    case 't': {
                        switch (buffer[offset++]) {
                            case 'r': {
                                return len == 6 && buffer[offset++] == 'u' && buffer[offset++] == 'c' && buffer[offset++] == 't' ? CCTokenContext.STRUCT : null;
                            }
                            case 'a': {
                                if (len == 6) {
                                    return buffer[offset++] == 't' && buffer[offset++] == 'i' && buffer[offset++] == 'c' ? CCTokenContext.STATIC : null;
                                }
                                if (len == 11) {
                                    return buffer[offset++] == 't' && buffer[offset++] == 'i' && buffer[offset++] == 'c' && buffer[offset++] == '_' && buffer[offset++] == 'c' && buffer[offset++] == 'a' && buffer[offset++] == 's' && buffer[offset++] == 't' ? CCTokenContext.STATIC_CAST : null;
                                }
                                return null;
                            }
                        }
                        return null;
                    }
                    case 'w': {
                        return len == 6 && buffer[offset++] == 'i' && buffer[offset++] == 't' && buffer[offset++] == 'c' && buffer[offset++] == 'h' ? CCTokenContext.SWITCH : null;
                    }
                }
                return null;
            }
            case 't': {
                if (len <= 2) {
                    return null;
                }
                switch (buffer[offset++]) {
                    case 'e': {
                        return len == 8 && buffer[offset++] == 'm' && buffer[offset++] == 'p' && buffer[offset++] == 'l' && buffer[offset++] == 'a' && buffer[offset++] == 't' && buffer[offset++] == 'e' ? CCTokenContext.TEMPLATE : null;
                    }
                    case 'h': {
                        switch (buffer[offset++]) {
                            case 'i': {
                                return len == 4 && buffer[offset++] == 's' ? CCTokenContext.THIS : null;
                            }
                            case 'r': {
                                return len == 5 && buffer[offset++] == 'o' && buffer[offset++] == 'w' ? CCTokenContext.THROW : null;
                            }
                        }
                        return null;
                    }
                    case 'r': {
                        switch (buffer[offset++]) {
                            case 'u': {
                                return len == 4 && buffer[offset++] == 'e' ? CCTokenContext.TRUE : null;
                            }
                            case 'y': {
                                return len == 3 ? CCTokenContext.TRY : null;
                            }
                        }
                        return null;
                    }
                    case 'y': {
                        return len == 7 && buffer[offset++] == 'p' && buffer[offset++] == 'e' && buffer[offset++] == 'd' && buffer[offset++] == 'e' && buffer[offset++] == 'f' ? CCTokenContext.TYPEDEF : null;
                    }
                }
                return null;
            }
            case 'u': {
                if (len <= 4) {
                    return null;
                }
                switch (buffer[offset++]) {
                    case 's': {
                        return len == 5 && buffer[offset++] == 'i' && buffer[offset++] == 'n' && buffer[offset++] == 'g' ? CCTokenContext.USING : null;
                    }
                    case 'n': {
                        switch (buffer[offset++]) {
                            case 'i': {
                                return len == 5 && buffer[offset++] == 'o' && buffer[offset++] == 'n' ? CCTokenContext.UNION : null;
                            }
                            case 's': {
                                return len == 8 && buffer[offset++] == 'i' && buffer[offset++] == 'g' && buffer[offset++] == 'n' && buffer[offset++] == 'e' && buffer[offset++] == 'd' ? CCTokenContext.UNSIGNED : null;
                            }
                        }
                        return null;
                    }
                }
                return null;
            }
            case 'v': {
                if (len <= 3) {
                    return null;
                }
                switch (buffer[offset++]) {
                    case 'i': {
                        return len == 7 && buffer[offset++] == 'r' && buffer[offset++] == 't' && buffer[offset++] == 'u' && buffer[offset++] == 'a' && buffer[offset++] == 'l' ? CCTokenContext.VIRTUAL : null;
                    }
                    case 'o': {
                        switch (buffer[offset++]) {
                            case 'i': {
                                return len == 4 && buffer[offset++] == 'd' ? CCTokenContext.VOID : null;
                            }
                            case 'l': {
                                return len == 8 && buffer[offset++] == 'a' && buffer[offset++] == 't' && buffer[offset++] == 'i' && buffer[offset++] == 'l' && buffer[offset++] == 'e' ? CCTokenContext.VOLATILE : null;
                            }
                        }
                        return null;
                    }
                }
                return null;
            }
            case 'w': {
                if (len <= 4) {
                    return null;
                }
                switch (buffer[offset++]) {
                    case 'c': {
                        return len == 7 && buffer[offset++] == 'h' && buffer[offset++] == 'a' && buffer[offset++] == 'r' && buffer[offset++] == '_' && buffer[offset++] == 't' ? CCTokenContext.WCHAR_T : null;
                    }
                    case 'h': {
                        return len == 5 && buffer[offset++] == 'i' && buffer[offset++] == 'l' && buffer[offset++] == 'e' ? CCTokenContext.WHILE : null;
                    }
                }
                return null;
            }
        }
        return null;
    }

    public static TokenID matchCPPKeyword(char[] buffer, int offset, int len) {
        if (buffer[offset] != '#') {
            return null;
        }
        ++offset;
        if (--len > 7) {
            return null;
        }
        if (len <= 1) {
            return null;
        }
        switch (buffer[offset++]) {
            case 'd': {
                return len == 6 && buffer[offset++] == 'e' && buffer[offset++] == 'f' && buffer[offset++] == 'i' && buffer[offset++] == 'n' && buffer[offset++] == 'e' ? CCTokenContext.CPPDEFINE : null;
            }
            case 'e': {
                if (len <= 3) {
                    return null;
                }
                switch (buffer[offset++]) {
                    case 'l': {
                        switch (buffer[offset++]) {
                            case 's': {
                                return len == 4 && buffer[offset++] == 'e' ? CCTokenContext.CPPELSE : null;
                            }
                            case 'i': {
                                return len == 4 && buffer[offset++] == 'f' ? CCTokenContext.CPPELIF : null;
                            }
                        }
                        return null;
                    }
                    case 'n': {
                        return len == 5 && buffer[offset++] == 'd' && buffer[offset++] == 'i' && buffer[offset++] == 'f' ? CCTokenContext.CPPENDIF : null;
                    }
                    case 'r': {
                        return len == 5 && buffer[offset++] == 'r' && buffer[offset++] == 'o' && buffer[offset++] == 'r' ? CCTokenContext.CPPERROR : null;
                    }
                }
                return null;
            }
            case 'i': {
                switch (buffer[offset++]) {
                    case 'f': {
                        if (len == 2) {
                            return CCTokenContext.CPPIF;
                        }
                        switch (buffer[offset++]) {
                            case 'd': {
                                return len == 5 && buffer[offset++] == 'e' && buffer[offset++] == 'f' ? CCTokenContext.CPPIFDEF : null;
                            }
                            case 'n': {
                                return len == 6 && buffer[offset++] == 'd' && buffer[offset++] == 'e' && buffer[offset++] == 'f' ? CCTokenContext.CPPIFNDEF : null;
                            }
                        }
                        return null;
                    }
                    case 'n': {
                        return len == 7 && buffer[offset++] == 'c' && buffer[offset++] == 'l' && buffer[offset++] == 'u' && buffer[offset++] == 'd' && buffer[offset++] == 'e' ? CCTokenContext.CPPINCLUDE : null;
                    }
                }
                return null;
            }
            case 'l': {
                if (len != 4) {
                    return null;
                }
                return buffer[offset++] == 'i' && buffer[offset++] == 'n' && buffer[offset++] == 'e' ? CCTokenContext.CPPLINE : null;
            }
            case 'p': {
                return len == 6 && buffer[offset++] == 'r' && buffer[offset++] == 'a' && buffer[offset++] == 'g' && buffer[offset++] == 'm' && buffer[offset++] == 'a' ? CCTokenContext.CPPPRAGMA : null;
            }
            case 'u': {
                if (len != 5) {
                    return null;
                }
                return buffer[offset++] == 'n' && buffer[offset++] == 'd' && buffer[offset++] == 'e' && buffer[offset++] == 'f' ? CCTokenContext.CPPUNDEF : null;
            }
            case 'w': {
                if (len != 7) {
                    return null;
                }
                return buffer[offset++] == 'a' && buffer[offset++] == 'r' && buffer[offset++] == 'n' && buffer[offset++] == 'i' && buffer[offset++] == 'n' && buffer[offset++] == 'g' ? CCTokenContext.CPPWARNING : null;
            }
        }
        return null;
    }
}

