/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cpp.editor.cplusplus;

import org.netbeans.editor.ImageTokenID;
import org.netbeans.editor.TokenContextPath;
import org.netbeans.editor.TokenID;
import org.netbeans.editor.TokenItem;
import org.netbeans.editor.ext.ExtFormatSupport;
import org.netbeans.editor.ext.FormatTokenPosition;
import org.netbeans.editor.ext.FormatWriter;
import org.netbeans.modules.cpp.editor.cplusplus.ABundle;
import org.netbeans.modules.cpp.editor.cplusplus.CCSettingsDefaults;
import org.netbeans.modules.cpp.editor.cplusplus.CCTokenContext;

public class CCFormatSupport
extends ExtFormatSupport {
    private TokenContextPath tokenContextPath;

    public CCFormatSupport(FormatWriter formatWriter) {
        this(formatWriter, CCTokenContext.contextPath);
    }

    public CCFormatSupport(FormatWriter formatWriter, TokenContextPath tokenContextPath) {
        super(formatWriter);
        this.tokenContextPath = tokenContextPath;
    }

    public TokenContextPath getTokenContextPath() {
        return this.tokenContextPath;
    }

    public boolean isComment(TokenItem token, int offset) {
        TokenID tokenID = token.getTokenID();
        return token.getTokenContextPath() == this.tokenContextPath && (tokenID == CCTokenContext.LINE_COMMENT || tokenID == CCTokenContext.BLOCK_COMMENT);
    }

    public boolean isPreprocessorAtLineStart(TokenItem token) {
        if (this.getSettingBoolean("cc-keep-preprocessor-at-line-start", CCSettingsDefaults.defaultFormatPreprocessorAtLineStart)) {
            return false;
        }
        return token != null && token.getImage().startsWith("#") && this.getVisualColumnOffset(this.getPosition(token, 0)) == 0;
    }

    public boolean isMultiLineComment(TokenItem token) {
        return token.getTokenID() == CCTokenContext.BLOCK_COMMENT;
    }

    public boolean isMultiLineComment(FormatTokenPosition pos) {
        TokenItem token = pos.getToken();
        return token == null ? false : this.isMultiLineComment(token);
    }

    public boolean isCCDocComment(TokenItem token) {
        return this.isMultiLineComment(token) && token.getImage().startsWith("/*");
    }

    public TokenID getWhitespaceTokenID() {
        return CCTokenContext.WHITESPACE;
    }

    public TokenContextPath getWhitespaceTokenContextPath() {
        return this.tokenContextPath;
    }

    public boolean canModifyWhitespace(TokenItem inToken) {
        if (inToken.getTokenContextPath() == CCTokenContext.contextPath) {
            switch (inToken.getTokenID().getNumericID()) {
                case 6: 
                case 9: {
                    return true;
                }
            }
        }
        return false;
    }

    public TokenItem findStatement(TokenItem token) {
        TokenItem lit = null;
        for (TokenItem t = this.getPreviousToken(token); t != null; t = t.getPrevious()) {
            if (t.getTokenContextPath() != this.tokenContextPath) continue;
            switch (t.getTokenID().getNumericID()) {
                case 53: {
                    if (this.isForLoopSemicolon(t)) break;
                    return lit != null ? lit : t;
                }
                case 52: 
                case 59: 
                case 60: 
                case 96: {
                    return lit != null ? lit : t;
                }
                case 88: 
                case 93: 
                case 95: 
                case 113: {
                    return t;
                }
                case 100: 
                case 102: 
                case 124: {
                    TokenItem mt;
                    if (lit != null && lit.getTokenID() == CCTokenContext.LPAREN && (mt = this.findMatchingToken(lit, token, (ImageTokenID)CCTokenContext.RPAREN, false)) != null && mt.getNext() != null && (mt = this.findImportantToken(mt.getNext(), token, false)) != null) {
                        return mt;
                    }
                    return t;
                }
            }
            if (this.isPreprocessorAtLineStart(t) || !this.isImportant(t, 0)) continue;
            lit = t;
        }
        return lit;
    }

    public TokenItem findIf(TokenItem elseToken) {
        if (elseToken == null || !this.tokenEquals(elseToken, (TokenID)CCTokenContext.ELSE, this.tokenContextPath)) {
            throw new IllegalArgumentException(ABundle.getText("MSG_AcceptOnlyElse"));
        }
        int braceDepth = 0;
        int elseDepth = 0;
        block7: while ((elseToken = this.findStatement(elseToken)) != null) {
            switch (elseToken.getTokenID().getNumericID()) {
                case 59: {
                    if (--braceDepth >= 0) break;
                    return null;
                }
                case 60: {
                    ++braceDepth;
                    break;
                }
                case 96: {
                    if (braceDepth != 0) break;
                    ++elseDepth;
                    break;
                }
                case 52: 
                case 53: 
                case 88: 
                case 93: 
                case 95: 
                case 100: 
                case 124: {
                    break;
                }
                case 102: {
                    if (braceDepth != 0 || elseDepth-- != 0) continue block7;
                    return elseToken;
                }
            }
        }
        return null;
    }

    public TokenItem findSwitch(TokenItem caseToken) {
        if (caseToken == null || !this.tokenEquals(caseToken, (TokenID)CCTokenContext.CASE, this.tokenContextPath) && !this.tokenEquals(caseToken, (TokenID)CCTokenContext.DEFAULT, this.tokenContextPath)) {
            throw new IllegalArgumentException(ABundle.getText("MSG_AcceptOlyCaseDefault"));
        }
        int braceDepth = 1;
        while ((caseToken = this.findStatement(caseToken)) != null) {
            switch (caseToken.getTokenID().getNumericID()) {
                case 59: {
                    if (--braceDepth >= 0) break;
                    return null;
                }
                case 60: {
                    ++braceDepth;
                    break;
                }
                case 93: 
                case 113: {
                    if (braceDepth != 0) break;
                    return caseToken;
                }
            }
        }
        return null;
    }

    public TokenItem findTry(TokenItem catchToken) {
        if (catchToken == null || !this.tokenEquals(catchToken, (TokenID)CCTokenContext.CATCH, this.tokenContextPath)) {
            throw new IllegalArgumentException(ABundle.getText("MSG_AcceptOnlyCatch"));
        }
        int braceDepth = 0;
        while ((catchToken = this.findStatement(catchToken)) != null) {
            switch (catchToken.getTokenID().getNumericID()) {
                case 59: {
                    if (--braceDepth >= 0) break;
                    return null;
                }
                case 60: {
                    ++braceDepth;
                    break;
                }
                case 117: {
                    if (braceDepth != 0) break;
                    return catchToken;
                }
            }
        }
        return null;
    }

    public TokenItem findStatementStart(TokenItem token) {
        TokenItem t = this.findStatement(token);
        if (t != null) {
            switch (t.getTokenID().getNumericID()) {
                case 53: {
                    TokenItem scss = this.findStatement(t);
                    switch (scss.getTokenID().getNumericID()) {
                        case 52: 
                        case 53: 
                        case 59: 
                        case 60: 
                        case 88: 
                        case 93: {
                            return t;
                        }
                        case 95: 
                        case 100: 
                        case 102: 
                        case 124: {
                            return this.findStatementStart(t);
                        }
                        case 96: {
                            TokenItem ifss = this.findIf(scss);
                            if (ifss != null) {
                                return this.findStatementStart(ifss);
                            }
                            return scss;
                        }
                    }
                    TokenItem bscss = this.findStatement(scss);
                    if (bscss != null) {
                        switch (bscss.getTokenID().getNumericID()) {
                            case 52: 
                            case 53: 
                            case 59: 
                            case 60: {
                                return scss;
                            }
                            case 95: 
                            case 100: 
                            case 102: 
                            case 124: {
                                return this.findStatementStart(bscss);
                            }
                            case 96: {
                                TokenItem ifss = this.findIf(bscss);
                                if (ifss != null) {
                                    return this.findStatementStart(ifss);
                                }
                                return bscss;
                            }
                        }
                    }
                    return scss;
                }
                case 59: {
                    return token;
                }
                case 60: {
                    TokenItem lbss;
                    TokenItem lb = this.findMatchingToken(t, null, (ImageTokenID)CCTokenContext.LBRACE, true);
                    if (lb != null && (lbss = this.findStatement(lb)) != null) {
                        switch (lbss.getTokenID().getNumericID()) {
                            case 96: {
                                TokenItem ifss = this.findIf(lbss);
                                if (ifss != null) {
                                    return this.findStatementStart(ifss);
                                }
                                return lbss;
                            }
                            case 89: {
                                TokenItem tryss = this.findTry(lbss);
                                if (tryss != null) {
                                    return this.findStatementStart(tryss);
                                }
                                return lbss;
                            }
                            case 95: 
                            case 100: 
                            case 102: 
                            case 124: {
                                return this.findStatementStart(lbss);
                            }
                        }
                    }
                    return t;
                }
                case 52: 
                case 88: 
                case 93: {
                    return token;
                }
                case 96: {
                    TokenItem ifss = this.findIf(t);
                    return ifss != null ? this.findStatementStart(ifss) : t;
                }
                case 95: 
                case 100: 
                case 102: 
                case 124: {
                    return this.findStatementStart(t);
                }
            }
        }
        return token;
    }

    public int getTokenIndent(TokenItem token, boolean forceFirstNonWhitespace) {
        FormatTokenPosition tp = this.getPosition(token, 0);
        FormatTokenPosition fnw = forceFirstNonWhitespace ? this.findLineFirstNonWhitespace(tp) : this.findLineFirstNonWhitespaceAndNonLeftBrace(tp);
        if (fnw != null) {
            tp = fnw;
        }
        return this.getVisualColumnOffset(tp);
    }

    public int getTokenIndent(TokenItem token) {
        return this.getTokenIndent(token, false);
    }

    public int findIndent(TokenItem token) {
        int indent = -1;
        if (token != null) {
            block0 : switch (token.getTokenID().getNumericID()) {
                case 96: {
                    TokenItem ifss = this.findIf(token);
                    if (ifss == null) break;
                    indent = this.getTokenIndent(ifss);
                    break;
                }
                case 59: {
                    TokenItem stmt = this.findStatement(token);
                    if (stmt == null) {
                        indent = 0;
                        break;
                    }
                    switch (stmt.getTokenID().getNumericID()) {
                        case 95: 
                        case 96: 
                        case 100: 
                        case 102: 
                        case 124: {
                            indent = this.getTokenIndent(stmt);
                            break block0;
                        }
                        case 59: {
                            indent = this.getTokenIndent(stmt) + this.getShiftWidth();
                            break block0;
                        }
                    }
                    stmt = this.findStatementStart(token);
                    if (stmt == null) {
                        indent = 0;
                        break;
                    }
                    if (stmt == token) {
                        stmt = this.findStatement(token);
                        indent = stmt != null ? (indent = this.getTokenIndent(stmt)) : 0;
                        break;
                    }
                    indent = this.getTokenIndent(stmt);
                    switch (stmt.getTokenID().getNumericID()) {
                        case 59: {
                            indent += this.getShiftWidth();
                        }
                    }
                    break;
                }
                case 60: {
                    TokenItem rbmt = this.findMatchingToken(token, null, (ImageTokenID)CCTokenContext.LBRACE, true);
                    if (rbmt != null) {
                        TokenItem t = this.findStatement(rbmt);
                        boolean forceFirstNonWhitespace = false;
                        if (t == null) {
                            t = rbmt;
                        } else {
                            switch (t.getTokenID().getNumericID()) {
                                case 53: 
                                case 59: 
                                case 60: {
                                    t = rbmt;
                                    forceFirstNonWhitespace = true;
                                }
                            }
                        }
                        indent = this.getTokenIndent(t, forceFirstNonWhitespace);
                        break;
                    }
                    indent = this.getTokenIndent(token);
                    break;
                }
                case 88: 
                case 93: {
                    TokenItem swss = this.findSwitch(token);
                    if (swss == null) break;
                    indent = this.getTokenIndent(swss) + this.getShiftWidth();
                }
            }
        }
        if (indent < 0) {
            TokenItem t = this.findImportantToken(token, null, true);
            while (t != null && this.getPosition(t, 0) != null && this.findLineFirstNonWhitespace(this.getPosition(t, 0)) != null && this.isPreprocessorAtLineStart(this.findLineFirstNonWhitespace(this.getPosition(t, 0)).getToken())) {
                t = this.findImportantToken(t, null, true);
            }
            if (t != null) {
                switch (t.getTokenID().getNumericID()) {
                    case 53: {
                        TokenItem tt = this.findStatementStart(token);
                        while (tt != null && (this.isPreprocessorAtLineStart(tt) || tt.getImage().startsWith("\n"))) {
                            tt = this.findStatementStart(tt.getPrevious());
                        }
                        indent = this.getTokenIndent(tt);
                        break;
                    }
                    case 59: {
                        TokenItem lbss = this.findStatementStart(t);
                        indent = this.getTokenIndent(t) + this.getShiftWidth();
                        break;
                    }
                    case 60: {
                        TokenItem t3 = this.findStatementStart(token);
                        indent = this.getTokenIndent(t3);
                        break;
                    }
                    case 56: {
                        TokenItem rpmt = this.findMatchingToken(t, null, (ImageTokenID)CCTokenContext.LPAREN, true);
                        if (rpmt == null || (rpmt = this.findImportantToken(rpmt, null, true)) == null || rpmt.getTokenContextPath() != this.tokenContextPath) break;
                        switch (rpmt.getTokenID().getNumericID()) {
                            case 100: 
                            case 102: 
                            case 124: {
                                indent = this.getTokenIndent(rpmt) + this.getShiftWidth();
                            }
                        }
                        break;
                    }
                    case 52: {
                        indent = this.getTokenIndent(t) + this.getShiftWidth();
                        break;
                    }
                    case 95: 
                    case 96: {
                        indent = this.getTokenIndent(t) + this.getShiftWidth();
                    }
                }
                if (indent < 0) {
                    indent = this.getTokenIndent(t);
                }
            }
        }
        if (indent < 0) {
            indent = 0;
        }
        return indent;
    }

    public FormatTokenPosition indentLine(FormatTokenPosition pos) {
        int indent = 0;
        FormatTokenPosition firstNWS = this.findLineFirstNonWhitespace(pos);
        if (firstNWS != null) {
            if (!this.isPreprocessorAtLineStart(firstNWS.getToken())) {
                if (this.isComment(firstNWS)) {
                    if (this.isMultiLineComment(firstNWS) && firstNWS.getOffset() != 0) {
                        indent = this.getLineIndent(this.getPosition(firstNWS.getToken(), 0), true) + 1;
                        if (!this.isIndentOnly() && this.getChar(firstNWS) != '*' && !this.isCCDocComment(firstNWS.getToken())) {
                            indent = this.getLineIndent(pos, true);
                        }
                    } else {
                        indent = !this.isMultiLineComment(firstNWS) ? this.findIndent(firstNWS.getToken()) : (this.isCCDocComment(firstNWS.getToken()) ? this.findIndent(firstNWS.getToken()) : this.getLineIndent(firstNWS, true));
                    }
                } else {
                    if (this.isIndentOnly()) {
                        FormatTokenPosition prevprevEol;
                        boolean skipIndent = false;
                        FormatTokenPosition eol = this.findLineEnd(pos);
                        FormatTokenPosition prevEol = this.findNonWhitespace(eol, null, true, true);
                        if (prevEol != null && prevEol.getToken() != null && (prevEol.getToken().getTokenID() == CCTokenContext.LBRACE || prevEol.getToken().getTokenID() == CCTokenContext.RBRACE) && (prevprevEol = this.findNonWhitespace(prevEol, null, true, true)) != null && prevprevEol.getToken() != null) {
                            skipIndent = true;
                        }
                        if (skipIndent) {
                            return firstNWS;
                        }
                    }
                    indent = this.findIndent(firstNWS.getToken());
                }
            }
        } else {
            TokenItem token = pos.getToken();
            if (token == null && (token = this.findLineStart(pos).getToken()) == null) {
                token = this.getLastToken();
            }
            indent = token != null && this.isMultiLineComment(token) ? this.getVisualColumnOffset(this.getPosition(token, 0)) : this.findIndent(pos.getToken());
        }
        return this.changeLineIndent(pos, indent);
    }

    public boolean isForLoopSemicolon(TokenItem token) {
        if (token == null || !this.tokenEquals(token, (TokenID)CCTokenContext.SEMICOLON, this.tokenContextPath)) {
            throw new IllegalArgumentException("Only accept ';'.");
        }
        int parDepth = 0;
        int braceDepth = 0;
        boolean semicolonFound = false;
        for (token = token.getPrevious(); token != null; token = token.getPrevious()) {
            if (this.tokenEquals(token, (TokenID)CCTokenContext.LPAREN, this.tokenContextPath)) {
                if (parDepth == 0) {
                    FormatTokenPosition tp = this.getPosition(token, 0);
                    return (tp = this.findImportant(tp, null, false, true)) != null && this.tokenEquals(tp.getToken(), (TokenID)CCTokenContext.FOR, this.tokenContextPath);
                }
                --parDepth;
                continue;
            }
            if (this.tokenEquals(token, (TokenID)CCTokenContext.RPAREN, this.tokenContextPath)) {
                ++parDepth;
                continue;
            }
            if (this.tokenEquals(token, (TokenID)CCTokenContext.LBRACE, this.tokenContextPath)) {
                if (braceDepth == 0) {
                    return false;
                }
                --braceDepth;
                continue;
            }
            if (this.tokenEquals(token, (TokenID)CCTokenContext.RBRACE, this.tokenContextPath)) {
                ++braceDepth;
                continue;
            }
            if (!this.tokenEquals(token, (TokenID)CCTokenContext.SEMICOLON, this.tokenContextPath)) continue;
            if (semicolonFound) {
                return false;
            }
            semicolonFound = true;
        }
        return false;
    }

    public boolean getFormatSpaceBeforeParenthesis() {
        return this.getSettingBoolean("cc-add-space-before-parenthesis", CCSettingsDefaults.defaultFormatSpaceBeforeParenthesis);
    }

    public boolean getFormatSpaceAfterComma() {
        return this.getSettingBoolean("cc-add-space-after-comma", CCSettingsDefaults.defaultFormatSpaceAfterComma);
    }

    public boolean getFormatNewlineBeforeBrace() {
        return this.getSettingBoolean("cc-add-newline-before-brace", CCSettingsDefaults.defaultFormatNewlineBeforeBrace);
    }

    public FormatTokenPosition findLineFirstNonWhitespaceAndNonLeftBrace(FormatTokenPosition pos) {
        FormatTokenPosition ftp = super.findLineFirstNonWhitespace(pos);
        if (ftp == null) {
            return null;
        }
        if (!ftp.getToken().getImage().startsWith("{")) {
            return ftp;
        }
        FormatTokenPosition eolp = this.findNextEOL(ftp);
        TokenItem rbmt = this.findMatchingToken(ftp.getToken(), eolp != null ? eolp.getToken() : null, (ImageTokenID)CCTokenContext.RBRACE, false);
        if (rbmt != null) {
            return ftp;
        }
        FormatTokenPosition ftp_next = this.getNextPosition(ftp);
        if (ftp_next == null) {
            return ftp;
        }
        FormatTokenPosition ftp2 = this.findImportant(ftp_next, null, true, false);
        if (ftp2 != null) {
            return ftp2;
        }
        return ftp;
    }
}

