/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cpp.builds;

import java.awt.Toolkit;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.util.Comparator;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.SortedMap;
import java.util.TreeMap;
import org.netbeans.modules.cpp.CppModule;
import org.openide.ErrorManager;
import org.openide.awt.StatusDisplayer;
import org.openide.cookies.EditorCookie;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileSystem;
import org.openide.filesystems.FileSystemCapability;
import org.openide.filesystems.FileUtil;
import org.openide.filesystems.Repository;
import org.openide.loaders.DataObject;
import org.openide.loaders.DataObjectNotFoundException;
import org.openide.text.Annotatable;
import org.openide.text.Annotation;
import org.openide.text.Line;
import org.openide.util.NbBundle;
import org.openide.util.WeakSet;
import org.openide.windows.OutputEvent;
import org.openide.windows.OutputListener;
import org.openide.windows.OutputWriter;

public class OutputWindowOutputStream
extends OutputStream {
    private OutputWriter writer;
    private StringBuffer buffer = new StringBuffer(1000);
    private boolean hadFirst = false;
    private HyperlinkFactory factory = new HyperlinkFactory();
    private static final Set hyperlinks = new WeakSet();
    static /* synthetic */ Class class$org$netbeans$modules$cpp$builds$OutputWindowOutputStream;
    static /* synthetic */ Class class$org$openide$cookies$EditorCookie;

    public OutputWindowOutputStream(OutputWriter writer) {
        this.writer = writer;
    }

    public void close() throws IOException {
        this.flush();
        this.writer.close();
    }

    public void flush() throws IOException {
        this.flushLines();
        if (this.buffer.length() > 0) {
            this.writer.print(this.buffer.toString());
            this.buffer.setLength(0);
        }
        this.writer.flush();
    }

    public void write(byte[] b) throws IOException {
        this.write(b, 0, b.length);
    }

    public void write(byte[] b, int offset, int length) throws IOException {
        this.buffer.append(new String(b, offset, length));
        this.flushLines();
    }

    public void write(int b) throws IOException {
        this.buffer.append((char)b);
        if ((char)b == '\n') {
            this.flushLines();
        }
    }

    private void flushLines() throws IOException {
        block0: while (true) {
            int len = this.buffer.length();
            for (int i = 0; i < len; ++i) {
                if (this.buffer.charAt(i) != '\n') continue;
                int end = i;
                if (end > 0 && this.buffer.charAt(end - 1) == '\r') {
                    --end;
                }
                this.flushLine(this.buffer.substring(0, end));
                this.buffer.delete(0, i + 1);
                continue block0;
            }
            break;
        }
    }

    private void flushLine(String l) throws IOException {
        Hyperlink link;
        if (!this.hadFirst) {
            this.hadFirst = true;
            if (l.trim().length() == 0) {
                return;
            }
        }
        if ((link = this.factory.create(l)) != null) {
            this.writer.println(link.getMessage(), (OutputListener)link);
        } else {
            this.writer.println(l);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void detachAllAnnotations() {
        Set set = hyperlinks;
        synchronized (set) {
            Iterator it = hyperlinks.iterator();
            while (it.hasNext()) {
                ((Hyperlink)it.next()).destroy();
            }
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    private static final class HyperlinkFactory
    implements Comparator {
        private Map fss0 = new HashMap();
        private SortedMap fss = new TreeMap(this);
        private static PrintWriter debugwriter = null;

        public HyperlinkFactory() {
            Repository repo = Repository.getDefault();
            Enumeration e = repo.getFileSystems();
            while (e.hasMoreElements()) {
                FileSystem fs = (FileSystem)e.nextElement();
                FileObject root = fs.getRoot();
                File path = FileUtil.toFile((FileObject)root);
                if (path == null) continue;
                String prefix = path.getAbsolutePath();
                if (!prefix.endsWith(File.separator)) {
                    prefix = prefix + File.separator;
                }
                if (path == null) continue;
                this.fss0.put(prefix, fs);
                this.fss.put(prefix, fs);
            }
            this.fss0 = null;
        }

        public Hyperlink create(String line) {
            Iterator it = this.fss.entrySet().iterator();
            while (it.hasNext()) {
                String message;
                int colon1;
                Map.Entry entry = it.next();
                String prefix = (String)entry.getKey();
                if (!line.startsWith(prefix) && !line.replace('/', File.separatorChar).startsWith(prefix) || (colon1 = line.indexOf(58, prefix.length())) == -1) continue;
                String filename = line.substring(prefix.length(), colon1).replace(File.separatorChar, '/');
                FileSystem fs = (FileSystem)entry.getValue();
                FileObject fo = fs.findResource(filename);
                if (fo == null) continue;
                int line1 = -1;
                int col1 = -1;
                int line2 = -1;
                int col2 = -1;
                int start = colon1 + 1;
                int colon2 = line.indexOf(58, colon1 + 1);
                if (colon2 != -1) {
                    try {
                        line1 = Integer.parseInt(line.substring(colon1 + 1, colon2).trim()) - 1;
                        start = colon2 + 1;
                        int colon3 = line.indexOf(58, colon2 + 1);
                        if (colon3 != -1) {
                            col1 = Integer.parseInt(line.substring(colon2 + 1, colon3).trim()) - 1;
                            start = colon3 + 1;
                            int colon4 = line.indexOf(58, colon3 + 1);
                            if (colon4 != -1) {
                                line2 = Integer.parseInt(line.substring(colon3 + 1, colon4).trim()) - 1;
                                start = colon4 + 1;
                                int colon5 = line.indexOf(58, colon4 + 1);
                                if (colon5 != -1) {
                                    col2 = Integer.parseInt(line.substring(colon4 + 1, colon5).trim()) - 1;
                                    start = colon5 + 1;
                                }
                            }
                        }
                    }
                    catch (NumberFormatException nfe) {
                        // empty catch block
                    }
                }
                if ((message = line.substring(start).trim()).length() == 0) {
                    message = null;
                }
                Hyperlink h = new Hyperlink(fo, line1, col1, line2, col2, message);
                return h;
            }
            return null;
        }

        private static void debug(String s) {
            if (debugwriter == null) {
                try {
                    debugwriter = new PrintWriter(new FileWriter("/dev/tty"));
                }
                catch (IOException ioe) {
                    ErrorManager.getDefault().notify((Throwable)ioe);
                    return;
                }
            }
            debugwriter.println("[owos]: " + s);
            debugwriter.flush();
        }

        public int compare(Object o1, Object o2) {
            FileSystem f1 = (FileSystem)this.fss0.get(o1);
            FileSystem f2 = (FileSystem)this.fss0.get(o2);
            boolean c1 = f1.getCapability().capableOf(FileSystemCapability.COMPILE);
            boolean c2 = f2.getCapability().capableOf(FileSystemCapability.COMPILE);
            if (c1 && !c2) {
                return -1;
            }
            if (!c1 && c2) {
                return 1;
            }
            String p1 = (String)o1;
            String p2 = (String)o2;
            int comp = p2.length() - p1.length();
            if (comp != 0) {
                return comp;
            }
            return System.identityHashCode(f1) - System.identityHashCode(f2);
        }
    }

    private static final class Hyperlink
    extends Annotation
    implements OutputListener,
    PropertyChangeListener {
        private FileObject file;
        private int line1;
        private int col1;
        private int line2;
        private int col2;
        private String message;
        private boolean dead = false;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        Hyperlink(FileObject file, int line1, int col1, int line2, int col2, String message) {
            this.file = file;
            this.line1 = line1;
            this.col1 = col1;
            this.line2 = line2;
            this.col2 = col2;
            this.message = message;
            Set set = hyperlinks;
            synchronized (set) {
                hyperlinks.add(this);
            }
        }

        void destroy() {
            this.doDetach();
            this.dead = true;
        }

        public String getMessage() {
            String m;
            String fname = this.file.getPath();
            String string = this.message != null ? this.message : (m = NbBundle.getMessage((Class)(class$org$netbeans$modules$cpp$builds$OutputWindowOutputStream == null ? (class$org$netbeans$modules$cpp$builds$OutputWindowOutputStream = OutputWindowOutputStream.class$("org.netbeans.modules.cpp.builds.OutputWindowOutputStream")) : class$org$netbeans$modules$cpp$builds$OutputWindowOutputStream), (String)"ERR_unknown"));
            if (this.line1 == -1) {
                return NbBundle.getMessage((Class)(class$org$netbeans$modules$cpp$builds$OutputWindowOutputStream == null ? (class$org$netbeans$modules$cpp$builds$OutputWindowOutputStream = OutputWindowOutputStream.class$("org.netbeans.modules.cpp.builds.OutputWindowOutputStream")) : class$org$netbeans$modules$cpp$builds$OutputWindowOutputStream), (String)"MSG_err", (Object)fname, (Object)m);
            }
            if (this.col1 == -1) {
                return NbBundle.getMessage((Class)(class$org$netbeans$modules$cpp$builds$OutputWindowOutputStream == null ? (class$org$netbeans$modules$cpp$builds$OutputWindowOutputStream = OutputWindowOutputStream.class$("org.netbeans.modules.cpp.builds.OutputWindowOutputStream")) : class$org$netbeans$modules$cpp$builds$OutputWindowOutputStream), (String)"MSG_err_line", (Object)fname, (Object)m, (Object)new Integer(this.line1 + 1));
            }
            if (this.line2 == -1 || this.col2 == -1 || this.line1 == this.line2 && this.col1 == this.col2) {
                return NbBundle.getMessage((Class)(class$org$netbeans$modules$cpp$builds$OutputWindowOutputStream == null ? (class$org$netbeans$modules$cpp$builds$OutputWindowOutputStream = OutputWindowOutputStream.class$("org.netbeans.modules.cpp.builds.OutputWindowOutputStream")) : class$org$netbeans$modules$cpp$builds$OutputWindowOutputStream), (String)"MSG_err_line_col", (Object[])new Object[]{fname, m, new Integer(this.line1 + 1), new Integer(this.col1 + 1)});
            }
            if (this.line1 == this.line2) {
                return NbBundle.getMessage((Class)(class$org$netbeans$modules$cpp$builds$OutputWindowOutputStream == null ? (class$org$netbeans$modules$cpp$builds$OutputWindowOutputStream = OutputWindowOutputStream.class$("org.netbeans.modules.cpp.builds.OutputWindowOutputStream")) : class$org$netbeans$modules$cpp$builds$OutputWindowOutputStream), (String)"MSG_err_line_col_col", (Object[])new Object[]{fname, m, new Integer(this.line1 + 1), new Integer(this.col1 + 1), new Integer(this.col2 + 1)});
            }
            return NbBundle.getMessage((Class)(class$org$netbeans$modules$cpp$builds$OutputWindowOutputStream == null ? (class$org$netbeans$modules$cpp$builds$OutputWindowOutputStream = OutputWindowOutputStream.class$("org.netbeans.modules.cpp.builds.OutputWindowOutputStream")) : class$org$netbeans$modules$cpp$builds$OutputWindowOutputStream), (String)"MSG_err_line_col_line_col", (Object[])new Object[]{fname, m, new Integer(this.line1 + 1), new Integer(this.col1 + 1), new Integer(this.line2 + 1), new Integer(this.col2 + 1)});
        }

        public void outputLineAction(OutputEvent ev) {
            System.err.println("outputLineAction: " + ev.getLine());
            if (this.dead) {
                return;
            }
            if (!this.file.isValid()) {
                Toolkit.getDefaultToolkit().beep();
                return;
            }
            if (this.message != null) {
                StatusDisplayer.getDefault().setStatusText(this.message);
            }
            try {
                DataObject dob = DataObject.find((FileObject)this.file);
                EditorCookie ed = (EditorCookie)dob.getCookie(class$org$openide$cookies$EditorCookie == null ? (class$org$openide$cookies$EditorCookie = OutputWindowOutputStream.class$("org.openide.cookies.EditorCookie")) : class$org$openide$cookies$EditorCookie);
                if (ed != null) {
                    if (this.line1 == -1) {
                        ed.open();
                    } else {
                        ed.openDocument();
                        CppModule.err.log("opened document for " + this.file);
                        Line l = ed.getLineSet().getOriginal(this.line1);
                        if (!l.isDeleted()) {
                            this.attachAsNeeded(l, ed);
                            if (this.col1 == -1) {
                                l.show(2);
                            } else {
                                l.show(2, this.col1);
                            }
                        }
                    }
                } else {
                    Toolkit.getDefaultToolkit().beep();
                }
            }
            catch (DataObjectNotFoundException donfe) {
                ErrorManager.getDefault().notify(16, (Throwable)donfe);
            }
            catch (IndexOutOfBoundsException iobe) {
                ErrorManager.getDefault().notify(16, (Throwable)iobe);
            }
            catch (IOException ioe) {
                ErrorManager.getDefault().notify(16, (Throwable)ioe);
            }
        }

        public void outputLineSelected(OutputEvent ev) {
            System.err.println("outputLineSelected: " + ev.getLine());
            if (this.dead) {
                return;
            }
            if (!this.file.isValid()) {
                return;
            }
            try {
                DataObject dob = DataObject.find((FileObject)this.file);
                EditorCookie ed = (EditorCookie)dob.getCookie(class$org$openide$cookies$EditorCookie == null ? (class$org$openide$cookies$EditorCookie = OutputWindowOutputStream.class$("org.openide.cookies.EditorCookie")) : class$org$openide$cookies$EditorCookie);
                if (ed != null) {
                    Line l;
                    if (ed.getDocument() == null) {
                        CppModule.err.log("no document for " + this.file);
                        return;
                    }
                    CppModule.err.log("got document for " + this.file);
                    if (this.line1 != -1 && !(l = ed.getLineSet().getOriginal(this.line1)).isDeleted()) {
                        this.attachAsNeeded(l, ed);
                        if (this.col1 == -1) {
                            l.show(0);
                        } else {
                            l.show(0, this.col1);
                        }
                    }
                }
            }
            catch (DataObjectNotFoundException donfe) {
                ErrorManager.getDefault().notify(16, (Throwable)donfe);
            }
            catch (IndexOutOfBoundsException iobe) {
                ErrorManager.getDefault().notify(16, (Throwable)iobe);
            }
        }

        private synchronized void attachAsNeeded(Line l, EditorCookie ed) {
            if (this.getAttachedAnnotatable() == null) {
                Line ann;
                boolean log = CppModule.err.isLoggable(0);
                String text = l.getText();
                System.err.println("attachAsNeeded: " + text);
                if (log) {
                    CppModule.err.log("Attaching to line " + l.getDisplayName() + " text=`" + text + "' line1=" + this.line1 + " line2=" + this.line2 + " col1=" + this.col1 + " col2=" + this.col2);
                }
                if (text != null && (this.line2 == -1 || this.line1 == this.line2) && this.col1 != -1) {
                    if (log) {
                        CppModule.err.log("\tfits on one line");
                    }
                    if (this.col2 != -1 && this.col2 >= this.col1 && this.col2 < text.length()) {
                        if (log) {
                            CppModule.err.log("\tspecified section of the line");
                        }
                        ann = l.createPart(this.col1, this.col2 - this.col1 + 1);
                    } else if (this.col1 < text.length()) {
                        if (log) {
                            CppModule.err.log("\tspecified column to end of line");
                        }
                        ann = l.createPart(this.col1, text.length() - this.col1);
                    } else {
                        if (log) {
                            CppModule.err.log("\tcolumn numbers are bogus");
                        }
                        ann = l;
                    }
                } else {
                    if (log) {
                        CppModule.err.log("\tmultiple lines, something wrong with line, or no column given");
                    }
                    ann = l;
                }
                this.attach((Annotatable)ann);
                ann.addPropertyChangeListener((PropertyChangeListener)this);
            }
        }

        private synchronized void doDetach() {
            Annotatable ann = this.getAttachedAnnotatable();
            if (ann != null) {
                if (CppModule.err.isLoggable(0)) {
                    CppModule.err.log("Detaching from " + ann + " `" + ann.getText() + "'");
                }
                ann.removePropertyChangeListener((PropertyChangeListener)this);
                this.detach();
            }
        }

        public void outputLineCleared(OutputEvent ev) {
            this.doDetach();
        }

        public void propertyChange(PropertyChangeEvent ev) {
            if (this.dead) {
                return;
            }
            String prop = ev.getPropertyName();
            if (prop == null || prop.equals("text") || prop.equals("deleted")) {
                if (CppModule.err.isLoggable(0)) {
                    CppModule.err.log("Received Annotatable property change: " + prop);
                }
                this.doDetach();
            }
        }

        public String getAnnotationType() {
            return "org-apache-tools-ant-module-error";
        }

        public String getShortDescription() {
            return this.message;
        }

        public String toString() {
            return "Hyperlink[" + this.file + ":" + this.line1 + ":" + this.col1 + ":" + this.line2 + ":" + this.col2 + "]";
        }
    }
}

