/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cpp.builds;

import java.awt.Component;
import java.beans.PropertyEditor;
import java.beans.PropertyEditorSupport;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.lang.reflect.InvocationTargetException;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.ResourceBundle;
import java.util.StringTokenizer;
import java.util.Vector;
import org.apache.regexp.RE;
import org.apache.regexp.RECompiler;
import org.apache.regexp.REProgram;
import org.apache.regexp.RESyntaxException;
import org.netbeans.modules.cpp.builds.BuildCustomizer;
import org.netbeans.modules.cpp.builds.BuildEvent;
import org.netbeans.modules.cpp.builds.BuildListener;
import org.netbeans.modules.cpp.builds.ErrorExpression;
import org.netbeans.modules.cpp.builds.MakeExecutor;
import org.netbeans.modules.cpp.builds.MakeLogger;
import org.netbeans.modules.cpp.builds.TargetEditor;
import org.netbeans.modules.cpp.makepicklist.MakePicklist;
import org.netbeans.modules.cpp.makepicklist.MakePicklistElement;
import org.netbeans.modules.cpp.settings.MakeSettings;
import org.netbeans.modules.cpp.utils.CppUtils;
import org.openide.DialogDisplayer;
import org.openide.ErrorManager;
import org.openide.NotifyDescriptor;
import org.openide.ServiceType;
import org.openide.compiler.ExternalCompiler;
import org.openide.execution.Executor;
import org.openide.execution.NbProcessDescriptor;
import org.openide.filesystems.FileObject;
import org.openide.loaders.DataObject;
import org.openide.loaders.Environment;
import org.openide.loaders.ExecutionSupport;
import org.openide.loaders.MultiDataObject;
import org.openide.modules.InstalledFileLocator;
import org.openide.nodes.Node;
import org.openide.nodes.PropertySupport;
import org.openide.nodes.Sheet;
import org.openide.util.Lookup;
import org.openide.util.NbBundle;
import org.openide.util.Utilities;
import org.openide.windows.InputOutput;

public class MakeExecSupport
extends ExecutionSupport {
    private Sheet.Set sheetSet;
    public static final String PROP_BUILD_DIRECTORY = "buildDirectory";
    public static final String PROP_EXECUTION = "execution";
    public static final String PROP_MAKE_COMMAND = "makeCommand";
    public static final String PROP_MAKE_OPTIONS = "makeOptions";
    public static final String PROP_MAKE_TARGETS = "makeTargets";
    private PropertySupport buildDirectoryProperty = null;
    private PropertySupport executorProperty = null;
    private PropertySupport makeCommandProperty = null;
    private PropertySupport makeOptionsProperty = null;
    private PropertySupport makeTargetsProperty = null;
    private File buildDir;
    private ArrayList listeners = new ArrayList(5);
    private int rc;
    private static BuildCustomizer customizer;
    private static ResourceBundle bundle;
    BuildProcessThread makeThread = null;
    Process makeProc = null;
    static /* synthetic */ Class class$org$netbeans$modules$cpp$builds$MakeExecSupport;
    static /* synthetic */ Class class$java$lang$String;
    static /* synthetic */ Class class$org$openide$execution$Executor;
    static /* synthetic */ Class class$org$netbeans$modules$cpp$builds$MakeExecutor;

    public MakeExecSupport(MultiDataObject.Entry entry) {
        super(entry);
    }

    public FileObject getFileObject() {
        return this.getEntry().getFile();
    }

    public static BuildCustomizer getBuildCustomizer() {
        return customizer;
    }

    public static void setBuildCustomizer(BuildCustomizer bc) {
        if (bc == null) {
            if (customizer != null) {
                customizer.removeBuildProperties();
            }
        } else {
            bc.updateBuildProperties();
        }
        customizer = bc;
    }

    public int executeMake(MakeLogger logger, InputOutput io, StringBuffer targetList) throws IOException, InterruptedException {
        String commandLine;
        String commandInterpreter;
        boolean override;
        String[] envp;
        MakePicklist.getInstance().addElement(new MakePicklistElement(CppUtils.getPath(this.getEntry().getFile()), targetList.toString(), this.getBuildDirectory(), this.getMakeCommand(), this.getMakeOptions()));
        MakePicklist.getInstance().savePicklist();
        if (customizer == null) {
            envp = null;
            override = false;
        } else {
            envp = customizer.getBuildEnvironment(this.getFileObject());
            override = customizer.isOverrideEnv();
        }
        String bdir = this.getBuildDirectory();
        this.buildDir = bdir.length() == 0 || bdir.equals(".") ? new File(CppUtils.getPath(this.getEntry().getFile().getParent())) : (bdir.charAt(0) == '/' ? new File(bdir) : new File(CppUtils.getPath(this.getEntry().getFile().getParent()), bdir));
        if (!this.buildDir.exists() || !this.buildDir.isDirectory()) {
            String msg = MessageFormat.format(this.getString("NOT_A_VALID_BUILD_DIRECTORY"), this.buildDir.getPath());
            NotifyDescriptor.Message notifyDescriptor = new NotifyDescriptor.Message((Object)msg, 0);
            DialogDisplayer.getDefault().notify((NotifyDescriptor)notifyDescriptor);
            return -1;
        }
        String line = " -f \"" + CppUtils.getPath(this.getEntry().getFile()) + "\"" + " " + this.getMakeOptions(true) + " " + targetList;
        if (Utilities.isUnix()) {
            File domake = InstalledFileLocator.getDefault().locate("bin/domake.sh", null, false);
            commandInterpreter = domake != null ? domake.getPath() : this.getMakeCommand();
            commandLine = this.getMakeCommand() + line;
        } else {
            commandInterpreter = this.getMakeCommand();
            commandLine = line;
        }
        NbProcessDescriptor desc = new NbProcessDescriptor(commandInterpreter, commandLine, NbBundle.getMessage((Class)(class$org$netbeans$modules$cpp$builds$MakeExecSupport == null ? (class$org$netbeans$modules$cpp$builds$MakeExecSupport = MakeExecSupport.class$("org.netbeans.modules.cpp.builds.MakeExecSupport")) : class$org$netbeans$modules$cpp$builds$MakeExecSupport), (String)"HINT_MakeProcessDescriptor"));
        BuildEvent ev = new BuildEvent((Object)this);
        ev.setMessage(this.getMakeCommand() + line);
        logger.messageLogged(ev);
        this.makeProc = desc.exec(null, envp, override, this.buildDir);
        this.makeThread = new BuildProcessThread(this.makeProc.getErrorStream());
        System.out.println("makeThread 1 " + this.makeThread);
        this.makeThread.start();
        int rc = this.makeProc.waitFor();
        this.makeThread.join();
        return rc;
    }

    public void start() {
        System.err.println("MES.start");
        super.start();
    }

    public void destroy() {
        if (this.makeProc != null) {
            this.makeProc.destroy();
        }
    }

    public void createProperties() {
        if (this.buildDirectoryProperty == null) {
            this.buildDirectoryProperty = this.createBuildDirectoryProperty();
            this.executorProperty = this.createExecutorProperty();
            this.makeCommandProperty = this.createMakeCommandProperty();
            this.makeOptionsProperty = this.createMakeOptionsProperty();
            this.makeTargetsProperty = this.createMakeTargetsProperty();
        }
    }

    public void addProperties(Sheet.Set set) {
        this.createProperties();
        this.sheetSet = set;
        set.put((Node.Property)this.buildDirectoryProperty);
        set.put((Node.Property)this.makeCommandProperty);
        set.put((Node.Property)this.makeOptionsProperty);
        set.put((Node.Property)this.makeTargetsProperty);
        if (customizer != null) {
            customizer.addBuildProperties(this.getFileObject(), set);
        }
    }

    private PropertySupport createBuildDirectoryProperty() {
        return new PropertySupport.ReadWrite(PROP_BUILD_DIRECTORY, class$java$lang$String == null ? (class$java$lang$String = MakeExecSupport.class$("java.lang.String")) : class$java$lang$String, this.getString("PROP_BUILD_DIRECTORY"), this.getString("HINT_BUILD_DIRECTORY")){

            public Object getValue() {
                return MakeExecSupport.this.getBuildDirectory();
            }

            public void setValue(Object val) {
                MakeExecSupport.this.setBuildDirectory((String)val);
            }

            public boolean supportsDefaultValue() {
                return true;
            }

            public void restoreDefaultValue() {
                this.setValue(null);
            }

            public boolean canWrite() {
                return !MakeExecSupport.this.getEntry().getFile().getParent().isReadOnly();
            }
        };
    }

    public String getBuildDirectory() {
        String dir = (String)this.getEntry().getFile().getAttribute(PROP_BUILD_DIRECTORY);
        if (dir == null) {
            dir = MakeSettings.getDefault().getDefaultBuildDirectory();
            this.setBuildDirectory(dir);
        }
        return dir;
    }

    public void setBuildDirectory(String dir) {
        block2: {
            try {
                this.getEntry().getFile().setAttribute(PROP_BUILD_DIRECTORY, (Object)dir);
            }
            catch (IOException ex) {
                String msg = MessageFormat.format(this.getString("MSG_CANT_SET_BUILD_DIRECTORY"), CppUtils.getPath(this.getEntry().getFile()));
                if (!Boolean.getBoolean("netbeans.debug.exceptions")) break block2;
                ex.printStackTrace();
            }
        }
    }

    private PropertySupport createExecutorProperty() {
        return new PropertySupport.ReadWrite(PROP_EXECUTION, class$org$openide$execution$Executor == null ? (class$org$openide$execution$Executor = MakeExecSupport.class$("org.openide.execution.Executor")) : class$org$openide$execution$Executor, this.getString("PROP_EXECUTION"), this.getString("HINT_EXECUTION")){

            public Object getValue() {
                Executor e = MakeExecSupport.getExecutor(MakeExecSupport.this.getEntry());
                if (e == null) {
                    return MakeExecSupport.this.defaultExecutor();
                }
                return e;
            }

            public void setValue(Object val) throws InvocationTargetException {
                try {
                    MakeExecSupport.setExecutor(MakeExecSupport.this.getEntry(), (Executor)val);
                }
                catch (IOException ex) {
                    throw new InvocationTargetException(ex);
                }
            }

            public boolean supportsDefaultValue() {
                return true;
            }

            public void restoreDefaultValue() throws InvocationTargetException {
                this.setValue(null);
            }

            public boolean canWrite() {
                return !MakeExecSupport.this.getEntry().getFile().getParent().isReadOnly();
            }
        };
    }

    protected Executor defaultExecutor() {
        return MakeSettings.getDefault().getExecutor();
    }

    public static Executor getExecutor(MultiDataObject.Entry entry) {
        ServiceType exec;
        Object handle = entry.getFile().getAttribute(PROP_EXECUTION);
        if (handle != null && handle instanceof ServiceType.Handle && (exec = ((ServiceType.Handle)handle).getServiceType()) instanceof MakeExecutor) {
            return (Executor)exec;
        }
        Lookup l = Environment.find((DataObject)entry.getDataObject());
        return (Executor)l.lookup(class$org$netbeans$modules$cpp$builds$MakeExecutor == null ? (class$org$netbeans$modules$cpp$builds$MakeExecutor = MakeExecSupport.class$("org.netbeans.modules.cpp.builds.MakeExecutor")) : class$org$netbeans$modules$cpp$builds$MakeExecutor);
    }

    public static void setExecutor(MultiDataObject.Entry entry, Executor exec) throws IOException {
        entry.getFile().setAttribute(PROP_EXECUTION, (Object)(exec == null ? null : new ServiceType.Handle((ServiceType)exec)));
    }

    private PropertySupport createMakeCommandProperty() {
        return new PropertySupport.ReadWrite(PROP_MAKE_COMMAND, class$java$lang$String == null ? (class$java$lang$String = MakeExecSupport.class$("java.lang.String")) : class$java$lang$String, this.getString("PROP_MAKE_COMMAND"), this.getString("HINT_MAKE_COMMAND")){

            public Object getValue() {
                return MakeExecSupport.this.getMakeCommand();
            }

            public void setValue(Object val) {
                MakeExecSupport.this.setMakeCommand((String)val);
            }

            public boolean supportsDefaultValue() {
                return true;
            }

            public void restoreDefaultValue() {
                this.setValue(null);
            }

            public boolean canWrite() {
                return !MakeExecSupport.this.getEntry().getFile().getParent().isReadOnly();
            }
        };
    }

    public String getMakeCommand() {
        String make = (String)this.getEntry().getFile().getAttribute(PROP_MAKE_COMMAND);
        if (make == null || make.equals("")) {
            make = MakeSettings.getDefault().getDefaultMakeCommand();
            this.setMakeCommand(make);
        }
        return make;
    }

    public void setMakeCommand(String make) {
        block2: {
            try {
                this.getEntry().getFile().setAttribute(PROP_MAKE_COMMAND, (Object)make);
            }
            catch (IOException ex) {
                String msg = MessageFormat.format(this.getString("MSG_CANT_SET_MAKE_COMMAND"), CppUtils.getPath(this.getEntry().getFile()));
                if (!Boolean.getBoolean("netbeans.debug.exceptions")) break block2;
                ex.printStackTrace();
            }
        }
    }

    private PropertySupport createMakeOptionsProperty() {
        return new PropertySupport.ReadWrite(PROP_MAKE_OPTIONS, class$java$lang$String == null ? (class$java$lang$String = MakeExecSupport.class$("java.lang.String")) : class$java$lang$String, this.getString("PROP_MAKE_OPTIONS"), this.getString("HINT_MAKE_OPTIONS")){

            public Object getValue() {
                return MakeExecSupport.this.getMakeOptions(false);
            }

            public void setValue(Object val) {
                MakeExecSupport.this.setMakeOptions((String)val);
            }

            public boolean supportsDefaultValue() {
                return true;
            }

            public void restoreDefaultValue() {
                this.setValue(null);
            }

            public boolean canWrite() {
                return !MakeExecSupport.this.getEntry().getFile().getParent().isReadOnly();
            }
        };
    }

    public String getMakeOptions() {
        return this.getMakeOptions(false);
    }

    public String getMakeOptions(boolean useCustomizer) {
        StringBuffer options = new StringBuffer(256);
        String savedOptions = (String)this.getEntry().getFile().getAttribute(PROP_MAKE_OPTIONS);
        if (savedOptions == null) {
            savedOptions = "";
            this.setMakeOptions(savedOptions);
        }
        if (useCustomizer && customizer != null) {
            options.append(customizer.getCustomBuildOptions(this.getFileObject()));
            options.append(' ');
        }
        options.append(savedOptions);
        return options.toString();
    }

    public void setMakeOptions(String options) {
        block2: {
            try {
                this.getEntry().getFile().setAttribute(PROP_MAKE_OPTIONS, (Object)options);
            }
            catch (IOException ex) {
                String msg = MessageFormat.format(this.getString("MSG_CANT_SET_MAKE_OPTIONS"), CppUtils.getPath(this.getEntry().getFile()));
                if (!Boolean.getBoolean("netbeans.debug.exceptions")) break block2;
                ex.printStackTrace();
            }
        }
    }

    private PropertySupport createMakeTargetsProperty() {
        return new PropertySupport.ReadWrite(PROP_MAKE_TARGETS, class$java$lang$String == null ? (class$java$lang$String = MakeExecSupport.class$("java.lang.String")) : class$java$lang$String, this.getString("PROP_MAKE_TARGETS"), this.getString("HINT_MAKE_TARGETS")){

            public Object getValue() {
                return MakeExecSupport.this.getMakeTargets();
            }

            public void setValue(Object val) {
                MakeExecSupport.this.setMakeTargets((String)val);
            }

            public boolean supportsDefaultValue() {
                return false;
            }

            public void restoreDefaultValue() {
                this.setValue(null);
            }

            public boolean canWrite() {
                return !MakeExecSupport.this.getEntry().getFile().getParent().isReadOnly();
            }

            public PropertyEditor getPropertyEditor() {
                return new TargetsPropertyEditor((PropertySupport)this);
            }
        };
    }

    public String getMakeTargets() {
        String target = (String)this.getEntry().getFile().getAttribute(PROP_MAKE_TARGETS);
        if (target == null) {
            target = "";
            this.setMakeTargets(target);
        }
        return target;
    }

    private String[] tokenizeTargets(String targets) {
        StringTokenizer st = new StringTokenizer(targets, ";:,");
        Vector<String> v = new Vector<String>();
        while (st.hasMoreTokens()) {
            int n = 0;
            String t = st.nextToken();
            while (n < t.length() && Character.isWhitespace(t.charAt(n)) && ++n < t.length()) {
            }
            if (n >= t.length()) continue;
            if (n > 0) {
                v.add(t.substring(n));
                continue;
            }
            v.add(t);
        }
        String[] ret = new String[v.size()];
        for (int i = 0; i < v.size(); ++i) {
            ret[i] = (String)v.elementAt(i);
        }
        return ret;
    }

    public String[] getMakeTargetsArray() {
        return this.tokenizeTargets(this.getMakeTargets());
    }

    public void setMakeTargets(String targetlist) {
        block3: {
            try {
                this.getEntry().getFile().setAttribute(PROP_MAKE_TARGETS, (Object)targetlist);
                if (this.sheetSet != null) {
                    this.sheetSet.remove(PROP_MAKE_TARGETS);
                    this.sheetSet.put((Node.Property)this.makeTargetsProperty);
                }
            }
            catch (IOException ex) {
                String msg = MessageFormat.format(this.getString("MSG_CANT_SET_MAKE_TARGETS"), CppUtils.getPath(this.getEntry().getFile()));
                if (!Boolean.getBoolean("netbeans.debug.exceptions")) break block3;
                ex.printStackTrace();
            }
        }
    }

    public void addMakeTargets(String newtargets) {
        String targets = (String)this.getEntry().getFile().getAttribute(PROP_MAKE_TARGETS);
        if (newtargets == null || newtargets.length() == 0) {
            return;
        }
        if (targets == null) {
            targets = "";
        }
        targets = targets.length() == 0 ? newtargets : targets + ", " + newtargets;
        this.setMakeTargets(targets);
    }

    public void addBuildListener(BuildListener l) {
        this.listeners.add(l);
    }

    public void removeBuildListener(BuildListener l) {
        this.listeners.remove(this.listeners.indexOf(l));
    }

    public void fireBuildStarted() {
        for (int i = 0; i < this.listeners.size(); ++i) {
            BuildListener listener = (BuildListener)this.listeners.get(i);
            listener.buildStarted(null);
        }
    }

    public void fireBuildFinished(BuildEvent ev) {
        for (int i = 0; i < this.listeners.size(); ++i) {
            BuildListener listener = (BuildListener)this.listeners.get(i);
            listener.buildFinished(ev);
        }
    }

    public void fireBuildEvent(String msg) {
        BuildEvent event = new BuildEvent((Object)this);
        event.setMessage(msg);
        for (int i = 0; i < this.listeners.size(); ++i) {
            BuildListener listener = (BuildListener)this.listeners.get(i);
            listener.messageLogged(event);
        }
    }

    public String filterEvent(String line) {
        ErrorExpression err = MakeSettings.getDefault().getErrorExpression();
        RE errorPattern = MakeExecSupport.getErrorPattern(err);
        boolean idx = false;
        if (err.getFilePos() < 0) {
            return line;
        }
        if (errorPattern.match(line)) {
            String sg;
            int column;
            int lnum;
            int lowerBound = 0;
            int upperBound = errorPattern.getParenCount() - 1;
            String file = errorPattern.getParen(err.getFilePos());
            String path = file.charAt(0) == File.separatorChar ? new File(file).getAbsolutePath() : new File(this.buildDir, file).getAbsolutePath();
            if (err.getLinePos() < lowerBound || err.getLinePos() > upperBound) {
                lnum = 1;
            } else {
                try {
                    lnum = Integer.parseInt(errorPattern.getParen(err.getLinePos()));
                }
                catch (NumberFormatException ex) {
                    lnum = 1;
                }
            }
            if (err.getColumnPos() < lowerBound || err.getColumnPos() > upperBound) {
                column = 0;
            } else {
                try {
                    column = Integer.parseInt(errorPattern.getParen(err.getColumnPos()));
                }
                catch (NumberFormatException ex) {
                    column = 0;
                }
            }
            String msg = err.getDescriptionPos() < lowerBound || err.getDescriptionPos() > upperBound ? "" : ((sg = errorPattern.getParen(err.getDescriptionPos())) == null ? "" : sg.trim());
            StringBuffer fline = new StringBuffer(256);
            fline.append(path);
            fline.append(':');
            fline.append(lnum);
            if (column > 0) {
                fline.append(':');
                fline.append(column);
            }
            fline.append(':');
            fline.append(msg);
            return fline.toString();
        }
        return line;
    }

    private static RE getErrorPattern(ExternalCompiler.ErrorExpression err) {
        String regexp = err.getErrorExpression();
        try {
            RECompiler rec = new RECompiler();
            REProgram rep = rec.compile(regexp);
            RE errRE = new RE(rep, 2);
            return errRE;
        }
        catch (RESyntaxException e) {
            ErrorManager.getDefault().notify((Throwable)e);
            return null;
        }
    }

    private String getString(String prop) {
        return bundle.getString(prop);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static {
        bundle = NbBundle.getBundle((Class)(class$org$netbeans$modules$cpp$builds$MakeExecSupport == null ? (class$org$netbeans$modules$cpp$builds$MakeExecSupport = MakeExecSupport.class$("org.netbeans.modules.cpp.builds.MakeExecSupport")) : class$org$netbeans$modules$cpp$builds$MakeExecSupport));
    }

    class TargetsPropertyEditor
    extends PropertyEditorSupport {
        PropertySupport prop = null;

        TargetsPropertyEditor(PropertySupport prop) {
            this.prop = prop;
        }

        public Component getCustomEditor() {
            String val = null;
            try {
                val = (String)this.prop.getValue();
            }
            catch (Exception exception) {
                // empty catch block
            }
            return new TargetEditor(MakeExecSupport.this.tokenizeTargets(val));
        }

        public boolean supportsCustomEditor() {
            return true;
        }
    }

    public final class BuildProcessThread
    extends Thread {
        private InputStream err;

        public BuildProcessThread(InputStream err) {
            this.err = err;
        }

        public void run() {
            BufferedReader in = new BufferedReader(new InputStreamReader(this.err));
            try {
                String line;
                while ((line = in.readLine()) != null) {
                    String fmsg = customizer == null ? MakeExecSupport.this.filterEvent(line) : customizer.filterEvent(line);
                    if (fmsg == null) continue;
                    MakeExecSupport.this.fireBuildEvent(fmsg);
                }
                in.close();
            }
            catch (IOException ioe) {
                // empty catch block
            }
        }
    }
}

