/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cpp.builds;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.Collection;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.border.CompoundBorder;
import javax.swing.border.EmptyBorder;
import javax.swing.border.EtchedBorder;
import javax.swing.border.TitledBorder;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import org.netbeans.modules.cpp.builds.ErrorExpression;
import org.netbeans.modules.cpp.builds.ErrorExpressionEditor;
import org.netbeans.modules.cpp.settings.MakeSettings;
import org.openide.explorer.propertysheet.editors.EnhancedCustomPropertyEditor;
import org.openide.util.HelpCtx;
import org.openide.util.NbBundle;

public final class ErrorExpressionPanel
extends JPanel
implements EnhancedCustomPropertyEditor {
    private ErrorExpressionEditor editor;
    static final long serialVersionUID = -2763818133650482979L;
    private JPanel descriptionPanel;
    private JPanel buttonsPanel;
    private JScrollPane presetsScroll;
    private JLabel presetNameLabel;
    private JTextField presetNameField;
    private JLabel errorDescriptionLabel;
    private JTextField errorDescriptionField;
    private JLabel filePositionLabel;
    private JTextField filePositionField;
    private JLabel linePositionLabel;
    private JTextField linePositionField;
    private JLabel columnPositionLabel;
    private JTextField columnPositionField;
    private JLabel descriptionPositionLabel;
    private JTextField descriptionPositionField;
    private JButton addButton;
    private JButton removeButton;
    private JButton changeButton;
    private JList errorDescriptions;
    private ErrorExpression descriptions;
    private boolean internalListChange = false;
    static /* synthetic */ Class class$org$netbeans$modules$cpp$builds$ErrorExpressionPanel;

    public ErrorExpressionPanel(ErrorExpressionEditor ed) {
        this.editor = ed;
        this.descriptions = (ErrorExpression)((Object)ed.getValue());
        this.initComponents();
        this.setBorder(new CompoundBorder(new EmptyBorder(new Insets(2, 2, 2, 2)), new TitledBorder(new EtchedBorder(), ErrorExpressionPanel.getString("CTL_Error_description_name"))));
        this.addButton.setText(ErrorExpressionPanel.getString("CTL_Add"));
        this.addButton.setToolTipText(ErrorExpressionPanel.getString("CTL_Add_tip"));
        this.removeButton.setText(ErrorExpressionPanel.getString("CTL_Remove"));
        this.removeButton.setToolTipText(ErrorExpressionPanel.getString("CTL_Remove_tip"));
        this.changeButton.setText(ErrorExpressionPanel.getString("CTL_Change"));
        this.changeButton.setToolTipText(ErrorExpressionPanel.getString("CTL_Change_tip"));
        this.presetNameLabel.setText(ErrorExpressionPanel.getString("CTL_Preset_label"));
        this.errorDescriptionLabel.setText(ErrorExpressionPanel.getString("CTL_Error_label"));
        this.filePositionLabel.setText(ErrorExpressionPanel.getString("CTL_File_label"));
        this.linePositionLabel.setText(ErrorExpressionPanel.getString("CTL_Line_label"));
        this.columnPositionLabel.setText(ErrorExpressionPanel.getString("CTL_Column_label"));
        this.descriptionPositionLabel.setText(ErrorExpressionPanel.getString("CTL_Description_label"));
        ListSelectionListener l = new ListSelectionListener(){

            public void valueChanged(ListSelectionEvent ev) {
                if (ErrorExpressionPanel.this.internalListChange) {
                    return;
                }
                int sel = ErrorExpressionPanel.this.errorDescriptions.getSelectedIndex();
                if (sel < 0) {
                    return;
                }
                ErrorExpressionPanel.this.descriptions = ErrorExpressionPanel.this.editor.getExpressions()[sel];
                ErrorExpressionPanel.this.updateFields();
                ErrorExpressionPanel.this.updateButtons();
            }
        };
        this.errorDescriptions.addListSelectionListener(l);
        this.updateList();
        this.updateFields();
        this.updateButtons();
        HelpCtx.setHelpIDString((JComponent)this, (String)(class$org$netbeans$modules$cpp$builds$ErrorExpressionPanel == null ? (class$org$netbeans$modules$cpp$builds$ErrorExpressionPanel = ErrorExpressionPanel.class$("org.netbeans.modules.cpp.builds.ErrorExpressionPanel")) : class$org$netbeans$modules$cpp$builds$ErrorExpressionPanel).getName());
    }

    public Object getPropertyValue() throws IllegalStateException {
        return this.descriptions;
    }

    public Dimension getPreferredSize() {
        Dimension d = super.getPreferredSize();
        if (d.width < 400) {
            d.width = 400;
        }
        return d;
    }

    private void updateList() {
        ErrorExpression[] exprs = this.editor.getExpressions();
        ErrorExpression sel = this.descriptions;
        String[] strings = new String[exprs.length];
        int selIndex = -1;
        for (int i = 0; i < exprs.length; ++i) {
            strings[i] = exprs[i].getName();
            if (!exprs[i].getName().equals(sel.getName())) continue;
            selIndex = i;
        }
        this.internalListChange = true;
        this.errorDescriptions.setListData(strings);
        this.internalListChange = false;
        if (selIndex != -1) {
            this.errorDescriptions.setSelectedIndex(selIndex);
        }
    }

    private void updateFields() {
        ErrorExpression current = this.descriptions;
        this.presetNameField.setText(current.getName());
        this.errorDescriptionField.setText(current.getErrorExpression());
        this.filePositionField.setText(String.valueOf(current.getFilePos()));
        this.linePositionField.setText(String.valueOf(current.getLinePos()));
        this.columnPositionField.setText(String.valueOf(current.getColumnPos()));
        this.descriptionPositionField.setText(String.valueOf(current.getDescriptionPos()));
    }

    private void updateButtons() {
        boolean enabled;
        boolean bl = enabled = this.errorDescriptions.getSelectedIndex() != -1;
        if (enabled) {
            enabled = !this.isReadOnly(this.descriptions);
        }
        this.removeButton.setEnabled(enabled);
        this.changeButton.setEnabled(enabled);
        this.addButton.setEnabled(!"".equals(this.presetNameField.getText()));
    }

    private boolean isReadOnly(ErrorExpression sel) {
        if (sel.equals((Object)MakeSettings.SUN_COMPILERS)) {
            return true;
        }
        return sel.equals((Object)MakeSettings.GNU_COMPILERS);
    }

    private void initComponents() {
        this.setBorder(new EmptyBorder(new Insets(5, 5, 5, 0)));
        this.setLayout(new GridBagLayout());
        this.descriptionPanel = new JPanel();
        this.descriptionPanel.setLayout(new GridBagLayout());
        this.presetNameLabel = new JLabel();
        GridBagConstraints gridBagConstraints2 = new GridBagConstraints();
        gridBagConstraints2.fill = 2;
        gridBagConstraints2.insets = new Insets(2, 2, 2, 2);
        gridBagConstraints2.anchor = 17;
        this.descriptionPanel.add((Component)this.presetNameLabel, gridBagConstraints2);
        this.presetNameField = new JTextField();
        gridBagConstraints2 = new GridBagConstraints();
        gridBagConstraints2.gridwidth = 0;
        gridBagConstraints2.fill = 2;
        gridBagConstraints2.insets = new Insets(2, 2, 2, 2);
        this.descriptionPanel.add((Component)this.presetNameField, gridBagConstraints2);
        this.errorDescriptionLabel = new JLabel();
        gridBagConstraints2 = new GridBagConstraints();
        gridBagConstraints2.fill = 2;
        gridBagConstraints2.insets = new Insets(2, 2, 2, 2);
        gridBagConstraints2.anchor = 17;
        gridBagConstraints2.weighty = 0.2;
        this.descriptionPanel.add((Component)this.errorDescriptionLabel, gridBagConstraints2);
        this.errorDescriptionField = new JTextField();
        gridBagConstraints2 = new GridBagConstraints();
        gridBagConstraints2.gridwidth = 0;
        gridBagConstraints2.fill = 2;
        gridBagConstraints2.ipadx = 20;
        gridBagConstraints2.insets = new Insets(2, 2, 2, 2);
        gridBagConstraints2.anchor = 17;
        gridBagConstraints2.weightx = 1.0;
        this.descriptionPanel.add((Component)this.errorDescriptionField, gridBagConstraints2);
        this.filePositionLabel = new JLabel();
        gridBagConstraints2 = new GridBagConstraints();
        gridBagConstraints2.fill = 2;
        gridBagConstraints2.insets = new Insets(2, 2, 2, 2);
        gridBagConstraints2.anchor = 17;
        gridBagConstraints2.weighty = 0.2;
        this.descriptionPanel.add((Component)this.filePositionLabel, gridBagConstraints2);
        this.filePositionField = new JTextField();
        this.filePositionField.setHorizontalAlignment(4);
        gridBagConstraints2 = new GridBagConstraints();
        gridBagConstraints2.gridwidth = 0;
        gridBagConstraints2.ipadx = 40;
        gridBagConstraints2.insets = new Insets(2, 2, 2, 20);
        gridBagConstraints2.anchor = 17;
        this.descriptionPanel.add((Component)this.filePositionField, gridBagConstraints2);
        this.linePositionLabel = new JLabel();
        gridBagConstraints2 = new GridBagConstraints();
        gridBagConstraints2.fill = 2;
        gridBagConstraints2.insets = new Insets(2, 2, 2, 2);
        gridBagConstraints2.anchor = 17;
        gridBagConstraints2.weighty = 0.2;
        this.descriptionPanel.add((Component)this.linePositionLabel, gridBagConstraints2);
        this.linePositionField = new JTextField();
        this.linePositionField.setHorizontalAlignment(4);
        gridBagConstraints2 = new GridBagConstraints();
        gridBagConstraints2.gridwidth = 0;
        gridBagConstraints2.ipadx = 40;
        gridBagConstraints2.insets = new Insets(2, 2, 2, 20);
        gridBagConstraints2.anchor = 17;
        this.descriptionPanel.add((Component)this.linePositionField, gridBagConstraints2);
        this.columnPositionLabel = new JLabel();
        gridBagConstraints2 = new GridBagConstraints();
        gridBagConstraints2.fill = 2;
        gridBagConstraints2.insets = new Insets(2, 2, 2, 2);
        gridBagConstraints2.anchor = 17;
        gridBagConstraints2.weighty = 0.2;
        this.descriptionPanel.add((Component)this.columnPositionLabel, gridBagConstraints2);
        this.columnPositionField = new JTextField();
        this.columnPositionField.setHorizontalAlignment(4);
        gridBagConstraints2 = new GridBagConstraints();
        gridBagConstraints2.gridwidth = 0;
        gridBagConstraints2.ipadx = 40;
        gridBagConstraints2.insets = new Insets(2, 2, 2, 20);
        gridBagConstraints2.anchor = 17;
        this.descriptionPanel.add((Component)this.columnPositionField, gridBagConstraints2);
        this.descriptionPositionLabel = new JLabel();
        gridBagConstraints2 = new GridBagConstraints();
        gridBagConstraints2.fill = 2;
        gridBagConstraints2.insets = new Insets(2, 2, 2, 2);
        gridBagConstraints2.anchor = 17;
        gridBagConstraints2.weighty = 0.2;
        this.descriptionPanel.add((Component)this.descriptionPositionLabel, gridBagConstraints2);
        this.descriptionPositionField = new JTextField();
        this.descriptionPositionField.setHorizontalAlignment(4);
        gridBagConstraints2 = new GridBagConstraints();
        gridBagConstraints2.gridwidth = 0;
        gridBagConstraints2.ipadx = 40;
        gridBagConstraints2.insets = new Insets(2, 2, 2, 20);
        gridBagConstraints2.anchor = 17;
        this.descriptionPanel.add((Component)this.descriptionPositionField, gridBagConstraints2);
        GridBagConstraints gridBagConstraints1 = new GridBagConstraints();
        gridBagConstraints1.gridx = 0;
        gridBagConstraints1.gridy = 0;
        gridBagConstraints1.fill = 1;
        gridBagConstraints1.weightx = 1.0;
        this.add((Component)this.descriptionPanel, gridBagConstraints1);
        this.buttonsPanel = new JPanel();
        this.buttonsPanel.setBorder(new EmptyBorder(new Insets(0, 8, 0, 0)));
        this.buttonsPanel.setLayout(new GridBagLayout());
        this.addButton = new JButton();
        this.addButton.setEnabled(false);
        this.addButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                ErrorExpressionPanel.this.addButtonActionPerformed(evt);
            }
        });
        GridBagConstraints gridBagConstraints3 = new GridBagConstraints();
        gridBagConstraints3.gridx = 0;
        gridBagConstraints3.gridy = 0;
        gridBagConstraints3.fill = 2;
        gridBagConstraints3.insets = new Insets(2, 2, 2, 5);
        gridBagConstraints3.anchor = 15;
        this.buttonsPanel.add((Component)this.addButton, gridBagConstraints3);
        this.removeButton = new JButton();
        this.removeButton.setEnabled(false);
        this.removeButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                ErrorExpressionPanel.this.removeButtonActionPerformed(evt);
            }
        });
        gridBagConstraints3 = new GridBagConstraints();
        gridBagConstraints3.gridx = 0;
        gridBagConstraints3.gridy = 2;
        gridBagConstraints3.fill = 2;
        gridBagConstraints3.insets = new Insets(2, 2, 2, 5);
        gridBagConstraints3.anchor = 11;
        gridBagConstraints3.weighty = 1.0;
        this.buttonsPanel.add((Component)this.removeButton, gridBagConstraints3);
        this.changeButton = new JButton();
        this.changeButton.setEnabled(false);
        this.changeButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                ErrorExpressionPanel.this.changeButtonActionPerformed(evt);
            }
        });
        gridBagConstraints3 = new GridBagConstraints();
        gridBagConstraints3.gridx = 0;
        gridBagConstraints3.gridy = 1;
        gridBagConstraints3.fill = 2;
        gridBagConstraints3.insets = new Insets(2, 2, 2, 5);
        this.buttonsPanel.add((Component)this.changeButton, gridBagConstraints3);
        gridBagConstraints1 = new GridBagConstraints();
        gridBagConstraints1.gridx = 1;
        gridBagConstraints1.gridy = 0;
        gridBagConstraints1.gridwidth = 0;
        gridBagConstraints1.fill = 1;
        this.add((Component)this.buttonsPanel, gridBagConstraints1);
        this.presetsScroll = new JScrollPane();
        this.errorDescriptions = new JList();
        this.errorDescriptions.addMouseListener(new MouseAdapter(){

            public void mouseClicked(MouseEvent evt) {
                ErrorExpressionPanel.this.errorDescriptionsMouseClicked(evt);
            }
        });
        this.presetsScroll.setViewportView(this.errorDescriptions);
        gridBagConstraints1 = new GridBagConstraints();
        gridBagConstraints1.fill = 1;
        gridBagConstraints1.insets = new Insets(8, 0, 0, 0);
        gridBagConstraints1.weightx = 1.0;
        gridBagConstraints1.weighty = 1.0;
        this.add((Component)this.presetsScroll, gridBagConstraints1);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void removeButtonActionPerformed(ActionEvent evt) {
        ErrorExpressionEditor errorExpressionEditor = this.editor;
        synchronized (errorExpressionEditor) {
            Collection exprs = this.editor.getExpressionsVector();
            int pos = this.errorDescriptions.getSelectedIndex();
            exprs.remove((Object)this.descriptions);
            if (pos >= exprs.size()) {
                pos = exprs.size() - 1;
            }
            this.descriptions = pos >= 0 ? this.editor.getExpressions()[pos] : null;
            this.updateList();
        }
    }

    private void changeButtonActionPerformed(ActionEvent evt) {
        if ("".equals(this.presetNameField.getText())) {
            return;
        }
        ErrorExpression expr = this.descriptions;
        int fPos = 0;
        int lPos = 0;
        int cPos = 0;
        int dPos = 0;
        try {
            fPos = Integer.parseInt(this.filePositionField.getText());
            lPos = Integer.parseInt(this.linePositionField.getText());
            cPos = Integer.parseInt(this.columnPositionField.getText());
            dPos = Integer.parseInt(this.descriptionPositionField.getText());
        }
        catch (NumberFormatException ex) {
            return;
        }
        expr.setName(this.presetNameField.getText());
        expr.setErrorExpression(this.errorDescriptionField.getText());
        expr.setFilePos(fPos);
        expr.setLinePos(lPos);
        expr.setColumnPos(cPos);
        expr.setDescriptionPos(dPos);
        this.updateList();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addButtonActionPerformed(ActionEvent evt) {
        if ("".equals(this.presetNameField.getText())) {
            return;
        }
        ErrorExpression[] exprsAr = this.editor.getExpressions();
        for (int i = 0; i < exprsAr.length; ++i) {
            if (!exprsAr[i].getName().equals(this.presetNameField.getText())) continue;
            return;
        }
        ErrorExpression expr = null;
        try {
            expr = new ErrorExpression(this.presetNameField.getText(), this.errorDescriptionField.getText(), Integer.parseInt(this.filePositionField.getText()), Integer.parseInt(this.linePositionField.getText()), Integer.parseInt(this.columnPositionField.getText()), Integer.parseInt(this.descriptionPositionField.getText()));
        }
        catch (NumberFormatException ex) {
            return;
        }
        ErrorExpressionEditor errorExpressionEditor = this.editor;
        synchronized (errorExpressionEditor) {
            Collection exprs = this.editor.getExpressionsVector();
            int pos = this.errorDescriptions.getSelectedIndex();
            exprs.add(expr);
            this.descriptions = expr;
            this.updateList();
        }
    }

    private void errorDescriptionsMouseClicked(MouseEvent evt) {
    }

    private static String getString(String res) {
        return NbBundle.getBundle((Class)(class$org$netbeans$modules$cpp$builds$ErrorExpressionPanel == null ? (class$org$netbeans$modules$cpp$builds$ErrorExpressionPanel = ErrorExpressionPanel.class$("org.netbeans.modules.cpp.builds.ErrorExpressionPanel")) : class$org$netbeans$modules$cpp$builds$ErrorExpressionPanel)).getString(res);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

