/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tools.debugger.dbxgui.utils;

import java.io.FileOutputStream;
import java.io.PrintWriter;

public class TimerLogger {
    private FileOutputStream logStream = null;
    private PrintWriter logfile = null;
    private String fileName = "ipe.log";
    private String message = null;
    private long startTime;

    public TimerLogger() {
        this(null, null);
    }

    public TimerLogger(String inFilename, String inMessage) {
        this.setMessage(inMessage);
        this.initLogfile(inFilename);
    }

    public void initLogfile(String inFilename) {
        this.fileName = inFilename != null ? inFilename : this.fileName;
        try {
            this.logStream = new FileOutputStream(this.fileName);
            this.logfile = new PrintWriter(this.logStream);
        }
        catch (Exception ex) {
            System.out.println("Cannot open log file: " + this.fileName);
            ex.printStackTrace();
        }
    }

    public String getFilename() {
        return this.fileName;
    }

    public void setMessage(String inMessage) {
        this.message = inMessage != null ? "[" + inMessage + "]" : null;
    }

    public void log(String str) {
        if (this.logfile != null) {
            this.logfile.println(str);
            this.logfile.flush();
        }
    }

    public void start() {
        this.startTime = System.currentTimeMillis();
        this.log(this.message + "Timer started.");
        this.log("Current time is (in milliseconds): " + this.startTime);
    }

    public void stop() {
        long endTime = System.currentTimeMillis();
        this.log(this.message + "Timer stopped.");
        this.log("Current time is (in milliseconds): " + endTime);
        long elapsedTime = endTime - this.startTime;
        this.log("Elapsed time is (in milliseconds): " + elapsedTime);
    }

    public static void main(String[] args) {
        TimerLogger logger = new TimerLogger("e:\\temp\\perf.txt", "test function");
        logger.start();
        for (int i = 0; i < 999999; ++i) {
        }
        logger.stop();
    }
}

