/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tools.debugger.dbxgui.utils;

import java.util.StringTokenizer;

public class Log {
    public static final int IVAN = 1;
    private static int categories = 0;
    private static boolean setup = false;

    private static void printCaller() {
        Throwable t = new Throwable();
        StackTraceElement[] stack = t.getStackTrace();
        StackTraceElement caller = stack[2];
        String className = caller.getClassName();
        className = className.substring(className.lastIndexOf(46) + 1);
        String methodName = caller.getMethodName();
        System.out.print(className + "." + methodName);
    }

    public static void pr(int category, String msg) {
        if (Log.enabled(category)) {
            System.out.print("@@ ");
            System.out.println(msg);
        }
    }

    public static void prf(int category) {
        if (Log.enabled(category)) {
            System.out.print("@@ ");
            Log.printCaller();
            System.out.println("()");
        }
    }

    public static void prfa(int category, String args) {
        if (Log.enabled(category)) {
            System.out.print("@@ ");
            Log.printCaller();
            System.out.print("(");
            System.out.print(args);
            System.out.println(")");
        }
    }

    public static void prf(int category, String msg) {
        if (Log.enabled(category)) {
            System.out.print("@@ ");
            Log.printCaller();
            System.out.print("(): ");
            System.out.println(msg);
        }
    }

    public static boolean enabled(int category) {
        if (!setup) {
            String cats = System.getProperty("LOG");
            if (cats != null) {
                StringTokenizer tokenizer = new StringTokenizer(cats, ",");
                while (tokenizer.hasMoreTokens()) {
                    String token = tokenizer.nextToken();
                    if (!token.equals("IVAN")) continue;
                    categories |= 1;
                }
            }
            setup = true;
        }
        return (categories & category) == category;
    }
}

